---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 122
  claims_with_evidence: 118
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Xml.XmlSerializer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：118 / 122、根拠なし：4
- 優先レビュー（高）
  1. **UT-XSR-116〜118（イベント検証）**：イベント発火の詳細な動作はソースコードから直接確認困難
  2. **UT-XSR-103（nullシリアライズ）**：null値のシリアライズ結果の詳細動作
  3. **UT-XSR-033（MakeUnique境界値）**：再帰呼び出しの詳細動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Xml.XmlSerializer/ref/System.Xml.XmlSerializer.cs` - API参照定義
- E-02: `src/libraries/System.Xml.XmlSerializer/ref/System.Xml.XmlSerializer.Forwards.cs` - 型転送定義
- E-03: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/CodeIdentifier.cs` - CodeIdentifier実装
- E-04: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/CodeIdentifiers.cs` - CodeIdentifiers実装
- E-05: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/SoapAttributeAttribute.cs` - SoapAttributeAttribute実装
- E-06: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/SoapAttributes.cs` - SoapAttributes実装
- E-07: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/SoapAttributeOverrides.cs` - SoapAttributeOverrides実装
- E-08: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/SoapElementAttribute.cs` - SoapElementAttribute実装
- E-09: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/SoapEnumAttribute.cs` - SoapEnumAttribute実装
- E-10: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/SoapTypeAttribute.cs` - SoapTypeAttribute実装
- E-11: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/XmlSerializer.cs` - XmlSerializer実装
- E-12: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/XmlAttributes.cs` - XmlAttributes実装
- E-13: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/XmlArrayAttribute.cs` - XmlArrayAttribute実装
- E-14: `src/libraries/System.Xml.XmlSerializer/README.md` - モジュール説明

## 3) Claims と根拠の対応（レビューの主戦場）

### CodeIdentifier クラス（UT-XSR-001〜014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MakePascalが先頭小文字をPascalCaseに変換 | E-03 (L27-47) | ○ |
| C-02 | MakePascalが2文字以下を全て大文字に変換 | E-03 (L31-34) | ○ |
| C-03 | MakePascalがnullでArgumentNullExceptionをスロー | E-03 (L29) | ○ |
| C-04 | MakeCamelが先頭大文字をcamelCaseに変換 | E-03 (L52-72) | ○ |
| C-05 | MakeCamelが2文字以下を全て小文字に変換 | E-03 (L56-59) | ○ |
| C-06 | MakeCamelがnullでArgumentNullExceptionをスロー | E-03 (L54) | ○ |
| C-07 | MakeValidが数字開始識別子にItemプレフィックス付与 | E-03 (L86-89, L106-117) | ○ |
| C-08 | MakeValidが空文字列でItemを返却 | E-03 (L93) | ○ |
| C-09 | MakeValidがMaxIdentifierLength(511)で切り詰め | E-03 (L17, L81) | ○ |
| C-10 | MakeValidがnullでArgumentNullExceptionをスロー | E-03 (L79) | ○ |

### CodeIdentifiers クラス（UT-XSR-015〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | デフォルトコンストラクタで大文字小文字区別 | E-04 (L44-46, L50-52) | ○ |
| C-12 | caseSensitive=falseで非区別モード | E-04 (L56-60) | ○ |
| C-13 | Add/AddUniqueが識別子を追加 | E-04 (L135-140, L153-157) | ○ |
| C-14 | IsInUseが使用中/予約済み識別子を判定 | E-04 (L145-148) | ○ |
| C-15 | MakeUniqueが重複時に連番付与 | E-04 (L94-114) | ○ |
| C-16 | MakeUniqueがMaxIdentifierLength超過時にItem使用 | E-04 (L109-112) | ○ |
| C-17 | Clear/Removeが識別子を削除 | E-04 (L65-69, L162-166) | ○ |
| C-18 | MakeRightCaseがUseCamelCasingに応じて変換 | E-04 (L83-89) | ○ |
| C-19 | ToArrayが配列を返却 | E-04 (L171-179) | ○ |

### SOAP属性クラス（UT-XSR-035〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | SoapAttributeAttributeのコンストラクタと各プロパティ | E-05 (全体) | ○ |
| C-21 | SoapElementAttributeのコンストラクタと各プロパティ | E-08 (全体) | ○ |
| C-22 | SoapEnumAttributeのコンストラクタと各プロパティ | E-09 (全体) | ○ |
| C-23 | SoapTypeAttributeのコンストラクタと各プロパティ | E-10 (全体) | ○ |
| C-24 | SoapAttributesのコンストラクタとICustomAttributeProvider処理 | E-06 (L26-86) | ○ |
| C-25 | SoapAttributesのSoapIgnore処理で他属性クリア | E-06 (L78-85) | ○ |
| C-26 | SoapAttributeOverridesのAdd/インデクサ | E-07 (全体) | ○ |
| C-27 | SoapAttributeOverridesの重複追加でInvalidOperationException | E-07 (L30-33) | ○ |

### XmlAttributes クラス（UT-XSR-071〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | XmlAttributesのコンストラクタとICustomAttributeProvider処理 | E-12 (L49-191) | ○ |
| C-29 | XmlAttributesのnull引数でArgumentNullException | E-12 (L79) | ○ |
| C-30 | XmlAttributesのXmlIgnore処理で他属性クリア | E-12 (L169-183) | ○ |
| C-31 | XmlAttributesの各プロパティ | E-12 (L203-317) | ○ |

### XmlArrayAttribute クラス（UT-XSR-088〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | XmlArrayAttributeのコンストラクタ | E-13 (L25-35) | ○ |
| C-33 | XmlArrayAttributeの各プロパティ | E-13 (L40-86) | ○ |
| C-34 | XmlArrayAttributeのOrder負値でArgumentException | E-13 (L82-84) | ○ |

### XmlSerializer クラス（UT-XSR-096〜122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | XmlSerializerのコンストラクタ(Type) | E-11 (L210-212, L218) | ○ |
| C-36 | XmlSerializerのコンストラクタでnull例外 | E-11 (L218, L278) | ○ |
| C-37 | XmlSerializerのSerializeメソッド各オーバーロード | E-11 (L334-419) | ○ |
| C-38 | XmlSerializerのDeserializeメソッド各オーバーロード | E-11 (L444-526) | ○ |
| C-39 | XmlSerializerのCanDeserialize | E-11 (L543-566) | ○ |
| C-40 | XmlSerializerのFromTypes/FromMappings | E-11 (L570-765) | ○ |
| C-41 | XmlSerializerのGetXmlSerializerAssemblyName | E-11 (L767-777) | ○ |
| C-42 | XmlSerializerのイベント（UnknownNode等） | E-11 (L779-825) | △ |
| C-43 | nullシリアライズの詳細動作 | E-11 | △ |
| C-44 | XmlDeserializationEventsの各プロパティ | E-11 (L25-81) | ○ |

## 4) 不足情報（Unknown / Missing）
- **イベント発火の詳細動作**：UnknownNode/UnknownAttribute/UnknownElementイベントの発火条件と引数の詳細は、XmlSerializationReader等の内部実装に依存
  - 候補：`XmlSerializationReader.cs` / 統合テストでの検証
- **nullシリアライズの出力形式**：null値をシリアライズした際のXML出力形式（空要素/xsi:nil等）の詳細
  - 候補：`XmlSerializationPrimitiveWriter.cs` / 実際のシリアライズ出力の検証
- **MakeUnique再帰呼び出し**：長い識別子に対する再帰的なItem使用の詳細動作
  - 候補：実行時テストでの検証

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：属性クラスのプロパティ検証（UT-XSR-035〜095の大部分）- 単純なget/set検証
- **1（中リスク）**：CodeIdentifier/CodeIdentifiersの文字列操作 - Unicode文字の扱いに注意
- **1（中リスク）**：XmlSerializer.CanDeserialize - リフレクションモードでの動作が常にtrue返却
- **2（高リスク）**：イベント発火テスト（UT-XSR-116〜118）- 内部実装依存、モック/スタブが必要な場合あり

## 6) レビュアーチェックリスト（最小）
- [ ] CodeIdentifierのMakeValid境界値テスト（MaxIdentifierLength=511）が実装可能か確認
- [ ] SoapAttributes/XmlAttributesのICustomAttributeProvider処理が正しくテスト可能か確認
- [ ] XmlSerializerのイベント検証テストで適切なモック戦略が使用されているか確認
- [ ] nullシリアライズのテストケースで期待結果が正確か確認（xsi:nil属性の有無等）
- [ ] 大文字小文字非区別モードのCodeIdentifiersテストがカルチャ依存しないか確認
