---
generated_at: 2026-01-30 18:15:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：libraries-shims 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-SHM-053, 054**：シリアライゼーション互換性テストの詳細な入力データ仕様が未確定
  2. **UT-SHM-049, 050**：異常系テストの具体的な例外タイプの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/shims/System.Void.cs` - void型転送の実装
- E-02: `src/libraries/shims/mscorlib/src/mscorlib.cs` - mscorlib型転送（118行、GenericComparer等の内部型転送）
- E-03: `src/libraries/shims/System/src/System.cs` - System型転送（TreeSet, ZLibException等）
- E-04: `src/libraries/shims/System.Core/src/System.Core.cs` - System.Core型転送（HashSet, Enumerable, Expression等）
- E-05: `src/libraries/shims/System.Data/src/System.Data.cs` - System.Data型転送（ODBC32）
- E-06: `src/libraries/shims/System.Xml/src/System.Xml.cs` - System.Xml型転送（251行、XmlDocument, XmlReader等）
- E-07: `src/libraries/shims/System.Configuration/src/System.Configuration.cs` - System.Configuration型転送（108行）
- E-08: `src/libraries/shims/System.Drawing/src/System.Drawing.cs` - System.Drawing型転送（167行）
- E-09: `src/libraries/shims/Microsoft.VisualBasic/src/Microsoft.VisualBasic.cs` - Microsoft.VisualBasic型転送（78行）
- E-10: `src/libraries/shims/System.Security.Cryptography.Algorithms/src/System.Security.Cryptography.Algorithms.cs` - 暗号化型転送（64行）
- E-11: `src/libraries/shims/System.Threading.Tasks.Extensions/src/System.Threading.Tasks.Extensions.cs` - ValueTask型転送（17行）
- E-12: `src/libraries/shims/System.Buffers/src/System.Buffers.cs` - ArrayPool型転送
- E-13: `src/libraries/shims/System.Runtime.CompilerServices.Unsafe/src/System.Runtime.CompilerServices.Unsafe.cs` - Unsafe型転送
- E-14: `src/libraries/shims/netstandard/src/netstandard.cs` - netstandard型転送（大規模ファイル、269KB以上）
- E-15: mscorlib.csのコメント「Desktop to Core serialization」 - シリアライゼーション互換性の意図説明
- E-16: mscorlib.csのコメント「back-compatibility with .NET Core 2.0」 - .NET Core 2.0互換性の意図説明
- E-17: mscorlib.csのコメント「back-compatibility with legacy Xamarin」 - Xamarin互換性の意図説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | System.Void型が正しく転送される | E-01 | ○ |
| C-02 | GenericComparer<T>型が正しく転送される | E-02 | ○ |
| C-03 | NullableComparer<T>型が正しく転送される | E-02 | ○ |
| C-04 | ObjectComparer<T>型が正しく転送される | E-02 | ○ |
| C-05 | GenericEqualityComparer<T>型が正しく転送される | E-02 | ○ |
| C-06 | NonRandomizedStringEqualityComparer型が正しく転送される | E-02, E-16 | ○ |
| C-07 | HashCode型が正しく転送される | E-02, E-17 | ○ |
| C-08 | Memory<T>型が正しく転送される | E-02, E-17 | ○ |
| C-09 | Span<T>型が正しく転送される | E-02, E-17 | ○ |
| C-10 | ReadOnlySpan<T>型が正しく転送される | E-02, E-17 | ○ |
| C-11 | ValueTask型が正しく転送される | E-02, E-11 | ○ |
| C-12 | ValueTask<T>型が正しく転送される | E-02, E-11 | ○ |
| C-13 | TreeSet<T>型が正しく転送される | E-03 | ○ |
| C-14 | ZLibException型が正しく転送される | E-03 | ○ |
| C-15 | CookieVariant型が正しく転送される | E-03 | ○ |
| C-16 | HashSet<T>型が正しく転送される | E-04 | ○ |
| C-17 | Enumerable型が正しく転送される | E-04 | ○ |
| C-18 | Expression型が正しく転送される | E-04 | ○ |
| C-19 | DynamicObject型が正しく転送される | E-04 | ○ |
| C-20 | ExpandoObject型が正しく転送される | E-04 | ○ |
| C-21 | TimeZoneInfo型が正しく転送される | E-04 | ○ |
| C-22 | ReaderWriterLockSlim型が正しく転送される | E-04 | ○ |
| C-23 | Aes型が正しく転送される | E-04, E-10 | ○ |
| C-24 | ECDsa型が正しく転送される | E-04, E-10 | ○ |
| C-25 | ODBC32型が正しく転送される | E-05 | ○ |
| C-26 | XmlDocument型が正しく転送される | E-06 | ○ |
| C-27 | XmlReader型が正しく転送される | E-06 | ○ |
| C-28 | XmlWriter型が正しく転送される | E-06 | ○ |
| C-29 | XmlSerializer型が正しく転送される | E-06 | ○ |
| C-30 | XPathNavigator型が正しく転送される | E-06 | ○ |
| C-31 | ConfigurationManager型が正しく転送される | E-07 | ○ |
| C-32 | ConfigurationSection型が正しく転送される | E-07 | ○ |
| C-33 | Bitmap型が正しく転送される | E-08 | ○ |
| C-34 | Graphics型が正しく転送される | E-08 | ○ |
| C-35 | Image型が正しく転送される | E-08 | ○ |
| C-36 | Color型が正しく転送される | E-08 | ○ |
| C-37 | Collection型（VB）が正しく転送される | E-09 | ○ |
| C-38 | Strings型（VB）が正しく転送される | E-09 | ○ |
| C-39 | FileSystem型（VB）が正しく転送される | E-09 | ○ |
| C-40 | SHA256型が正しく転送される | E-10 | ○ |
| C-41 | SHA512型が正しく転送される | E-10 | ○ |
| C-42 | RSA型が正しく転送される | E-10 | ○ |
| C-43 | HMACSHA256型が正しく転送される | E-10 | ○ |
| C-44 | ValueTaskAwaiter型が正しく転送される | E-11 | ○ |
| C-45 | IValueTaskSource型が正しく転送される | E-11 | ○ |
| C-46 | ArrayPool<T>型が正しく転送される | E-12 | ○ |
| C-47 | Unsafe型が正しく転送される | E-13 | ○ |
| C-48 | netstandard互換型が正しく転送される | E-14 | ○ |
| C-49 | 存在しない型への参照時に例外がスローされる | **根拠なし** | △ |
| C-50 | 循環参照が発生しない | **根拠なし** | △ |
| C-51 | shimsアセンブリが正常に読み込まれる | E-01〜E-14（全ファイルの存在） | ○ |
| C-52 | 型転送先アセンブリが自動解決される | E-02〜E-14（TypeForwardedTo属性の存在） | ○ |
| C-53 | シリアライズ済みオブジェクトがデシリアライズできる | E-15 | ○ |
| C-54 | BinaryFormatterで互換性が維持される | E-15 | ○ |
| C-55 | Type.GetType()で型が解決される | E-02〜E-14（TypeForwardedTo属性） | ○ |
| C-56 | Assembly.GetType()で型が解決される | E-02〜E-14（TypeForwardedTo属性） | ○ |
| C-57 | アセンブリバージョンが正しい | プロジェクトファイル（未確認だが推定可能） | ○ |
| C-58 | PublicKeyTokenが正しい | プロジェクトファイル（未確認だが推定可能） | ○ |
| C-59 | Index型が正しく転送される | E-02 | ○ |
| C-60 | Range型が正しく転送される | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-49（異常系：存在しない型への例外）**
  - TypeForwardedTo属性の動作仕様は.NETランタイムに依存
  - 候補：ECMA-335仕様書 / .NET Runtime実装ドキュメント / 単体テスト実装による確認
- **C-50（異常系：循環参照検出）**
  - 型転送の循環検出はランタイムの責務
  - 候補：.NET Runtimeソースコード（AssemblyLoader部分） / 既存テストケースの確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - shimsモジュールはTypeForwardedTo属性のみで構成され、ビジネスロジックを含まない
- **0: 低リスク** - 型転送の正確性は.NETランタイムによって保証される
- **1: 中リスク** - シリアライゼーション互換性テスト（C-53, C-54）は実際のレガシーデータが必要
- **1: 中リスク** - 異常系テスト（C-49, C-50）はランタイム依存のため、環境による差異の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各shimファイルのTypeForwardedTo属性が実在する型を参照しているか確認
- [ ] 転送先の型が.NET Runtime内に存在することを確認
- [ ] シリアライゼーション互換性テストの入力データ仕様を定義
- [ ] 異常系テストの期待される例外タイプを.NETドキュメントで確認
- [ ] テストID命名規則（UT-SHM-XXX）がプロジェクト規約に準拠しているか確認
