---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：mono.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **InternalCallメソッドの実装詳細**：ネイティブコードとの連携部分
  2. **スレッド同期プリミティブのエッジケース**：Monitor, Threadの境界条件
  3. **GCの内部動作**：_RegisterForFullGCNotificationなど未実装メソッド

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/mono/System.Private.CoreLib/src/System/TypeSpec.cs`
- E-02: `src/mono/System.Private.CoreLib/src/System/TypeIdentifier.cs`
- E-03: `src/mono/System.Private.CoreLib/src/System/Delegate.Mono.cs`
- E-04: `src/mono/System.Private.CoreLib/src/System/GC.Mono.cs`
- E-05: `src/mono/System.Private.CoreLib/src/System/Threading/Thread.Mono.cs`
- E-06: `src/mono/System.Private.CoreLib/src/System/Threading/Monitor.Mono.cs`
- E-07: `src/mono/System.Private.CoreLib/src/System/Reflection/RuntimeAssembly.cs`
- E-08: `src/mono/System.Private.CoreLib/src/System/Runtime/InteropServices/Marshal.Mono.cs`
- E-09: `src/mono/System.Private.CoreLib/src/System/Reflection/Emit/DynamicMethod.Mono.cs`
- E-10: `src/mono/System.Private.CoreLib/src/System/Reflection/Emit/RuntimeILGenerator.Mono.cs`
- E-11: `src/mono/System.Private.CoreLib/src/System/Runtime/CompilerServices/RuntimeHelpers.Mono.cs`
- E-12: `src/mono/System.Private.CoreLib/src/System/RuntimeType.Mono.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### TypeSpec関連（UT-MON-001〜013）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TypeSpec.Parseで型名がパースできる | E-01 (L248-534) | ○ |
| C-02 | ネスト型（+区切り）がパースできる | E-01 (L363-366) | ○ |
| C-03 | 配列型（[]）がパースできる | E-01 (L492-516) | ○ |
| C-04 | 多次元配列がパースできる | E-01 (L493-514) | ○ |
| C-05 | ポインタ型（*）がパースできる | E-01 (L413-424) | ○ |
| C-06 | 参照型（&）がパースできる | E-01 (L407-412) | ○ |
| C-07 | ジェネリック型がパースできる | E-01 (L457-489) | ○ |
| C-08 | アセンブリ修飾名がパースできる | E-01 (L425-446) | ○ |
| C-09 | nullでArgumentNullException | E-01 (L251) | ○ |
| C-10 | 不正構文でArgumentException | E-01 (複数箇所) | ○ |
| C-11 | EscapeDisplayNameで特殊文字がエスケープされる | E-01 (L259-283) | ○ |
| C-12 | UnescapeInternalNameでエスケープが解除される | E-01 (L285-297) | ○ |

### IArraySpec/PointerSpec関連（UT-MON-014〜018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | IArraySpec.Resolveで配列型が作成される | E-01 (L57-63) | ○ |
| C-15 | bound=trueでMakeArrayType(1)が呼ばれる | E-01 (L59-60) | ○ |
| C-16 | 多次元配列でMakeArrayType(dimensions)が呼ばれる | E-01 (L63) | ○ |
| C-17 | PointerSpec.Resolveでポインタ型が作成される | E-01 (L106-111) | ○ |
| C-18 | 多重ポインタでループ処理される | E-01 (L107-109) | ○ |

### TypeIdentifier関連（UT-MON-019〜022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | FromDisplayでTypeIdentifierが生成される | E-02 (L115-118) | ○ |
| C-20 | FromInternalで内部名から生成される | E-02 (L120-128) | ○ |
| C-21 | ATypeName.Equalsで等価比較ができる | E-02 (L78-81) | ○ |
| C-22 | ATypeName.GetHashCodeでハッシュが取得できる | E-02 (L83-86) | ○ |

### Delegate関連（UT-MON-023〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | CreateDelegateでデリゲートが作成される | E-03 (L112-151) | ○ |
| C-24 | type=nullでArgumentNullException | E-03 (L124) | ○ |
| C-25 | method=nullでArgumentNullException | E-03 (L125) | ○ |
| C-26 | RuntimeType以外でArgumentException | E-03 (L127-128) | ○ |
| C-27 | デリゲート型でない場合ArgumentException | E-03 (L132-133) | ○ |
| C-28 | IsReturnTypeMatchで戻り値型がマッチする | E-03 (L367-390) | ○ |
| C-29 | 共変性でtrueが返る | E-03 (L374-375) | ○ |
| C-30 | IsArgumentTypeMatchで引数型がマッチする | E-03 (L392-412) | ○ |
| C-31 | 反変性でtrueが返る | E-03 (L397-400) | ○ |
| C-32 | Equalsで等価比較ができる | E-03 (L486-512) | ○ |
| C-33 | 異なるデリゲートでfalseが返る | E-03 (L488) | ○ |
| C-34 | GetHashCodeでハッシュが取得できる | E-03 (L514-519) | ○ |

### GC関連（UT-MON-035〜050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | AddMemoryPressureでプレッシャーが追加される | E-04 (L60-68) | ○ |
| C-36 | 負の値でArgumentOutOfRangeException | E-04 (L62) | ○ |
| C-37 | 0でArgumentOutOfRangeException | E-04 (L62) | ○ |
| C-38 | RemoveMemoryPressureでプレッシャーが削除される | E-04 (L70-78) | ○ |
| C-39 | Collectでガベージコレクションが実行される | E-04 (L83-104) | ○ |
| C-40 | 世代指定でGCが実行される | E-04 (L83-104) | ○ |
| C-41 | 負の世代でArgumentOutOfRangeException | E-04 (L99) | ○ |
| C-42 | CollectionCountでコレクション回数が返る | E-04 (L106-110) | ○ |
| C-43 | 負の世代でArgumentOutOfRangeException | E-04 (L108) | ○ |
| C-44 | GetGenerationでオブジェクトの世代が返る | E-04 (L81) | ○ |
| C-45 | SuppressFinalizeでファイナライゼーションが抑制される | E-04 (L138-142) | ○ |
| C-46 | SuppressFinalizeでnullの場合ArgumentNullException | E-04 (L140) | ○ |
| C-47 | ReRegisterForFinalizeで再登録される | E-04 (L147-151) | ○ |
| C-48 | AllocateUninitializedArrayで配列が確保される | E-04 (L286-294) | ○ |
| C-49 | AllocateArrayでピン留め配列が確保される | E-04 (L296-303) | ○ |
| C-50 | GetGCMemoryInfoでメモリ情報が返る | E-04 (L264-276) | ○ |

### Thread関連（UT-MON-051〜064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | Initializeでスレッドが初期化される | E-05 (L201-204) | ○ |
| C-52 | IsAliveで実行中スレッドの状態が確認できる | E-05 (L87-93) | ○ |
| C-53 | 停止スレッドでfalseが返る | E-05 (L92) | ○ |
| C-54 | IsBackgroundで状態が取得できる | E-05 (L96-102) | ○ |
| C-55 | IsBackground setterで状態が設定できる | E-05 (L103-115) | ○ |
| C-56 | Joinでスレッド終了を待機できる | E-05 (L192-196) | ○ |
| C-57 | 負のタイムアウトでArgumentOutOfRangeException | E-05 (L194) | ○ |
| C-58 | Interruptで割り込みできる | E-05 (L184-190) | ○ |
| C-59 | SpinWaitでスピン待機が実行される | E-05 (L206-213) | ○ |
| C-60 | 負のイテレーションで即座に戻る | E-05 (L208-209) | ○ |
| C-61 | Yieldでyieldできる | E-05 (L244-247) | ○ |
| C-62 | Priorityで優先度が取得できる | E-05 (L157-173) | ○ |
| C-63 | Priority setterで優先度が設定できる | E-05 (L164-172) | ○ |
| C-64 | ManagedThreadIdでIDが取得できる | E-05 (L131) | ○ |

### Monitor関連（UT-MON-065〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | Enterでロックが取得できる | E-06 (L13-14) | ○ |
| C-66 | Enterでnullの場合例外がスローされる | E-06 (L153-154) | ○ |
| C-67 | Enter(ref bool)でロック取得とフラグ設定 | E-06 (L17-24) | ○ |
| C-68 | lockTaken=trueでArgumentException | E-06 (L20-21) | ○ |
| C-69 | Exitでロックが解放できる | E-06 (L29-37) | ○ |
| C-70 | ロック非保持でSynchronizationLockException | E-06 (L103, L114, L127) | ○ |
| C-71 | TryEnterでロック取得を試行できる | E-06 (L39-44) | ○ |
| C-72 | タイムアウト付きでロック取得を試行できる | E-06 (L54-59) | ○ |
| C-73 | 負のタイムアウトでArgumentOutOfRangeException | E-06 (L156-157) | ○ |
| C-74 | IsEnteredでロック状態が確認できる | E-06 (L68-72) | ○ |
| C-75 | IsEnteredでnullの場合ArgumentNullException | E-06 (L70) | ○ |
| C-76 | Waitで待機できる | E-06 (L77-83) | ○ |
| C-77 | Waitでロック非保持の場合SynchronizationLockException | E-06 (L126-127) | ○ |
| C-78 | Pulseで通知できる | E-06 (L85-89) | ○ |
| C-79 | Pulseでロック非保持の場合SynchronizationLockException | E-06 (L102-103) | ○ |
| C-80 | PulseAllで全待機スレッドに通知できる | E-06 (L91-95) | ○ |

### RuntimeAssembly関連（UT-MON-081〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | EntryPointでエントリポイントが取得できる | E-07 (L81-90) | ○ |
| C-82 | FullNameで完全名が取得できる | E-07 (L98) | ○ |
| C-83 | Locationでロケーションが取得できる | E-07 (L134) | ○ |
| C-84 | GetManifestResourceNamesでリソース名一覧が取得できる | E-07 (L142-148) | ○ |
| C-85 | GetManifestResourceStreamでストリームが取得できる | E-07 (L222-244) | ○ |
| C-86 | 存在しないリソースでnullが返る | E-07 (L232-237) | ○ |
| C-87 | 空文字でArgumentException | E-07 (L224) | ○ |
| C-88 | GetTypeで型が取得できる | E-07 (L266-271) | ○ |
| C-89 | GetTypeで空文字の場合ArgumentException | E-07 (L268) | ○ |
| C-90 | GetModulesでモジュール一覧が取得できる | E-07 (L307-324) | ○ |
| C-91 | GetModuleで指定モジュールが取得できる | E-07 (L293-305) | ○ |
| C-92 | GetModuleで空文字の場合ArgumentException | E-07 (L295) | ○ |
| C-93 | GetCustomAttributesでカスタム属性が取得できる | E-07 (L283-286) | ○ |
| C-94 | IsDefinedで属性の存在確認ができる | E-07 (L273-276) | ○ |

### Marshal関連（UT-MON-095〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | GetLastPInvokeErrorでエラーが取得できる | E-08 (L23-24) | ○ |
| C-96 | SetLastPInvokeErrorでエラーが設定できる | E-08 (L30-31) | ○ |
| C-97 | IsPinnableでnullの場合trueが返る | E-08 (L48-49) | ○ |
| C-98 | IsPinnableで文字列の場合trueが返る | E-08 (L48-49) | ○ |
| C-99 | IsPinnableで参照型の場合falseが返る | E-08 (L50-52) | ○ |
| C-100 | GetExceptionPointersでPlatformNotSupportedException | E-08 (L92-95) | ○ |

### DynamicMethod関連（UT-MON-101〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | CreateDelegateでデリゲートが作成される | E-09 (L39-48) | ○ |
| C-102 | CreateDelegateでnullの場合ArgumentNullException | E-09 (L41) | ○ |
| C-103 | CreateDelegateでターゲット付きデリゲートが作成される | E-09 (L50-58) | ○ |
| C-104 | GetILGeneratorでILGeneratorが取得できる | E-09 (L62-67) | ○ |
| C-105 | Invokeでメソッドが実行される | E-09 (L69-83) | ○ |
| C-106 | VarArgs呼び出し規約でNotSupportedException | E-09 (L71-72) | ○ |

### RuntimeILGenerator関連（UT-MON-107〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | Emitでオペコードが出力される | E-10 (L481-485) | ○ |
| C-108 | Emit(byte)でbyte引数付きオペコードが出力される | E-10 (L487-492) | ○ |
| C-109 | Emit(int)でint引数付きオペコードが出力される | E-10 (L529-534) | ○ |
| C-110 | DeclareLocalでローカル変数が宣言できる | E-10 (L439-461) | ○ |
| C-111 | DeclareLocalでピン留めローカル変数が宣言できる | E-10 (L445) | ○ |
| C-112 | DeclareLocalでnullの場合ArgumentNullException | E-10 (L441) | ○ |
| C-113 | DefineLabelでラベルが定義できる | E-10 (L463-479) | ○ |
| C-114 | MarkLabelでラベルがマークできる | E-10 (L832-841) | ○ |
| C-115 | MarkLabelで無効なラベルの場合ArgumentException | E-10 (L834-835) | ○ |
| C-116 | MarkLabelで再定義の場合ArgumentException | E-10 (L836-837) | ○ |
| C-117 | BeginExceptionBlockで例外ブロックが開始できる | E-10 (L381-401) | ○ |
| C-118 | BeginCatchBlockでcatchブロックが開始できる | E-10 (L346-370) | ○ |
| C-119 | BeginCatchBlockで例外ブロック外の場合NotSupportedException | E-10 (L348-349) | ○ |
| C-120 | BeginFinallyBlockでfinallyブロックが開始できる | E-10 (L419-434) | ○ |
| C-121 | BeginFaultBlockでfaultブロックが開始できる | E-10 (L403-417) | ○ |
| C-122 | EndExceptionBlockで例外ブロックが終了できる | E-10 (L813-827) | ○ |
| C-123 | EndExceptionBlockで例外ブロック外の場合NotSupportedException | E-10 (L815-816) | ○ |
| C-124 | EmitCallでメソッド呼び出しが出力される | E-10 (L774-794) | ○ |
| C-125 | EmitCallで無効なオペコードの場合NotSupportedException | E-10 (L778-779) | ○ |

### RuntimeHelpers関連（UT-MON-126〜150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | InitializeArrayで配列が初期化される | E-11 (L15-21) | ○ |
| C-127 | InitializeArrayでnullの場合ArgumentNullException | E-11 (L17) | ○ |
| C-128 | GetHashCodeでハッシュコードが返る | E-11 (L40-47) | ○ |
| C-129 | GetHashCodeで一貫したハッシュが返る | E-11 (L40-47) | ○ |
| C-130 | TryGetHashCodeで未割当の場合0が返る | E-11 (L58-64) | ○ |
| C-131 | Equalsで同一参照の場合trueが返る | E-11 (L66-68) | ○ |
| C-132 | Equalsでnullの場合falseが返る | E-11 (L70-71) | ○ |
| C-133 | GetObjectValueで値型のコピーが返る | E-11 (L82) | ○ |
| C-134 | GetUninitializedObjectで未初期化オブジェクトが返る | E-11 (L207-224) | ○ |
| C-135 | GetUninitializedObjectでRuntimeType以外の場合SerializationException | E-11 (L216-220) | ○ |
| C-136 | RunClassConstructorでクラスコンストラクタが実行される | E-11 (L85-91) | ○ |
| C-137 | RunClassConstructorで無効なハンドルの場合ArgumentException | E-11 (L87-88) | ○ |
| C-138 | EnsureSufficientExecutionStackで十分なスタックがある場合正常終了 | E-11 (L93-99) | ○ |
| C-139 | EnsureSufficientExecutionStackでスタック不足の場合InsufficientExecutionStackException | E-11 (L97-98) | ○ |
| C-140 | TryEnsureSufficientExecutionStackで十分なスタックの場合true | E-11 (L101-104) | ○ |
| C-141 | AllocateTypeAssociatedMemoryでメモリが確保される | E-11 (L149-160) | ○ |
| C-142 | AllocateTypeAssociatedMemoryで負のサイズの場合ArgumentOutOfRangeException | E-11 (L156) | ○ |
| C-143 | AllocateTypeAssociatedMemoryでRuntimeType以外の場合ArgumentException | E-11 (L151-154) | ○ |
| C-144 | PrepareMethodでメソッドが準備される | E-11 (L110-133) | ○ |
| C-145 | PrepareMethodで無効なハンドルの場合ArgumentException | E-11 (L112-113) | ○ |
| C-146 | Boxで値型がボックス化される | E-11 (L264-295) | ○ |
| C-147 | BoxでnullハンドルでArgumentNullException | E-11 (L266-267) | ○ |
| C-148 | BoxでByRefLike型でNotSupportedException | E-11 (L290-291) | ○ |
| C-149 | SizeOfで型のサイズが返る | E-11 (L309-319) | ○ |
| C-150 | SizeOfでnullハンドルでArgumentNullException | E-11 (L311-312) | ○ |

## 4) 不足情報（Unknown / Missing）
- **InternalCallメソッドの内部実装**：MethodImplOptions.InternalCallで宣言されたメソッドはネイティブ実装のため、C#コードからは具体的な動作を検証できない
  - 候補：mono/metadata配下のCソースコード / テストスイートの結果 / .NET仕様書
- **GC通知機能の実装状況**：_RegisterForFullGCNotification等はNotImplementedExceptionをスローする
  - 候補：Mono特有の制限として文書化 / CoreCLRとの差異を明記
- **プラットフォーム依存の動作**：TARGET_UNIX, TARGET_BROWSER等のコンパイルフラグによる動作の違い
  - 候補：各プラットフォームでの個別テスト / 条件付きコンパイルの網羅的テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - TypeSpec、TypeIdentifier、基本的なReflection操作：十分なコードカバレッジあり
- **1: 中リスク** - GC、Thread、Monitor：InternalCallの動作はネイティブコードに依存
- **2: 高リスク** - ILGenerator：動的コード生成は複雑なケースでの動作検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TypeSpec.Parseの各種型構文（配列、ポインタ、ジェネリック）が正しく解析されることを確認
- [ ] Delegateの共変性・反変性の動作が期待通りであることを確認
- [ ] GCメソッドの境界条件（負数、ゼロ）のエラーハンドリングを確認
- [ ] Thread/Monitorの同期プリミティブがスレッドセーフであることを確認
- [ ] ILGeneratorの例外ブロック生成が正しいILを出力することを確認
- [ ] RuntimeHelpersのBox/SizeOfがすべての値型で動作することを確認
- [ ] InternalCallメソッドの戻り値と例外が仕様通りであることを確認（ネイティブテスト必須）
