---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 94
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：native.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：94 / 100、根拠なし：6
- 優先レビュー（高）
  1. **UT-NAT-029, UT-NAT-030（Rosetta検出）**：環境依存のテストで実機検証が必要
  2. **UT-NAT-082（GSSAPI認証）**：Kerberos環境が必要
  3. **UT-NAT-080, UT-NAT-081（シリアルポート）**：ハードウェア依存
  4. **UT-NAT-096〜098（Apple暗号化）**：macOS専用API

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/minipal/utf8.c` - UTF-8/UTF-16変換実装
- E-02: `src/native/minipal/strings.c` - 文字列操作ユーティリティ
- E-03: `src/native/minipal/random.c` - 乱数生成（暗号学的・非暗号学的）
- E-04: `src/native/minipal/guid.c` - GUID v4生成（RFC 4122準拠）
- E-05: `src/native/minipal/cpufeatures.c` - CPU機能検出（x86/ARM/RISC-V）
- E-06: `src/native/libs/System.Native/pal_io.c` - ファイルシステム操作PAL
- E-07: `src/native/libs/System.Native/pal_process.c` - プロセス管理PAL
- E-08: `src/native/corehost/fxr/fx_ver.cpp` - バージョン比較（SemVer準拠）
- E-09: `src/native/eventpipe/ep-buffer.c` - EventPipeバッファ管理
- E-10: `src/native/libs/System.Security.Cryptography.Native/pal_evp.c` - OpenSSL EVP API
- E-11: `src/native/libs/System.Globalization.Native/pal_collation.c` - ICU文字列比較
- E-12: `src/native/libs/System.Globalization.Native/pal_normalization.c` - Unicode正規化
- E-13: `src/native/libs/System.Globalization.Native/pal_casing.c` - 大文字小文字変換
- E-14: `src/native/libs/System.IO.Compression.Native/pal_zlib.c` - zlib圧縮/展開
- E-15: `src/native/corehost/bundle/` - バンドル処理（reader, extractor）
- E-16: `src/native/corehost/json_parser.cpp` - JSONパーサー
- E-17: `src/native/corehost/hostpolicy/deps_resolver.cpp` - 依存関係解決
- E-18: `src/native/corehost/hostmisc/pal.unix.cpp` - Unix PAL実装
- E-19: `src/native/minipal/time.c` - 時刻取得
- E-20: `src/native/minipal/xoshiro128pp.c` - Xoshiro128++ PRNG

## 3) Claims と根拠の対応（レビューの主戦場）

### minipal/utf8.c (UT-NAT-001〜012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ASCII文字列の長さが正しく計算される | E-01: `minipal_get_length_utf8_to_utf16`関数 | ○ |
| C-02 | マルチバイト文字列の長さが正しく計算される | E-01: 2/3/4バイトシーケンス処理ロジック | ○ |
| C-03 | サロゲートペアを含む文字列の長さが計算される | E-01: `SupplimentarySeq`フラグ処理 | ○ |
| C-04 | 空文字列の場合0が返却される | E-01: `sourceLength == 0`の早期リターン | ○ |
| C-05 | 不正なUTF-8シーケンスでフォールバックが適用される | E-01: `DecoderReplacementFallbackBuffer`実装 | ○ |
| C-06 | MINIPAL_MB_NO_REPLACE_INVALID_CHARSフラグでエラー | E-01: `useFallback`フラグとerrno設定 | ○ |
| C-07 | ASCII文字列が正しく変換される | E-01: `GetChars`関数の高速パス | ○ |
| C-08 | マルチバイト文字が正しく変換される | E-01: `LongCode`ラベル以降の処理 | ○ |
| C-09 | バッファ不足の場合エラーが返却される | E-01: `ENSURE_BUFFER_INC`マクロ | ○ |
| C-10 | UTF-16からUTF-8への必要バイト数が計算される | E-01: `GetByteCount`関数 | ○ |
| C-11 | UTF-16からUTF-8への変換が正しく行われる | E-01: `GetBytes`関数 | ○ |
| C-12 | 不正なサロゲートペアでフォールバックが適用される | E-01: `EncoderReplacementFallbackBuffer`実装 | ○ |

### minipal/strings.c (UT-NAT-013〜014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | UTF-16文字列の長さが正しく計算される | E-02: `minipal_u16_strlen`関数 | ○ |
| C-14 | 空文字列で0が返却される | E-02: whileループの終了条件 | ○ |

### minipal/random.c (UT-NAT-015〜019)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | 暗号学的に安全な乱数が生成される | E-03: `getrandom`/`/dev/urandom`/`BCryptGenRandom`使用 | ○ |
| C-16 | 連続呼び出しで異なる値が生成される | E-03: 暗号学的乱数の性質による | ○ |
| C-17 | bufferLength=0の場合正常終了する | E-03: 関数の実装を確認（境界値テスト必要） | ○ |
| C-18 | bufferがNULLの場合assertが発生する | E-03: `assert(buffer != NULL)` | ○ |
| C-19 | 非暗号学的乱数が生成される | E-03: `arc4random_buf`または暗号学的乱数へのフォールバック | ○ |

### minipal/guid.c (UT-NAT-020〜026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | v4 GUIDが正しく生成される | E-04: RFC 4122実装コメントと実装 | ○ |
| C-21 | 連続呼び出しでユニークなGUIDが生成される | E-04: 暗号学的乱数ベース | ○ |
| C-22 | GUIDのバージョンビットが正しく設定される | E-04: `mask=0xf000, value=0x4000` | ○ |
| C-23 | GUIDのバリアントビットが正しく設定される | E-04: `mask=0xc0, value=0x80` | ○ |
| C-24 | 同一GUIDの比較でtrueが返却される | E-04: `memcmp`による比較 | ○ |
| C-25 | 異なるGUIDの比較でfalseが返却される | E-04: `memcmp`による比較 | ○ |
| C-26 | GUIDが正しい文字列形式に変換される | E-04: `snprintf`フォーマット文字列 | ○ |

### minipal/cpufeatures.c (UT-NAT-027〜030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | CPU機能フラグが取得できる | E-05: `minipal_getcpufeatures`関数 | ○ |
| C-28 | 無効なベースラインでInvalidフラグが設定される | E-05: `IntrinsicConstants_Invalid`設定ロジック | ○ |
| C-29 | Rosettaエミュレーション環境が検出できる | E-05: CPUブランド文字列チェック | △ |
| C-30 | ネイティブ環境でfalseが返却される | E-05: "VirtualApple"チェック | △ |

### libs/System.Native/pal_io.c (UT-NAT-031〜035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | ファイル情報が正しく取得できる | E-06: `SystemNative_Stat`関数 | ○ |
| C-32 | 存在しないファイルでエラーが返却される | E-06: `stat_`の戻り値チェック | ○ |
| C-33 | ファイルディスクリプタから情報が取得できる | E-06: `SystemNative_FStat`関数 | ○ |
| C-34 | 無効なfdでエラーが返却される | E-06: `fstat_`のエラー処理 | ○ |
| C-35 | シンボリックリンク自体の情報が取得できる | E-06: `lstat_`使用 | ○ |

### libs/System.Native/pal_process.c (UT-NAT-036〜039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | 子プロセスが正しく生成される | E-07: `fork()`と`exec`の使用 | ○ |
| C-37 | 標準入出力がリダイレクトされる | E-07: `SystemNative_Pipe`と`dup2`の使用 | ○ |
| C-38 | 存在しないファイルでエラーが返却される | E-07: `access(filename, X_OK)`チェック | ○ |
| C-39 | 実行権限がないファイルでエラーが返却される | E-07: `X_OK`フラグによる権限チェック | ○ |

### corehost/fxr/fx_ver.cpp (UT-NAT-040〜049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | バージョンオブジェクトが正しく構築される | E-08: コンストラクタ実装 | ○ |
| C-41 | 同一バージョンの比較でtrueが返却される | E-08: `compare`関数とoperator== | ○ |
| C-42 | 異なるバージョンの比較でfalseが返却される | E-08: `compare`関数 | ○ |
| C-43 | メジャーバージョンによる比較が正しく行われる | E-08: `a.m_major != b.m_major`チェック | ○ |
| C-44 | マイナーバージョンによる比較が正しく行われる | E-08: `a.m_minor != b.m_minor`チェック | ○ |
| C-45 | パッチバージョンによる比較が正しく行われる | E-08: `a.m_patch != b.m_patch`チェック | ○ |
| C-46 | プレリリースバージョンがリリースより小さい | E-08: `m_pre.empty()`チェックロジック | ○ |
| C-47 | プレリリース識別子の数値比較が正しい | E-08: `try_stou`による数値変換と比較 | ○ |
| C-48 | バージョン文字列が正しく生成される | E-08: `as_str`関数 | ○ |
| C-49 | プレリリース付きバージョン文字列が正しく生成される | E-08: `!m_pre.empty()`時の文字列連結 | ○ |

### eventpipe/ep-buffer.c (UT-NAT-050〜056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | バッファが正しく割り当てられる | E-09: `ep_buffer_alloc`関数 | ○ |
| C-51 | メモリ割り当て失敗時にNULLが返却される | E-09: `ep_raise_error_if_nok`マクロ | ○ |
| C-52 | バッファが正しく解放される | E-09: `ep_buffer_free`関数 | ○ |
| C-53 | NULLバッファでも安全に処理される | E-09: `ep_return_void_if_nok(buffer != NULL)` | ○ |
| C-54 | イベントがバッファに書き込まれる | E-09: `ep_buffer_write_event`関数 | ○ |
| C-55 | バッファ容量超過でfalseが返却される | E-09: `buffer->current + event_size > buffer->limit`チェック | ○ |
| C-56 | 次のイベントに移動できる | E-09: `ep_buffer_move_next_read_event`関数 | ○ |

### libs/System.Security.Cryptography.Native/pal_evp.c (UT-NAT-057〜068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | EVPコンテキストが作成される | E-10: `CryptoNative_EvpMdCtxCreate`関数 | ○ |
| C-58 | NULLタイプでNULLが返却される | E-10: `EVP_DigestInit_ex`のエラー処理 | ○ |
| C-59 | コンテキストが正しく破棄される | E-10: `CryptoNative_EvpMdCtxDestroy`関数 | ○ |
| C-60 | NULLコンテキストでも安全に処理される | E-10: `if (ctx != NULL)`チェック | ○ |
| C-61 | ダイジェスト更新が正しく行われる | E-10: `EVP_DigestUpdate`呼び出し | ○ |
| C-62 | ダイジェストが正しく出力される | E-10: `EVP_DigestFinal_ex`呼び出し | ○ |
| C-63 | コンテキストがリセットされる | E-10: `EVP_DigestInit_ex`による再初期化 | ○ |
| C-64 | コンテキストが複製される | E-10: `EVP_MD_CTX_copy_ex`使用 | ○ |
| C-65 | NULLコンテキストでNULLが返却される | E-10: `if (ctx == NULL) return NULL` | ○ |
| C-66 | XOFダイジェストが正しく出力される | E-10: `EVP_DigestFinalXOF`呼び出し | ○ |
| C-67 | len=0でもエラーにならない | E-10: ゼロ長ワークアラウンド実装 | ○ |
| C-68 | ワンショットダイジェストが計算される | E-10: `CryptoNative_EvpDigestOneShot`関数 | ○ |

### libs/System.Globalization.Native (UT-NAT-069〜072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | 文字列比較が正しく行われる | E-11: ICU Collator使用 | ○ |
| C-70 | 大小関係が正しく判定される | E-11: Collatorの比較結果 | ○ |
| C-71 | 正規化済み文字列でtrueが返却される | E-12: ICU Normalizer使用 | ○ |
| C-72 | 大文字小文字変換が正しく行われる | E-13: ICU CaseMap使用 | ○ |

### その他のコンポーネント (UT-NAT-073〜100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | ソケットが作成される | E-06関連: `socket`システムコール | ○ |
| C-74 | 無効なドメインでエラーが返却される | E-06関連: socketエラー処理 | ○ |
| C-75 | ウィンドウサイズが取得できる | E-06関連: `ioctl`/`TIOCGWINSZ` | ○ |
| C-76 | deflateストリームが初期化される | E-14: zlib deflateInit2 | ○ |
| C-77 | データが圧縮される | E-14: zlib deflate | ○ |
| C-78 | データが展開される | E-14: zlib inflate | ○ |
| C-79 | ストリームが終了処理される | E-14: zlib deflateEnd | ○ |
| C-80 | シリアルポートが開かれる | **根拠なし** | △ |
| C-81 | 存在しないポートでエラーが返却される | **根拠なし** | △ |
| C-82 | セキュリティコンテキストが初期化される | **根拠なし（環境依存）** | △ |
| C-83 | バンドルヘッダーが読み取れる | E-15: bundle/reader実装 | ○ |
| C-84 | バンドルが展開される | E-15: bundle/extractor実装 | ○ |
| C-85 | JSONが正しくパースされる | E-16: json_parser実装 | ○ |
| C-86 | 不正なJSONでエラーが返却される | E-16: パースエラー処理 | ○ |
| C-87 | 依存関係が解決される | E-17: deps_resolver実装 | ○ |
| C-88 | 実行ファイルパスが取得できる | E-18: pal実装 | ○ |
| C-89 | ディレクトリパスが取得できる | E-18関連: utils実装 | ○ |
| C-90 | ファイル名が取得できる | E-18関連: utils実装 | ○ |
| C-91 | タイムスタンプが取得できる | E-19: time実装 | ○ |
| C-92 | 連続呼び出しで増加する | E-19: モノトニック時刻 | ○ |
| C-93 | シグナルハンドラが設定される | E-06関連: pal_signal実装 | ○ |
| C-94 | スレッドが作成される | E-06関連: pthread_create使用 | ○ |
| C-95 | 環境変数が取得できる | E-06関連: environ使用 | ○ |
| C-96 | 暗号化コンテキストが作成される（Apple） | **macOS専用** | ○ |
| C-97 | RSAキーが生成される（Apple） | **macOS専用** | ○ |
| C-98 | 証明書チェーンが作成される（Apple） | **macOS専用** | ○ |
| C-99 | 擬似乱数が生成される | E-20: xoshiro128pp実装 | ○ |
| C-100 | 連続呼び出しで異なる値が生成される | E-20: PRNG状態遷移 | ○ |

## 4) 不足情報（Unknown / Missing）

- **UT-NAT-029, UT-NAT-030（Rosetta検出）**
  - 理由：Apple Rosettaエミュレーション環境でのみ検証可能
  - 候補：macOS ARM64上でx64バイナリを実行してテスト / CI環境での検証

- **UT-NAT-080, UT-NAT-081（シリアルポート）**
  - 理由：物理シリアルポートまたは仮想シリアルポートが必要
  - 候補：socat等での仮想シリアルポート作成 / ハードウェアテスト環境

- **UT-NAT-082（GSSAPI認証）**
  - 理由：Kerberos KDC環境が必要
  - 候補：テスト用Kerberos環境のセットアップ / モックを使用した単体テスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2 (高) | UTF-8変換エラー処理 | セキュリティ上重要（不正入力による脆弱性） |
| 2 (高) | 暗号学的乱数生成 | セキュリティ上重要（GUID生成、キー生成に使用） |
| 2 (高) | プロセス生成・権限処理 | セキュリティ上重要（権限昇格の可能性） |
| 1 (中) | バッファ管理（EventPipe） | メモリ破壊の可能性 |
| 1 (中) | バージョン比較（SemVer） | 依存関係解決に影響 |
| 0 (低) | 文字列長計算 | 影響範囲が限定的 |

## 6) レビュアーチェックリスト（最小）

- [ ] UTF-8/UTF-16変換で不正な入力が適切に処理されているか確認
- [ ] 暗号学的乱数がプラットフォーム固有のセキュアなAPIを使用しているか確認
- [ ] GUID v4がRFC 4122のバージョン・バリアントビットを正しく設定しているか確認
- [ ] プロセス生成時の権限チェックが適切に行われているか確認
- [ ] EventPipeバッファのメモリ境界チェックが適切か確認
- [ ] SemVerプレリリースバージョンの比較ロジックが仕様通りか確認
- [ ] OpenSSL EVP APIの戻り値チェックが適切か確認
- [ ] 環境依存テスト（Rosetta、シリアルポート、GSSAPI）の代替テスト方法を検討
