---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：src-coreclr 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-CLR-097 (Thread.Interrupt)**: スレッド割り込みの詳細な動作確認が必要
  2. **UT-CLR-058 (GC.RefreshMemoryLimit)**: 内部実装の詳細が不明
  3. **UT-CLR-082 (RuntimeHelpers.Box)**: 内部MethodTable構造に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/coreclr/tools/ILVerification/Verifier.cs`
- E-02: `src/coreclr/tools/ILVerification/AccessVerificationHelpers.cs`
- E-03: `src/coreclr/tools/ILVerification/TypeVerifier.cs`
- E-04: `src/coreclr/System.Private.CoreLib/src/System/GC.CoreCLR.cs`
- E-05: `src/coreclr/System.Private.CoreLib/src/System/Runtime/CompilerServices/RuntimeHelpers.CoreCLR.cs`
- E-06: `src/coreclr/System.Private.CoreLib/src/System/Threading/Thread.CoreCLR.cs`
- E-07: `src/coreclr/tools/dotnet-pgo/MethodMemoryMap.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ILVerify関連 (UT-CLR-001 ~ UT-CLR-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Verifierコンストラクタの正常初期化 | E-01 (行27-35) | ○ |
| C-02 | Verifierコンストラクタのnull処理 | E-01 | ○ |
| C-03 | SetSystemModuleNameの正常動作 | E-01 (行37-45) | ○ |
| C-04 | SetSystemModuleNameのエラー処理 | E-01 (行40-43) | ○ |
| C-05 | Verify(PEReader)の正常動作 | E-01 (行52-79) | ○ |
| C-06 | Verify(PEReader)のnull検証 | E-01 (行54-57) | ○ |
| C-07 | Verify(PEReader)のSystemModule検証 | E-01 (行59-62) | ○ |
| C-08 | Verify(PEReader, TypeDefinitionHandle)の正常動作 | E-01 (行81-121) | ○ |
| C-09 | Verify(PEReader, TypeDefinitionHandle)のnull検証 | E-01 (行88-91) | ○ |
| C-10 | Verify(PEReader, MethodDefinitionHandle)の正常動作 | E-01 (行123-155) | ○ |
| C-11 | TypeVerifier.Verifyの正常動作 | E-03 (行40-43) | ○ |
| C-12 | TypeVerifier.VerifyInterfacesの重複検出 | E-03 (行65-88) | ○ |
| C-13 | TypeVerifier.VerifyInterfacesの未実装検出 | E-03 (行90-114) | ○ |
| C-14 | AccessVerificationHelpers.CanAccess(Type)のpublic検証 | E-02 (行22-56) | ○ |
| C-15 | AccessVerificationHelpers.CanAccessのジェネリック対応 | E-02 (行24-25) | ○ |
| C-16 | AccessVerificationHelpers.CanAccessのinternal検証 | E-02 (行46-47) | ○ |
| C-17 | AccessVerificationHelpers.CanAccess(Method)の正常動作 | E-02 (行62-78) | ○ |
| C-18 | AccessVerificationHelpers.CanAccess(Field)の正常動作 | E-02 (行84-97) | ○ |

### GC関連 (UT-CLR-019 ~ UT-CLR-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | GetGCMemoryInfo()の正常動作 | E-04 (行68) | ○ |
| C-20 | GetGCMemoryInfo(GCKind)の正常動作 | E-04 (行73-87) | ○ |
| C-21 | GetGCMemoryInfo(GCKind)の境界値検証 | E-04 (行75-82) | ○ |
| C-22 | AddMemoryPressureの正常動作 | E-04 (行133-142) | ○ |
| C-23 | AddMemoryPressureの負値検証 | E-04 (行135) | ○ |
| C-24 | AddMemoryPressureの0値検証 | E-04 (行135) | ○ |
| C-25 | RemoveMemoryPressureの正常動作 | E-04 (行144-153) | ○ |
| C-26 | RemoveMemoryPressureの負値検証 | E-04 (行146) | ○ |
| C-27 | GetGeneration(object)の正常動作 | E-04 (行157-161) | ○ |
| C-28 | GetGeneration(object)のnull検証 | E-04 (行159) | ○ |
| C-29 | Collect()の正常動作 | E-04 (行175-179) | ○ |
| C-30 | Collect(int)の正常動作 | E-04 (行168-171) | ○ |
| C-31 | Collect(int)の負値検証 | E-04 (行199) | ○ |
| C-32 | Collectのaggressiveモード動作 | E-04 (行192-244) | ○ |
| C-33 | Aggressiveモードの世代制約 | E-04 (行215-218) | ○ |
| C-34 | Aggressiveモードのblocking制約 | E-04 (行219-222) | ○ |
| C-35 | CollectionCountの正常動作 | E-04 (行246-250) | ○ |
| C-36 | CollectionCountの負値検証 | E-04 (行248) | ○ |
| C-37 | KeepAliveの正常動作 | E-04 (行287-291) | ○ |
| C-38 | SuppressFinalizeの正常動作 | E-04 (行354-363) | ○ |
| C-39 | SuppressFinalizeのnull検証 | E-04 (行356) | ○ |
| C-40 | ReRegisterForFinalizeの正常動作 | E-04 (行372-383) | ○ |
| C-41 | ReRegisterForFinalizeのnull検証 | E-04 (行374) | ○ |
| C-42 | GetTotalMemory(false)の正常動作 | E-04 (行389-411) | ○ |
| C-43 | GetTotalMemory(true)の正常動作 | E-04 (行394-410) | ○ |
| C-44 | GetAllocatedBytesForCurrentThreadの正常動作 | E-04 (行420) | ○ |
| C-45 | GetTotalAllocatedBytesの正常動作 | E-04 (行427) | ○ |
| C-46 | RegisterForFullGCNotificationの正常動作 | E-04 (行447-471) | ○ |
| C-47 | RegisterForFullGCNotificationのしきい値検証(0) | E-04 (行449-456) | ○ |
| C-48 | RegisterForFullGCNotificationのしきい値検証(100) | E-04 (行449-456) | ○ |
| C-49 | TryStartNoGCRegionの正常動作 | E-04 (行546-548) | ○ |
| C-50 | TryStartNoGCRegionの負値検証 | E-04 (行522) | ○ |
| C-51 | TryStartNoGCRegionの0値検証 | E-04 (行522) | ○ |
| C-52 | EndNoGCRegionの正常動作 | E-04 (行566-575) | ○ |
| C-53 | EndNoGCRegionの状態検証 | E-04 (行569-570) | ○ |
| C-54 | AllocateUninitializedArrayの正常動作 | E-04 (行799-834) | ○ |
| C-55 | AllocateArrayの正常動作 | E-04 (行842-854) | ○ |
| C-56 | GetTotalPauseDurationの正常動作 | E-04 (行863-866) | ○ |
| C-57 | GetConfigurationVariablesの正常動作 | E-04 (行915-924) | ○ |
| C-58 | RefreshMemoryLimitの正常動作 | E-04 (行969-998) | △ |

### RuntimeHelpers関連 (UT-CLR-059 ~ UT-CLR-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | InitializeArrayの正常動作 | E-05 (行19-87) | ○ |
| C-60 | InitializeArrayのnull検証 | E-05 (行21-22) | ○ |
| C-61 | InitializeArrayの無効ハンドル検証 | E-05 (行24-25) | ○ |
| C-62 | GetObjectValueの値型クローン | E-05 (行141-156) | ○ |
| C-63 | GetObjectValueの参照型返却 | E-05 (行148-149) | ○ |
| C-64 | GetObjectValueのnull処理 | E-05 (行143-144) | ○ |
| C-65 | RunClassConstructorの正常動作 | E-05 (行170-176) | ○ |
| C-66 | RunClassConstructorの無効ハンドル検証 | E-05 (行172-173) | ○ |
| C-67 | RunModuleConstructorの正常動作 | E-05 (行189-195) | ○ |
| C-68 | PrepareMethodの正常動作 | E-05 (行203-220) | ○ |
| C-69 | PrepareDelegateの正常動作 | E-05 (行225-233) | ○ |
| C-70 | PrepareDelegateのnull処理 | E-05 (行227-230) | ○ |
| C-71 | GetHashCodeの正常動作 | E-05 (行245-263) | ○ |
| C-72 | GetHashCodeのnull処理 | E-05 (行257-260) | ○ |
| C-73 | Equalsの同一参照比較 | E-05 (行265-287) | ○ |
| C-74 | Equalsの異なる参照比較 | E-05 (行269-273) | ○ |
| C-75 | Equalsの値型比較 | E-05 (行275-286) | ○ |
| C-76 | EnsureSufficientExecutionStackの正常動作 | E-05 (行317-323) | ○ |
| C-77 | TryEnsureSufficientExecutionStackの正常動作 | E-05 (行328-329) | ○ |
| C-78 | GetUninitializedObjectの正常動作 | E-05 (行331-347) | ○ |
| C-79 | GetUninitializedObjectのnull検証 | E-05 (行340-342) | ○ |
| C-80 | AllocateTypeAssociatedMemoryの正常動作 | E-05 (行477-487) | ○ |
| C-81 | AllocateTypeAssociatedMemoryの負値検証 | E-05 (行484) | ○ |
| C-82 | Boxの正常動作 | E-05 (行450-451) | △ |
| C-83 | SizeOfの正常動作 | E-05 (行632-643) | ○ |
| C-84 | SizeOfの無効ハンドル検証 | E-05 (行634-635) | ○ |

### Thread関連 (UT-CLR-085 ~ UT-CLR-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | ManagedThreadIdの正常動作 | E-06 (行75-79) | ○ |
| C-86 | GetNativeHandleの正常動作 | E-06 (行82-93) | ○ |
| C-87 | GetNativeHandleの未初期化検証 | E-06 (行87-90) | ○ |
| C-88 | SpinWaitの正常動作 | E-06 (行146-158) | ○ |
| C-89 | Yieldの正常動作 | E-06 (行163) | ○ |
| C-90 | IsAliveの正常動作 | E-06 (行201) | ○ |
| C-91 | IsBackgroundの正常動作 | E-06 (行207-234) | ○ |
| C-92 | IsBackgroundの終了スレッド検証 | E-06 (行211-214, 221-225) | ○ |
| C-93 | IsThreadPoolThreadの正常動作 | E-06 (行244-266) | ○ |
| C-94 | Priorityの正常動作 | E-06 (行273-289) | ○ |
| C-95 | Priorityの終了スレッド検証 | E-06 (行277-280) | ○ |
| C-96 | ThreadStateの正常動作 | E-06 (行298-311) | ○ |
| C-97 | Interruptの正常動作 | E-06 (行435-443) | △ |

### MethodMemoryMap関連 (UT-CLR-098 ~ UT-CLR-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | GetInfoの正常動作 | E-07 (行226-240) | ○ |
| C-99 | GetInfoの境界外検証 | E-07 (行232-236) | ○ |
| C-100 | GetMethodの正常動作 | E-07 (行242) | ○ |

## 4) 不足情報（Unknown / Missing）
- **RefreshMemoryLimit（C-58）**: 内部のGCヒープ制限更新ロジックの詳細が不明。AppContextからの設定読み込みは確認できるが、実際のGC動作への反映は確認困難
  - 候補：GCInterface_RefreshMemoryLimit のネイティブ実装 / GC設定のドキュメント
- **Box（C-82）**: MethodTable構造体を利用したボックス化の詳細が内部実装に依存
  - 候補：CastHelpers.Box / CastHelpers.Box_Nullable の実装詳細
- **Interrupt（C-97）**: プラットフォーム別の割り込み実装詳細が異なる
  - 候補：WaitSubsystem.Interrupt (Unix) / ThreadNative_Interrupt (Windows) の実装詳細

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコードから明確に根拠が取得可能
- **1 (中リスク)**: GC.RefreshMemoryLimit、RuntimeHelpers.Box - 内部実装に依存するため、実行時の動作確認が推奨
- **1 (中リスク)**: Thread.Interrupt - プラットフォーム依存のため、各プラットフォームでのテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] ILVerify関連のテストケースがVerifier.csの主要メソッドをカバーしているか確認
- [ ] GC関連のテストケースが境界値（0、負値、最大値）を適切にカバーしているか確認
- [ ] RuntimeHelpers関連のテストケースがnull検証を含んでいるか確認
- [ ] Thread関連のテストケースがスレッド状態（未開始、実行中、終了）を考慮しているか確認
- [ ] 根拠なし（△）の項目について、追加の情報源を特定できるか検討
- [ ] プラットフォーム依存のテストケース（Thread.Interrupt等）の対応方針を確認
