---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 125
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-installer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：125 / 125、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースはソースコードに基づいて生成されており、根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/installer/managed/Microsoft.NET.HostModel/Bundle/Bundler.cs`
- E-02: `src/installer/managed/Microsoft.NET.HostModel/Bundle/FileEntry.cs`
- E-03: `src/installer/managed/Microsoft.NET.HostModel/Bundle/FileSpec.cs`
- E-04: `src/installer/managed/Microsoft.NET.HostModel/Bundle/Manifest.cs`
- E-05: `src/installer/managed/Microsoft.NET.HostModel/Bundle/TargetInfo.cs`
- E-06: `src/installer/managed/Microsoft.NET.HostModel/Bundle/FileType.cs`
- E-07: `src/installer/managed/Microsoft.NET.HostModel/AppHost/HostWriter.cs`
- E-08: `src/installer/managed/Microsoft.NET.HostModel/AppHost/BinaryUtils.cs`
- E-09: `src/installer/managed/Microsoft.NET.HostModel/AppHost/PEUtils.cs`
- E-10: `src/installer/managed/Microsoft.NET.HostModel/AppHost/ElfUtils.cs`
- E-11: `src/installer/managed/Microsoft.NET.HostModel/AppHost/RetryUtil.cs`
- E-12: `src/installer/managed/Microsoft.NET.HostModel/AppHost/AppHostExceptions.cs`
- E-13: `src/installer/managed/Microsoft.NET.HostModel/ComHost/ClsidMap.cs`
- E-14: `src/installer/managed/Microsoft.NET.HostModel/ComHost/ComHost.cs`
- E-15: `src/installer/managed/Microsoft.NET.HostModel/ComHost/RegFreeComManifest.cs`
- E-16: `src/installer/managed/Microsoft.NET.HostModel/MachO/MachObjectFile.cs`
- E-17: `src/installer/managed/Microsoft.NET.HostModel/MachO/BinaryFormat/Blobs/CodeDirectoryBlob.cs`
- E-18: `src/installer/managed/Microsoft.NET.HostModel/ResourceUpdater.cs`
- E-19: `src/installer/managed/Microsoft.NET.HostModel/HostModelUtils.cs`
- E-20: `src/installer/managed/Microsoft.NET.HostModel/Utils/Base64Url.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Bundle関連（UT-INS-001 から UT-INS-049）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BundlerコンストラクタでhostNameにパス区切り文字が含まれる場合ArgumentExceptionがスロー | E-01 Line 53-56 | ○ |
| C-02 | Bundlerコンストラクタでフレームワーク6未満で圧縮オプション指定時例外 | E-01 Line 62-66 | ○ |
| C-03 | GenerateBundleで空のSourcePathを持つFileSpecで例外 | E-01 Line 273-276 | ○ |
| C-04 | GenerateBundleでホストバイナリ未指定時例外 | E-01 Line 277-285 | ○ |
| C-05 | GenerateBundleで重複BundleRelativePathで異なるSourcePath時例外 | E-01 Line 478-483 | ○ |
| C-06 | IsBundleでバンドルファイル判定 | E-01 Line 422-446 | ○ |
| C-07 | GetBinaryWriterStringLengthで文字列長計算 | E-01 Line 499-511 | ○ |
| C-08 | ShouldCompressで圧縮判定ロジック | E-01 Line 78-94 | ○ |
| C-09 | FileEntryコンストラクタでパス正規化（バックスラッシュ変換） | E-02 Line 38 | ○ |
| C-10 | FileEntry.Writeでバージョン6以上でCompressedSize書き込み | E-02 Line 44-57 | ○ |
| C-11 | FileEntry.GetFileEntryLengthでバージョン別長さ計算 | E-02 Line 63-70 | ○ |
| C-12 | FileSpec.IsValidで空値チェック | E-03 Line 28-32 | ○ |
| C-13 | Manifestコンストラクタでcompat modeフラグ設定 | E-04 Line 88-93 | ○ |
| C-14 | Manifest.AddEntryでファイルエントリ追加 | E-04 Line 95-126 | ○ |
| C-15 | Manifest.AddEntryでWrite後呼び出し時例外 | E-04 Line 97-100 | ○ |
| C-16 | Manifest.Writeでマニフェスト書き込み | E-04 Line 148-180 | ○ |
| C-17 | Manifest.GetManifestLengthで長さ計算 | E-04 Line 185-201 | ○ |
| C-18 | Manifest.Containsで相対パス検索 | E-04 Line 203-206 | ○ |
| C-19 | TargetInfoコンストラクタでアーキテクチャ別アライメント設定 | E-05 Line 59-82 | ○ |
| C-20 | TargetInfoコンストラクタでフレームワークバージョン別BundleMajorVersion設定 | E-05 Line 39-57 | ○ |
| C-21 | TargetInfo.IsNativeBinaryでプラットフォーム別バイナリ判定 | E-05 Line 85-88 | ○ |
| C-22 | TargetInfo.GetAssemblyNameでプラットフォーム別処理 | E-05 Line 90-95 | ○ |
| C-23 | TargetInfo.ShouldExcludeでバージョン3以外のhostfxr/hostpolicy除外 | E-05 Line 123-127 | ○ |

### AppHost関連（UT-INS-050 から UT-INS-073）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | HostWriter.CreateAppHostでパス長1024バイト制限 | E-07 Line 77-81 | ○ |
| C-25 | HostWriter.CreateAppHostで非PEファイルにGUIオプション指定時例外 | E-07 Line 102-108 | ○ |
| C-26 | HostWriter.CreateAppHostで非Mach-OファイルにmacOS署名指定時例外 | E-07 Line 139-143 | ○ |
| C-27 | HostWriter.CreateAppHostでAppRelativeDotNet絶対パス検証 | E-07 Line 209-210 | ○ |
| C-28 | HostWriter.CreateAppHostでAppRelativeDotNet長さ制限 | E-07 Line 216-217 | ○ |
| C-29 | BinaryUtils.SearchAndReplaceでパターン置換 | E-08 Line 12-49 | ○ |
| C-30 | BinaryUtils.SearchAndReplaceでパターン未検出時例外 | E-08 Line 26-29 | ○ |
| C-31 | BinaryUtils.SearchAndReplaceでゼロパディング | E-08 Line 37-39, 51-60 | ○ |
| C-32 | BinaryUtils.SearchInFileでパターン検索 | E-08 Line 77-92 | ○ |
| C-33 | BinaryUtils.CopyFileでディレクトリ作成 | E-08 Line 165-175 | ○ |
| C-34 | BinaryUtils.WriteToStreamでストリーム書き込み | E-08 Line 177-200 | ○ |
| C-35 | PEUtils.IsPEImageでPEファイル判定 | E-09 Line 19-28, 30-42 | ○ |
| C-36 | PEUtils.SetWindowsGraphicalUserInterfaceBitでサブシステム変更 | E-09 Line 81-92 | ○ |
| C-37 | PEUtils.SetWindowsGraphicalUserInterfaceBitで非CUI例外 | E-09 Line 87-88 | ○ |
| C-38 | PEUtils.RemoveCetCompatBitでCETビット削除 | E-09 Line 49-75 | ○ |
| C-39 | ElfUtils.IsElfImageでELFファイル判定 | E-10 Line 15-32 | ○ |
| C-40 | ElfUtils.IsElfImageで16バイト未満ファイル判定 | E-10 Line 20-23 | ○ |

### ComHost関連（UT-INS-074 から UT-INS-084）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ClsidMap.CreateでCLSIDマップ生成 | E-13 Line 33-72 | ○ |
| C-42 | ClsidMap.CreateでGuidAttribute未指定時例外 | E-13 Line 188-202 | ○ |
| C-43 | ClsidMap.CreateでGUID重複時例外 | E-13 Line 51-54 | ○ |
| C-44 | ComHost.CreateでComHostファイル作成 | E-14 Line 24-69 | ○ |
| C-45 | ComHost.Createでタイプライブラリ埋め込み | E-14 Line 45-67 | ○ |
| C-46 | ComHost.Createで無効タイプライブラリID例外 | E-14 Line 49-52 | ○ |
| C-47 | ComHost.Createで空タイプライブラリ例外 | E-14 Line 57-58 | ○ |
| C-48 | ComHost.Createで存在しないタイプライブラリ例外 | E-14 Line 62-65 | ○ |
| C-49 | RegFreeComManifest.CreateManifestFromClsidmapでマニフェスト生成 | E-15 Line 26-52 | ○ |

### MachO関連（UT-INS-085 から UT-INS-099）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | MachObjectFile.Createで有効なMach-O解析 | E-16 Line 74-103 | ○ |
| C-51 | MachObjectFile.Createで非Mach-O時例外 | E-16 Line 77-78 | ○ |
| C-52 | MachObjectFile.Createで32ビット時例外 | E-16 Line 81-82 | ○ |
| C-53 | MachObjectFile.IsMachOImageでMach-O判定 | E-16 Line 176-194 | ○ |
| C-54 | MachObjectFile.AdHocSignFileで署名追加 | E-16 Line 117-128 | ○ |
| C-55 | MachObjectFile.RemoveCodeSignatureIfPresentで署名削除 | E-16 Line 204-227 | ○ |
| C-56 | MachObjectFile.TryAdjustHeadersForBundleでヘッダー調整 | E-16 Line 154-174 | ○ |
| C-57 | MachObjectFile.TryAdjustHeadersForBundleで既存署名時例外 | E-16 Line 156-160 | ○ |
| C-58 | MachObjectFile.TryAdjustHeadersForBundleでサイズ超過時false | E-16 Line 161-166 | ○ |
| C-59 | MachObjectFile.GetSignatureSizeEstimateでサイズ見積もり | E-16 Line 303-306 | ○ |
| C-60 | MachObjectFile.Writeで書き込み | E-16 Line 311-324 | ○ |
| C-61 | MachObjectFile.Writeで容量不足時例外 | E-16 Line 313-314 | ○ |

### ResourceUpdater関連（UT-INS-100 から UT-INS-110）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | ResourceUpdaterコンストラクタでPEファイル初期化 | E-18 Line 29-62 | ○ |
| C-63 | ResourceUpdater.AddResourcesFromPEImageでリソース追加 | E-18 Line 71-80 | ○ |
| C-64 | ResourceUpdater.AddResourcesFromPEImageでUpdate後例外 | E-18 Line 73-74 | ○ |
| C-65 | ResourceUpdater.AddResource(IntPtr)でリソース追加 | E-18 Line 95-107 | ○ |
| C-66 | ResourceUpdater.AddResource(IntPtr)で非整数タイプ例外 | E-18 Line 97-100 | ○ |
| C-67 | ResourceUpdater.Updateでリソース更新 | E-18 Line 135-300 | ○ |
| C-68 | ResourceUpdater.Updateで再呼び出し例外 | E-18 Line 137-138 | ○ |
| C-69 | ResourceUpdater.IsIntResourceでリソースID判定 | E-18 Line 82-85 | ○ |
| C-70 | ResourceUpdater.GetAlignedでアライメント計算 | E-18 Line 326 | ○ |

### ユーティリティ関連（UT-INS-111 から UT-INS-125）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | RetryUtil.RetryOnIOErrorでリトライ機能 | E-11 Line 23-37 | ○ |
| C-72 | RetryUtil.RetryOnIOErrorで最大リトライ回数 | E-11 Line 20-21, 32 | ○ |
| C-73 | HostModelUtils.GetFileLengthでファイル長取得 | E-19 Line 41-45 | ○ |
| C-74 | HostModelUtils.IsCodesignAvailableでcodesign存在確認 | E-19 Line 19 | ○ |
| C-75 | Base64Url.EncodeToStringでBase64Urlエンコード | E-20 Line 9-16 | ○ |
| C-76 | CodeDirectoryBlob.Createで署名ブロブ作成 | E-17 Line 117-175 | ○ |
| C-77 | CodeDirectoryBlob.GetIdentifierLengthで長さ計算 | E-17 Line 286-289 | ○ |
| C-78 | CodeDirectoryBlob.GetCodeSlotCountでスロット数計算 | E-17 Line 291-294 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全てのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースはソースコードの実装に基づいており、高い信頼性があります

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの対象クラス・メソッドがソースコード上に存在することを確認
- [ ] 正常系・異常系・境界値の観点が網羅されているか確認
- [ ] 優先度の設定が適切か確認（金額計算、セキュリティ、データ整合性は高優先度）
- [ ] テストIDの連番が正しいことを確認
- [ ] 期待結果が具体的で検証可能であることを確認
- [ ] Bundle関連の圧縮・署名機能のテストケースが十分か確認
- [ ] プラットフォーム固有機能（Windows PE, macOS Mach-O, Linux ELF）のテストが網羅されているか確認
