---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 160
  claims_with_evidence: 152
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート: src-mono 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています：

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.95**
  - 根拠あり: 152 / 160、根拠なし: 8
- 優先レビュー（高）
  1. **UT-MONO-042〜043**: GC.AllocateArrayのピン留め動作確認が実装依存
  2. **UT-MONO-044〜045**: GC通知機能がNotImplementedException
  3. **UT-MONO-087〜088**: サテライトアセンブリの存在確認が環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/mono/System.Private.CoreLib/src/System/TypeSpec.cs`
- E-02: `src/mono/System.Private.CoreLib/src/System/Delegate.Mono.cs`
- E-03: `src/mono/System.Private.CoreLib/src/System/GC.Mono.cs`
- E-04: `src/mono/System.Private.CoreLib/src/System/Threading/Thread.Mono.cs`
- E-05: `src/mono/System.Private.CoreLib/src/System/Threading/Monitor.Mono.cs`
- E-06: `src/mono/System.Private.CoreLib/src/System/Reflection/RuntimeAssembly.cs`
- E-07: `src/mono/System.Private.CoreLib/src/System/Reflection/Emit/RuntimeTypeBuilder.Mono.cs`
- E-08: `src/mono/System.Private.CoreLib/src/System/Reflection/Emit/RuntimeILGenerator.Mono.cs`
- E-09: `src/mono/System.Private.CoreLib/src/System/Runtime/InteropServices/Marshal.Mono.cs`
- E-10: `src/mono/System.Private.CoreLib/src/System/Runtime/CompilerServices/RuntimeHelpers.Mono.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### TypeSpec関連 (UT-MONO-001〜017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TypeSpec.Parseで単純な型名がパースできる | E-01: Parse()メソッド L248-534 | ○ |
| C-02 | TypeSpec.Parseでネスト型名がパースできる | E-01: AddName()メソッド L299-309、'+'の処理 L363-366 | ○ |
| C-03 | TypeSpec.Parseでジェネリック型がパースできる | E-01: generic_params処理 L456-489 | ○ |
| C-04 | TypeSpec.Parseで配列型がパースできる | E-01: IArraySpec処理 L491-516 | ○ |
| C-05 | TypeSpec.Parseで多次元配列がパースできる | E-01: dimensions処理 L493-510 | ○ |
| C-06 | TypeSpec.Parseでポインタ型がパースできる | E-01: PointerSpec処理 L413-423 | ○ |
| C-07 | TypeSpec.Parseでnull入力時にArgumentNullException | E-01: ArgumentNullException.ThrowIfNull L251 | ○ |
| C-08 | IArraySpec.Resolveで配列型が作成される | E-01: Resolve()メソッド L57-64 | ○ |
| C-09 | PointerSpec.Resolveでポインタ型が作成される | E-01: Resolve()メソッド L106-111 | ○ |
| C-10 | EscapeDisplayNameで特殊文字がエスケープされる | E-01: EscapeDisplayName()メソッド L259-283 | ○ |
| C-11 | UnescapeInternalNameでエスケープが解除される | E-01: UnescapeInternalName()メソッド L285-297 | ○ |

### Delegate関連 (UT-MONO-018〜026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | Delegate.CreateDelegateで静的メソッドからデリゲート作成 | E-02: CreateDelegate()メソッド L112-151 | ○ |
| C-13 | Delegate.CreateDelegateでインスタンスメソッドからデリゲート作成 | E-02: CreateDelegate()メソッド L153-175 | ○ |
| C-14 | 型がnullの場合ArgumentNullException | E-02: ArgumentNullException.ThrowIfNull L124 | ○ |
| C-15 | RuntimeType以外でArgumentException | E-02: RuntimeType検査 L127-128 | ○ |
| C-16 | デリゲート型以外でArgumentException | E-02: IsDelegate()検査 L132-133 | ○ |
| C-17 | Delegate.Equalsで同一ターゲット・メソッドでtrue | E-02: Equals()メソッド L486-512 | ○ |

### GC関連 (UT-MONO-027〜045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | AddMemoryPressureで正の値が受け付けられる | E-03: AddMemoryPressure()メソッド L60-68 | ○ |
| C-19 | AddMemoryPressureで0以下の値でArgumentOutOfRangeException | E-03: ThrowIfNegativeOrZero L62 | ○ |
| C-20 | RemoveMemoryPressureで0以下の値でArgumentOutOfRangeException | E-03: ThrowIfNegativeOrZero L72 | ○ |
| C-21 | Collectで負の世代でArgumentOutOfRangeException | E-03: ThrowIfNegative L99 | ○ |
| C-22 | CollectionCountで世代回数が返却される | E-03: CollectionCount()メソッド L106-110 | ○ |
| C-23 | SuppressFinalizeでnullでArgumentNullException | E-03: ThrowIfNull L140 | ○ |
| C-24 | ReRegisterForFinalizeでnullでArgumentNullException | E-03: ThrowIfNull L149 | ○ |
| C-25 | AllocateArrayでピン留め配列が確保される | E-03: AllocateArray()メソッド L296-303 | ○ |
| C-26 | RegisterForFullGCNotificationで範囲外値でArgumentOutOfRangeException | E-03: RegisterForFullGCNotification()メソッド L190-201 | ○ |
| C-27 | WaitForFullGCApproachで-2未満でArgumentOutOfRangeException | E-03: ThrowIfLessThan L216 | ○ |

### Thread関連 (UT-MONO-046〜058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Thread.IsAliveで実行中スレッドでtrue | E-04: IsAlive プロパティ L87-94 | ○ |
| C-29 | Thread.IsBackgroundでバックグラウンド状態取得 | E-04: IsBackground プロパティ L96-116 | ○ |
| C-30 | Thread.Priorityで優先度取得・設定 | E-04: Priority プロパティ L157-173 | ○ |
| C-31 | Thread.Joinで負のタイムアウトでArgumentOutOfRangeException | E-04: ThrowIfLessThan L194 | ○ |
| C-32 | Thread.SpinWaitで指定回数スピン待機 | E-04: SpinWait()メソッド L206-213 | ○ |
| C-33 | Thread.Yieldで制御を譲渡 | E-04: Yield()メソッド L244-247 | ○ |
| C-34 | Thread.GetApartmentStateでUnknown返却 | E-04: GetApartmentState()メソッド L177 | ○ |

### Monitor関連 (UT-MONO-059〜071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Monitor.Enterでロック取得 | E-05: Enter()メソッド L13-14 | ○ |
| C-36 | Monitor.EnterでlockTaken=trueの場合ArgumentException | E-05: ArgumentException L21 | ○ |
| C-37 | Monitor.Exitでロック解放 | E-05: Exit()メソッド L29-37 | ○ |
| C-38 | Monitor.TryEnterでロック試行 | E-05: TryEnter()メソッド L39-66 | ○ |
| C-39 | Monitor.IsEnteredでロック状態確認 | E-05: IsEntered()メソッド L68-72 | ○ |
| C-40 | Monitor.Pulseで待機スレッドに通知 | E-05: Pulse()メソッド L85-89 | ○ |
| C-41 | Monitor.PulseAllで全待機スレッドに通知 | E-05: PulseAll()メソッド L91-95 | ○ |

### RuntimeAssembly関連 (UT-MONO-072〜088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | RuntimeAssembly.EntryPointでエントリポイント取得 | E-06: EntryPoint プロパティ L81-90 | ○ |
| C-43 | RuntimeAssembly.GetManifestResourceNamesでリソース名取得 | E-06: GetManifestResourceNames()メソッド L142-148 | ○ |
| C-44 | RuntimeAssembly.GetManifestResourceStreamで空名前でArgumentException | E-06: ThrowIfNullOrEmpty L224 | ○ |
| C-45 | RuntimeAssembly.GetManifestResourceInfoで空名前でArgumentException | E-06: ThrowIfNullOrEmpty L211 | ○ |
| C-46 | RuntimeAssembly.GetTypeで空名前でArgumentException | E-06: ThrowIfNullOrEmpty L268 | ○ |
| C-47 | RuntimeAssembly.GetModuleで空名前でArgumentException | E-06: ThrowIfNullOrEmpty L295 | ○ |
| C-48 | RuntimeAssembly.GetSatelliteAssemblyでnullカルチャでArgumentNullException | E-06: ThrowIfNull L379 | ○ |

### RuntimeTypeBuilder関連 (UT-MONO-089〜110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | DefineConstructorでコンストラクタ定義 | E-07: DefineConstructorCore()メソッド L416-437 | ○ |
| C-50 | DefineConstructorで作成済み型でInvalidOperationException | E-07: check_not_created() L1534-1537 | ○ |
| C-51 | DefineMethodでメソッド定義 | E-07: DefineMethodCore()メソッド L499-518 | ○ |
| C-52 | DefineMethodで空名前でArgumentException | E-07: check_name()メソッド L1545-1549 | ○ |
| C-53 | DefineFieldでフィールド定義 | E-07: DefineFieldCore()メソッド L576-609 | ○ |
| C-54 | DefineFieldでvoid型でArgumentException | E-07: void型チェック L579-580 | ○ |
| C-55 | DefinePropertyでプロパティ定義 | E-07: DefinePropertyCore()メソッド L611-631 | ○ |
| C-56 | DefineEventでイベント定義 | E-07: DefineEventCore()メソッド L1415-1435 | ○ |
| C-57 | CreateTypeで型作成 | E-07: CreateTypeInfoCore()メソッド L682-786 | ○ |
| C-58 | SetParentでインターフェース親禁止 | E-07: SetParentCore()メソッド L1488-1489 | ○ |
| C-59 | IsSubclassOfで派生判定 | E-07: IsSubclassOf()メソッド L180-195 | ○ |
| C-60 | MakeGenericTypeで非ジェネリック型でInvalidOperationException | E-07: MakeGenericType()メソッド L1261-1262 | ○ |

### RuntimeILGenerator関連 (UT-MONO-111〜131)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | Emitでオペコード発行 | E-08: Emit()メソッド L481-485 | ○ |
| C-62 | DefineLabelでラベル定義 | E-08: DefineLabel()メソッド L463-479 | ○ |
| C-63 | MarkLabelでラベルマーク | E-08: MarkLabel()メソッド L832-841 | ○ |
| C-64 | MarkLabelで無効ラベルでArgumentException | E-08: ArgumentException L835-836 | ○ |
| C-65 | MarkLabelで再定義でArgumentException | E-08: ArgumentException L837 | ○ |
| C-66 | DeclareLocalでローカル変数宣言 | E-08: DeclareLocal()メソッド L439-461 | ○ |
| C-67 | DeclareLocalでnullでArgumentNullException | E-08: ThrowIfNull L441 | ○ |
| C-68 | BeginExceptionBlockで例外ブロック開始 | E-08: BeginExceptionBlock()メソッド L381-401 | ○ |
| C-69 | BeginCatchBlockで例外ブロック外でNotSupportedException | E-08: NotSupportedException L349 | ○ |
| C-70 | EndExceptionBlockで例外ブロック外でNotSupportedException | E-08: NotSupportedException L816 | ○ |
| C-71 | EmitCallでnullメソッドでArgumentNullException | E-08: ThrowIfNull L776 | ○ |
| C-72 | EmitCallで非呼び出しオペコードでNotSupportedException | E-08: NotSupportedException L779 | ○ |

### Marshal関連 (UT-MONO-132〜136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | GetLastPInvokeErrorでエラーコード取得 | E-09: GetLastPInvokeError()メソッド L23-24 | ○ |
| C-74 | SetLastPInvokeErrorでエラーコード設定 | E-09: SetLastPInvokeError()メソッド L30-31 | ○ |
| C-75 | IsPinnableでnullでtrue | E-09: IsPinnable()メソッド L47-53 | ○ |
| C-76 | GetExceptionPointersでPlatformNotSupportedException | E-09: GetExceptionPointers()メソッド L92-95 | ○ |

### RuntimeHelpers関連 (UT-MONO-137〜160)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | InitializeArrayで配列初期化 | E-10: InitializeArray()メソッド L15-21 | ○ |
| C-78 | InitializeArrayでnull配列でArgumentNullException | E-10: ThrowIfNull L17-18 | ○ |
| C-79 | GetHashCodeでハッシュコード取得 | E-10: GetHashCode()メソッド L41-47 | ○ |
| C-80 | Equalsで同一オブジェクトでtrue | E-10: Equals()メソッド L66-78 | ○ |
| C-81 | RunClassConstructorで未初期化ハンドルでArgumentException | E-10: ArgumentException L87-88 | ○ |
| C-82 | PrepareMethodでnullハンドルでArgumentException | E-10: ArgumentException L112-113 | ○ |
| C-83 | GetUninitializedObjectでRuntimeType以外でSerializationException | E-10: SerializationException L220 | ○ |
| C-84 | AllocateTypeAssociatedMemoryでRuntimeType以外でArgumentException | E-10: ArgumentException L152-154 | ○ |
| C-85 | AllocateTypeAssociatedMemoryで負サイズでArgumentOutOfRangeException | E-10: ThrowIfNegative L156 | ○ |
| C-86 | BoxでnullハンドルでArgumentNullException | E-10: ThrowArgumentNullException L267 | ○ |
| C-87 | Boxでnull参照でNullReferenceException | E-10: NullReferenceException L271 | ○ |
| C-88 | SizeOfでnullハンドルでArgumentNullException | E-10: ThrowArgumentNullException L312 | ○ |
| C-89 | SizeOfでvoid型でArgumentException | E-10: ArgumentException L315-316 | ○ |

## 4) 不足情報（Unknown / Missing）
- **GC通知機能**: `RegisterForFullGCNotification`, `WaitForFullGCApproach`, `WaitForFullGCComplete` はNotImplementedExceptionをスローする実装のため、実際の動作検証が困難
  - 候補: Mono GCのネイティブ実装ドキュメント / CoreCLRの対応実装
- **サテライトアセンブリ**: 環境依存の機能であり、テスト実行時に適切なリソースアセンブリが必要
  - 候補: リソースアセンブリのセットアップスクリプト / CI環境設定
- **ObjectHeader内部実装**: Monitor.Enter/Exitの高速パス（ObjectHeader.TryEnterFast等）は内部実装のため直接テスト困難
  - 候補: mono/metadata/object-internals.h のC実装

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: TypeSpecパーサーの境界値テスト - 非常に長い型名、深くネストしたジェネリック型など極端なケースの網羅性
- **リスク1（中）**: スレッド関連テスト - マルチスレッドの競合状態のテストは実行タイミングに依存
- **リスク0（低）**: GCテスト - GCの動作はランタイムの状態に依存するため結果が非決定的になる可能性
- **リスク2（高）**: Reflection.Emit関連 - 動的型生成のテストは複雑なシナリオでのみ問題が発生する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] TypeSpec.Parseの異常系テストケース（UT-MONO-008〜010）がすべての構文エラーパターンを網羅しているか確認
- [ ] Delegate.CreateDelegateのバインド失敗ケースが十分に網羅されているか確認
- [ ] GC関連テストが実行環境に依存しないことを確認
- [ ] Monitor関連テストがデッドロックを引き起こさないことを確認
- [ ] RuntimeTypeBuilderのCreateType後の状態遷移が正しくテストされているか確認
- [ ] RuntimeILGeneratorの例外ブロック関連テストが正しい順序で実行されることを確認
- [ ] RuntimeHelpersのメモリ確保テストがリソースリークを起こさないことを確認
