---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 171
  claims_with_evidence: 168
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：src-native.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧(src-native.csv)の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：168 / 171、根拠なし：3
- 優先レビュー（高）
  1. **UT-NAT-135**: TypeNameBuilder.GetExactOwningType - 型階層探索ロジックの複雑性
  2. **UT-NAT-131**: ConversionExtensions.ToAddress (ARM32) - プラットフォーム固有の処理
  3. **UT-NAT-152**: PrintfStressMessageFormatter - 未知フォーマット指定子のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/TargetPointer.cs`
- E-02: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/TargetCodePointer.cs`
- E-03: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/TargetNUInt.cs`
- E-04: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/TargetSpan.cs`
- E-05: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/VirtualReadException.cs`
- E-06: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/CorDbHResults.cs`
- E-07: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/DataType.cs`
- E-08: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/ContractRegistry.cs`
- E-09: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/Target.cs`
- E-10: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/IContractFactory.cs`
- E-11: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/Contracts/IContract.cs`
- E-12: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/Contracts/ILoader.cs`
- E-13: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/Contracts/IThread.cs`
- E-14: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/Contracts/IExecutionManager.cs`
- E-15: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Abstractions/Contracts/Extensions/ICodeVersionsExtensions.cs`
- E-16: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader/ContractDescriptorParser.cs`
- E-17: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader/CachingContractRegistry.cs`
- E-18: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader/ContractDescriptorTarget.cs`
- E-19: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Legacy/ConversionExtensions.cs`
- E-20: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Legacy/TypeNameBuilder.cs`
- E-21: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Contracts/PrintfStressMessageFormatter.cs`
- E-22: `src/native/managed/cdac/Microsoft.Diagnostics.DataContractReader.Contracts/TargetStream.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### 基本型（TargetPointer, TargetCodePointer, TargetNUInt, TargetSpan）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-13 | TargetPointerの初期化、演算子、メソッド | E-01 | ○ |
| C-14〜C-17 | TargetCodePointerの初期化、演算子、プロパティ | E-02 | ○ |
| C-18〜C-20 | TargetNUIntの初期化、演算子、デバッグ表示 | E-03 | ○ |
| C-21〜C-23 | TargetSpanの初期化、プロパティ | E-04 | ○ |

### 例外・エラーコード
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24〜C-26 | VirtualReadExceptionの各コンストラクタ | E-05 | ○ |
| C-27 | CorDbgHResults定数値 | E-06 | ○ |

### 列挙型・レジストリ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28〜C-30 | DataType列挙値 | E-07 | ○ |
| C-31〜C-36 | ContractRegistryのプロパティ・メソッド | E-08 | ○ |

### JSONパーサー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37〜C-58 | ContractDescriptorParser及び内部クラス | E-16 | ○ |

### キャッシング・ファクトリ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59〜C-62 | CachingContractRegistry | E-17 | ○ |

### ContractDescriptorTarget
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63〜C-106 | ContractDescriptorTargetの各メソッド | E-18 | ○ |

### インターフェース・コントラクト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107〜C-108 | IContractFactory | E-10 | ○ |
| C-109 | IContract.Name | E-11 | ○ |
| C-110〜C-113 | ModuleHandle, ModuleFlags | E-12 | ○ |
| C-114〜C-117 | ThreadStoreData, ThreadData, ThreadState | E-13 | ○ |
| C-118 | CodeBlockHandle | E-14 | ○ |
| C-119〜C-123 | ICodeVersionsExtensions | E-15 | ○ |

### Legacy変換
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124〜C-131 | ConversionExtensions | E-19 | ○ |
| C-132〜C-137 | TypeNameBuilder, TypeNameFormat | E-20 | ○ |

### フォーマッタ・ストリーム
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138〜C-152 | PrintfStressMessageFormatter | E-21 | ○ |
| C-153〜C-166 | TargetStream | E-22 | ○ |

### Target内部型
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-167〜C-171 | Target.TypeInfo, Target.FieldInfo | E-09 | ○ |

### 根拠不足の項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | TypeNameBuilder.GetExactOwningType - 無限ループ検出の具体的動作 | **根拠不足** | △ |
| C-131 | ConversionExtensions.ToAddress - ARM64ポインタ認証のNotImplementedException | **根拠不足** | △ |
| C-152 | PrintfStressMessageFormatter - 全フォーマット指定子の網羅性 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **GetExactOwningType**: コード内のTODOコメント「TODO(cdac) - Consider adding infinite loop detection here」により、無限ループ検出の実装が将来追加される可能性あり。現時点でのテストは現行動作に基づく
- **ARM64ポインタ認証**: NotImplementedException をスローする実装のため、実際のARM64環境での動作は未検証
- **PrintfStressMessageFormatter**: 全ての printf 形式指定子の網羅性は、ソースコードの _formatActions ディクショナリに基づくが、すべての組み合わせの検証は困難

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 基本型（TargetPointer等）のテストケース - 単純な値型のため
- **1: 中リスク**: JSONパーサー関連 - 複雑なパース処理だが、エッジケースは比較的明確
- **2: 高リスク**:
  - ContractDescriptorTarget.TryCreate - バイナリ形式のパースは誤りが検出しにくい
  - PrintfStressMessageFormatter - printf 互換性の完全性確保が困難
  - ConversionExtensions (32/64ビット変換) - 符号拡張ロジックの誤りは深刻なバグにつながる

## 6) レビュアーチェックリスト（最小）
- [ ] TargetPointerの暗黙変換オーバーロードが正しく定義されているか確認
- [ ] VirtualReadExceptionのHResultが正しい値(0x80131c49)であることを確認
- [ ] ContractDescriptorParser のJSONフォーマット仕様との整合性を確認
- [ ] ContractDescriptorTarget の32ビット/64ビット処理の分岐が正しいか確認
- [ ] CachingContractRegistry のスレッドセーフ性を確認（TryAddの使用）
- [ ] ConversionExtensions の符号拡張ロジックが正しいか確認
- [ ] PrintfStressMessageFormatter の全フォーマット指定子がサポートされているか確認
- [ ] TargetStream が読み取り専用ストリームとして正しく実装されているか確認
