---
generated_at: 2026-01-30 16:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-samples 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **UT-SMP-017〜019**：ネイティブライブラリ不在時の動作はテスト環境依存
  2. **UT-SMP-004〜005**：オーバーフロー/アンダーフロー動作は実装依存
  3. **UT-SMP-020**：ソースジェネレータの動作確認はビルド時に検証される

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/samples/LibraryImportGeneratorSample/Program.cs` - メインソースファイル
- E-02: `src/samples/LibraryImportGeneratorSample/LibraryImportGeneratorSample.csproj` - プロジェクト設定ファイル
- E-03: LibraryImport属性定義（System.Runtime.InteropServices名前空間）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NativeExportsNEクラスにSum(int, int)メソッドが存在する | E-01 (行13-14) | ○ |
| C-02 | Sum(int, int)はEntryPoint="sumi"でネイティブ関数を呼び出す | E-01 (行13) | ○ |
| C-03 | NativeExportsNEクラスにSum(int, int, out int)メソッドが存在する | E-01 (行16-17) | ○ |
| C-04 | Sum(int, int, out int)はEntryPoint="sumouti"でネイティブ関数を呼び出す | E-01 (行16) | ○ |
| C-05 | NativeExportsNEクラスにSum(int, ref int)メソッドが存在する | E-01 (行19-20) | ○ |
| C-06 | Sum(int, ref int)はEntryPoint="sumrefi"でネイティブ関数を呼び出す | E-01 (行19) | ○ |
| C-07 | NativeExportsNE_Binary定数が定義されている | E-01 (行11) | ○ |
| C-08 | 定数値は"Microsoft.Interop.Tests.NativeExportsNE"である | E-01 (行11) | ○ |
| C-09 | ProgramクラスにMainメソッドが存在する | E-01 (行25-38) | ○ |
| C-10 | Mainメソッドは3つのSumオーバーロードを呼び出す | E-01 (行29, 32, 36) | ○ |
| C-11 | プロジェクトはLibraryImportGeneratorを有効化している | E-02 (行13) | ○ |
| C-12 | プロジェクトはNativeExportsテストアセットを参照している | E-02 (行18) | ○ |
| C-13 | NativeExportsNEはpartial staticクラスである | E-01 (行9) | ○ |
| C-14 | Sumメソッドはすべてpartialメソッドである | E-01 (行14, 17, 20) | ○ |
| C-15 | LibraryImport属性が各Sumメソッドに適用されている | E-01 (行13, 16, 19) | ○ |
| C-16 | Mainメソッドでa=12, b=13の値が使用されている | E-01 (行27-28) | ○ |
| C-17 | Console.WriteLineで結果が出力される | E-01 (行30, 33, 37) | ○ |
| C-18 | 正常系テストケースが各オーバーロードに対して定義されている | E-01全体 | ○ |
| C-19 | 境界値テストケースがint型の範囲を考慮している | E-01（int型使用） | ○ |
| C-20 | 異常系テストケースがDLL不在を考慮している | E-01, E-03（P/Invoke仕様） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（モジュールが単一ファイルで構成されており、全コードを解析済み）
- ネイティブライブラリ（NativeExports）の実装詳細は別プロジェクトに存在
  - 候補：`src/libraries/System.Runtime.InteropServices/tests/TestAssets/NativeExports/`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - シンプルなサンプルコードで、P/Invokeの基本機能デモンストレーション
- テストケースはLibraryImportGeneratorの使用例を網羅
- ネイティブライブラリとの連携部分は実行環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-SMP-xxx）が正しいか確認
- [ ] 各Sumオーバーロードに対するテストケースが網羅されているか確認
- [ ] 境界値（int.MaxValue, int.MinValue, 0）のテストが含まれているか確認
- [ ] 異常系（DLL不在）のテストが含まれているか確認
- [ ] 優先度の設定が適切か確認（金額計算等がないため、機能重要度で判定）
