---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 126
  claims_with_evidence: 118
  claims_without_evidence: 8
confidence_derived: 0.94
---

# 根拠レポート: src-tasks 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と整合しているか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 118 / 126 = 0.94
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：118 / 126、根拠なし：8
- 優先レビュー（高）
  1. **UT-TSK-068〜075**: PrepareForReadyToRunCompilationの一部メソッドは内部実装のため詳細確認推奨
  2. **UT-TSK-104〜105**: WebcilConverterはラッパークラスのため実際の変換ロジックは別ライブラリ
  3. **UT-TSK-125〜126**: BuildPropertiesTableは内部クラスのためアクセシビリティ確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/tasks/AotCompilerTask/MonoAOTCompiler.cs` - MonoAOTCompilerクラスの実装
- E-02: `src/tasks/Common/Utils.cs` - ユーティリティメソッド群
- E-03: `src/tasks/WasmAppBuilder/EmccCompile.cs` - EmccCompileタスク
- E-04: `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs` - WASM基底タスク
- E-05: `src/tasks/Common/FileCache.cs` - ファイルキャッシュ機能
- E-06: `src/tasks/Common/ProxyFile.cs` - プロキシファイル機能
- E-07: `src/tasks/Crossgen2Tasks/PrepareForReadyToRunCompilation.cs` - R2R準備タスク
- E-08: `src/tasks/MonoTargetsTasks/ILStrip/ILStrip.cs` - ILストリップタスク
- E-09: `src/tasks/Microsoft.NET.Sdk.WebAssembly.Pack.Tasks/GenerateWasmBootJson.cs` - BootJson生成
- E-10: `src/tasks/MonoTargetsTasks/RuntimeConfigParser/RuntimeConfigParser.cs` - RuntimeConfig解析
- E-11: `src/tasks/WasmAppBuilder/WasmCalculateInitialHeapSize.cs` - ヒープサイズ計算
- E-12: `src/tasks/WasmAppBuilder/WebcilConverter.cs` - Webcil変換ラッパー
- E-13: `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` - P/Invokeテーブル生成
- E-14: `src/tasks/MobileBuildTasks/Android/Ndk/NdkVersion.cs` - NDKバージョン解析
- E-15: `src/tasks/installer.tasks/GenerateRunScript.cs` - 実行スクリプト生成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-21 | MonoAOTCompilerの各テストケース | E-01 | ○ |
| C-22〜C-39 | Utilsの各テストケース | E-02 | ○ |
| C-40〜C-47 | EmccCompileの各テストケース | E-03 | ○ |
| C-48〜C-55 | WasmAppBuilderBaseTaskの各テストケース | E-04 | ○ |
| C-56〜C-64 | FileCacheの各テストケース | E-05 | ○ |
| C-65〜C-67 | ProxyFileの各テストケース | E-06 | ○ |
| C-68〜C-75 | PrepareForReadyToRunCompilationの各テストケース | E-07 | △ |
| C-76〜C-84 | ILStripの各テストケース | E-08 | ○ |
| C-85〜C-90 | GenerateWasmBootJsonの各テストケース | E-09 | ○ |
| C-91〜C-99 | RuntimeConfigParserTaskの各テストケース | E-10 | ○ |
| C-100〜C-103 | WasmCalculateInitialHeapSizeの各テストケース | E-11 | ○ |
| C-104〜C-105 | WebcilConverterの各テストケース | E-12 | △ |
| C-106〜C-112 | PInvokeTableGeneratorの各テストケース | E-13 | ○ |
| C-113〜C-117 | NdkVersionの各テストケース | E-14 | ○ |
| C-118〜C-124 | GenerateRunScriptの各テストケース | E-15 | ○ |
| C-125〜C-126 | BuildPropertiesTableの各テストケース | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **PrepareForReadyToRunCompilation (C-68〜C-75)**
  - 一部の内部メソッド（GetInputFileEligibility, IsReferenceAssembly, HasILCode）はprivate staticメソッドであり、直接テストするには追加のテスト用インフラが必要
  - 候補：リフレクションによるテスト / InternalsVisibleTo属性の追加

- **WebcilConverter (C-104〜C-105)**
  - 実際の変換ロジックは `NET.WebAssembly.Webcil.WebcilConverter` にあり、このクラスは薄いラッパーである
  - 候補：統合テストとして実装 / モックを使用

- **BuildPropertiesTable (C-125〜C-126)**
  - MonoAOTCompiler内の入れ子クラス（private sealed class）であり、直接アクセスが困難
  - 候補：インスタンスを取得する間接的なテスト / リファクタリングで公開

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UT-TSK-001〜067, UT-TSK-076〜103, UT-TSK-106〜124
  - 公開メソッドに対する標準的なテストケース
- **1（中リスク）**: UT-TSK-068〜075, UT-TSK-104〜105, UT-TSK-113〜117
  - 内部実装依存またはラッパークラスのテスト
- **2（高リスク）**: UT-TSK-125〜126
  - プライベートクラスへのアクセスが必要なテスト

## 6) レビュアーチェックリスト（最小）
- [ ] MonoAOTCompilerの主要メソッド（Execute, ProcessAndValidateArguments, PrecompileLibrary）のテストケースが網羅されているか
- [ ] Utils静的メソッド（IsNewerThan, CopyIfDifferent, ComputeHash等）の境界値テストが含まれているか
- [ ] 各MSBuildタスク（EmccCompile, ILStrip, GenerateWasmBootJson等）のExecuteメソッドの正常系・異常系が網羅されているか
- [ ] FileCacheとProxyFileの連携動作（キャッシュ有効/無効、ファイル変更検出）がテストされているか
- [ ] エラーハンドリング（LogAsErrorException, ArgumentException等）のテストが含まれているか
- [ ] プラットフォーム依存の処理（Windows/Unix、改行コード等）が考慮されているか
- [ ] 並列処理（Parallel.ForEach）を使用するメソッドの同時実行テストが考慮されているか

## 7) 追加情報

### 対象ソースファイル一覧
本テストケース一覧は以下の主要ソースファイルを基に作成：

| カテゴリ | ファイル数 | 主要クラス |
|---------|-----------|----------|
| AotCompilerTask | 1 | MonoAOTCompiler |
| WasmAppBuilder | 12+ | EmccCompile, WasmAppBuilderBaseTask, WebcilConverter等 |
| Crossgen2Tasks | 6 | PrepareForReadyToRunCompilation, RunReadyToRunCompiler等 |
| MonoTargetsTasks | 6+ | ILStrip, RuntimeConfigParser, MarshalingPInvokeScanner等 |
| Microsoft.NET.Sdk.WebAssembly.Pack.Tasks | 7 | GenerateWasmBootJson, ComputeWasmBuildAssets等 |
| MobileBuildTasks | 10+ | NdkVersion, AppleSdk, AndroidProject等 |
| installer.tasks | 5+ | GenerateRunScript, GenerateTestSharedFrameworkDepsFile等 |
| Common | 8+ | Utils, FileCache, ProxyFile, CompilerCache等 |

### テストID命名規則
- プレフィックス: `UT-TSK-` (Unit Test - Tasks)
- 連番: 001〜126

### 優先度の分布
| 優先度 | 件数 | 割合 |
|-------|-----|-----|
| 高 | 48 | 38.1% |
| 中 | 62 | 49.2% |
| 低 | 16 | 12.7% |
