---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 130
  claims_with_evidence: 130
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-tests.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：130 / 130、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/Assert.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/CoreCLRTestLibrary/TestFramework.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/CoreCLRTestLibrary/Generator.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/CoreCLRTestLibrary/Utilities.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/CoreCLRTestLibrary/PlatformDetection.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/CoreCLRTestLibrary/CoreClrConfigurationDetection.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/XUnitWrapperLibrary/TestFilter.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/XUnitWrapperLibrary/TestSummary.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/CoreCLRTestLibrary/AssertExtensions.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/XUnitWrapperGenerator/ITestInfo.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/XUnitWrapperGenerator/XUnitWrapperGenerator.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/tests/Common/Coreclr.TestWrapper/CoreclrTestWrapperLib.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Xunit.Assert.Throws<T>が例外をスローすること | E-01 (Assert.cs:43-54) | ○ |
| C-02 | Xunit.Assert.Throws<T>が例外未発生時にAssertFail | E-01 (Assert.cs:47-48) | ○ |
| C-03 | Xunit.Assert.Throws<T>が型不一致時にAssertFail | E-01 (Assert.cs:50-51) | ○ |
| C-04 | Xunit.Assert.Trueがtrueで正常動作 | E-01 (Assert.cs:68-74) | ○ |
| C-05 | Xunit.Assert.Trueがfalseで例外スロー | E-01 (Assert.cs:70-73) | ○ |
| C-06 | Xunit.Assert.Falseがfalseで正常動作 | E-01 (Assert.cs:88-94) | ○ |
| C-07 | Xunit.Assert.Falseがtrueで例外スロー | E-01 (Assert.cs:90-93) | ○ |
| C-08 | Xunit.Assert.Nullがnullで正常動作 | E-01 (Assert.cs:108-114) | ○ |
| C-09 | Xunit.Assert.Nullが非nullで例外スロー | E-01 (Assert.cs:110-113) | ○ |
| C-10 | Xunit.Assert.NotNullが非nullで正常動作 | E-01 (Assert.cs:128-134) | ○ |
| C-11 | Xunit.Assert.NotNullがnullで例外スロー | E-01 (Assert.cs:130-133) | ○ |
| C-12 | Xunit.Assert.Equal<T>が等価で正常動作 | E-01 (Assert.cs:143-149) | ○ |
| C-13 | Xunit.Assert.Equal<T>が非等価で例外スロー | E-01 (Assert.cs:145-148) | ○ |
| C-14 | Xunit.Assert.Sameが同一参照で正常動作 | E-01 (Assert.cs:158-166) | ○ |
| C-15 | Xunit.Assert.Sameが異なる参照で例外スロー | E-01 (Assert.cs:162-165) | ○ |
| C-16 | Xunit.Assert.NotEqual<T>が非等価で正常動作 | E-01 (Assert.cs:188-194) | ○ |
| C-17 | Xunit.Assert.NotEqual<T>が等価で例外スロー | E-01 (Assert.cs:190-193) | ○ |
| C-18 | XunitExceptionがメッセージを保持 | E-01 (Assert.cs:232-243) | ○ |
| C-19 | TestFramework.BeginTestCaseがシード初期化 | E-02 (TestFramework.cs:26-51) | ○ |
| C-20 | CORECLR_SEED環境変数でシード設定 | E-02 (TestFramework.cs:30-45) | ○ |
| C-21 | CORECLR_SEED=randomでランダムシード | E-02 (TestFramework.cs:36-39) | ○ |
| C-22 | TestFramework.EndTestCaseがtrueを返す | E-02 (TestFramework.cs:54-59) | ○ |
| C-23 | Generator.GetBoolがboolean返却 | E-03 (Generator.cs:50-53) | ○ |
| C-24 | Generator.GetBytesがバイト配列生成 | E-03 (Generator.cs:56-65) | ○ |
| C-25 | Generator.GetInt64が範囲内の値を返却 | E-03 (Generator.cs:67-91) | ○ |
| C-26 | Generator.GetUInt64が範囲内の値を返却 | E-03 (Generator.cs:93-115) | ○ |
| C-27 | Generator.GetInt32が範囲内の値を返却 | E-03 (Generator.cs:117-128) | ○ |
| C-28 | Generator.GetUInt32が範囲内の値を返却 | E-03 (Generator.cs:130-152) | ○ |
| C-29 | Generator.GetInt16が範囲内の値を返却 | E-03 (Generator.cs:154-165) | ○ |
| C-30 | Generator.GetUInt16が範囲内の値を返却 | E-03 (Generator.cs:167-178) | ○ |
| C-31 | Generator.GetByteが範囲内の値を返却 | E-03 (Generator.cs:180-191) | ○ |
| C-32 | Generator.GetSByteが範囲内の値を返却 | E-03 (Generator.cs:193-204) | ○ |
| C-33 | Generator.GetDoubleが0.0-1.0を返却 | E-03 (Generator.cs:206-217) | ○ |
| C-34 | Generator.GetSingleが0.0-1.0を返却 | E-03 (Generator.cs:219-230) | ○ |
| C-35 | Generator.GetCharLetterが文字を返却 | E-03 (Generator.cs:232-297) | ○ |
| C-36 | GetCharLetterがサロゲート制御可能 | E-03 (Generator.cs:249-297) | ○ |
| C-37 | Generator.GetCharNumberが数字を返却 | E-03 (Generator.cs:299-351) | ○ |
| C-38 | Generator.GetCharが文字を返却 | E-03 (Generator.cs:353-399) | ○ |
| C-39 | Generator.GetStringが指定長さの文字列生成 | E-03 (Generator.cs:401-478) | ○ |
| C-40 | GetStringが空文字列を返却（境界値） | E-03 (Generator.cs:436) | ○ |
| C-41 | GetStringがnullを返却（無効な長さ） | E-03 (Generator.cs:437) | ○ |
| C-42 | Generator.GetStringsが複数文字列生成 | E-03 (Generator.cs:480-521) | ○ |
| C-43 | Generator.Seedがシード設定 | E-03 (Generator.cs:19-48) | ○ |
| C-44 | Generator.Seedが再設定防止 | E-03 (Generator.cs:34-47) | ○ |
| C-45 | Utilities.IsX86がx86検出 | E-04 (Utilities.cs:61) | ○ |
| C-46 | Utilities.IsX64がx64検出 | E-04 (Utilities.cs:63) | ○ |
| C-47 | Utilities.IsArmがARM検出 | E-04 (Utilities.cs:64) | ○ |
| C-48 | Utilities.IsArm64がARM64検出 | E-04 (Utilities.cs:65) | ○ |
| C-49 | Utilities.IsWindowsがWindows検出 | E-04 (Utilities.cs:68) | ○ |
| C-50 | Utilities.IsLinuxがLinux検出 | E-04 (Utilities.cs:69) | ○ |
| C-51 | Utilities.IsMacOSXがmacOS検出 | E-04 (Utilities.cs:71) | ○ |
| C-52 | Utilities.IsMonoRuntimeがMono検出 | E-04 (Utilities.cs:97) | ○ |
| C-53 | Utilities.IsNativeAotがNativeAOT検出 | E-04 (Utilities.cs:99) | ○ |
| C-54 | Utilities.Is64が64ビット検出 | E-04 (Utilities.cs:94) | ○ |
| C-55 | Utilities.Is32が32ビット検出 | E-04 (Utilities.cs:95) | ○ |
| C-56 | ByteArrayToStringがバイト配列変換 | E-04 (Utilities.cs:123-136) | ○ |
| C-57 | ByteArrayToStringが空配列で空文字列 | E-04 (Utilities.cs:132-133) | ○ |
| C-58 | CompareBytesが同一配列でtrue | E-04 (Utilities.cs:138-148) | ○ |
| C-59 | CompareBytesが異なる配列でfalse | E-04 (Utilities.cs:145) | ○ |
| C-60 | CompareBytesがnull同士でtrue | E-04 (Utilities.cs:140) | ○ |
| C-61 | CompareBytesがnullと非nullでfalse | E-04 (Utilities.cs:141) | ○ |
| C-62 | CompareBytesが長さ不一致でfalse | E-04 (Utilities.cs:143) | ○ |
| C-63 | ExecuteAndUnloadがアセンブリ実行・アンロード | E-04 (Utilities.cs:446-472) | ○ |
| C-64 | DisableOSCoreDumpがコアダンプ無効化 | E-04 (Utilities.cs:514-531) | ○ |
| C-65 | PlatformDetection.Is32BitProcess | E-05 (PlatformDetection.cs:12) | ○ |
| C-66 | PlatformDetection.Is64BitProcess | E-05 (PlatformDetection.cs:13) | ○ |
| C-67 | PlatformDetection.IsWindows | E-05 (PlatformDetection.cs:19) | ○ |
| C-68 | PlatformDetection.IsBuiltInComEnabled | E-05 (PlatformDetection.cs:21-24) | ○ |
| C-69 | IsNonZeroLowerBoundArraySupported | E-05 (PlatformDetection.cs:33-53) | ○ |
| C-70 | PlatformDetection.IsMonoRuntime | E-05 (PlatformDetection.cs:62) | ○ |
| C-71 | CoreClrConfigurationDetection.IsJitStress | E-06 (CoreClrConfigurationDetection.cs:16) | ○ |
| C-72 | IsJitStressが0でfalse | E-06 (CoreClrConfigurationDetection.cs:16) | ○ |
| C-73 | CoreClrConfigurationDetection.IsGCStress | E-06 (CoreClrConfigurationDetection.cs:38) | ○ |
| C-74 | IsGCStress3の検出 | E-06 (CoreClrConfigurationDetection.cs:21) | ○ |
| C-75 | IsGCStressCの検出 | E-06 (CoreClrConfigurationDetection.cs:22) | ○ |
| C-76 | IsTieredCompilationの検出 | E-06 (CoreClrConfigurationDetection.cs:23) | ○ |
| C-77 | IsCheckedRuntimeの検出 | E-06 (CoreClrConfigurationDetection.cs:44) | ○ |
| C-78 | IsDebugRuntimeの検出 | E-06 (CoreClrConfigurationDetection.cs:46) | ○ |
| C-79 | IsReleaseRuntimeの検出 | E-06 (CoreClrConfigurationDetection.cs:45) | ○ |
| C-80 | IsCoreClrInterpreterの検出 | E-06 (CoreClrConfigurationDetection.cs:26-36) | ○ |
| C-81 | TestFilter.ShouldRunTestがnullフィルターでtrue | E-07 (TestFilter.cs:192-194) | ○ |
| C-82 | ShouldRunTestが除外テストでfalse | E-07 (TestFilter.cs:188-189) | ○ |
| C-83 | ShouldRunTestがフィルター一致でtrue | E-07 (TestFilter.cs:198) | ○ |
| C-84 | ShouldRunTestがフィルター不一致でfalse | E-07 (TestFilter.cs:198) | ○ |
| C-85 | NameClause.IsMatchが完全一致でtrue | E-07 (TestFilter.cs:48-52) | ○ |
| C-86 | NameClause.IsMatchが完全不一致でfalse | E-07 (TestFilter.cs:52) | ○ |
| C-87 | NameClause.IsMatchが部分一致でtrue | E-07 (TestFilter.cs:50) | ○ |
| C-88 | AndClause.IsMatchが両方trueでtrue | E-07 (TestFilter.cs:72-74) | ○ |
| C-89 | AndClause.IsMatchが片方falseでfalse | E-07 (TestFilter.cs:72-74) | ○ |
| C-90 | OrClause.IsMatchが片方trueでtrue | E-07 (TestFilter.cs:93-95) | ○ |
| C-91 | OrClause.IsMatchが両方falseでfalse | E-07 (TestFilter.cs:93-95) | ○ |
| C-92 | NotClause.IsMatchが反転 | E-07 (TestFilter.cs:112-113) | ○ |
| C-93 | LoadTestExclusionTableが除外リスト読込 | E-07 (TestFilter.cs:238-260) | ○ |
| C-94 | GetTestExclusionReasonが理由取得 | E-07 (TestFilter.cs:209-219) | ○ |
| C-95 | GetTestExclusionReasonが理由なしで空文字 | E-07 (TestFilter.cs:216-218) | ○ |
| C-96 | TestSummary.ReportPassedTest | E-08 (TestSummary.cs:160-180) | ○ |
| C-97 | TestSummary.ReportFailedTest | E-08 (TestSummary.cs:182-204) | ○ |
| C-98 | TestSummary.ReportSkippedTest | E-08 (TestSummary.cs:206-223) | ○ |
| C-99 | TestResult.ToXmlStringが成功XML生成 | E-08 (TestSummary.cs:98-101) | ○ |
| C-100 | TestResult.ToXmlStringが失敗XML生成 | E-08 (TestSummary.cs:57-87) | ○ |
| C-101 | TestResult.ToXmlStringがスキップXML生成 | E-08 (TestSummary.cs:88-97) | ○ |
| C-102 | GetTestResultOutputがXML生成 | E-08 (TestSummary.cs:226-266) | ○ |
| C-103 | AssertExtensions.ThrowsArgumentException | E-09 (AssertExtensions.cs:39-42) | ○ |
| C-104 | AssertExtensions.ThrowsArgumentException<T> | E-09 (AssertExtensions.cs:63-75) | ○ |
| C-105 | ThrowsMissingMemberException<T> | E-09 (AssertExtensions.cs:96-105) | ○ |
| C-106 | ThrowsWithInnerException<T,TInner> | E-09 (AssertExtensions.cs:130-143) | ○ |
| C-107 | ThrowsWithInnerExceptionが内部例外null時エラー | E-09 (AssertExtensions.cs:136-137) | ○ |
| C-108 | ThrowsAnyが複数例外型テスト | E-09 (AssertExtensions.cs:145-166) | ○ |
| C-109 | ThrowsAnyが例外なしでXunitException | E-09 (AssertExtensions.cs:165) | ○ |
| C-110 | CollectionEqual<T>が同一配列で成功 | E-09 (AssertExtensions.cs:191-197) | ○ |
| C-111 | CollectionEqual<T>が異なる配列でエラー | E-09 (AssertExtensions.cs:196) | ○ |
| C-112 | CollectionEqual<T>が長さ不一致でエラー | E-09 (AssertExtensions.cs:193) | ○ |
| C-113 | BasicTestMethod.GenerateTestExecution静的 | E-10 (ITestInfo.cs:52-54) | ○ |
| C-114 | BasicTestMethodインスタンスメソッド | E-10 (ITestInfo.cs:56-58) | ○ |
| C-115 | LegacyStandaloneEntryPointTestMethod | E-10 (ITestInfo.cs:95-137) | ○ |
| C-116 | ConditionalTest.GenerateTestExecution | E-10 (ITestInfo.cs:139-183) | ○ |
| C-117 | MemberDataTest.GenerateTestExecution | E-10 (ITestInfo.cs:268-318) | ○ |
| C-118 | OutOfProcessTest.GenerateTestExecution | E-10 (ITestInfo.cs:340-372) | ○ |
| C-119 | CoreclrTestWrapperLib.RunTestが正常実行 | E-12 (CoreclrTestWrapperLib.cs:769-936) | ○ |
| C-120 | RunTestがタイムアウト時にプロセスキル | E-12 (CoreclrTestWrapperLib.cs:869-927) | ○ |
| C-121 | RunTestがクラッシュダンプ収集 | E-12 (CoreclrTestWrapperLib.cs:905-921) | ○ |
| C-122 | ProcessExtensions.GetChildrenがWindows対応 | E-12 (CoreclrTestWrapperLib.cs:162-198) | ○ |
| C-123 | ProcessExtensions.GetChildrenがLinux対応 | E-12 (CoreclrTestWrapperLib.cs:200-244) | ○ |
| C-124 | ProcessExtensions.GetChildrenがmacOS対応 | E-12 (CoreclrTestWrapperLib.cs:246-258) | ○ |
| C-125 | TryGetProcessIdがID取得 | E-12 (CoreclrTestWrapperLib.cs:114-127) | ○ |
| C-126 | TryGetProcessIdが終了プロセスでfalse | E-12 (CoreclrTestWrapperLib.cs:122-126) | ○ |
| C-127 | TryGetProcessNameが名前取得 | E-12 (CoreclrTestWrapperLib.cs:129-142) | ○ |
| C-128 | TryPrintStackTraceFromCrashReport | E-12 (CoreclrTestWrapperLib.cs:436-650) | ○ |
| C-129 | TryPrintStackTraceFromCrashReportがファイルなしでfalse | E-12 (CoreclrTestWrapperLib.cs:475-478) | ○ |
| C-130 | TryPrintStackTraceFromWindowsDmp | E-12 (CoreclrTestWrapperLib.cs:667-708) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースに対応するソースコードが存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されている

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（UT-TST-001〜130）の連番が正しいか
- [ ] 対象クラス・メソッドがソースコードと一致しているか
- [ ] テスト観点（正常系/異常系/境界値）の分類が適切か
- [ ] 優先度の設定が適切か（高：コア機能、中：ユーティリティ、低：補助機能）
- [ ] 期待結果がテスト対象メソッドの仕様と一致しているか
