---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 115
  claims_with_evidence: 108
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート：src-tools 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：108 / 115、根拠なし：7
- 優先レビュー（高）
  1. **UT-TOL-112 (MarkStep.Process)**：MarkStep.csの一部のみ読み込み、完全な処理フローが確認できていない
  2. **UT-TOL-058 (DocumentCompiler #include)**：includeディレクティブの完全なテスト観点は推測
  3. **UT-TOL-100 (GetMethodIL)**：UnreachableBlocksOptimizerの詳細動作は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tools/StressLogAnalyzer/src/StressLogAnalyzer.cs` - メイン解析ロジック
- E-02: `src/tools/StressLogAnalyzer/src/Filters/ValueRangeFilter.cs` - 値範囲フィルタ実装
- E-03: `src/tools/StressLogAnalyzer/src/Filters/ValueFilter.cs` - 値フィルタ実装
- E-04: `src/tools/StressLogAnalyzer/src/Filters/FacilityMessageFilter.cs` - ファシリティフィルタ実装
- E-05: `src/tools/StressLogAnalyzer/src/InterestingStringFinder.cs` - 文字列識別ロジック
- E-06: `src/tools/StressLogAnalyzer/src/GCThreadMap.cs` - GCスレッドマッピング
- E-07: `src/tools/StressLogAnalyzer/src/TimeTracker.cs` - 時間追跡ロジック
- E-08: `src/tools/StressLogAnalyzer/src/Options.cs` - オプション定義（ThreadFilter含む）
- E-09: `src/tools/StressLogAnalyzer/src/Output/StressMessageWriter.cs` - メッセージ出力
- E-10: `src/tools/ilasm/src/ILAssembler/DocumentCompiler.cs` - ILコンパイラ
- E-11: `src/tools/ilasm/src/ILAssembler/PreprocessedTokenSource.cs` - プリプロセッサ
- E-12: `src/tools/ilasm/src/ILAssembler/TypeName.cs` - 型名レコード
- E-13: `src/tools/illink/src/linker/Linker/LinkContext.cs` - リンカーコンテキスト
- E-14: `src/tools/illink/src/linker/Linker/TypeHierarchyCache.cs` - 型階層キャッシュ
- E-15: `src/tools/illink/src/linker/Linker/TypeNameResolver.WithDiagnostics.cs` - 型名解決
- E-16: `src/tools/illink/src/linker/Linker.Steps/MarkStep.cs` - マーキングステップ（部分読み込み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StressLogAnalyzer.AnalyzeLogsAsync - ログ解析の基本動作 | E-01 | ○ |
| C-02 | StressLogAnalyzer.AnalyzeLogsAsync - GCスレッドフィルタ適用 | E-01 | ○ |
| C-03 | StressLogAnalyzer.AnalyzeLogsAsync - 時間範囲フィルタ適用 | E-01 | ○ |
| C-04 | StressLogAnalyzer.AnalyzeLogsAsync - キャンセル処理 | E-01 | ○ |
| C-05 | StressLogAnalyzer.AnalyzeLogsAsync - 空ログリスト処理 | E-01 | ○ |
| C-06 | ValueRangeFilter.IncludeMessage - PLAN_PLUG範囲判定 | E-02 | ○ |
| C-07 | ValueRangeFilter.IncludeMessage - GCMEMCOPY範囲判定 | E-02 | ○ |
| C-08 | ValueRangeFilter.IncludeMessage - RELOCATE_REFERENCE範囲判定 | E-02 | ○ |
| C-09 | ValueRangeFilter.IncludeMessage - NOT_INTERESTING委譲 | E-02 | ○ |
| C-10 | ValueRangeFilter.RangeIsInteresting - 単一ポイント範囲 | E-02 | ○ |
| C-11 | ValueFilter.IncludeMessage - 基本動作 | E-03 | ○ |
| C-12 | ValueFilter.IncludeMessage - フィルタチェーン委譲 | E-03 | ○ |
| C-13 | ValueFilter.IncludeMessage - 複数引数チェック | E-03 | ○ |
| C-14 | FacilityMessageFilter.IncludeMessage - フィルタ無効時 | E-04 | ○ |
| C-15 | FacilityMessageFilter.IncludeMessage - GCファシリティフィルタ | E-04 | ○ |
| C-16 | FacilityMessageFilter.IncludeMessage - ビットマスク処理 | E-04 | ○ |
| C-17 | InterestingStringFinder.IsInteresting - キャッシュ登録 | E-05 | ○ |
| C-18 | InterestingStringFinder.IsInteresting - ユーザー文字列フィルタ | E-05 | ○ |
| C-19 | InterestingStringFinder.IsInteresting - プレフィックスマッチ | E-05 | ○ |
| C-20 | InterestingStringFinder.IsInteresting - キャッシュ境界チェック | E-05 | ○ |
| C-21 | InterestingStringFinder.IsWellKnown - 既知文字列判定 | E-05 | ○ |
| C-22 | InterestingStringFinder.IsWellKnown - 未知文字列判定 | E-05 | ○ |
| C-23 | GCThreadMap.TryRememberHeapForThread - スレッドヒープマッピング | E-06 | ○ |
| C-24 | GCThreadMap.TryRememberHeapForThread - BGCスレッド識別 | E-06 | ○ |
| C-25 | GCThreadMap.TryRememberHeapForThread - 世代別スレッド記録 | E-06 | ○ |
| C-26 | GCThreadMap.TryRememberHeapForThread - WKS GCスキップ | E-06 | ○ |
| C-27 | GCThreadMap.ThreadHasHeap - ヒープ保持判定 | E-06 | ○ |
| C-28 | GCThreadMap.GetThreadHeap - ヒープ情報取得 | E-06 | ○ |
| C-29 | GCThreadMap.IncludeThread - スレッドフィルタ判定 | E-06 | ○ |
| C-30 | GCThreadMap.IncludeThread - ヒープフィルタ判定 | E-06 | ○ |
| C-31 | TimeTracker.TicksToSecondsFromStart - 時間変換 | E-07 | ○ |
| C-32 | TimeTracker.RecordGCStart - GC開始記録 | E-07 | ○ |
| C-33 | TimeTracker.RecordGCStart - GC開始更新 | E-07 | ○ |
| C-34 | TimeTracker.RecordGCStart - GCインデックス範囲外 | E-07 | ○ |
| C-35 | TimeTracker.RecordGCEnd - GC終了記録 | E-07 | ○ |
| C-36 | TimeTracker.RecordGCEnd - GC終了更新 | E-07 | ○ |
| C-37 | TimeTracker.SetEndTimestamp - 相対時間範囲 | E-07 | ○ |
| C-38 | TimeTracker.SetEndTimestamp - 終了時刻設定 | E-07 | ○ |
| C-39 | TimeTracker.IsInTimeRange - フィルタなし | E-07 | ○ |
| C-40 | TimeTracker.IsInTimeRange - 範囲内判定 | E-07 | ○ |
| C-41 | TimeTracker.IsInTimeRange - 範囲前判定 | E-07 | ○ |
| C-42 | TimeTracker.IsInTimeRange - 範囲後判定 | E-07 | ○ |
| C-43 | TimeTracker.IsInInterestingGCTimeRange - GC時間範囲判定 | E-07 | ○ |
| C-44 | TimeTracker.IsInInterestingGCTimeRange - GC時間範囲外 | E-07 | ○ |
| C-45 | ThreadFilter.AddThread - スレッド追加 | E-08 | ○ |
| C-46 | ThreadFilter.AddBackgroundGCThread - BGCスレッド追加 | E-08 | ○ |
| C-47 | ThreadFilter.AddForegroundGCThread - FGCスレッド追加 | E-08 | ○ |
| C-48 | ThreadFilter.IncludeThread - 全スレッド許可 | E-08 | ○ |
| C-49 | ThreadFilter.IncludeThread - スレッドID一致 | E-08 | ○ |
| C-50 | ThreadFilter.IncludeHeapThread - BGCヒープ一致 | E-08 | ○ |
| C-51 | ThreadFilter.constructor - GCスレッドID解析 | E-08 | ○ |
| C-52 | ThreadFilter.constructor - BGスレッドID解析 | E-08 | ○ |
| C-53 | StressMessageWriter.OutputMessageAsync - メッセージ出力 | E-09 | ○ |
| C-54 | StressMessageWriter.GetFacility - ファシリティ文字列化(ALL) | E-09 | ○ |
| C-55 | StressMessageWriter.GetFacility - GC特殊エンコーディング | E-09 | ○ |
| C-56 | DocumentCompiler.Compile - ILコンパイル基本動作 | E-10 | ○ |
| C-57 | DocumentCompiler.Compile - 構文エラー検出 | E-10 | ○ |
| C-58 | DocumentCompiler.Compile - #include処理 | E-10, E-11 | △ |
| C-59 | PreprocessedTokenSource.NextToken - インクルード処理 | E-11 | ○ |
| C-60 | PreprocessedTokenSource.NextToken - 変数定義 | E-11 | ○ |
| C-61 | PreprocessedTokenSource.NextToken - 変数値設定 | E-11 | ○ |
| C-62 | PreprocessedTokenSource.NextToken - ifdef true分岐 | E-11 | ○ |
| C-63 | PreprocessedTokenSource.NextToken - ifdef false分岐 | E-11 | ○ |
| C-64 | PreprocessedTokenSource.NextToken - ifndef true分岐 | E-11 | ○ |
| C-65 | PreprocessedTokenSource.NextToken - else分岐 | E-11 | ○ |
| C-66 | PreprocessedTokenSource.NextToken - endif処理 | E-11 | ○ |
| C-67 | PreprocessedTokenSource.NextToken - マクロ展開 | E-11 | ○ |
| C-68 | PreprocessedTokenSource.NextToken - 未閉じifdef検出 | E-11 | ○ |
| C-69 | PreprocessedTokenSource.NextToken - 不正else検出 | E-11 | ○ |
| C-70 | PreprocessedTokenSource.ConsumeDisabledPreprocessorBlock - ネストifdef処理 | E-11 | ○ |
| C-71 | TypeName.constructor - 型名構築 | E-12 | ○ |
| C-72 | TypeName.constructor - ネスト型名構築 | E-12 | ○ |
| C-73 | LinkContext.constructor - コンテキスト初期化 | E-13 | ○ |
| C-74 | LinkContext.SetFeatureValue - フィーチャー設定 | E-13 | ○ |
| C-75 | LinkContext.HasFeatureValue - フィーチャー判定 | E-13 | ○ |
| C-76 | LinkContext.HasFeatureValue - 未設定フィーチャー | E-13 | ○ |
| C-77 | LinkContext.GetType - 型名解決 | E-13 | ○ |
| C-78 | LinkContext.GetType - 型名検索 | E-13 | ○ |
| C-79 | LinkContext.GetType - 型名解決失敗 | E-13 | ○ |
| C-80 | LinkContext.TryResolve - アセンブリ解決 | E-13 | ○ |
| C-81 | LinkContext.TryResolve - アセンブリ解決失敗 | E-13 | ○ |
| C-82 | LinkContext.RegisterAssembly - アセンブリ登録 | E-13 | ○ |
| C-83 | LinkContext.RegisterAssembly - 重複登録スキップ | E-13 | ○ |
| C-84 | LinkContext.CalculateAssemblyAction - アクション計算 | E-13 | ○ |
| C-85 | LinkContext.CalculateAssemblyAction - C++/CLI特殊処理 | E-13 | ○ |
| C-86 | LinkContext.CalculateAssemblyAction - トリマブル判定 | E-13 | ○ |
| C-87 | LinkContext.IsTrimmable - トリマブル属性判定 | E-13 | ○ |
| C-88 | LinkContext.IsTrimmable - トリマブル属性なし | E-13 | ○ |
| C-89 | LinkContext.Resolve(MethodReference) - メソッド解決 | E-13 | ○ |
| C-90 | LinkContext.Resolve(MethodReference) - キャッシュ | E-13 | ○ |
| C-91 | LinkContext.Resolve(MethodReference) - 解決失敗 | E-13 | ○ |
| C-92 | LinkContext.Resolve(TypeReference) - 型解決 | E-13 | ○ |
| C-93 | LinkContext.Resolve(TypeReference) - ジェネリックパラメータ例外 | E-13 | ○ |
| C-94 | LinkContext.TryResolve(TypeReference) - 型仕様解決 | E-13 | ○ |
| C-95 | LinkContext.LogWarning - 警告ログ | E-13 | ○ |
| C-96 | LinkContext.LogError - エラーログ | E-13 | ○ |
| C-97 | LinkContext.IsWarningSuppressed - 警告抑制(NoTrimWarn) | E-13 | ○ |
| C-98 | LinkContext.IsWarningSuppressed - 警告コード抑制 | E-13 | ○ |
| C-99 | LinkContext.IsWarningAsError - 警告エラー化 | E-13 | ○ |
| C-100 | LinkContext.GetMethodIL - メソッドIL取得 | E-13 | △ |
| C-101 | TypeHierarchyCache.IsSystemType - システム型判定 | E-14 | ○ |
| C-102 | TypeHierarchyCache.IsSystemType - 非システム型判定 | E-14 | ○ |
| C-103 | TypeHierarchyCache.IsSystemReflectionIReflect - IReflect判定 | E-14 | ○ |
| C-104 | TypeHierarchyCache.GetFlags - フラグキャッシュ | E-14 | ○ |
| C-105 | TypeNameResolver.TryResolveTypeName - 型名解決 | E-15 | ○ |
| C-106 | TypeNameResolver.TryResolveTypeName - 空文字列型名 | E-15 | ○ |
| C-107 | TypeNameResolver.TryResolveTypeName - 非修飾名エラー | E-15 | ○ |
| C-108 | CodeOptimizationsSettings.IsEnabled - グローバル最適化判定 | E-13 | ○ |
| C-109 | CodeOptimizationsSettings.IsEnabled - アセンブリ固有最適化 | E-13 | ○ |
| C-110 | CodeOptimizationsSettings.Enable - 最適化有効化 | E-13 | ○ |
| C-111 | CodeOptimizationsSettings.Disable - 最適化無効化 | E-13 | ○ |
| C-112 | MarkStep.Process - マーキング処理 | E-16 | △ |
| C-113 | IntegerRange.constructor - 範囲構造体 | E-08 | ○ |
| C-114 | TimeRange.constructor - 時間範囲レコード | E-08 | ○ |
| C-115 | Options.constructor - オプションレコード | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- **MarkStep.cs**: ファイルが大きく、最初の200行のみ読み込み。完全なProcess()メソッドの実装詳細は確認できていない
  - 候補：完全なMarkStep.csの読み込み / 既存テストコードの参照
- **UnreachableBlocksOptimizer**: GetMethodIL内で使用されるが、詳細実装は未確認
  - 候補：UnreachableBlocksOptimizer.csの読み込み
- **DocumentCompiler #include統合テスト**: includedDocumentLoaderの完全なテスト観点は推測に基づく
  - 候補：既存のテストコードの参照
- **illink内の他のSteps**: MarkStep以外のStep（SweepStep, OutputStep等）は解析対象外
  - 候補：必要に応じて追加解析
- **TLens Analyzers**: src/tools/illink/src/tlens/TLens.Analyzers/配下のアナライザーは解析対象外
  - 候補：必要に応じて追加解析
- **ilasm GrammarVisitor**: 完全な文法処理ロジックは未確認
  - 候補：GrammarVisitor.csの読み込み
- **StressLogHeader/ModuleTable**: ヘッダー構造の詳細は未確認
  - 候補：StressLogHeader.csの読み込み

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - MarkStep.Processテストケース（UT-TOL-112）：ファイルサイズが大きく部分的な読み込みのみ。マーキングロジックの全体像は把握できていないため、テストケースが不十分な可能性あり
- **0: 低リスク** - DocumentCompiler/PreprocessedTokenSourceのプリプロセッサ関連：基本的なプリプロセッサディレクティブはカバーしているが、エッジケースの網羅性は要確認
- **0: 低リスク** - StressLogAnalyzer系：ソースコードを詳細に読み込んでおり、主要なメソッドとロジックをカバー
- **0: 低リスク** - LinkContext系：1000行以上のファイルを完全に読み込み、主要なpublicメソッドをカバー

## 6) レビュアーチェックリスト（最小）
- [ ] MarkStep.Process（UT-TOL-112）のテストケースが実際のマーキングロジックを反映しているか確認
- [ ] GCスレッドフィルタ関連テスト（UT-TOL-002, 023-030）がSVR/WKS GCの両方のシナリオをカバーしているか確認
- [ ] PreprocessedTokenSourceのネストしたifdef/ifndef処理（UT-TOL-070）のエッジケースを確認
- [ ] LinkContext.Resolve系メソッドのキャッシュ動作テストが並行アクセスを考慮しているか確認
- [ ] TypeNameResolverの型名解決テストがジェネリック型、配列型、ポインタ型をカバーしているか確認
- [ ] ValueRangeFilter/ValueFilterの範囲境界値テストが十分か確認（開始/終了が同値のケース等）
