---
generated_at: 2026-01-30 13:30:00
metrics:
  claims_total: 111
  claims_with_evidence: 108
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート: tasks モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：108 / 111、根拠なし：3
- 優先レビュー（高）
  1. **UT-TSK-051, 052**: CompilerCacheのコンストラクタテスト - コードは簡潔だが、実際の使用パターンの確認が必要
  2. **UT-TSK-111**: LogAsErrorExceptionのテスト - 非常に単純なクラスだが、使用箇所との整合性確認が必要
  3. **UT-TSK-109, 110**: SanitizeEchoメソッドのエッジケース - セキュリティ上重要なエスケープ処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tasks/AotCompilerTask/MonoAOTCompiler.cs` - MonoAOTCompilerクラス実装（1370行）
- E-02: `src/tasks/Common/Utils.cs` - Utilsユーティリティクラス（503行）
- E-03: `src/tasks/Common/FileCache.cs` - FileCacheクラス実装（94行）
- E-04: `src/tasks/Common/ProxyFile.cs` - ProxyFileクラス実装（57行）
- E-05: `src/tasks/Common/CompilerCache.cs` - CompilerCacheクラス実装（22行）
- E-06: `src/tasks/Common/Builders/AppBuilderTask.cs` - AppBuilderTaskクラス（98行）
- E-07: `src/tasks/Common/LogAsErrorException.cs` - LogAsErrorException例外クラス（10行）
- E-08: `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs` - WasmAppBuilderBaseTaskクラス（191行）
- E-09: `src/tasks/WasmAppBuilder/EmccCompile.cs` - EmccCompileタスク（337行）
- E-10: `src/tasks/Crossgen2Tasks/PrepareForReadyToRunCompilation.cs` - PrepareForReadyToRunCompilationタスク（589行）
- E-11: `src/tasks/Crossgen2Tasks/RunReadyToRunCompiler.cs` - RunReadyToRunCompilerタスク（424行）
- E-12: `src/tasks/Microsoft.NET.WebAssembly.Webcil/WebcilConverter.cs` - WebcilConverterクラス（377行）
- E-13: `src/tasks/Microsoft.NET.WebAssembly.Webcil/WebcilReader.cs` - WebcilReaderクラス（441行）
- E-14: `src/tasks/MonoTargetsTasks/ILStrip/ILStrip.cs` - ILStripタスク（372行）
- E-15: `src/tasks/Microsoft.NET.Sdk.WebAssembly.Pack.Tasks/GenerateWasmBootJson.cs` - GenerateWasmBootJsonタスク（573行）
- E-16: `src/tasks/installer.tasks/GenerateRunScript.cs` - GenerateRunScriptタスク（155行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-TSK-001) | MonoAOTCompiler.ProcessAndValidateArgumentsで有効パラメータ検証 | E-01 (line 329-485) | ○ |
| C-02 (UT-TSK-002) | CompilerBinaryPath存在チェック | E-01 (line 331-335) | ○ |
| C-03 (UT-TSK-003) | Assemblies空チェック | E-01 (line 337-341) | ○ |
| C-04 (UT-TSK-004) | OutputDir存在チェック | E-01 (line 348-352) | ○ |
| C-05 (UT-TSK-005) | UseLLVMとLLVMPath整合性チェック | E-01 (line 378-389) | ○ |
| C-06 (UT-TSK-006) | Mode Enum検証 | E-01 (line 391-395) | ○ |
| C-07 (UT-TSK-007) | OutputType検証 | E-01 (line 397-407) | ○ |
| C-08 (UT-TSK-008) | UseDirectIcalls依存関係チェック | E-01 (line 439-442) | ○ |
| C-09 (UT-TSK-009) | Execute成功パス | E-01 (line 488-505) | ○ |
| C-10 (UT-TSK-010) | Execute失敗パス | E-01 (line 509-510) | ○ |
| C-11 (UT-TSK-011) | FilterOutUnmanagedAssemblies処理 | E-01 (line 625-653) | ○ |
| C-12 (UT-TSK-012) | AOT_InternalForceToInterpretメタデータチェック | E-01 (line 655-656) | ○ |
| C-13 (UT-TSK-013) | EnsureAllAssembliesInTheSameDir同一ディレクトリ | E-01 (line 658-663) | ○ |
| C-14 (UT-TSK-014) | EnsureAllAssembliesInTheSameDirコピー処理 | E-01 (line 665-689) | ○ |
| C-15 (UT-TSK-015) | GetPrecompileArgumentsFor引数生成 | E-01 (line 691-1038) | ○ |
| C-16 (UT-TSK-016) | LLVM関連オプション追加 | E-01 (line 716-728) | ○ |
| C-17 (UT-TSK-017) | C言語AOTモジュールテーブル生成 | E-01 (line 1150-1176) | ○ |
| C-18 (UT-TSK-018) | Objective-C AOTモジュールテーブル生成 | E-01 (line 1177-1198) | ○ |
| C-19 (UT-TSK-019) | TryGetAssemblyName成功パス | E-01 (line 1214-1238) | ○ |
| C-20 (UT-TSK-020) | TryGetAssemblyName失敗パス | E-01 (line 1233-1237) | ○ |
| C-21 (UT-TSK-021) | Utils.IsNewerThan新しい場合 | E-02 (line 47-49) | ○ |
| C-22 (UT-TSK-022) | Utils.IsNewerThan古い場合 | E-02 (line 47-49) | ○ |
| C-23 (UT-TSK-023) | Utils.IsNewerThanファイル不存在 | E-02 (line 47-49) | ○ |
| C-24 (UT-TSK-024) | Utils.CopyIfDifferent異なる内容 | E-02 (line 270-281) | ○ |
| C-25 (UT-TSK-025) | Utils.CopyIfDifferent同じ内容 | E-02 (line 276-278) | ○ |
| C-26 (UT-TSK-026) | Utils.CopyIfDifferent例外 | E-02 (line 273-274) | ○ |
| C-27 (UT-TSK-027) | Utils.ComputeHash | E-02 (line 348-357) | ○ |
| C-28 (UT-TSK-028) | Utils.ComputeIntegrity | E-02 (line 359-366) | ○ |
| C-29 (UT-TSK-029) | Utils.FixupSymbolName特殊文字置換 | E-02 (line 475-501) | ○ |
| C-30 (UT-TSK-030) | Utils.FixupSymbolName英数字維持 | E-02 (line 483-487) | ○ |
| C-31 (UT-TSK-031) | Utils.FixupSymbolName空文字列 | E-02 (line 475-501) | ○ |
| C-32 (UT-TSK-032) | Utils.IsManagedAssemblyマネージド判定 | E-02 (line 434-443) | ○ |
| C-33 (UT-TSK-033) | Utils.IsManagedAssemblyネイティブ判定 | E-02 (line 451-472) | ○ |
| C-34 (UT-TSK-034) | Utils.IsManagedAssemblyファイル不存在 | E-02 (line 436-437) | ○ |
| C-35 (UT-TSK-035) | Utils.RunProcess正常実行 | E-02 (line 106-129) | ○ |
| C-36 (UT-TSK-036) | Utils.RunProcess失敗時例外 | E-02 (line 125-126) | ○ |
| C-37 (UT-TSK-037) | Utils.TryRunProcess正常 | E-02 (line 131-215) | ○ |
| C-38 (UT-TSK-038) | Utils.TryRunProcess失敗 | E-02 (line 213-214) | ○ |
| C-39 (UT-TSK-039) | FileCache有効パス初期化 | E-03 (line 24-42) | ○ |
| C-40 (UT-TSK-040) | FileCache無効パス初期化 | E-03 (line 27-31) | ○ |
| C-41 (UT-TSK-041) | UpdateAndCheckHasFileChanged新ファイル | E-03 (line 44-51) | ○ |
| C-42 (UT-TSK-042) | UpdateAndCheckHasFileChanged同ハッシュ | E-03 (line 50) | ○ |
| C-43 (UT-TSK-043) | UpdateAndCheckHasFileChanged無効時例外 | E-03 (line 46-47) | ○ |
| C-44 (UT-TSK-044) | ShouldCopyファイル不存在 | E-03 (line 63-67) | ○ |
| C-45 (UT-TSK-045) | ShouldCopyハッシュ変更 | E-03 (line 73-77) | ○ |
| C-46 (UT-TSK-046) | Save有効パス | E-03 (line 82-89) | ○ |
| C-47 (UT-TSK-047) | Save無効パス | E-03 (line 84-85) | ○ |
| C-48 (UT-TSK-048) | ProxyFile.CopyOutputFileIfChangedキャッシュ無効 | E-04 (line 28-29) | ○ |
| C-49 (UT-TSK-049) | ProxyFile.CopyOutputFileIfChangedコピー実行 | E-04 (line 42-48) | ○ |
| C-50 (UT-TSK-050) | ProxyFile.CopyOutputFileIfChanged一時ファイル不存在 | E-04 (line 31-32) | ○ |
| C-51 (UT-TSK-051) | CompilerCache空コンストラクタ | E-05 (line 15) | △ |
| C-52 (UT-TSK-052) | CompilerCache既存ハッシュコンストラクタ | E-05 (line 16-17) | △ |
| C-53 (UT-TSK-053) | AppBuilderTask.Execute | E-06 (line 70-75) | ○ |
| C-54 (UT-TSK-054) | AppBuilderTask.GatherCompiledAssemblies | E-06 (line 77-96) | ○ |
| C-55 (UT-TSK-055) | EmccCompile.Execute正常 | E-09 (line 48-59) | ○ |
| C-56 (UT-TSK-056) | EmccCompile.Execute空ソース | E-09 (line 63-67) | ○ |
| C-57 (UT-TSK-057) | EmccCompile.ExecuteObjectFileメタデータなし | E-09 (line 69-74) | ○ |
| C-58 (UT-TSK-058) | ShouldCompileソース新しい | E-09 (line 268-313) | ○ |
| C-59 (UT-TSK-059) | ShouldCompile出力最新 | E-09 (line 287-289) | ○ |
| C-60 (UT-TSK-060) | ShouldCompileソース不存在 | E-09 (line 270-271) | ○ |
| C-61 (UT-TSK-061) | GetEnvironmentVariablesDict | E-09 (line 315-334) | ○ |
| C-62 (UT-TSK-062) | GetEnvironmentVariablesDict空 | E-09 (line 318-319) | ○ |
| C-63 (UT-TSK-063) | WasmAppBuilderBaseTask.Execute正常 | E-08 (line 56-67) | ○ |
| C-64 (UT-TSK-064) | WasmAppBuilderBaseTask.Execute例外 | E-08 (line 62-66) | ○ |
| C-65 (UT-TSK-065) | UpdateRuntimeConfigJson空パス | E-08 (line 92-93) | ○ |
| C-66 (UT-TSK-066) | UpdateRuntimeConfigJson更新 | E-08 (line 90-163) | ○ |
| C-67 (UT-TSK-067) | UpdateRuntimeConfigJsonアセンブリ不存在 | E-08 (line 102-103) | ○ |
| C-68 (UT-TSK-068) | FileCopyChecked正常 | E-08 (line 169-184) | ○ |
| C-69 (UT-TSK-069) | FileCopyCheckedソース不存在 | E-08 (line 171-175) | ○ |
| C-70 (UT-TSK-070) | PrepareForReadyToRunCompilation.ExecuteCore | E-10 (line 99-124) | ○ |
| C-71 (UT-TSK-071) | GetInputFileEligibilityコンパイル対象 | E-10 (line 434-519) | ○ |
| C-72 (UT-TSK-072) | GetInputFileEligibility非DLL/EXE | E-10 (line 437-441) | ○ |
| C-73 (UT-TSK-073) | GetInputFileEligibility参照アセンブリ | E-10 (line 460-464) | ○ |
| C-74 (UT-TSK-074) | IsReferenceAssembly | E-10 (line 521-558) | ○ |
| C-75 (UT-TSK-075) | HasILCode | E-10 (line 574-586) | ○ |
| C-76 (UT-TSK-076) | RunReadyToRunCompiler.ValidateParameters正常 | E-11 (line 79-218) | ○ |
| C-77 (UT-TSK-077) | ValidateParametersCrossgen2不存在 | E-11 (line 98-107) | ○ |
| C-78 (UT-TSK-078) | GenerateResponseFileCommandsCrossgen2 | E-11 (line 257-268) | ○ |
| C-79 (UT-TSK-079) | GenerateCrossgenResponseFile | E-11 (line 270-298) | ○ |
| C-80 (UT-TSK-080) | WebcilConverter.FromPortableExecutable | E-12 (line 54-55) | ○ |
| C-81 (UT-TSK-081) | ConvertToWebcil変換 | E-12 (line 57-84) | ○ |
| C-82 (UT-TSK-082) | ConvertToWebcil WASMラッピング | E-12 (line 73-83) | ○ |
| C-83 (UT-TSK-083) | GatherInfo | E-12 (line 110-176) | ○ |
| C-84 (UT-TSK-084) | WriteHeader | E-12 (line 178-191) | ○ |
| C-85 (UT-TSK-085) | CopySections | E-12 (line 247-257) | ○ |
| C-86 (UT-TSK-086) | WebcilReader初期化正常 | E-13 (line 32-51) | ○ |
| C-87 (UT-TSK-087) | WebcilReader初期化例外 | E-13 (line 44-50) | ○ |
| C-88 (UT-TSK-088) | ReadHeader | E-13 (line 58-89) | ○ |
| C-89 (UT-TSK-089) | GetMetadataReader | E-13 (line 108-124) | ○ |
| C-90 (UT-TSK-090) | ReadDebugDirectory正常 | E-13 (line 125-151) | ○ |
| C-91 (UT-TSK-091) | ReadDebugDirectory空 | E-13 (line 127-136) | ○ |
| C-92 (UT-TSK-092) | ILStrip.Execute正常 | E-14 (line 57-120) | ○ |
| C-93 (UT-TSK-093) | ILStrip.Execute空Assemblies | E-14 (line 59-61) | ○ |
| C-94 (UT-TSK-094) | StripAssembly正常 | E-14 (line 122-156) | ○ |
| C-95 (UT-TSK-095) | StripAssembly非マネージド | E-14 (line 139-141) | ○ |
| C-96 (UT-TSK-096) | TrimMethods正常 | E-14 (line 158-232) | ○ |
| C-97 (UT-TSK-097) | TrimMethodsファイル不存在 | E-14 (line 167-170) | ○ |
| C-98 (UT-TSK-098) | GenerateWasmBootJson.Execute正常 | E-15 (line 104-118) | ○ |
| C-99 (UT-TSK-099) | GenerateWasmBootJson.Execute例外 | E-15 (line 112-115) | ○ |
| C-100 (UT-TSK-100) | GetGlobalizationModeInvariant | E-15 (line 507-517) | ○ |
| C-101 (UT-TSK-101) | GetGlobalizationModeAll | E-15 (line 511-512) | ○ |
| C-102 (UT-TSK-102) | IsTargeting80OrLater true | E-15 (line 547-548, 559-570) | ○ |
| C-103 (UT-TSK-103) | IsTargeting80OrLater false | E-15 (line 547-548, 559-570) | ○ |
| C-104 (UT-TSK-104) | GenerateRunScript.Execute正常 | E-16 (line 26-59) | ○ |
| C-105 (UT-TSK-105) | GenerateRunScript.Execute空RunCommands | E-16 (line 28-32) | ○ |
| C-106 (UT-TSK-106) | GenerateRunScript.Executeテンプレート不存在 | E-16 (line 34-38) | ○ |
| C-107 (UT-TSK-107) | WriteRunScript Unix形式 | E-16 (line 61-133) | ○ |
| C-108 (UT-TSK-108) | WriteRunScript Windows形式 | E-16 (line 61-133) | ○ |
| C-109 (UT-TSK-109) | SanitizeEchoバッククォートエスケープ | E-16 (line 135-152) | ○ |
| C-110 (UT-TSK-110) | SanitizeEcho Unix引用符 | E-16 (line 144-149) | ○ |
| C-111 (UT-TSK-111) | LogAsErrorException初期化 | E-07 (line 4-9) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-TSK-051, 052 (CompilerCache)**: コードは非常に単純だが、スレッドセーフ性やConcurrentDictionaryの挙動に関する詳細なテストパターンの根拠が不足
  - 候補：既存のユニットテスト / 統合テスト / スレッドセーフ性の設計文書
- **UT-TSK-111 (LogAsErrorException)**: 例外クラスは単純だが、どのようなエラー状況で使用されるかの網羅的な根拠が不足
  - 候補：エラーハンドリングガイドライン / 既存のエラーケーステスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UT-TSK-051, 052, 111: 単純なクラスであり、実装ミスの可能性は低い
- **1: 中リスク** - UT-TSK-109, 110 (SanitizeEcho): セキュリティ上重要なエスケープ処理。入力値によってはコマンドインジェクションの可能性
- **1: 中リスク** - UT-TSK-035-038 (プロセス実行): 外部プロセス実行は環境依存性が高い
- **2: 高リスク** - なし

## 6) レビュアーチェックリスト（最小）
- [ ] CompilerCache (UT-TSK-051, 052) のスレッドセーフ性テストパターンが適切か確認
- [ ] LogAsErrorException (UT-TSK-111) の使用箇所と例外メッセージの整合性を確認
- [ ] SanitizeEcho (UT-TSK-109, 110) のエスケープ処理がセキュリティ要件を満たすか確認
- [ ] プロセス実行テスト (UT-TSK-035-038) の環境依存性と再現性を確認
- [ ] 各テストケースの優先度（高/中/低）が適切か確認
- [ ] 境界値テストケースの網羅性を確認
- [ ] AOTコンパイル関連テストケース (UT-TSK-001-020) の網羅性を確認
