---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 122
  claims_with_evidence: 118
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：tools モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：118 / 122、根拠なし：4
- 優先レビュー（高）
  1. **UT-TLS-070 (ILCompilation.Emit)**: Emitメソッドの実装が空のため、期待結果の検証が必要
  2. **UT-TLS-069 (ILCompilation.constructor)**: 実装の詳細が不明
  3. **UT-TLS-093 (EntityRegistry.WriteContentTo)**: 複雑なメタデータ書き込みロジックの検証が必要
  4. **UT-TLS-115 (LinkContext.GetMethodIL)**: 内部最適化処理の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/StressLogAnalyzer.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Options.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Filters/IMessageFilter.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Filters/ValueFilter.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Filters/ValueRangeFilter.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Filters/FacilityMessageFilter.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Filters/AllMessagesFilter.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Filters/InterestingMessageFilter.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Filters/DPrintLevelFilter.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/TimeTracker.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/GCThreadMap.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/InterestingStringFinder.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/LogFacility.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/StressLogHeader.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Output/StressMessageWriter.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Output/GCThreadNameOutput.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Output/HexThreadNameOutput.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Output/IThreadNameOutput.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/Output/IStressMessageOutput.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/DefaultSpecialPointerFormatter.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/tools/StressLogAnalyzer/src/IInterestingStringFinder.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/tools/ilasm/src/ILAssembler/DocumentCompiler.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/tools/ilasm/src/ILAssembler/ILCompilation.cs`
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/tools/ilasm/src/ILAssembler/Options.cs`
- E-25: `/Users/tomoka.baba/Work/runtime-main/src/tools/ilasm/src/ILAssembler/Diagnostic.cs`
- E-26: `/Users/tomoka.baba/Work/runtime-main/src/tools/ilasm/src/ILAssembler/SourceText.cs`
- E-27: `/Users/tomoka.baba/Work/runtime-main/src/tools/ilasm/src/ILAssembler/EntityRegistry.cs`
- E-28: `/Users/tomoka.baba/Work/runtime-main/src/tools/ilasm/src/ILAssembler/TypeName.cs`
- E-29: `/Users/tomoka.baba/Work/runtime-main/src/tools/illink/src/linker/Linker/LinkContext.cs`
- E-30: `/Users/tomoka.baba/Work/runtime-main/src/tools/illink/src/linker/Linker.Steps/IStep.cs`
- E-31: `/Users/tomoka.baba/Work/runtime-main/src/tools/illink/src/linker/Linker.Steps/BaseStep.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StressLogAnalyzer.AnalyzeLogsAsyncがログを正しく解析する | E-01 | ○ |
| C-02 | ThreadFilterがスレッドフィルタリングを正しく適用する | E-01, E-02 | ○ |
| C-03 | TimeTrackerが時間範囲フィルタリングを正しく適用する | E-01, E-10 | ○ |
| C-04 | CancellationTokenによる中断が正しく動作する | E-01 | ○ |
| C-05 | 空のログコレクションで正しく処理される | E-01 | ○ |
| C-06 | ThreadFilter constructorがスレッドIDを正しくパースする | E-02 | ○ |
| C-07 | ThreadFilter constructorがGCプレフィックスを正しく処理する | E-02 | ○ |
| C-08 | ThreadFilter constructorがBGプレフィックスを正しく処理する | E-02 | ○ |
| C-09 | ThreadFilter constructorがカンマ区切りを正しく処理する | E-02 | ○ |
| C-10 | 空配列で_allThreads=trueとなる | E-02 | ○ |
| C-11 | IncludeThreadが登録済みスレッドでtrueを返す | E-02 | ○ |
| C-12 | IncludeThreadが未登録スレッドでfalseを返す | E-02 | ○ |
| C-13 | allThreads=trueで常にtrueを返す | E-02 | ○ |
| C-14 | IncludeHeapThreadがフォアグラウンドGCスレッドを正しく判定する | E-02 | ○ |
| C-15 | IncludeHeapThreadがバックグラウンドGCスレッドを正しく判定する | E-02 | ○ |
| C-16 | HasAnyGCThreadFilterがGCスレッドフィルタの存在を正しく判定する | E-02 | ○ |
| C-17 | HasAnyFilterがフィルタ設定の存在を正しく判定する | E-02 | ○ |
| C-18 | TicksToSecondsFromStartが正しく時間変換する | E-10 | ○ |
| C-19 | 開始タイムスタンプと同じ値で0を返す | E-10 | ○ |
| C-20 | RecordGCStartがGC開始時刻を記録する | E-10 | ○ |
| C-21 | 範囲外GCインデックスで記録しない | E-10 | ○ |
| C-22 | null範囲で何も記録しない | E-10 | ○ |
| C-23 | RecordGCEndがGC終了時刻を記録する | E-10 | ○ |
| C-24 | 負の開始タイムスタンプが相対値として解釈される | E-10 | ○ |
| C-25 | IsInTimeRangeが範囲内でInRangeを返す | E-10 | ○ |
| C-26 | IsInTimeRangeが範囲前でBeforeRangeを返す | E-10 | ○ |
| C-27 | IsInTimeRangeが範囲後でAfterRangeを返す | E-10 | ○ |
| C-28 | timeRange=nullで常にInRangeを返す | E-10 | ○ |
| C-29 | IsInInterestingGCTimeRangeがGC時間範囲を正しく判定する | E-10 | ○ |
| C-30 | TryRememberHeapForThreadがTHREAD_WAITを正しく処理する | E-11 | ○ |
| C-31 | TryRememberHeapForThreadがSTART_BGC_THREADを正しく処理する | E-11 | ○ |
| C-32 | DESIRED_NEW_ALLOCATION gen0/1でヒープが記憶される | E-11 | ○ |
| C-33 | DESIRED_NEW_ALLOCATION gen2以上で記憶されない | E-11 | ○ |
| C-34 | ThreadHasHeapが登録済みスレッドを正しく判定する | E-11 | ○ |
| C-35 | GetThreadHeapが正しいヒープ情報を返す | E-11 | ○ |
| C-36 | IncludeThreadがフィルタを正しく適用する | E-11 | ○ |
| C-37 | IsInterestingが既知の興味深い文字列を検出する | E-12 | ○ |
| C-38 | IsInterestingがユーザー指定文字列を検出する | E-12 | ○ |
| C-39 | IsInterestingがプレフィックスマッチを正しく処理する | E-12 | ○ |
| C-40 | IsInterestingがキャッシュを正しく使用する | E-12 | ○ |
| C-41 | IsWellKnownが既知文字列を正しく判定する | E-12 | ○ |
| C-42 | IsWellKnownが未知文字列を正しく判定する | E-12 | ○ |
| C-43 | AllMessagesFilterがincludeAllMessages=trueで常にtrueを返す | E-07 | ○ |
| C-44 | AllMessagesFilterがincludeAllMessages=falseで常にfalseを返す | E-07 | ○ |
| C-45 | ValueFilterが範囲内の値でtrueを返す | E-04 | ○ |
| C-46 | ValueFilterが範囲外で内部フィルタに委譲する | E-04 | ○ |
| C-47 | ValueRangeFilterがPLAN_PLUGを正しく処理する | E-05 | ○ |
| C-48 | ValueRangeFilterがGCMEMCOPYを正しく処理する | E-05 | ○ |
| C-49 | ValueRangeFilterがRELOCATE_REFERENCEを正しく処理する | E-05 | ○ |
| C-50 | FacilityMessageFilterが無視対象ファシリティをフィルタする | E-06 | ○ |
| C-51 | FacilityMessageFilterがignoreFacility=0で内部フィルタに委譲する | E-06 | ○ |
| C-52 | FacilityMessageFilterがGCエンコードメッセージを正しく判定する | E-06 | ○ |
| C-53 | InterestingMessageFilterが興味深いメッセージを検出する | E-08 | ○ |
| C-54 | InterestingMessageFilterが非興味深いメッセージで内部フィルタに委譲する | E-08 | ○ |
| C-55 | DPrintLevelFilterがレベル範囲内でtrueを返す | E-09 | ○ |
| C-56 | DPrintLevelFilterがレベル範囲外で内部フィルタに委譲する | E-09 | ○ |
| C-57 | StressMessageWriterがメッセージを正しくフォーマットする | E-15 | ○ |
| C-58 | StressMessageWriterがwriteFormatString=trueでフォーマット文字列を出力する | E-15 | ○ |
| C-59 | StressMessageWriter.OutputLineAsyncが正しく動作する | E-15 | ○ |
| C-60 | GCThreadNameOutputがGCスレッド名を正しく返す | E-16 | ○ |
| C-61 | GCThreadNameOutputがBGスレッド名を正しく返す | E-16 | ○ |
| C-62 | GCThreadNameOutputが非GCスレッド名を16進数で返す | E-16 | ○ |
| C-63 | HexThreadNameOutputがスレッドIDを16進数で返す | E-17 | ○ |
| C-64 | DefaultSpecialPointerFormatterがMethodDescを正しくフォーマットする | E-20 | ○ |
| C-65 | DefaultSpecialPointerFormatterがMethodTableを正しくフォーマットする | E-20 | ○ |
| C-66 | DocumentCompilerが有効なILソースをコンパイルできる | E-22 | ○ |
| C-67 | DocumentCompilerが構文エラーを検出する | E-22 | ○ |
| C-68 | DocumentCompilerが#includeを正しく処理する | E-22 | ○ |
| C-69 | ILCompilationコンストラクタが正しく動作する | E-23 | △ |
| C-70 | ILCompilation.Emitがバイト配列を返す | E-23 | △ |
| C-71 | Diagnosticが正しく初期化される | E-25 | ○ |
| C-72 | SourceTextが正しく初期化される | E-26 | ○ |
| C-73 | Options.NoAutoInheritが設定・取得できる | E-24 | ○ |
| C-74 | EntityRegistryコンストラクタがModuleTypeを作成する | E-27 | ○ |
| C-75 | GetOrCreateTypeDefinitionが型定義を作成・取得する | E-27 | ○ |
| C-76 | GetOrCreateTypeDefinitionが同じ型定義で同一インスタンスを返す | E-27 | ○ |
| C-77 | GetOrCreateTypeReferenceが型参照を作成・取得する | E-27 | ○ |
| C-78 | GetOrCreateAssemblyReferenceがアセンブリ参照を作成・取得する | E-27 | ○ |
| C-79 | GetOrCreateModuleReferenceがモジュール参照を作成・取得する | E-27 | ○ |
| C-80 | GetOrCreateTypeSpecが型仕様を作成・取得する | E-27 | ○ |
| C-81 | CreateGenericParameterがジェネリックパラメータを作成する | E-27 | ○ |
| C-82 | CreateUnrecordedMethodDefinitionがメソッド定義を作成する | E-27 | ○ |
| C-83 | TryAddMethodDefinitionToContainingTypeがメソッドを追加する | E-27 | ○ |
| C-84 | TryAddMethodDefinitionToContainingTypeが重複メソッドでfalseを返す | E-27 | ○ |
| C-85 | CreateUnrecordedFieldDefinitionがフィールド定義を作成する | E-27 | ○ |
| C-86 | CreateParameterがパラメータを作成する | E-27 | ○ |
| C-87 | GetOrCreateStandaloneSignatureがスタンドアロンシグネチャを作成・取得する | E-27 | ○ |
| C-88 | CreateCustomAttributeがカスタム属性を作成する | E-27 | ○ |
| C-89 | ResolveImplicitBaseTypeがSystem.Objectを解決する | E-27 | ○ |
| C-90 | ResolveImplicitBaseTypeがSystem.ValueTypeを解決する | E-27 | ○ |
| C-91 | ResolveImplicitBaseTypeがSystem.Enumを解決する | E-27 | ○ |
| C-92 | ResolveImplicitBaseTypeがnullでnullを返す | E-27 | ○ |
| C-93 | WriteContentToがメタデータを正しく書き込む | E-27 | △ |
| C-94 | TypeDefinitionEntityが正しく初期化される | E-27 | ○ |
| C-95 | TypeReferenceEntityが正しく初期化される | E-27 | ○ |
| C-96 | TypeNameが正しく初期化される | E-28 | ○ |
| C-97 | LinkContextコンストラクタが正しく動作する | E-29 | ○ |
| C-98 | GetTypeが完全修飾名で型を取得する | E-29 | ○ |
| C-99 | GetTypeがアセンブリ指定付き名前で型を取得する | E-29 | ○ |
| C-100 | GetTypeが存在しない型でnullを返す | E-29 | ○ |
| C-101 | TryResolve(string)がアセンブリを解決する | E-29 | ○ |
| C-102 | Resolve(MethodReference)がメソッドを解決する | E-29 | ○ |
| C-103 | Resolve(FieldReference)がフィールドを解決する | E-29 | ○ |
| C-104 | Resolve(TypeReference)が型を解決する | E-29 | ○ |
| C-105 | RegisterAssemblyがアセンブリを登録する | E-29 | ○ |
| C-106 | IsTrimmableがトリム可能アセンブリでtrueを返す | E-29 | ○ |
| C-107 | IsTrimmableがトリム不可アセンブリでfalseを返す | E-29 | ○ |
| C-108 | SetFeatureValueがフィーチャー値を設定する | E-29 | ○ |
| C-109 | HasFeatureValueが設定済みフィーチャー値を確認する | E-29 | ○ |
| C-110 | LogWarningが警告を記録する | E-29 | ○ |
| C-111 | LogErrorがエラーを記録する | E-29 | ○ |
| C-112 | IsWarningSuppressedがNoWarnの警告を判定する | E-29 | ○ |
| C-113 | IsWarningAsErrorがWarnAsErrorの警告を判定する | E-29 | ○ |
| C-114 | FlushCachedWarningsがキャッシュされた警告を出力する | E-29 | ○ |
| C-115 | GetMethodILが最適化済みILを取得する | E-29 | △ |
| C-116 | IsOptimizationEnabledが最適化有効を判定する | E-29 | ○ |
| C-117 | BaseStep.Processがステップを実行する | E-31 | ○ |
| C-118 | BaseStep.ConditionToProcessが条件スキップを制御する | E-31 | ○ |
| C-119 | CodeOptimizationsSettings.IsEnabledがグローバル最適化を判定する | E-29 | ○ |
| C-120 | CodeOptimizationsSettings.IsEnabledがアセンブリ固有設定を優先する | E-29 | ○ |
| C-121 | CodeOptimizationsSettings.Enableが最適化を有効化する | E-29 | ○ |
| C-122 | CodeOptimizationsSettings.Disableが最適化を無効化する | E-29 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ILCompilation の実装詳細**: ILCompilationクラスのEmitメソッドは空の配列を返す実装となっており、実際のコンパイル出力ロジックが不明
  - 候補：GrammarVisitor / DocumentCompiler との連携部分の解析
- **WriteContentTo の複雑なロジック**: EntityRegistry.WriteContentToは1000行以上の複雑なメタデータ生成ロジックを含むため、詳細な検証が困難
  - 候補：統合テストでの検証 / メタデータ書き込み結果の比較テスト
- **GetMethodIL の内部最適化**: UnreachableBlocksOptimizerによる最適化処理の詳細が不明
  - 候補：UnreachableBlocksOptimizer.ProcessMethod の解析
- **illink の大規模コードベース**: 328ファイル中、主要ファイルのみ解析。すべてのステップクラスは網羅していない
  - 候補：個別ステップクラス（MarkStep, SweepStep等）の詳細解析

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: StressLogAnalyzer関連クラス（フィルタ、出力クラス）- 単純なロジックで検証容易
- **1: 中リスク**: ilasm関連クラス - メタデータ生成の複雑性
- **1: 中リスク**: illink LinkContext - 依存関係解決の複雑性
- **2: 高リスク**: EntityRegistry.WriteContentTo - 大規模なメタデータ書き込みロジック

## 6) レビュアーチェックリスト（最小）
- [ ] StressLogAnalyzer.AnalyzeLogsAsync のスレッドセーフな並列処理が正しいか確認
- [ ] ThreadFilter の16進数パースが不正な入力でも安全に処理されるか確認
- [ ] TimeTracker の Interlocked 操作が競合状態を正しく処理するか確認
- [ ] ILCompilation.Emit が実際に有効なバイナリを生成するか確認（現在は空実装）
- [ ] EntityRegistry.WriteContentTo のメタデータテーブル順序が ECMA-335 に準拠しているか確認
- [ ] LinkContext の Resolve メソッドが循環参照を正しく処理するか確認
- [ ] CodeOptimizationsSettings のアセンブリ固有設定とグローバル設定の優先順位が正しいか確認
