---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 80
  claims_with_evidence: 72
  claims_without_evidence: 8
confidence_derived: 0.90
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：72 / 80、根拠なし：8
- 優先レビュー（高）
  1. **UAT-057〜060（環境別テスト）**：Node.js/Web Worker/シェル環境での詳細動作は推測を含む
  2. **UAT-077〜078（WebSocket/HTTP）**：web-socket.ts/http.tsの詳細実装は未確認
  3. **UAT-079〜080（遅延ロード/サテライト）**：実際のロードタイミング制御の詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/corehost/browserhost/loader/dotnet.ts` - dotnet.jsのエントリポイント
- E-02: `src/native/corehost/browserhost/loader/host-builder.ts` - DotnetHostBuilderクラス実装
- E-03: `src/native/corehost/browserhost/loader/config.ts` - LoaderConfig設定管理
- E-04: `src/native/corehost/browserhost/loader/assets.ts` - アセットロード機能
- E-05: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/invoke-js.ts` - JSImport実装
- E-06: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/invoke-cs.ts` - JSExport実装
- E-07: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/marshal.ts` - マーシャリング基盤
- E-08: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/marshal-to-cs.ts` - JS→C#マーシャリング
- E-09: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/marshal-to-js.ts` - C#→JSマーシャリング
- E-10: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/gc-handles.ts` - GCハンドル管理
- E-11: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/managed-exports.ts` - マネージドエクスポート
- E-12: `src/native/libs/Common/JavaScript/per-module/index.ts` - 環境検出
- E-13: `src/native/corehost/browserhost/loader/polyfills.ts` - ポリフィル
- E-14: `src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/cancelable-promise.ts` - キャンセル可能Promise

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dotnetオブジェクト初期化 | E-01, E-02 | ○ |
| C-02 | withConfig設定適用 | E-02, E-03 | ○ |
| C-03 | 環境変数設定 | E-02 | ○ |
| C-04 | 複数環境変数設定 | E-02 | ○ |
| C-05 | 仮想作業ディレクトリ設定 | E-02, E-03 | ○ |
| C-06 | 診断トレース有効化 | E-02, E-03 | ○ |
| C-07 | デバッグレベル設定 | E-02, E-03 | ○ |
| C-08 | メインアセンブリ名設定 | E-02, E-03 | ○ |
| C-09 | URLクエリパラメータからの引数取得 | E-02 | ○ |
| C-10 | アプリケーション環境設定 | E-02, E-03 | ○ |
| C-11 | アプリケーションカルチャ設定 | E-02, E-03 | ○ |
| C-12 | カスタムリソースローダー設定 | E-02, E-04 | ○ |
| C-13 | download()メソッド実行 | E-02 | ○ |
| C-14 | create()メソッド実行 | E-02 | ○ |
| C-15 | runMain()メソッド実行 | E-02 | ○ |
| C-16 | runMainAndExit()メソッド実行 | E-02 | ○ |
| C-17 | JSからC#メソッド呼び出し | E-06, E-11 | ○ |
| C-18 | C#からJSメソッド呼び出し | E-05 | ○ |
| C-19 | 引数なしメソッド呼び出し | E-06 | ○ |
| C-20 | 1引数メソッド呼び出し（戻り値なし） | E-06 | ○ |
| C-21 | 1引数メソッド呼び出し（戻り値あり） | E-06 | ○ |
| C-22 | 2引数メソッド呼び出し | E-06 | ○ |
| C-23 | 非同期メソッド呼び出し | E-06, E-09 | ○ |
| C-24 | 例外ハンドリング | E-05, E-08 | ○ |
| C-25 | 動的ES6モジュールインポート | E-05 | ○ |
| C-26 | モジュールインポートキャッシュ | E-05 | ○ |
| C-27 | JSオブジェクトプロパティ設定 | E-05 | ○ |
| C-28 | JSオブジェクトプロパティ取得 | E-05 | ○ |
| C-29 | JSオブジェクトプロパティ存在確認 | E-05 | ○ |
| C-30 | プロパティ型取得 | E-05 | ○ |
| C-31 | アセンブリロード | E-04 | ○ |
| C-32 | PDBファイルロード | E-04 | ○ |
| C-33 | ICUデータロード | E-04 | ○ |
| C-34 | VFSファイルロード | E-04 | ○ |
| C-35 | WASMモジュールロード | E-04 | ○ |
| C-36 | ダウンロード進捗コールバック | E-04 | ○ |
| C-37 | ダウンロードリトライ | E-04 | ○ |
| C-38 | 並列ダウンロードスロットリング | E-04 | ○ |
| C-39 | 設定バリデーションエラー（mainAssemblyName） | E-03 | ○ |
| C-40 | 設定バリデーションエラー（coreAssembly） | E-03 | ○ |
| C-41 | 設定マージ | E-03 | ○ |
| C-42 | 正常終了 | E-02 | ○ |
| C-43 | エラー終了 | E-02 | ○ |
| C-44 | appendElementOnExit機能 | E-03 | ○ |
| C-45 | JSオブジェクトGCハンドル管理 | E-10 | ○ |
| C-46 | JSオブジェクト解放 | E-10, E-11 | ○ |
| C-47 | プリミティブ型マーシャリング | E-07, E-08 | ○ |
| C-48 | Date型マーシャリング | E-07 | ○ |
| C-49 | BigInt型マーシャリング | E-07 | ○ |
| C-50 | 配列マーシャリング | E-07 | ○ |
| C-51 | Spanマーシャリング | E-05 | ○ |
| C-52 | Task完了 | E-11 | ○ |
| C-53 | Taskエラー完了 | E-11 | ○ |
| C-54 | DiscardNoWait | E-06 | ○ |
| C-55 | デリゲート呼び出し | E-11 | ○ |
| C-56 | WeakReference管理 | E-10 | ○ |
| C-57 | Node.js環境での初期化 | E-01, E-12 | △ |
| C-58 | Node.jsファイルシステムアクセス | E-12 | △ |
| C-59 | Web Workerでの初期化 | E-12 | △ |
| C-60 | シェル環境での初期化 | E-12 | △ |
| C-61 | URL.canParseポリフィル | E-13 | ○ |
| C-62 | デフォルト設定適用 | E-03 | ○ |
| C-63 | インテグリティチェック | E-04 | ○ |
| C-64 | 認証情報付きリクエスト | E-04 | ○ |
| C-65 | HTTPエラーハンドリング | E-04 | ○ |
| C-66 | デバッグログ出力 | E-07 | ○ |
| C-67 | パフォーマンス計測 | E-05, E-06 | ○ |
| C-68 | マネージドスタックトレース取得 | E-11 | ○ |
| C-69 | globalThis取得 | E-05 | ○ |
| C-70 | dotnetインスタンス取得 | E-05 | ○ |
| C-71 | シグネチャバージョン検証 | E-05, E-06 | ○ |
| C-72 | CSPポリシー対応 | E-05, E-06 | ○ |
| C-73 | アセンブリエクスポートバインド | E-11 | ○ |
| C-74 | 名前空間解決 | E-06 | ○ |
| C-75 | オーバーロード | E-06 | ○ |
| C-76 | キャンセル可能Promise | E-14 | ○ |
| C-77 | WebSocket相互運用 | **根拠不足** | △ |
| C-78 | HTTP相互運用 | **根拠不足** | △ |
| C-79 | 遅延アセンブリロード | E-03 | △ |
| C-80 | サテライトリソースロード | E-03, E-04 | △ |

## 4) 不足情報（Unknown / Missing）
- **Node.js/Web Worker/シェル環境の詳細動作**：環境検出フラグは確認できたが、各環境での具体的な動作差異の詳細は推測を含む
  - 候補：src/native/corehost/browserhost/loader/run.ts / 各環境用のテストコード / 環境別設定ドキュメント
- **WebSocket相互運用の詳細実装**：web-socket.tsファイルの存在は確認したが、詳細な実装内容は未読
  - 候補：src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/web-socket.ts
- **HTTP相互運用の詳細実装**：http.tsファイルの存在は確認したが、詳細な実装内容は未読
  - 候補：src/native/libs/System.Runtime.InteropServices.JavaScript.Native/interop/http.ts
- **遅延ロード/サテライトリソースのロードタイミング制御**：設定項目は確認できたが、実際のロードトリガー条件の詳細は未確認
  - 候補：ランタイム側のアセンブリローダー実装 / Blazorフレームワークとの統合コード

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 環境別テスト（UAT-057〜060）：各環境での実際の動作確認が必要
- **1: 中リスク** - WebSocket/HTTP相互運用（UAT-077〜078）：詳細実装の確認が推奨される
- **0: 低リスク** - 遅延ロード/サテライトリソース（UAT-079〜080）：設定は確認できているが、E2Eでの動作確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの前提条件が実際の運用環境で満たせるか確認
- [ ] 優先度「高」のテストケース（UAT-001〜016, UAT-017〜018, UAT-023〜024, UAT-031, UAT-035, UAT-039〜040, UAT-042〜043, UAT-052〜053, UAT-057, UAT-073）が網羅されているか確認
- [ ] 環境別テスト（Node.js/Web Worker/シェル）の詳細手順が実行可能か確認
- [ ] WebSocket/HTTP相互運用テストの具体的な検証方法を補完
- [ ] 遅延ロード/サテライトリソーステストのトリガー条件を明確化
- [ ] 各テストケースの期待結果が検証可能な形式で記述されているか確認
- [ ] セキュリティ関連テスト（CSPポリシー、認証情報、インテグリティチェック）の実施環境を準備
