# 帳票設計書 3-SchematronReport (HTML)

## 概要

本ドキュメントは、Schematron XML検証結果をHTML形式で出力するレポート生成機能の仕様を定義する帳票設計書である。

### 本帳票の処理概要

本帳票は、Schematronスキーマ言語を用いたXMLドキュメントの検証結果を、視覚的に分かりやすいHTML形式のレポートとして出力する機能である。XSLTスタイルシートとして実装されており、Schematronの検証結果を変換することでHTMLレポートを生成する。

**業務上の目的・背景**：XMLドキュメントの品質検証において、Schematronはビジネスルールや構造的制約を柔軟に定義できるスキーマ言語として広く利用されている。本帳票は、Schematron検証で発見されたエラーや警告を、開発者やドキュメント管理者が容易に理解・対処できるHTMLレポートとして提供する。これにより、XMLドキュメントの品質管理プロセスを効率化し、検証結果の共有やレビューを容易にする。

**帳票の利用シーン**：
- XMLドキュメントのバリデーション結果の確認
- ビジネスルール違反の一覧確認
- 検証結果のチーム内共有
- 品質管理ドキュメントとしてのアーカイブ
- CI/CDパイプラインでの検証レポート生成

**主要な出力内容**：
1. レポートタイトル（Schematronスキーマのタイトル）
2. パターン別の検証結果セクション
3. アサーション違反の一覧（リンク付き）
4. レポート項目の一覧（条件に合致した項目）
5. 診断情報（diagnosticsが有効な場合）
6. Schematronに関する帰属情報

**帳票の出力タイミング**：XSLTプロセッサを使用してSchematronスキーマとXMLドキュメントを処理する際に生成される。通常、2段階のXSLT変換（スキーマからバリデータ生成、バリデータによる検証）を経て、最終的にHTMLレポートが出力される。

**帳票の利用者**：XMLドキュメント作成者、品質管理担当者、開発者、テスト担当者

## 帳票種別

検証レポート / HTMLドキュメント

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | XSLTプロセッサ | コマンドライン / API | XSLT変換実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | N/A（Webブラウザ表示） |
| 向き | N/A |
| ファイル名 | 任意（XSLTプロセッサの出力設定による） |
| 出力方法 | XSLT変換出力 |
| 文字コード | XSLTプロセッサのデフォルト |

### HTML固有設定

| 項目 | 内容 |
|-----|------|
| 出力メソッド | html（xsl:output method="html"） |
| インラインスタイル | 有（styleタグ内にCSS定義） |

## 帳票レイアウト

### レイアウト概要

HTML形式のレポートとして、ヘッダー、パターン別セクション、フッターの構成で出力される。

```
┌─────────────────────────────────────┐
│       Schematron Report             │
│       (スキーマタイトル)              │
├─────────────────────────────────────┤
│  パターン1: Check structure         │
│  ・アサーション違反1                 │
│  ・アサーション違反2                 │
├─────────────────────────────────────┤
│  パターン2: Check constraints       │
│  ・レポート項目1                     │
├─────────────────────────────────────┤
│       フッター（帰属情報）            │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | アイコン | スキーマアイコン | @icon属性 | img要素 |
| 2 | タイトル | "Schematron Report" | 固定値 | h2要素（ピンク色） |
| 3 | スキーマタイトル | スキーマの名前 | sch:title要素 | h1要素 |

### 明細部（パターンセクション）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | パターン名 | 検証パターンの名前 | @name属性 | h3要素（黒背景白文字） | - |
| 2 | ドキュメントリンク | 関連ドキュメントへのリンク | @see属性 | a要素 | - |

### 明細部（アサーション/レポート項目）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | アイコン | 項目アイコン | @icon属性 | img要素 | - |
| 2 | ロール | 項目の役割 | @role属性 | i要素（イタリック） | - |
| 3 | メッセージ | エラー/レポートメッセージ | テキストノード | テキスト | - |
| 4 | 診断情報 | 追加の診断ヒント | @diagnostics属性 | b要素（太字） | - |
| 5 | リンク | 該当箇所へのリンク | generate-id() | a要素 | - |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 作成者情報 | "Schematron Report by David Carlisle" | 固定値 | テキスト |
| 2 | Schematronリンク | Schematronホームページへのリンク | 固定URL | a要素 |
| 3 | 作者リンク | Rick Jelliffe氏へのメールリンク | 固定URL | a要素 |
| 4 | 組織リンク | Academia Sinicaへのリンク | 固定URL | a要素 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| スキーマ存在 | 有効なSchematronスキーマが存在すること | Yes |
| 検証対象存在 | 検証対象のXMLドキュメントが存在すること | Yes |

### パラメータ

| パラメータ名 | 説明 | デフォルト値 |
|-------------|------|-------------|
| diagnose | 診断情報を出力するか | "yes" |
| phase | 実行するフェーズ | "#ALL"または@defaultPhase |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | パターン | 定義順 |
| 2 | ルール | 定義順 |
| 3 | アサーション/レポート | 定義順 |

### 改ページ条件

N/A（HTML形式のためブラウザの印刷設定に依存）

## データベース参照仕様

### 参照テーブル一覧

N/A（XMLドキュメントとSchematronスキーマを入力として使用）

### 入力XMLデータ参照

#### Schematronスキーマ

| 参照要素 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| sch:schema/@icon | ヘッダーアイコン | 存在する場合 | - |
| sch:schema/@fpi | 正式公開識別子 | 存在する場合 | title属性として使用 |
| sch:title | スキーマタイトル | - | h1見出し |
| sch:pattern/@name | パターン名 | - | h3見出し |
| sch:pattern/@see | ドキュメントリンク | 存在する場合 | リンク先URL |
| sch:assert | アサーション定義 | @test失敗時 | エラー項目 |
| sch:report | レポート定義 | @test成功時 | 情報項目 |
| sch:diagnostic | 診断情報定義 | @diagnostics参照時 | 追加説明 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 項目リンク | generate-id(.) | N/A | XPath関数でユニークIDを生成 |
| パターンモード | "M" + count(preceding-sibling::*) | N/A | XSLT処理用モード名 |
| ルール優先度 | 4000 - count(preceding-sibling::*) | N/A | テンプレート優先度 |

## 処理フロー

### 出力フロー（2段階変換）

```mermaid
flowchart TD
    A[Schematronスキーマ] --> B[skeleton1-5.xsl]
    B --> C[検証用XSLTスタイルシート生成]
    C --> D[schematron-report.xsl]
    D --> E[最終XSLTスタイルシート]

    F[検証対象XMLドキュメント] --> G[XSLTプロセッサ]
    E --> G
    G --> H[HTMLレポート出力]
```

### テンプレート処理フロー

```mermaid
flowchart TD
    A[ルート要素マッチ] --> B[process-root呼び出し]
    B --> C[HTML構造生成]
    C --> D[スタイル定義出力]
    D --> E[ヘッダー出力]
    E --> F[do-all-patternsモード実行]
    F --> G{各パターン処理}
    G --> H[process-pattern呼び出し]
    H --> I[パターン見出し出力]
    I --> J[ルール適用]
    J --> K{assert評価}
    K -->|失敗| L[process-assert呼び出し]
    K -->|成功| M[スキップ]
    J --> N{report評価}
    N -->|成功| O[process-report呼び出し]
    N -->|失敗| P[スキップ]
    L --> Q[エラー項目出力]
    O --> R[レポート項目出力]
    Q --> S[診断情報出力]
    R --> S
    S --> T[フッター出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| マークアップエラー | @test属性なし（assert/report） | "Markup Error: no test attribute in <assert>/<report>" | スキーマを修正 |
| マークアップエラー | @id属性なし（diagnostic） | "Markup Error: no id attribute in <diagnostic>" | スキーマを修正 |
| マークアップエラー | @context属性なし（rule） | "Markup Error: no context attribute in <rule>" | スキーマを修正 |
| 参照エラー | 未定義diagnosticの参照 | "Reference error: A diagnostic ... has been referenced but is not declared" | スキーマを修正 |
| 参照エラー | 未定義abstract ruleの参照 | "Reference Error: the abstract rule ... has been referenced but is not declared" | スキーマを修正 |
| 警告 | 認識できない要素 | "Warning: unrecognized element ..." | 確認して対処 |
| 警告 | 子要素を含むべきでない要素 | "Warning: ... must not contain any child elements" | スキーマを修正 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百のルール/アサーション |
| 目標出力時間 | XSLTプロセッサ依存（通常は秒単位） |
| 同時出力数上限 | N/A（バッチ処理可能） |

## セキュリティ考慮事項

- XSLTスタイルシートの読み込み元を信頼できるソースに限定すること
- 外部エンティティの解決（XXE攻撃）に注意し、XSLTプロセッサの設定を適切に行うこと
- 生成されたHTMLレポートをWebサーバで公開する場合は、XSS対策を考慮すること
- 診断情報にはビジネスロジックの詳細が含まれる可能性があるため、公開範囲に注意すること

## 備考

- 本XSLTスタイルシートはSchematron 1.5仕様に基づいており、一部1.6の拡張機能もサポートする
- 様々なXSLTプロセッサ（MS XML 3, Oracle, SAXON, XT等）での動作が確認されている
- Sablotronはimportをサポートしないため、手動でのスタイルシートマージが必要
- Xalan for Java 2.0は名前空間URIの出力に問題があるため、手動修正が必要な場合がある
- David Carlisle氏のschematron-reportエラーブラウザと連携して動作する

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Schematronスキーマの構造とXSLT名前空間エイリアスの使用方法を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schematron-report.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-report.xsl` | xsl:import、パラメータ定義、名前空間エイリアス（axsl）の使用を理解する |
| 1-2 | skeleton1-5.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/skeleton1-5.xsl` | Schematronの基本スケルトン、各要素のテンプレート定義を理解する |
| 1-3 | TestSchema.xml | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/TestSchema.xml` | Schematronスキーマの実際の構造（pattern, rule, assert）を理解する |

**読解のコツ**: XSLTでは`axsl:`名前空間エイリアスが`xsl:`の出力用エイリアスとして使用されている。これは2段階変換（Schematronスキーマ→検証用XSLT→検証結果）を実現するための技法である。

#### Step 2: エントリーポイントを理解する

HTML出力を生成するテンプレートの起点を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | schematron-report.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-report.xsl` | process-root、process-prolog名前付きテンプレートがHTML構造の起点 |

**主要処理フロー**:
1. **行46-48**: process-prolog - 出力メソッドをHTMLに設定
2. **行50-92**: process-root - HTML全体構造を生成、タイトル、スタイル定義、コンテンツ、フッターを出力
3. **行55-63**: style要素でリンク色とh3のスタイルを定義

#### Step 3: パターン処理を理解する

検証パターンの出力処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | schematron-report.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-report.xsl` | process-pattern（行100-118）でパターン見出しを生成 |

**主要処理フロー**:
- **行104-116**: @see属性がある場合はリンク付きh3要素、ない場合は通常のh3要素を生成
- **行108-110**: リンクは新規ウィンドウ（target="SRDOCO"）で開く

#### Step 4: アサーション/レポート処理を理解する

個々の検証結果項目の出力処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | schematron-report.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-report.xsl` | process-assert（行122-140）、process-report（行142-158）を理解 |

**主要処理フロー**:
- **行127-139**: li要素内にリンク、ロール、メッセージ、診断情報を出力
- **行129**: schematron-out.htmlへのリンクをgenerate-id()で生成
- **行133-136**: diagnose="yes"の場合のみdiagnosticsSplitを呼び出し

#### Step 5: 基本スケルトンの処理を理解する

skeleton1-5.xslの主要なテンプレートを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | skeleton1-5.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/skeleton1-5.xsl` | sch:schema、sch:pattern、sch:rule、sch:assert、sch:reportのテンプレートを理解 |

**主要処理フロー**:
- **行82-134**: sch:schemaテンプレート - 検証用XSLTスタイルシートの骨格を生成
- **行147-164**: sch:assertテンプレート - axsl:choose/when/otherwiseでテスト失敗時の処理を生成
- **行165-179**: sch:reportテンプレート - axsl:ifでテスト成功時の処理を生成
- **行341-354**: sch:ruleテンプレート - コンテキストに対するマッチングとルール処理を生成
- **行446-480**: diagnosticsSplit - 診断ID文字列を分割して各診断を処理

### プログラム呼び出し階層図

```
[XSLTプロセッサ]
    │
    ├─ schematron-report.xsl
    │      │
    │      └─ xsl:import "skeleton1-5.xsl"
    │
    └─ skeleton1-5.xsl
           │
           ├─ sch:schema テンプレート
           │      ├─ process-prolog [schematron-report.xslでオーバーライド]
           │      ├─ process-root [schematron-report.xslでオーバーライド]
           │      └─ do-all-patterns モード
           │             └─ sch:pattern テンプレート
           │                    └─ process-pattern [schematron-report.xslでオーバーライド]
           │
           ├─ sch:rule テンプレート
           │      ├─ process-rule
           │      ├─ sch:assert テンプレート
           │      │      └─ process-assert [schematron-report.xslでオーバーライド]
           │      └─ sch:report テンプレート
           │             └─ process-report [schematron-report.xslでオーバーライド]
           │
           └─ sch:diagnostic テンプレート
                  └─ process-diagnostic
                         └─ diagnosticsSplit
```

### データフロー図

```
[入力]                     [処理]                              [出力]

Schematronスキーマ        skeleton1-5.xsl                    検証用XSLT
(.xml/.sch)                     │                                │
    │                           │                                │
    ├─ sch:schema ────────────▶ スタイルシート構造生成 ───────▶ axsl:stylesheet
    │                           │
    ├─ sch:pattern ───────────▶ パターン処理テンプレート ─────▶ axsl:apply-templates
    │                           │
    ├─ sch:rule ──────────────▶ ルールテンプレート生成 ───────▶ axsl:template match="{@context}"
    │                           │
    ├─ sch:assert ────────────▶ 条件分岐生成 ─────────────────▶ axsl:choose/when/otherwise
    │                           │
    └─ sch:report ────────────▶ 条件出力生成 ─────────────────▶ axsl:if


検証用XSLT +              XSLTプロセッサ                     HTMLレポート
検証対象XML                     │                                │
    │                           │                                │
    └─ 変換実行 ──────────────▶ process-root ─────────────────▶ <html>
                                    │                                │
                                    ├─ スタイル出力 ──────────────▶ <style>
                                    │                                │
                                    ├─ ヘッダー出力 ──────────────▶ <h2>Schematron Report</h2>
                                    │                                │
                                    ├─ タイトル出力 ──────────────▶ <h1>{title}</h1>
                                    │                                │
                                    ├─ パターン処理 ──────────────▶ <h3>{pattern name}</h3>
                                    │                                │
                                    ├─ assert/report出力 ─────────▶ <li><a>...</a></li>
                                    │                                │
                                    └─ フッター出力 ──────────────▶ <p>Schematron Report by...</p>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| schematron-report.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-report.xsl` | XSLT | HTMLレポート生成用のカスタマイズスタイルシート |
| skeleton1-5.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/skeleton1-5.xsl` | XSLT | Schematron 1.5の基本スケルトンスタイルシート |
| schematron-basic.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-basic.xsl` | XSLT | 基本的なテキスト出力用スタイルシート |
| schematron-message.xsl | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-message.xsl` | XSLT | メッセージ出力用スタイルシート |
| TestSchema.xml | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/TestSchema.xml` | XML | テスト用Schematronスキーマ |
| Test1.xml | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/Test1.xml` | XML | テスト用入力XMLドキュメント |
| v1Test1.txt | `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/v1Test1.txt` | テキスト | テスト期待出力 |
