---
generated_at: 2026-01-30 12:55:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-CrashReport_JSON.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **想定データ件数**：具体的な数値の根拠が不明確
  2. **目標出力時間**：要件定義書等での明示的な記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/coreclr/debug/createdump/crashreportwriter.cpp` 行1-414
- E-02: `src/coreclr/debug/createdump/crashreportwriter.h` 行1-48
- E-03: `src/coreclr/debug/createdump/crashinfo.h`
- E-04: `src/coreclr/debug/createdump/threadinfo.h`
- E-05: `src/coreclr/debug/createdump/stackframe.h`
- E-06: `帳票一覧.csv` 行2（No.1 CrashReport定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | protocol_versionは"1.0.0"である | E-01 行59 | ○ |
| C-02 | architectureはコンパイル時マクロで決定される（amd64/arm64/arm） | E-01 行62-68 | ○ |
| C-03 | バージョンはsccsid変数から取得される | E-01 行69-73 | ○ |
| C-04 | process_nameはMainModule()->ModuleName()から取得 | E-01 行77-81 | ○ |
| C-05 | threads配列にスレッド情報が出力される | E-01 行83-176 | ○ |
| C-06 | is_managedフィールドはthread->IsManaged()から取得 | E-01 行136 | ○ |
| C-07 | crashedフィールドはCrashThread()との比較で決定 | E-01 行87-90 | ○ |
| C-08 | managed_exception_objectはManagedExceptionObject()から取得 | E-01 行138-141 | ○ |
| C-09 | managed_exception_typeはManagedExceptionType()から取得 | E-01 行142-145 | ○ |
| C-10 | managed_exception_hresultはManagedExceptionHResult()から取得 | E-01 行146-149 | ○ |
| C-11 | native_thread_idはTid()から取得 | E-01 行150 | ○ |
| C-12 | ctx.IP/SP/BPはGetInstructionPointer/StackPointer/FramePointerから取得 | E-01 行151-155 | ○ |
| C-13 | stack_framesはStackFrames()から取得 | E-01 行157-173 | ○ |
| C-14 | ExceptionTypeはシグナル番号から変換される | E-01 行97-134 | ○ |
| C-15 | SIGILLは0x50000000に変換 | E-01 行102-103 | ○ |
| C-16 | SIGFPEは0x70000000に変換 | E-01 行105-106 | ○ |
| C-17 | SIGBUSは0x60000000に変換 | E-01 行108-109 | ○ |
| C-18 | SIGTRAPは0x03000000に変換 | E-01 行111-112 | ○ |
| C-19 | SIGSEGVは0x20000000に変換 | E-01 行114-115 | ○ |
| C-20 | SIGTERMは0x02000000に変換 | E-01 行117-118 | ○ |
| C-21 | SIGABRTは0x30000000に変換 | E-01 行120-121 | ○ |
| C-22 | macOSではOSVersion, SystemModel, SystemManufacturerが出力される | E-01 行183-187 | ○ |
| C-23 | ファイル名は{dumpFileName}.crashreport.jsonである | E-01 行34-35 | ○ |
| C-24 | JSONインデントは1スペースである | E-02 行6 (JSON_INDENT_VALUE=1) | ○ |
| C-25 | ファイルオープン失敗時のエラーメッセージ | E-01 行276 | ○ |
| C-26 | 書き込み失敗時は部分ファイルを削除する | E-01 行51 | ○ |
| C-27 | 想定データ件数は数十スレッド、各スレッド数百フレーム | **根拠なし** | △ |
| C-28 | 目標出力時間は数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **想定データ件数・目標出力時間**：パフォーマンス要件に関する記載は、ソースコード内のコメントや設計書から明示的な根拠を見つけることができなかった
  - 候補：要件定義書 / 性能設計書 / テスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 本帳票の主要な技術的仕様はソースコードから直接確認可能
- 1（中リスク）: パフォーマンス要件は推定値であり、実環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（C-27, C-28）について、実環境での実測値を確認する
- [ ] macOS以外のプラットフォーム（Linux等）での動作確認を行う
- [ ] JSON出力形式が解析ツール（Visual Studio等）と互換性があることを確認する
- [ ] セキュリティ考慮事項について、運用チームと認識を合わせる
