---
generated_at: 2026-01-30 12:58:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：2-EventReport.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **目標出力時間「ミリ秒オーダー」**：具体的な計測値の根拠なし
  2. **リソース文字列のデフォルト値一部**：一部のデフォルト値はコード上のフォールバック値から推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/coreclr/vm/eventreporter.cpp` 行1-696
- E-02: `src/coreclr/vm/eventreporter.h` 行1-68
- E-03: `src/coreclr/nativeaot/System.Private.CoreLib/src/System/EventReporter.cs` 行1-191
- E-04: `帳票一覧.csv` 行3（No.2 EventReport定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントソースは".NET Runtime"である | E-01 行410, E-03 行148 | ○ |
| C-02 | イベントタイプはEVENTLOG_ERROR_TYPEである | E-01 行411, E-03 行149 | ○ |
| C-03 | 最大エントリサイズは31842バイト（0x7C62）である | E-02 行22, E-03 行91 | ○ |
| C-04 | ERT_UnhandledExceptionのイベントIDは1026である | E-01 行382-383 | ○ |
| C-05 | ERT_ManagedFailFastのイベントIDは1025である | E-01 行384-385 | ○ |
| C-06 | ERT_UnmanagedFailFastのイベントIDは1023である | E-01 行386-387 | ○ |
| C-07 | ERT_StackOverflowのイベントIDは1027である | E-01 行388-389 | ○ |
| C-08 | ERT_CodeContractFailedのイベントIDは1028である | E-01 行390-391 | ○ |
| C-09 | アプリケーション名はWszGetModuleFileNameから取得 | E-01 行44-46 | ○ |
| C-10 | CoreCLRバージョンはVER_FILEVERSION_STR_Lから取得 | E-01 行88 | ○ |
| C-11 | .NETバージョンはCLR_PRODUCT_VERSION_Lから取得 | E-01 行92 | ○ |
| C-12 | 未処理例外の説明文は定義されたリソースから取得 | E-01 行98-106 | ○ |
| C-13 | ManagedFailFastの説明文は定義されたリソースから取得 | E-01 行108-116 | ○ |
| C-14 | UnmanagedFailFastの説明文は定義されたリソースから取得 | E-01 行118-125 | ○ |
| C-15 | StackOverflowの説明文は定義されたリソースから取得 | E-01 行127-136 | ○ |
| C-16 | CodeContractFailedの説明文は定義されたリソースから取得 | E-01 行138-146 | ○ |
| C-17 | デバッガアタッチ時は出力がスキップされる | E-01 行466-475, E-03 行180-181 | ○ |
| C-18 | 同一プロセスで2回目以降は出力がスキップされる | E-01 行477-481, E-03 行183-184 | ○ |
| C-19 | logFatalError設定が0の場合は出力がスキップされる | E-01 行483-486 | ○ |
| C-20 | バッファ超過時は切り詰め処理が行われる | E-01 行287-322, E-03 行99-119 | ○ |
| C-21 | 切り詰めメッセージは"The remainder of the message was truncated."である | E-01 行292-294, E-03 行102 | ○ |
| C-22 | AddStackTraceでスタックフレームが追加される | E-01 行273-324 | ○ |
| C-23 | BeginStackTraceで"Stack:"ラベルが追加される | E-01 行243-261, E-03 行82-83 | ○ |
| C-24 | スタックフレームは"   at"プレフィックス付きで出力される | E-01 行549-557 | ○ |
| C-25 | TypeString::AppendMethodInternalでメソッドシグネチャを取得 | E-01 行528 | ○ |
| C-26 | イベントログ破損エラーはログ出力のみ | E-01 行423-438 | ○ |
| C-27 | イベントログ満杯エラーはログ出力のみ | E-01 行423-438 | ○ |
| C-28 | メモリ不足エラーはログ出力のみ | E-01 行423-438 | ○ |
| C-29 | NativeAOT版ではRhFailFastReasonを使用 | E-03 行14, 42-58 | ○ |
| C-30 | NativeAOT版ではInterop.Advapi32.ReportEventを使用 | E-03 行157-171 | ○ |
| C-31 | 目標出力時間はミリ秒オーダー | **根拠なし** | △ |
| C-32 | 一部リソース文字列のデフォルト値 | **コードのフォールバック値から推測** | △ |

## 4) 不足情報（Unknown / Missing）
- **目標出力時間**：パフォーマンス要件に関する明示的な記載がなく、Windows Event Log APIの一般的な性能から推測した
  - 候補：Windowsドキュメント / 性能テスト結果 / 要件定義書
- **リソース文字列**：mscorrc.dllのリソースファイル自体を直接参照できていないため、一部のデフォルト値はコード内のフォールバック文字列から推測
  - 候補：`src/coreclr/dlls/mscorrc/` 配下のリソースファイル

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 本帳票の主要な技術的仕様はソースコードから直接確認可能
- 0（低リスク）: CoreCLR版とNativeAOT版の両方の実装を確認済み
- 1（中リスク）: リソース文字列の完全な一覧は別途リソースファイルの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] リソース文字列（IDS_ER_*）の実際の値を`src/coreclr/dlls/mscorrc/`で確認する
- [ ] イベントログへの出力が実際に動作することを実環境で確認する
- [ ] NativeAOT版とCoreCLR版の動作の差異を確認する（RhFailFastReason vs EventReporterType）
- [ ] イベントビューアでの表示形式を実際に確認する
- [ ] logFatalError設定の変更方法とデフォルト値を確認する
