---
generated_at: 2026-01-30 13:02:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：3-SchematronReport_HTML.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **目標出力時間**：XSLTプロセッサ依存のため具体的な数値根拠なし
  2. **対応XSLTプロセッサの動作確認状況**：コード内コメントからの情報であり、現在の状況は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/schematron-report.xsl` 行1-161
- E-02: `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/skeleton1-5.xsl` 行1-557
- E-03: `src/libraries/System.Private.Xml/tests/Xslt/TestFiles/TestData/XsltScenarios/Schematron/TestSchema.xml` 行1-15
- E-04: `帳票一覧.csv` 行4（No.3 SchematronReport定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力メソッドはhtmlである | E-01 行47 (axsl:output method="html") | ○ |
| C-02 | diagnoseパラメータのデフォルト値は"yes"である | E-01 行44 | ○ |
| C-03 | phaseパラメータのデフォルト値は"#ALL"またはdefaultPhaseである | E-02 行71-78 | ○ |
| C-04 | ヘッダーには"Schematron Report"が表示される | E-01 行67-68 | ○ |
| C-05 | スキーマタイトルはsch:titleから取得される | E-01 行69-71 | ○ |
| C-06 | リンクの色は定義されている（black/gray/#FF0088） | E-01 行56-58 | ○ |
| C-07 | h3要素は黒背景白文字で表示される | E-01 行59-62 | ○ |
| C-08 | パターン見出しは@see属性がある場合リンク付きになる | E-01 行104-116 | ○ |
| C-09 | リンクはtarget="SRDOCO"で新規ウィンドウに開く | E-01 行106 | ○ |
| C-10 | アサーション項目はli要素で出力される | E-01 行127-139 | ○ |
| C-11 | レポート項目はli要素で出力される | E-01 行147-157 | ○ |
| C-12 | 診断情報はdiagnose="yes"の場合のみ出力される | E-01 行133-136 | ○ |
| C-13 | リンク先はschematron-out.html#generate-id()である | E-01 行129, 149 | ○ |
| C-14 | フッターにDavid Carlisleの名前が表示される | E-01 行78 | ○ |
| C-15 | Schematronホームページへのリンクが含まれる | E-01 行79-82 | ○ |
| C-16 | Rick Jelliffe氏へのメールリンクが含まれる | E-01 行84-86 | ○ |
| C-17 | Academia Sinicaへのリンクが含まれる | E-01 行87-89 | ○ |
| C-18 | sch:assertは@test失敗時にprocess-assertを呼び出す | E-02 行147-164 | ○ |
| C-19 | sch:reportは@test成功時にprocess-reportを呼び出す | E-02 行165-179 | ○ |
| C-20 | @test属性がない場合はマークアップエラーメッセージを出力 | E-02 行148-150, 166-168 | ○ |
| C-21 | @id属性がないdiagnosticはマークアップエラーメッセージを出力 | E-02 行184-186 | ○ |
| C-22 | @context属性がないruleはマークアップエラーメッセージを出力 | E-02 行342-344 | ○ |
| C-23 | 未定義のdiagnostic参照は参照エラーメッセージを出力 | E-02 行465-467 | ○ |
| C-24 | 認識できない要素は警告メッセージを出力 | E-02 行485-496 | ○ |
| C-25 | パターンモードは"M" + preceding-sibling数で生成される | E-02 行318, 327, 345, 352 | ○ |
| C-26 | ルール優先度は4000 - preceding-sibling数で決定される | E-02 行345 | ○ |
| C-27 | diagnosticsSplitテンプレートで診断IDを分割処理する | E-02 行446-480 | ○ |
| C-28 | Schematron 1.5仕様に基づいている | E-02 行2-3, 26-33 (コメント) | ○ |
| C-29 | 目標出力時間はXSLTプロセッサ依存 | **根拠なし** | △ |
| C-30 | 対応XSLTプロセッサ一覧（MS XML 3, Oracle, SAXON等） | E-02 行40-57 (コメント、現在の動作未確認) | △ |

## 4) 不足情報（Unknown / Missing）
- **目標出力時間**：パフォーマンス要件に関する明示的な記載がなく、XSLTプロセッサの性能に依存するため具体値を示せない
  - 候補：各XSLTプロセッサのベンチマーク資料 / 実測テスト結果
- **対応XSLTプロセッサの現在の動作状況**：コード内のコメント（2001年時点）に記載があるが、現在のバージョンでの動作確認は未実施
  - 候補：.NET Framework / .NET Core / .NET 5+でのXsltCompiledTransformでの動作確認

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: XSLTスタイルシートの構造と処理フローはコードから直接確認可能
- 1（中リスク）: 古いXSLTスタイルシート（2001年版）であり、現在の.NET環境での互換性確認が必要
- 1（中リスク）: schematron-out.htmlへのリンクが存在することを前提としており、実際の運用では別途生成が必要

## 6) レビュアーチェックリスト（最小）
- [ ] .NET環境（XsltCompiledTransform）での実際の動作確認を行う
- [ ] schematron-out.htmlの生成方法と連携を確認する
- [ ] 診断情報（diagnostics）機能の動作確認を行う
- [ ] 各種XSLTプロセッサでの出力結果の差異を確認する
- [ ] Schematron 1.5と現在のSchematron ISO標準との差異を確認する
- [ ] セキュリティ（XXE攻撃対策、XSS対策）の観点でXSLTプロセッサの設定を確認する
