---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **BR-019 スレッド管理**：設計書リンク未確認（BOTR threading.md参照必要）
  2. **BR-029 例外処理**：設計書リンク未確認（BOTR exceptions.md参照必要）
  3. **BR-040 ランタイム構成**：具体的な設定項目一覧の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/design/features/tiered-compilation.md`
- E-02: `docs/design/features/DynamicPgo.md`
- E-03: `docs/design/features/assemblyloadcontext.md`
- E-04: `docs/design/features/unloadability.md`
- E-05: `docs/design/features/host-components.md`
- E-06: `docs/design/features/framework-version-resolution.md`
- E-07: `docs/design/features/host-startup-hook.md`
- E-08: `docs/design/features/native-hosting.md`
- E-09: `docs/design/features/globalization-invariant-mode.md`
- E-10: `docs/design/features/event-counter.md`
- E-11: `docs/design/features/COM-activation.md`
- E-12: `docs/design/features/IJW-activation.md`
- E-13: `docs/design/features/covariant-return-methods.md`
- E-14: `docs/design/features/hw-intrinsics.md`
- E-15: `docs/design/features/OnStackReplacement.md`
- E-16: `docs/design/features/StringDeduplication.md`
- E-17: `docs/design/features/PinnedHeap.md`
- E-18: `docs/design/features/cet-feature.md`
- E-19: `docs/design/features/host-tracing.md`
- E-20: `docs/design/coreclr/botr/README.md`
- E-21: `docs/design/coreclr/botr/garbage-collection.md`
- E-22: `docs/design/security/System.HashCode.md`
- E-23: `src/coreclr/jit/` (JITコンパイラ実装)
- E-24: `src/coreclr/gc/` (GC実装)
- E-25: `src/coreclr/vm/tieredcompilation.cpp`
- E-26: `src/tasks/Crossgen2Tasks/`
- E-27: `src/tasks/WasmAppBuilder/`
- E-28: `src/tasks/AppleAppBuilder/`
- E-29: `src/tasks/AndroidAppBuilder/`
- E-30: `src/libraries/Microsoft.Extensions.*/`
- E-31: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 JITコンパイル | E-23 | ○ |
| C-02 | BR-002 段階的コンパイル | E-01, E-25 | ○ |
| C-03 | BR-003 事前コンパイル（ReadyToRun） | E-26 | ○ |
| C-04 | BR-004 動的PGO | E-02 | ○ |
| C-05 | BR-005 ガベージコレクション | E-21, E-24 | ○ |
| C-06 | BR-006 世代別GC | E-21 | ○ |
| C-07 | BR-007 大規模オブジェクトヒープ管理 | E-21 | ○ |
| C-08 | BR-008 ピン留めオブジェクトヒープ | E-17 | ○ |
| C-09 | BR-009 アセンブリロードコンテキスト | E-03 | ○ |
| C-10 | BR-010 アセンブリアンロード | E-04 | ○ |
| C-11 | BR-011 アセンブリ依存関係解決 | E-05 | ○ |
| C-12 | BR-012 ランタイムホスト | E-05 | ○ |
| C-13 | BR-013 フレームワークバージョン解決 | E-06 | ○ |
| C-14 | BR-014 スタートアップフック | E-07 | ○ |
| C-15 | BR-015 ネイティブホスティング | E-08 | ○ |
| C-16 | BR-016 型ローダー | E-20 | ○ |
| C-17 | BR-017 共変戻り値型 | E-13 | ○ |
| C-18 | BR-018 既定インターフェースメソッド | E-20 | ○ |
| C-19 | BR-019 スレッド管理 | **根拠なし** | △ |
| C-20 | BR-020 スレッドプール | E-30 | ○ |
| C-21 | BR-021 P/Invoke | E-27 | ○ |
| C-22 | BR-022 COMインターオペラビリティ | E-11 | ○ |
| C-23 | BR-023 IJW | E-12 | ○ |
| C-24 | BR-024 国際化対応 | E-30 | ○ |
| C-25 | BR-025 グローバリゼーションインバリアントモード | E-09 | ○ |
| C-26 | BR-026 タイムゾーン処理 | E-09 | ○ |
| C-27 | BR-027 イベントカウンター | E-10 | ○ |
| C-28 | BR-028 プロファイリング | E-20 | ○ |
| C-29 | BR-029 例外処理 | **根拠なし** | △ |
| C-30 | BR-030 デバッグサポート | E-20 | ○ |
| C-31 | BR-031 WASM/WASIサポート | E-27 | ○ |
| C-32 | BR-032 Webcilフォーマット | E-27 | ○ |
| C-33 | BR-033 iOSサポート | E-28 | ○ |
| C-34 | BR-034 Androidサポート | E-29 | ○ |
| C-35 | BR-035 ハードウェア組み込み関数 | E-14 | ○ |
| C-36 | BR-036 On-Stack Replacement | E-15 | ○ |
| C-37 | BR-037 文字列重複排除 | E-16 | ○ |
| C-38 | BR-038 ハッシュコードセキュリティ | E-22 | ○ |
| C-39 | BR-039 制御フロー強制技術 | E-18 | ○ |
| C-40 | BR-040 ランタイム構成 | **根拠なし** | △ |
| C-41 | BR-041 依存関係注入 | E-30 | ○ |
| C-42 | BR-042 構成システム | E-30 | ○ |
| C-43 | BR-043 ロギングフレームワーク | E-30 | ○ |
| C-44 | BR-044 ホストトレーシング | E-19 | ○ |
| C-45 | BR-045 メモリキャッシュ | E-30 | ○ |

## 4) 不足情報（Unknown / Missing）
- BR-019（スレッド管理）：`docs/design/coreclr/botr/threading.md` の内容を直接確認できず
  - 候補：BOTR threading.md / src/coreclr/vm/threads.cpp / 公式ドキュメント
- BR-029（例外処理）：`docs/design/coreclr/botr/exceptions.md` の内容を直接確認できず
  - 候補：BOTR exceptions.md / src/coreclr/vm/exceptionhandling.cpp / 公式ドキュメント
- BR-040（ランタイム構成）：runtimeconfig.jsonの完全な設定項目一覧がない
  - 候補：公式ドキュメント / 各機能の設計書 / サンプルファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の要件に明確な設計ドキュメントまたはソースコード根拠あり
- 1: 中リスク - BOTRドキュメントの直接確認が必要な項目が3件存在
- 0: 低リスク - .NET Runtimeは公開プロジェクトであり、参照ドキュメントの信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] BR-019（スレッド管理）の実装詳細を `docs/design/coreclr/botr/threading.md` で確認
- [ ] BR-029（例外処理）の実装詳細を `docs/design/coreclr/botr/exceptions.md` で確認
- [ ] 優先度「高」の要件が実際のプロジェクト要求と一致しているか確認
- [ ] カテゴリ分類が組織の要件管理体系と整合しているか確認
- [ ] 「関連機能」列の参照先が正確かスポットチェック実施
