---
generated_at: 2026-01-30 11:30:00
metrics:
  claims_total: 62
  claims_with_evidence: 60
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：60 / 62、根拠なし：2
- 優先レビュー（高）
  1. **WASI Workload**：ワークロード定義の詳細根拠が不足
  2. **WebAssembly Workload**：ワークロード構成の詳細根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/README.md`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/coreclr/` ディレクトリ構造
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/mono/` ディレクトリ構造
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/` ディレクトリ一覧
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/tasks/` ディレクトリ構造
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/native/` ディレクトリ構造
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/tools/` ディレクトリ構造
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/installer/` ディレクトリ構造
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/workloads/` ディレクトリ構造
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/coreclr/jit/` ディレクトリ（JIT実装）
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/coreclr/gc/` ディレクトリ（GC実装）
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/coreclr/interpreter/` ディレクトリ
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/coreclr/nativeaot/` ディレクトリ
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/tasks/WasmAppBuilder/` ディレクトリ
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/tasks/AotCompilerTask/MonoAOTCompiler.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/tasks/Crossgen2Tasks/` ディレクトリ
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/tasks/AndroidAppBuilder/` ディレクトリ
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/tasks/AppleAppBuilder/` ディレクトリ
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/native/corehost/` ディレクトリ
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/native/eventpipe/` ディレクトリ
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/tools/illink/` ディレクトリ
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/coreclr/ilasm/` ディレクトリ
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/coreclr/ildasm/` ディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CoreCLR - Windows/Linux/macOS向けの高性能.NETランタイム実装 | E-01, E-02 | ○ |
| C-02 | Mono - クロスプラットフォーム対応の.NETランタイム実装 | E-01, E-03 | ○ |
| C-03 | NativeAOT - ネイティブコードへの事前コンパイル機能 | E-13 | ○ |
| C-04 | JITコンパイラ - Just-In-Timeコンパイラ | E-10 | ○ |
| C-05 | ガベージコレクター - 自動メモリ管理機能 | E-11 | ○ |
| C-06 | インタープリター - ILインタープリター | E-12 | ○ |
| C-07 | System.Collections - コレクション型 | E-04 | ○ |
| C-08 | System.Collections.Concurrent - 並行処理用コレクション | E-04 | ○ |
| C-09 | System.Collections.Immutable - イミュータブルコレクション | E-04 | ○ |
| C-10 | System.Text.Json - JSON処理 | E-04 | ○ |
| C-11 | System.Text.RegularExpressions - 正規表現 | E-04 | ○ |
| C-12 | System.Linq - 統合言語クエリ | E-04 | ○ |
| C-13 | System.Net.Http - HTTP通信 | E-04 | ○ |
| C-14 | System.Net.WebSockets - WebSocket通信 | E-04 | ○ |
| C-15 | System.Net.Sockets - ソケット通信 | E-04 | ○ |
| C-16 | System.Security.Cryptography - 暗号化 | E-04 | ○ |
| C-17 | System.IO.FileSystem - ファイルシステム | E-04 | ○ |
| C-18 | System.IO.Compression - 圧縮 | E-04 | ○ |
| C-19 | System.IO.Pipes - パイプ通信 | E-04 | ○ |
| C-20 | System.Threading - スレッディング | E-04 | ○ |
| C-21 | System.Threading.Channels - チャネル | E-04 | ○ |
| C-22 | System.Threading.Tasks.Dataflow - データフロー | E-04 | ○ |
| C-23 | System.Numerics.Tensors - テンソル | E-04 | ○ |
| C-24 | System.Reflection.Emit - 動的コード生成 | E-04 | ○ |
| C-25 | System.Reflection.Metadata - メタデータ読み取り | E-04 | ○ |
| C-26 | System.Data.Common - データアクセス基盤 | E-04 | ○ |
| C-27 | System.Diagnostics.Process - プロセス管理 | E-04 | ○ |
| C-28 | System.Diagnostics.DiagnosticSource - 診断 | E-04 | ○ |
| C-29 | System.Xml.XDocument - XML処理 | E-04 | ○ |
| C-30 | System.Xml.XmlSerializer - XMLシリアライズ | E-04 | ○ |
| C-31 | Microsoft.Extensions.DependencyInjection - 依存性注入 | E-04 | ○ |
| C-32 | Microsoft.Extensions.Configuration - 構成管理 | E-04 | ○ |
| C-33 | Microsoft.Extensions.Logging - ロギング | E-04 | ○ |
| C-34 | Microsoft.Extensions.Hosting - ホスティング | E-04 | ○ |
| C-35 | Microsoft.Extensions.Caching.Memory - メモリキャッシュ | E-04 | ○ |
| C-36 | Microsoft.Extensions.Http - HttpClientファクトリ | E-04 | ○ |
| C-37 | Microsoft.Extensions.Options - オプションパターン | E-04 | ○ |
| C-38 | Microsoft.Extensions.FileProviders.Physical - 物理ファイルプロバイダ | E-04 | ○ |
| C-39 | Microsoft.Extensions.FileSystemGlobbing - Globパターン | E-04 | ○ |
| C-40 | WasmAppBuilder - WebAssemblyアプリビルド | E-14 | ○ |
| C-41 | MonoAOTCompiler - Mono AOTコンパイル | E-15 | ○ |
| C-42 | Crossgen2Tasks - ReadyToRun生成 | E-16 | ○ |
| C-43 | AndroidAppBuilder - Androidアプリビルド | E-17 | ○ |
| C-44 | AppleAppBuilder - Apple(iOS/macOS)アプリビルド | E-18 | ○ |
| C-45 | WebcilConverter - DLLをWebcil形式に変換 | E-14 | ○ |
| C-46 | ILStrip - アセンブリからILを除去 | E-05 | ○ |
| C-47 | PInvokeTableGenerator - ネイティブ呼び出しテーブル生成 | E-14 | ○ |
| C-48 | corehost - ホストプログラム | E-19 | ○ |
| C-49 | eventpipe - イベントパイプ | E-20 | ○ |
| C-50 | containers - コンテナサポート | E-06 | ○ |
| C-51 | minipal - ミニPAL | E-06 | ○ |
| C-52 | ilasm - ILアセンブラ | E-22 | ○ |
| C-53 | ildasm - IL逆アセンブラ | E-23 | ○ |
| C-54 | illink - ILリンカー | E-21 | ○ |
| C-55 | StressLogAnalyzer - ストレスログ解析 | E-07 | ○ |
| C-56 | SharedFramework - 共有フレームワーク | E-08 | ○ |
| C-57 | HostFxr - フレームワーク解決ロジック | E-19 | ○ |
| C-58 | HostPolicy - アセンブリ読み込みポリシー | E-19 | ○ |
| C-59 | WebAssembly Workload - WebAssemblyワークロード | E-09 | ○ |
| C-60 | iOS Workload - iOSワークロード | E-09, E-18 | ○ |
| C-61 | Android Workload - Androidワークロード | E-09, E-17 | ○ |
| C-62 | WASI Workload - WASIワークロード | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **WASI Workload の詳細仕様**：`src/workloads/` 内にWASI固有のワークロード定義ファイルの確認が不十分
  - 候補：`src/mono/wasi/` ディレクトリ / ワークロードマニフェスト / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: ランタイムエンジン機能（C-01〜C-06） - ソースコードディレクトリで明確に確認
- **0 (低リスク)**: 基本クラスライブラリ（C-07〜C-30） - `src/libraries/` 内で全て確認
- **0 (低リスク)**: 拡張ライブラリ（C-31〜C-39） - Microsoft.Extensions.* として存在確認
- **0 (低リスク)**: ビルドタスク（C-40〜C-47） - `src/tasks/` 内で確認
- **0 (低リスク)**: ネイティブコンポーネント（C-48〜C-51） - `src/native/` 内で確認
- **0 (低リスク)**: ツール（C-52〜C-55） - ソースディレクトリで確認
- **0 (低リスク)**: インストーラ（C-56〜C-58） - `src/installer/` および `src/native/corehost/` で確認
- **1 (中リスク)**: ワークロード（C-59〜C-62） - 概念レベルでの存在確認のみ、詳細マニフェストの精査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各カテゴリの機能が網羅的であるか確認
- [ ] 機能名と説明の対応が正確であるか確認
- [ ] 備考欄の補足情報が適切であるか確認
- [ ] ワークロード機能の詳細を公式ドキュメントと照合
- [ ] 新規追加された機能（最新バージョン固有）が漏れていないか確認
