# 機能設計書 1-CoreCLR

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるCoreCLR（Core Common Language Runtime）の機能設計について記述する。CoreCLRはWindows、Linux、macOS向けの高性能.NETランタイム実装であり、JITコンパイラ、ガベージコレクター、仮想マシン、メタデータ処理等の基盤機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：CoreCLRは、.NETアプリケーションを実行するための基盤となるランタイムエンジンである。マネージドコード（C#、F#、VB.NET等で記述されたコード）を安全かつ効率的に実行するための環境を提供し、メモリ管理、型安全性、例外処理、スレッド管理等の複雑な処理を抽象化することで、開発者の生産性向上と高品質なアプリケーション開発を実現する。

**機能の利用シーン**：サーバーサイドアプリケーション、デスクトップアプリケーション、コンソールアプリケーション、マイクロサービス、クラウドネイティブアプリケーション等、あらゆる.NETアプリケーションの実行時に利用される。特にWindowsサーバー、Linuxコンテナ環境、Azure Functions等のクラウド環境での実行に最適化されている。

**主要な処理内容**：
1. EEStartup（Execution Engine Startup）によるランタイムの初期化
2. JITコンパイラによるILコードからネイティブコードへの変換
3. ガベージコレクターによる自動メモリ管理
4. 型システムの管理とメタデータの処理
5. 例外処理機構の提供
6. スレッド管理と同期プリミティブの提供
7. P/Invokeおよび相互運用性のサポート

**関連システム・外部連携**：
- ホストプログラム（dotnet.exe、カスタムホスト）との連携
- ネイティブライブラリとのP/Invoke連携
- COM相互運用（Windows環境）
- 診断ツール（プロファイラー、デバッガー）との連携

**権限による制御**：
- フルトラスト/パーシャルトラストによるコードアクセスセキュリティ
- アセンブリの署名検証
- ネイティブコード実行権限の制御

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CoreCLRは画面を持たないランタイムエンジンのため該当なし |

## 機能種別

計算処理 / システム基盤機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| IL Assembly | バイナリ | Yes | 実行対象のマネージドアセンブリ（.dll/.exe） | PE形式、メタデータ検証 |
| RuntimeConfig | JSON | No | ランタイム構成設定（.runtimeconfig.json） | JSON形式検証 |
| Environment Variables | 文字列 | No | 環境変数によるランタイム設定 | 設定値の型検証 |

### 入力データソース

- ファイルシステム上のアセンブリファイル
- 環境変数（DOTNET_*, COMPlus_*）
- ランタイム構成ファイル（*.runtimeconfig.json）
- ホストからのAPI呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行結果 | int | アプリケーションの終了コード |
| 標準出力 | Stream | Console.Write等による出力 |
| 標準エラー | Stream | 例外情報、エラーメッセージ |
| 診断イベント | EventPipe | プロファイリング・トレース情報 |

### 出力先

- プロセス終了コード
- 標準出力/標準エラーストリーム
- ETW（Event Tracing for Windows）/LTTng
- EventPipeによる診断出力

## 処理フロー

### 処理シーケンス

```
1. EnsureEEStarted()の呼び出し
   └─ ランタイム初期化の開始判定
2. EEStartup()の実行
   └─ 実行エンジンの初期化
3. InitializeGarbageCollector()
   └─ GCの初期化とヒープの確保
4. InitializeDebugger()（デバッグビルド時）
   └─ デバッガーインターフェースの初期化
5. AppDomainの作成
   └─ デフォルトAppDomainの初期化
6. アセンブリのロード
   └─ メインアセンブリとその依存関係の解決
7. Main()メソッドの実行
   └─ JITコンパイルとネイティブコード実行
8. EEShutDown()
   └─ ファイナライザー実行とリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[ホストからの起動要求] --> B{EE初期化済み?}
    B -->|No| C[EEStartup]
    B -->|Yes| G[アセンブリロード]
    C --> D[GC初期化]
    D --> E[スレッドプール初期化]
    E --> F[AppDomain作成]
    F --> G
    G --> H[エントリーポイント特定]
    H --> I[JITコンパイル]
    I --> J[ネイティブコード実行]
    J --> K{例外発生?}
    K -->|Yes| L[例外処理]
    K -->|No| M[正常終了]
    L --> M
    M --> N[EEShutDown]
    N --> O[プロセス終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | シングルトン初期化 | ランタイムはプロセスあたり1回のみ初期化される | EEStartup呼び出し時 |
| BR-02 | スレッドセーフ初期化 | 複数スレッドからの同時初期化要求を適切に処理 | マルチスレッド環境 |
| BR-03 | 順序付きシャットダウン | ファイナライザー→GC→ネイティブリソースの順で解放 | EEShutDown時 |

### 計算ロジック

- メモリアロケーション：世代別ヒープによる効率的なメモリ管理
- JITコンパイル：ILからネイティブコードへの変換とインライン展開最適化
- GCトリガー：世代別しきい値に基づくガベージコレクション実行判定

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | CoreCLRはデータベースを直接操作しない |

### テーブル別操作詳細

CoreCLRはランタイムエンジンであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| HRESULT_E_FAIL | 初期化失敗 | メモリ不足、設定エラー | ログ確認、リソース増強 |
| TypeLoadException | 型ロード失敗 | 依存アセンブリ不足 | 依存関係の確認 |
| OutOfMemoryException | メモリ不足 | ヒープ枯渇 | メモリリーク調査 |
| StackOverflowException | スタックオーバーフロー | 無限再帰等 | コード修正 |

### リトライ仕様

- ランタイム初期化失敗時：リトライなし（致命的エラー）
- アセンブリロード失敗時：構成に基づくフォールバック検索

## トランザクション仕様

CoreCLRはトランザクション管理を直接提供しないが、System.TransactionsやADO.NETを通じたトランザクションサポートの基盤を提供する。

## パフォーマンス要件

- JITコンパイル：ホットパスのTiered Compilationによる最適化
- GC：バックグラウンドGCによるSTW（Stop-The-World）時間の最小化
- 起動時間：ReadyToRun（R2R）イメージによる起動高速化

## セキュリティ考慮事項

- Type Safety：型システムによるメモリ安全性の保証
- Code Access Security：アセンブリの信頼性検証
- ASLR/DEP：ネイティブセキュリティ機構との統合
- Stack Overflow Protection：スタックオーバーフロー検出と安全な終了

## 備考

- CoreCLRはオープンソースであり、MITライセンスで公開されている
- .NET 5以降、CoreCLRは.NETの標準ランタイムとなっている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ランタイムの主要なデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | corhdr.h | `src/coreclr/inc/corhdr.h` | マネージドヘッダー構造、メタデータ形式 |
| 1-2 | threads.h | `src/coreclr/vm/threads.h` | Thread構造体、協調モード/プリエンプティブモード |
| 1-3 | object.h | `src/coreclr/vm/object.h` | GCヒープ上のオブジェクト表現 |

**読解のコツ**: C++マクロが多用されているため、まず`common.h`で定義されるマクロを確認すると理解が進む。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ceemain.cpp | `src/coreclr/vm/ceemain.cpp` | EEStartup()、EEShutDown()の実装 |

**主要処理フロー**:
1. **211行目**: `HRESULT EEStartup();` - ランタイム初期化のエントリーポイント宣言
2. **214行目**: `static void InitializeGarbageCollector();` - GC初期化関数宣言
3. **232-238行目**: グローバル状態変数（g_EEStartupStatus、g_fEEStarted）の定義
4. **246行目**: `static DangerousNonHostedSpinLock g_EEStartupLock;` - 初期化の排他制御

#### Step 3: 仮想マシン（VM）層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | method.hpp | `src/coreclr/vm/method.hpp` | MethodDesc - メソッドの内部表現 |
| 3-2 | clsload.hpp | `src/coreclr/vm/clsload.hpp` | ClassLoader - 型ロードの仕組み |
| 3-3 | codeman.h | `src/coreclr/vm/codeman.h` | コードマネージャー - JIT管理 |

**主要処理フロー**:
- MethodDescはメソッドのJIT状態、ネイティブコードアドレスを保持
- ClassLoaderは型定義からMethodTable/EEClassを構築

#### Step 4: ガベージコレクターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gc.h | `src/coreclr/gc/gc.h` | GCの公開インターフェース |
| 4-2 | gcinterface.h | `src/coreclr/gc/gcinterface.h` | IGCHeapインターフェース |

**主要処理フロー**:
- **gc.h 60-80行目**: `enum gc_reason` - GCトリガー理由の定義
- **gc.h 84-88行目**: `enum gc_etw_type` - GCタイプ（NGC/BGC/FGC）

### プログラム呼び出し階層図

```
ホストプログラム (dotnet.exe / coreclr_initialize)
    │
    ├─ EnsureEEStarted() [ceemain.cpp]
    │      └─ EEStartup() [ceemain.cpp]
    │             ├─ InitializeGarbageCollector()
    │             │      └─ GCHeapUtilities::CreateGCHeap()
    │             ├─ InitializeDebugger()
    │             └─ SystemDomain::Attach()
    │
    ├─ AssemblyLoader [assembly.cpp]
    │      └─ PEFile::Load()
    │
    └─ MethodDesc::DoPrestub() [prestub.cpp]
           └─ JIT Compilation
                  └─ ICorJitCompiler::compileMethod()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ILアセンブリ ──────▶ PEFile解析 ──────▶ メタデータ
     │                    │
     │                    ▼
     │              ClassLoader
     │                    │
     ▼                    ▼
メインメソッド ──────▶ JITコンパイル ──────▶ ネイティブコード
     │                    │
     │                    ▼
     │              コード実行
     │                    │
     ▼                    ▼
GCヒープ ◀──────── メモリ管理 ──────▶ オブジェクト生存管理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ceemain.cpp | `src/coreclr/vm/ceemain.cpp` | ソース | ランタイム初期化・シャットダウン |
| threads.h | `src/coreclr/vm/threads.h` | ヘッダ | スレッド管理の定義 |
| gc.h | `src/coreclr/gc/gc.h` | ヘッダ | GCインターフェース定義 |
| gcheaputilities.h | `src/coreclr/vm/gcheaputilities.h` | ヘッダ | GCヒープユーティリティ |
| method.hpp | `src/coreclr/vm/method.hpp` | ヘッダ | MethodDescの定義 |
| codeman.h | `src/coreclr/vm/codeman.h` | ヘッダ | コードマネージャー |
| clsload.hpp | `src/coreclr/vm/clsload.hpp` | ヘッダ | 型ローダー |
| assembly.cpp | `src/coreclr/vm/assembly.cpp` | ソース | アセンブリ管理 |
| jitinterface.cpp | `src/coreclr/vm/jitinterface.cpp` | ソース | JITとのインターフェース |
| corhost.cpp | `src/coreclr/vm/corhost.cpp` | ソース | ホスティングAPI |
