# 機能設計書 2-Mono

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるMono（Mono Runtime）の機能設計について記述する。Monoはクロスプラットフォーム対応の.NETランタイム実装であり、特にWebAssembly（WASM）、WASI、モバイルプラットフォーム（iOS/Android）向けの実行環境を提供する。

### 本機能の処理概要

**業務上の目的・背景**：Monoは、CoreCLRがサポートしないプラットフォームや特殊な実行環境で.NETアプリケーションを動作させるためのランタイムエンジンである。元々はオープンソースの.NET Framework互換ランタイムとして開発され、Xamarin買収後にMicrosoftの.NETエコシステムに統合された。ブラウザ上でのWebAssembly実行、iOSやAndroidでのモバイルアプリケーション実行、組み込みシステム向けなど、多様なシナリオに対応する。

**機能の利用シーン**：
- Blazor WebAssemblyアプリケーションのブラウザ上での実行
- Xamarin/MAUIによるiOS/Androidモバイルアプリケーションの実行
- WASI（WebAssembly System Interface）対応のサーバーレス環境での実行
- AOT（Ahead-of-Time）コンパイルが必要なプラットフォームでの実行

**主要な処理内容**：
1. JIT（Just-In-Time）コンパイルによるILコードのネイティブコード変換
2. インタープリターによるILコードの逐次実行（JIT不可環境向け）
3. AOTコンパイルによる事前ネイティブコード生成
4. LLVM連携による最適化されたネイティブコード生成
5. SGen GCによるメモリ管理
6. P/Invoke、ICalls（Internal Calls）による相互運用

**関連システム・外部連携**：
- ブラウザのWebAssembly実行環境との連携
- iOS/macOSランタイム（Objective-C bridging）
- Android Runtime（JNI連携）
- LLVM（最適化コンパイラバックエンド）

**権限による制御**：
- プラットフォーム固有のセキュリティサンドボックス
- WebAssembly実行時のブラウザセキュリティモデル

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Wasm Browser Sample | 主機能 | WebAssemblyランタイム上で.NETコードを実行するメイン処理 |
| 2 | Wasm Browser Advanced Sample | 主機能 | WebAssemblyランタイム上で高度な.NETコードを実行するメイン処理 |
| 3 | Wasm Browser Threading Sample | 主機能 | WebAssemblyランタイム上でマルチスレッド処理を実行 |
| 4 | Wasm Browser Shutdown Sample | 主機能 | WebAssemblyランタイム上でシャットダウン処理を実行 |
| 5 | Benchmark Sample | 主機能 | WebAssemblyランタイム上でベンチマーク処理を実行 |
| 6 | Profiler Sample | 主機能 | WebAssemblyランタイム上でプロファイリングを実行 |
| 9 | Simple Wasm Raytracer | 主機能 | WebAssemblyランタイム上でレイトレーシング計算を実行 |
| 10 | Hot Reload Sample | 主機能 | WebAssemblyランタイム上でホットリロードを実行 |

## 機能種別

計算処理 / システム基盤機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| IL Assembly | バイナリ | Yes | 実行対象のマネージドアセンブリ | PE形式検証 |
| AOT Data | バイナリ | No | 事前コンパイル済みネイティブコード | プラットフォーム互換性検証 |
| Runtime Options | 構造体 | No | ランタイム初期化オプション | オプション値検証 |

### 入力データソース

- ファイルシステム/仮想ファイルシステム上のアセンブリ
- WebAssembly環境では、JavaScript経由でロードされたアセンブリデータ
- 環境変数（MONO_*）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行結果 | int | アプリケーションの終了コード |
| JavaScript連携 | JSValue | WebAssembly環境でのJS相互運用 |
| プロファイリングデータ | バイナリ | 実行プロファイル情報 |

### 出力先

- プロセス終了コード
- JavaScript連携（WebAssembly環境）
- ログ出力（mono_log）

## 処理フロー

### 処理シーケンス

```
1. mono_main() / mono_jit_init()の呼び出し
   └─ ランタイム初期化の開始
2. mini_init()の実行
   └─ JITエンジンの初期化
3. mono_domain_create()
   └─ アプリケーションドメインの作成
4. mono_assembly_load()
   └─ アセンブリのロード
5. mono_jit_compile_method() / インタープリター
   └─ メソッドのJITコンパイルまたは解釈実行
6. GC処理（SGen）
   └─ 自動メモリ管理
7. mono_runtime_quit()
   └─ ランタイムのシャットダウン
```

### フローチャート

```mermaid
flowchart TD
    A[ホスト/ブラウザからの起動] --> B{プラットフォーム判定}
    B -->|WebAssembly| C[mono_wasm_load_runtime]
    B -->|Native| D[mono_jit_init]
    C --> E[AOTデータロード]
    D --> E
    E --> F[アセンブリロード]
    F --> G{実行モード}
    G -->|JIT| H[JITコンパイル]
    G -->|AOT| I[AOTコード実行]
    G -->|Interpreter| J[IL解釈実行]
    H --> K[ネイティブコード実行]
    I --> K
    J --> K
    K --> L{例外?}
    L -->|Yes| M[例外処理]
    L -->|No| N[正常継続/終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 実行モード自動選択 | プラットフォームに応じてJIT/AOT/インタープリターを自動選択 | ランタイム初期化時 |
| BR-02 | iOS AOT必須 | iOSプラットフォームではAOTコンパイル必須（JIT禁止） | iOSビルド時 |
| BR-03 | WASM制約 | WebAssemblyではスレッドの制限あり（COOP対応） | WASM実行時 |

### 計算ロジック

- Tiered Compilation：初回は高速コンパイル、ホットパスを最適化再コンパイル
- LLVM連携：LLVM IRへの変換と最適化によるネイティブコード生成

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | Monoはデータベースを直接操作しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| MONO_ERROR_GENERIC | 一般エラー | 各種ランタイムエラー | エラーメッセージ確認 |
| TypeLoadException | 型ロード失敗 | アセンブリ/型が見つからない | 依存関係確認 |
| EntryPointNotFoundException | エントリーポイント不明 | P/Invokeターゲット不在 | ネイティブライブラリ確認 |

### リトライ仕様

- JITコンパイル失敗：インタープリターへのフォールバック（構成による）
- アセンブリロード失敗：リトライなし

## トランザクション仕様

Monoはトランザクション管理を直接提供しない。

## パフォーマンス要件

- WebAssembly：初期ロード時間の最小化（AOTによる起動高速化）
- モバイル：バッテリー効率を考慮したJIT/AOTバランス
- Tiered Compilation：起動時間と実行時パフォーマンスのトレードオフ最適化

## セキュリティ考慮事項

- WebAssembly：ブラウザのサンドボックス内での実行
- iOSアプリ署名：コード署名によるAOTコードの検証
- P/Invokeセキュリティ：ネイティブコード呼び出しの制限

## 備考

- MonoはXamarin Inc.によって開発され、現在はMicrosoftの.NETプロジェクトに統合
- .NET 5以降、特定のワークロード（WASM、モバイル）でMonoランタイムが採用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mini.h | `src/mono/mono/mini/mini.h` | MonoInst、CallInfo等のJIT用データ構造 |
| 1-2 | class-internals.h | `src/mono/mono/metadata/class-internals.h` | MonoClass内部構造 |
| 1-3 | object-internals.h | `src/mono/mono/metadata/object-internals.h` | MonoObject内部構造 |

**読解のコツ**:
- Monoは元々GLib依存で書かれており、`g_*`関数やGLib型が多用されている
- **mini.h 49-51行目**: `MonoInst`、`CallInfo`、`SeqPointInfo`の前方宣言
- **mini.h 94-99行目**: LLVM有効時のコンパイルマクロ定義

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mini-runtime.c | `src/mono/mono/mini/mini-runtime.c` | ランタイム初期化、JIT実行 |
| 2-2 | jit.h | `src/native/public/mono/jit/jit.h` | 公開JIT API |

**主要処理フロー**:
- **mini-runtime.c 78行目**: `#include "mini.h"` - メインヘッダインクルード
- **mini-runtime.c 83-85行目**: AOTコンパイラ、ランタイムヘッダのインクルード
- **mini-runtime.c 94行目**: `#include "interp/interp.h"` - インタープリターとの統合

#### Step 3: JIT/AOT層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | aot-runtime.c | `src/mono/mono/mini/aot-runtime.c` | AOTランタイム |
| 3-2 | aot-compiler.c | `src/mono/mono/mini/aot-compiler.c` | AOTコンパイラ |
| 3-3 | mini-llvm.c | `src/mono/mono/mini/mini-llvm.c` | LLVM連携 |

#### Step 4: WebAssembly固有の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | driver.c | `src/mono/browser/runtime/driver.c` | WASMドライバー |
| 4-2 | interp.c | `src/mono/mono/mini/interp/interp.c` | インタープリター実装 |

### プログラム呼び出し階層図

```
ホスト/ブラウザ
    │
    ├─ mono_jit_init() [mini-runtime.c]
    │      ├─ mini_init()
    │      │      ├─ mono_thread_init()
    │      │      ├─ mono_gc_base_init() [SGen]
    │      │      └─ mono_arch_init()
    │      │
    │      └─ mono_domain_create()
    │
    ├─ mono_assembly_load()
    │      └─ mono_image_open()
    │
    └─ mono_runtime_invoke() / mono_jit_compile_method()
           ├─ [JITモード] mini_method_compile()
           │      └─ [LLVM有効時] mono_llvm_emit_method()
           │
           ├─ [AOTモード] mono_aot_get_method()
           │
           └─ [インタープリター] interp_exec_method()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ILアセンブリ ──────▶ mono_image_open() ──────▶ MonoImage
     │                    │
     │                    ▼
     │              型情報解析
     │                    │
     ▼                    ▼
メソッド呼び出し ────▶ JIT/AOT/Interp ──────▶ ネイティブ実行
     │                    │
     │                    ▼
     │              SGen GC
     │                    │
     ▼                    ▼
マネージドヒープ ◀──── メモリ管理 ──────▶ オブジェクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mini.h | `src/mono/mono/mini/mini.h` | ヘッダ | JITコンパイラ定義 |
| mini-runtime.c | `src/mono/mono/mini/mini-runtime.c` | ソース | ランタイム初期化 |
| aot-runtime.c | `src/mono/mono/mini/aot-runtime.c` | ソース | AOTランタイム |
| aot-compiler.c | `src/mono/mono/mini/aot-compiler.c` | ソース | AOTコンパイラ |
| interp.c | `src/mono/mono/mini/interp/interp.c` | ソース | ILインタープリター |
| mini-llvm.c | `src/mono/mono/mini/mini-llvm.c` | ソース | LLVM連携 |
| sgen-gc.c | `src/mono/mono/sgen/sgen-gc.c` | ソース | SGenガベージコレクター |
| jit.h | `src/native/public/mono/jit/jit.h` | ヘッダ | 公開JIT API |
| driver.c | `src/mono/browser/runtime/driver.c` | ソース | WASMドライバー |
| GC.Mono.cs | `src/mono/System.Private.CoreLib/src/System/GC.Mono.cs` | ソース | Mono固有GC API |
