# 機能設計書 24-System.Reflection.Emit

## 概要

本ドキュメントは、.NETランタイムのSystem.Reflection.Emit名前空間が提供する動的コード生成機能について、その設計仕様と実装の詳細を記述する。Reflection.Emitは、実行時にIL（Intermediate Language）コードを生成し、新しい型やメソッドを動的に作成する機能を提供する。

### 本機能の処理概要

System.Reflection.Emitは、実行時にCLR（Common Language Runtime）で実行可能なILコードを動的に生成するためのライブラリである。アセンブリ、モジュール、型、メソッド、フィールド、プロパティ、イベントなどを動的に定義し、生成したコードを実行またはディスクに保存できる。

**業務上の目的・背景**：静的にコンパイルされたコードでは対応できない動的なシナリオが存在する。例えば、ORMでのエンティティプロキシ生成、シリアライザでの高速アクセサ生成、式ツリーのコンパイル、動的言語のサポートなど。Reflection.Emitは、これらのシナリオでリフレクションよりも高速なコードを生成するために使用される。

**機能の利用シーン**：
- ORMフレームワーク（Entity Framework、Dapper等）でのプロキシ生成
- シリアライザ（JSON.NET、MessagePack等）での高速アクセサ生成
- 式ツリー（Expression<T>）のコンパイル
- AOPフレームワークでのインターセプター生成
- 動的言語ランタイム（DLR）のサポート
- コードジェネレーターの実装
- ユニットテストでのモック生成

**主要な処理内容**：
1. アセンブリ・モジュールの定義（AssemblyBuilder、ModuleBuilder）
2. 型の定義（TypeBuilder、EnumBuilder）
3. メンバーの定義（MethodBuilder、FieldBuilder、PropertyBuilder、EventBuilder）
4. ILコードの生成（ILGenerator）
5. ジェネリック型パラメータの定義（GenericTypeParameterBuilder）
6. カスタム属性の設定（SetCustomAttribute）

**関連システム・外部連携**：System.Reflection、System.Reflection.Metadata、System.Linq.Expressionsと統合。

**権限による制御**：動的メソッド生成にはセキュリティ制限あり。.NET Framework時代のReflectionPermissionは廃止。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUIを持たないライブラリ機能である |

## 機能種別

動的コード生成 / メタプログラミング / リフレクション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | アセンブリ/型/メンバー名 | 空文字列不可 |
| attributes | TypeAttributes/MethodAttributes等 | Yes | 属性フラグ | 有効なフラグ組み合わせ |
| parent | Type | No | 基底クラス | null可（Objectが既定） |
| interfaces | Type[] | No | 実装インターフェース | null可 |
| parameterTypes | Type[] | No | メソッドパラメータ型 | null可 |
| returnType | Type | No | メソッド戻り値型 | null可（voidの場合） |

### 入力データソース

- プログラムコードからの定義情報
- 式ツリー（Expression<T>）からの変換

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AssemblyBuilder | AssemblyBuilder | 動的アセンブリ |
| ModuleBuilder | ModuleBuilder | 動的モジュール |
| TypeBuilder | TypeBuilder | 動的型ビルダー |
| Type | Type | 完成した型（CreateType後） |
| MethodBuilder | MethodBuilder | 動的メソッドビルダー |

### 出力先

- インメモリ実行（Runnable Assembly）
- ディスクへの保存（PersistedAssemblyBuilder）

## 処理フロー

### 処理シーケンス

```
1. アセンブリ定義
   └─ AssemblyBuilder.DefineDynamicAssembly(name, access)

2. モジュール定義
   └─ assemblyBuilder.DefineDynamicModule(name)

3. 型定義
   └─ moduleBuilder.DefineType(name, attributes, parent, interfaces)

4. メンバー定義
   └─ typeBuilder.DefineMethod(name, attributes, returnType, parameterTypes)
   └─ typeBuilder.DefineField(name, type, attributes)
   └─ typeBuilder.DefineProperty(name, attributes, returnType, parameterTypes)
   └─ typeBuilder.DefineEvent(name, attributes, eventType)

5. ILコード生成
   └─ methodBuilder.GetILGenerator()
   └─ ilGenerator.Emit(OpCodes.Xxx, operand)
   └─ ilGenerator.Emit(OpCodes.Ret)

6. 型完成
   └─ typeBuilder.CreateType()

7. 使用
   └─ Activator.CreateInstance(type)
   └─ type.GetMethod(...).Invoke(...)
```

### フローチャート

```mermaid
flowchart TD
    A[AssemblyBuilder.DefineDynamicAssembly] --> B[DefineDynamicModule]
    B --> C[DefineType]
    C --> D{メンバー定義}
    D --> E[DefineMethod]
    D --> F[DefineField]
    D --> G[DefineProperty]
    D --> H[DefineConstructor]
    E --> I[GetILGenerator]
    I --> J[Emit IL命令]
    J --> K{すべての命令完了?}
    K -->|No| J
    K -->|Yes| L[CreateType]
    L --> M{保存?}
    M -->|Yes| N[Save to disk]
    M -->|No| O[インメモリ使用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 不変性 | CreateType後は型定義を変更不可 | CreateType呼び出し後 |
| BR-02 | 抽象メソッド検証 | 抽象メソッドはボディを持てない | 抽象クラス/インターフェース |
| BR-03 | デフォルトコンストラクタ | インターフェース/静的クラス以外で自動生成 | コンストラクタ未定義時 |
| BR-04 | スタック整合性 | IL命令実行後のスタック状態が整合 | すべてのメソッド |
| BR-05 | 例外ブロック整合性 | try-catch-finallyの開始・終了が対応 | 例外処理定義時 |

### 計算ロジック

ILスタック深度計算:
- 各命令のpush/pop効果を追跡
- 最大スタック深度をメタデータに記録
- 分岐命令では複数パスの深度を追跡

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidOperationException | 例外 | CreateType済みの型を変更 | CreateType前に定義完了 |
| ArgumentException | 例外 | 無効な型名/メンバー名 | 有効な識別子を使用 |
| InvalidOperationException | 例外 | 非抽象クラスに抽象メソッド | TypeAttributesをAbstractに |
| InvalidOperationException | 例外 | 抽象メソッドにボディあり | ボディを削除 |
| NotSupportedException | 例外 | 例外ブロック外でBeginCatchBlock | BeginExceptionBlock後に使用 |

### リトライ仕様

コード生成は同期処理のため、リトライは不要。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- 生成されたコードはJITコンパイル後、直接呼び出しと同等の性能
- コード生成自体のオーバーヘッドは初回のみ
- DynamicMethod（軽量コード生成）はメモリ効率が良い
- PersistedAssemblyBuilderでディスク保存可能

## セキュリティ考慮事項

- 動的コードは検証可能なILを生成すべき
- 信頼できないソースからの型情報を使用しない
- SkipVisibilityChecksオプションは慎重に使用
- PartialTrust環境での制限を考慮（.NET Framework時代）

## 備考

- .NET Core/.NET 5+ではRunAndCollectモードでアンロード可能
- PersistedAssemblyBuilder（.NET 9+）でPDB生成サポート
- System.Reflection.Metadataと連携したメタデータ生成

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビルダー階層を理解する

アセンブリ→モジュール→型→メンバーの階層構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PersistedAssemblyBuilder.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/PersistedAssemblyBuilder.cs` | 永続化可能なアセンブリビルダー |
| 1-2 | ModuleBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ModuleBuilderImpl.cs` | モジュールビルダー実装 |
| 1-3 | TypeBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/TypeBuilderImpl.cs` | 型ビルダー実装 |

**読解のコツ**: 各ビルダーが親ビルダーへの参照を持ち、階層的にメタデータを構築する構造を理解する。

#### Step 2: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TypeBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/TypeBuilderImpl.cs` | 型定義の詳細 |
| 2-2 | EnumBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/EnumBuilderImpl.cs` | 列挙型ビルダー |
| 2-3 | GenericTypeParameterBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/GenericTypeParameterBuilderImpl.cs` | ジェネリック型パラメータ |

**主要処理フロー（TypeBuilderImpl.cs）**:
- **13-41行目**: 内部フィールド（モジュール参照、名前、属性、メンバーリスト等）
- **44-50行目**: グローバル型("<Module>")用コンストラクタ
- **52-83行目**: 通常型用コンストラクタ（フルネームからnamespace抽出）
- **89-95行目**: AddInterfaceImplementationCoreでインターフェース追加
- **99-124行目**: CreateTypeInfoCoreで型を完成（デフォルトコンストラクタ自動生成含む）
- **126-149行目**: ValidateMethodsで抽象メソッドの検証

#### Step 3: メソッド・フィールド定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MethodBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/MethodBuilderImpl.cs` | メソッドビルダー |
| 3-2 | ConstructorBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ConstructorBuilderImpl.cs` | コンストラクタビルダー |
| 3-3 | FieldBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/FieldBuilderImpl.cs` | フィールドビルダー |

#### Step 4: ILコード生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ILGeneratorImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ILGeneratorImpl.cs` | ILジェネレーター実装 |
| 4-2 | SignatureHelper.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/SignatureHelper.cs` | シグネチャヘルパー |

**主要処理フロー（ILGeneratorImpl.cs）**:
- **14-36行目**: 内部フィールド（BlobBuilder、InstructionEncoder、スコープ、スタック深度追跡）
- **37-47行目**: コンストラクタ（BlobBuilder、ControlFlowBuilder初期化）
- **49-56行目**: 内部プロパティ（GetMaxStack、LocalCount等）
- **58-82行目**: AddExceptionBlocksで例外ハンドラ領域を登録
- **84行目**: ILOffsetプロパティで現在のオフセット取得
- **86-129行目**: BeginCatchBlockで例外キャッチブロック開始

#### Step 5: プロパティ・イベント定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | PropertyBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/PropertyBuilderImpl.cs` | プロパティビルダー |
| 5-2 | EventBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/EventBuilderImpl.cs` | イベントビルダー |
| 5-3 | ParameterBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ParameterBuilderImpl.cs` | パラメータビルダー |

### プログラム呼び出し階層図

```
AssemblyBuilder.DefineDynamicAssembly(name, access)
    │
    └─ PersistedAssemblyBuilder / RuntimeAssemblyBuilder
           │
           └─ DefineDynamicModule(name)
                  │
                  └─ ModuleBuilderImpl
                         │
                         ├─ DefineType(name, attr, parent, interfaces)
                         │      │
                         │      └─ TypeBuilderImpl
                         │             ├─ DefineMethod(name, attr, returnType, params)
                         │             │      └─ MethodBuilderImpl
                         │             │             └─ GetILGenerator()
                         │             │                    └─ ILGeneratorImpl
                         │             │                           └─ Emit(OpCodes.Xxx)
                         │             │
                         │             ├─ DefineField(name, type, attr)
                         │             │      └─ FieldBuilderImpl
                         │             │
                         │             ├─ DefineProperty(name, attr, returnType)
                         │             │      └─ PropertyBuilderImpl
                         │             │
                         │             ├─ DefineConstructor(attr, convention, params)
                         │             │      └─ ConstructorBuilderImpl
                         │             │
                         │             └─ CreateType()
                         │                    └─ CreateTypeInfoCore()
                         │
                         └─ DefineEnum(name, visibility, underlyingType)
                                └─ EnumBuilderImpl
```

### データフロー図

```
[入力]               [処理]                    [出力]

型情報           ビルダー階層               実行可能型
   │                   │                      │
   ├─ 型名 ──────────▶│                      │
   │                   │                      │
   ├─ 属性 ──────────▶│                      │
   │                   │                      │
   ├─ 基底クラス ────▶│                      │
   │                   │                      │
   │              ┌────┴────┐                 │
   │              │TypeBuilder│               │
   │              │DefineXxx  │               │
   │              └────┬────┘                 │
   │                   │                      │
メソッド情報           │                      │
   │              ┌────┴────┐                 │
   ├─ 戻り値型 ──▶│MethodBuilder│            │
   │              │GetILGenerator │           │
   ├─ パラメータ ▶│              │            │
   │              └────┬────┘                 │
   │                   │                      │
IL命令            ┌────┴────┐                 │
   │              │ILGenerator│               │
   ├─ Emit ──────▶│BlobBuilder │              │
   │              └────┬────┘                 │
   │                   │                      │
   │              CreateType()                │
   │                   │                      │
   │                   └─────────────────────▶│Type
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PersistedAssemblyBuilder.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/PersistedAssemblyBuilder.cs` | ソース | 永続化アセンブリビルダー |
| ModuleBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ModuleBuilderImpl.cs` | ソース | モジュールビルダー実装 |
| TypeBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/TypeBuilderImpl.cs` | ソース | 型ビルダー実装 |
| MethodBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/MethodBuilderImpl.cs` | ソース | メソッドビルダー実装 |
| ConstructorBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ConstructorBuilderImpl.cs` | ソース | コンストラクタビルダー実装 |
| FieldBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/FieldBuilderImpl.cs` | ソース | フィールドビルダー実装 |
| PropertyBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/PropertyBuilderImpl.cs` | ソース | プロパティビルダー実装 |
| EventBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/EventBuilderImpl.cs` | ソース | イベントビルダー実装 |
| ILGeneratorImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ILGeneratorImpl.cs` | ソース | ILジェネレーター実装 |
| EnumBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/EnumBuilderImpl.cs` | ソース | 列挙型ビルダー実装 |
| GenericTypeParameterBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/GenericTypeParameterBuilderImpl.cs` | ソース | ジェネリック型パラメータビルダー |
| ParameterBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ParameterBuilderImpl.cs` | ソース | パラメータビルダー実装 |
| LocalBuilderImpl.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/LocalBuilderImpl.cs` | ソース | ローカル変数ビルダー実装 |
| SignatureHelper.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/SignatureHelper.cs` | ソース | シグネチャヘルパー |
| CustomAttributeWrapper.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/CustomAttributeWrapper.cs` | ソース | カスタム属性ラッパー |
| ArrayMethod.cs | `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ArrayMethod.cs` | ソース | 配列メソッド |
