# 機能設計書 26-System.Data.Common

## 概要

本ドキュメントは、.NETランタイムのSystem.Data.Common名前空間が提供するデータアクセス基盤機能について、その設計仕様と実装の詳細を記述する。ADO.NETの共通インターフェースとプロバイダーモデルを提供する。

### 本機能の処理概要

System.Data.Commonは、ADO.NET（ActiveX Data Objects for .NET）の共通基盤を提供するライブラリである。データベースに依存しない抽象クラス（DbConnection、DbCommand、DbDataReader等）を通じて、様々なデータプロバイダーを統一的に扱うことができる。

**業務上の目的・背景**：アプリケーションがデータベースにアクセスする際、特定のデータベースベンダーに依存したコードを書くとポータビリティが低下する。System.Data.Commonは、プロバイダーモデルにより、データベースの種類を抽象化し、コードの再利用性と保守性を向上させる。

**機能の利用シーン**：
- データベースへの接続・切断
- SQLコマンドの実行（SELECT、INSERT、UPDATE、DELETE）
- トランザクション管理
- パラメータ化クエリの実行
- データリーダーによる結果セット読み取り
- バッチコマンドの実行（.NET 6+）
- 接続文字列の構築・解析

**主要な処理内容**：
1. 接続管理（DbConnection、DbConnectionStringBuilder）
2. コマンド実行（DbCommand、DbBatch）
3. データ読み取り（DbDataReader）
4. パラメータ管理（DbParameter、DbParameterCollection）
5. トランザクション制御（DbTransaction）
6. プロバイダーファクトリ（DbProviderFactory、DbProviderFactories）

**関連システム・外部連携**：各データベースプロバイダー（SqlClient、Npgsql、MySqlConnector等）、Entity Framework Core、Dapper等のORMと統合。

**権限による制御**：データベース接続に必要な認証情報と、ネットワークアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUIを持たないライブラリ機能である |

## 機能種別

データアクセス / データベース連携 / ORM基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| connectionString | string | Yes | 接続文字列 | 有効な形式 |
| commandText | string | Yes | SQLコマンド | nullでない |
| commandType | CommandType | No | コマンド種別 | 有効な列挙値 |
| isolationLevel | IsolationLevel | No | 分離レベル | 有効な列挙値 |
| parameters | DbParameter[] | No | SQLパラメータ | null可 |

### 入力データソース

- 接続文字列（コード/構成ファイル）
- SQLクエリ/ストアドプロシージャ
- パラメータ値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DbDataReader | DbDataReader | クエリ結果のリーダー |
| rowsAffected | int | 影響を受けた行数 |
| scalar | object | スカラー値 |
| DbTransaction | DbTransaction | トランザクションオブジェクト |

### 出力先

- DbDataReaderによる結果ストリーミング
- 戻り値としてのスカラー値/行数

## 処理フロー

### 処理シーケンス

```
1. 接続作成
   └─ DbProviderFactory.CreateConnection() または new XxxConnection()

2. 接続オープン
   └─ connection.Open() または connection.OpenAsync()

3. コマンド作成
   └─ connection.CreateCommand()
   └─ command.CommandText = "SELECT ..."

4. パラメータ設定
   └─ command.Parameters.Add(parameter)

5. コマンド実行
   └─ ExecuteReader(): 結果セット取得
   └─ ExecuteNonQuery(): 行数取得
   └─ ExecuteScalar(): 単一値取得

6. 結果読み取り
   └─ while (reader.Read()) { ... }

7. リソース解放
   └─ reader.Dispose()
   └─ command.Dispose()
   └─ connection.Close()
```

### フローチャート

```mermaid
flowchart TD
    A[DbProviderFactory] --> B[CreateConnection]
    B --> C[DbConnection]
    C --> D[Open/OpenAsync]
    D --> E[CreateCommand]
    E --> F[DbCommand]
    F --> G{実行方法}
    G -->|ExecuteReader| H[DbDataReader]
    G -->|ExecuteNonQuery| I[int rowsAffected]
    G -->|ExecuteScalar| J[object result]
    H --> K[Read/ReadAsync]
    K --> L{次の行?}
    L -->|Yes| M[データ取得]
    M --> K
    L -->|No| N[Dispose]
    I --> N
    J --> N
    N --> O[Connection.Close]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 接続プール | 同一接続文字列の接続は再利用 | プロバイダー実装依存 |
| BR-02 | 分離レベル | トランザクションの分離レベルを指定可能 | トランザクション使用時 |
| BR-03 | パラメータ化 | SQLインジェクション防止のためパラメータ使用推奨 | 常時 |
| BR-04 | 非同期対応 | Async/Awaitパターンで非同期実行可能 | 常時 |
| BR-05 | Dispose必須 | リソースは明示的に解放 | 常時 |

### 計算ロジック

接続タイムアウト: デフォルト15秒（ADP.DefaultConnectionTimeout）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作名 | メソッド | 影響 |
|--------|---------|------|
| SELECT | ExecuteReader | なし |
| INSERT/UPDATE/DELETE | ExecuteNonQuery | 行変更 |
| ストアドプロシージャ | ExecuteReader/NonQuery | 依存 |
| DDL | ExecuteNonQuery | スキーマ変更 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| DbException | 例外 | データベースエラー | エラー内容を確認 |
| InvalidOperationException | 例外 | 接続が閉じている | 接続を開く |
| ArgumentException | 例外 | 無効な接続文字列 | 形式を修正 |
| TimeoutException | 例外 | タイムアウト | タイムアウト値を調整 |

### リトライ仕様

- 一時的なエラー（デッドロック、ネットワーク断）はリトライ可能
- Pollyなどのリトライライブラリとの組み合わせを推奨

## トランザクション仕様

- BeginTransaction()でトランザクション開始
- Commit()/Rollback()で終了
- IsolationLevelで分離レベル指定
- TransactionScopeによる分散トランザクションも対応

## パフォーマンス要件

- 接続プールによる接続再利用
- 非同期メソッドによるスレッド効率化
- CommandBehavior.SequentialAccessによるストリーミング読み取り
- DbBatch（.NET 6+）による複数コマンドのバッチ実行

## セキュリティ考慮事項

- パラメータ化クエリでSQLインジェクション防止
- 接続文字列の安全な管理（SecretManager、KeyVault等）
- 最小権限の原則に従ったデータベースユーザー設定

## 備考

- .NET Frameworkから継承されたAPIで安定
- Entity Framework Coreの基盤として使用
- DbBatch（.NET 6+）でパフォーマンス向上

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: 接続管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DbConnection.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbConnection.cs` | 接続抽象クラス |
| 1-2 | DbConnectionStringBuilder.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbConnectionStringBuilder.cs` | 接続文字列ビルダー |

**主要処理フロー（DbConnection.cs）**:
- **11行目**: IDbConnection、IAsyncDisposable実装
- **28行目**: ConnectionString抽象プロパティ
- **30行目**: ConnectionTimeoutデフォルト値
- **47行目**: State抽象プロパティ
- **51行目**: BeginDbTransaction抽象メソッド
- **67-80行目**: BeginDbTransactionAsync仮想メソッド

#### Step 2: コマンド実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DbCommand.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbCommand.cs` | コマンド抽象クラス |
| 2-2 | DbParameter.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbParameter.cs` | パラメータ抽象クラス |
| 2-3 | DbBatch.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbBatch.cs` | バッチコマンド |

#### Step 3: データ読み取りを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DbDataReader.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbDataReader.cs` | データリーダー抽象クラス |

#### Step 4: プロバイダーファクトリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DbProviderFactory.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbProviderFactory.cs` | プロバイダーファクトリ |
| 4-2 | DbProviderFactories.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbProviderFactories.cs` | ファクトリ管理 |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DbConnection.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbConnection.cs` | ソース | 接続抽象クラス |
| DbCommand.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbCommand.cs` | ソース | コマンド抽象クラス |
| DbDataReader.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbDataReader.cs` | ソース | リーダー抽象クラス |
| DbParameter.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbParameter.cs` | ソース | パラメータ抽象クラス |
| DbTransaction.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbTransaction.cs` | ソース | トランザクション抽象クラス |
| DbProviderFactory.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbProviderFactory.cs` | ソース | プロバイダーファクトリ |
| DbBatch.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbBatch.cs` | ソース | バッチコマンド |
| DbConnectionStringBuilder.cs | `src/libraries/System.Data.Common/src/System/Data/Common/DbConnectionStringBuilder.cs` | ソース | 接続文字列ビルダー |
