# 機能設計書 27-System.Diagnostics.Process

## 概要

本ドキュメントは、.NETランタイムのSystem.Diagnostics.Process名前空間が提供するプロセス管理機能について、その設計仕様と実装の詳細を記述する。外部プロセスの起動、監視、終了を行う機能を提供する。

### 本機能の処理概要

System.Diagnostics.Processは、オペレーティングシステムのプロセスを起動、停止、監視するためのクラスを提供するライブラリである。Processクラスを通じて、外部プログラムの実行、標準入出力のリダイレクト、プロセス情報の取得などが可能である。

**業務上の目的・背景**：アプリケーションから外部ツール（コンパイラ、画像処理ツール、スクリプト等）を呼び出したり、システムプロセスを監視したりする需要がある。Processクラスは、これらの操作をクロスプラットフォームで実現する。

**機能の利用シーン**：
- 外部コマンド/プログラムの実行
- ビルドツール・スクリプトの起動
- システム監視・運用自動化
- 子プロセスとの標準入出力通信
- プロセス一覧の取得・監視
- ファイルの関連付けによるオープン

**主要な処理内容**：
1. プロセスの起動（Start）
2. プロセスの終了待機（WaitForExit）
3. 標準入出力のリダイレクト（StandardInput/Output/Error）
4. プロセス情報の取得（Id、ProcessName、WorkingSet等）
5. プロセスの強制終了（Kill）
6. プロセス一覧の取得（GetProcesses、GetProcessesByName）

**関連システム・外部連携**：オペレーティングシステムのプロセス管理機能（Windows: Win32 API、Unix: fork/exec）。

**権限による制御**：プロセス起動・終了には適切な権限が必要。昇格されたプロセスには管理者権限が必要な場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUIを持たないライブラリ機能である |

## 機能種別

プロセス管理 / 外部連携 / システム操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| fileName | string | Yes | 実行ファイルパス | 存在するファイル |
| arguments | string | No | コマンドライン引数 | null可 |
| workingDirectory | string | No | 作業ディレクトリ | 存在するディレクトリ |
| verb | string | No | 実行動詞（runas等） | 有効な動詞 |
| useShellExecute | bool | No | シェル経由実行 | true/false |
| redirectStandardInput/Output/Error | bool | No | 標準入出力リダイレクト | true/false |

### 入力データソース

- プログラムコードからのProcessStartInfo
- 標準入力へのデータ書き込み

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Process | Process | 起動されたプロセス |
| ExitCode | int | 終了コード |
| StandardOutput | StreamReader | 標準出力ストリーム |
| StandardError | StreamReader | 標準エラーストリーム |
| HasExited | bool | 終了済みフラグ |

### 出力先

- Processインスタンス
- 標準出力/エラーの読み取り

## 処理フロー

### 処理シーケンス

```
1. ProcessStartInfo作成
   └─ new ProcessStartInfo(fileName, arguments)
   └─ プロパティ設定（WorkingDirectory、リダイレクト等）

2. プロセス起動
   └─ Process.Start(startInfo) または process.Start()

3. 標準入出力処理（リダイレクト時）
   └─ process.StandardInput.WriteLine(...)
   └─ process.StandardOutput.ReadLine()
   └─ process.BeginOutputReadLine() // 非同期読み取り

4. 終了待機
   └─ process.WaitForExit() または WaitForExitAsync()

5. 終了コード取得
   └─ process.ExitCode

6. リソース解放
   └─ process.Dispose()
```

### フローチャート

```mermaid
flowchart TD
    A[ProcessStartInfo作成] --> B[プロパティ設定]
    B --> C{UseShellExecute?}
    C -->|Yes| D[シェル経由起動]
    C -->|No| E[直接起動]
    D --> F[Process.Start]
    E --> F
    F --> G{リダイレクト?}
    G -->|Yes| H[標準入出力処理]
    G -->|No| I[WaitForExit]
    H --> I
    I --> J{正常終了?}
    J -->|Yes| K[ExitCode取得]
    J -->|No| L[Kill]
    K --> M[Dispose]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | UseShellExecute制約 | UseShellExecute=trueではリダイレクト不可 | リダイレクト時 |
| BR-02 | 非同期読み取り | 標準出力/エラーの同時読み取りにはBeginXxxReadLine使用 | デッドロック防止 |
| BR-03 | Exited イベント | EnableRaisingEvents=trueで終了イベント発火 | イベント使用時 |
| BR-04 | WaitForExit後のExitCode | ExitCodeはWaitForExit後のみ有効 | 終了コード取得時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Win32Exception | 例外 | ファイルが見つからない | パスを確認 |
| InvalidOperationException | 例外 | プロセス未起動でExitCode参照 | Start後に参照 |
| InvalidOperationException | 例外 | リダイレクト未設定でStandardOutput参照 | リダイレクト設定 |

### リトライ仕様

プロセス起動失敗時は呼び出し側でリトライロジックを実装。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- プロセス起動はOSのオーバーヘッドあり
- 大量の標準出力は非同期読み取りを推奨
- GetProcesses()は全プロセス列挙のためコスト高

## セキュリティ考慮事項

- コマンドインジェクションに注意（引数のサニタイズ）
- 昇格プロセス（runas）は慎重に使用
- 環境変数経由の機密情報漏洩に注意

## 備考

- Windows/Linux/macOSでクロスプラットフォーム対応
- プラットフォーム固有の機能はpartial classで実装
- .NET 5以降でWaitForExitAsync追加

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: Processクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Process.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.cs` | 共通実装 |
| 1-2 | Process.Windows.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.Windows.cs` | Windows固有 |
| 1-3 | Process.Linux.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.Linux.cs` | Linux固有 |

**主要処理フロー（Process.cs）**:
- **25行目**: Componentを継承
- **27-69行目**: 内部フィールド（プロセスID、ハンドル、状態フラグ等）
- **77-78行目**: OutputDataReceived、ErrorDataReceivedイベント
- **93-100行目**: デフォルトコンストラクタ

#### Step 2: ProcessStartInfoを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProcessStartInfo.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessStartInfo.cs` | 起動情報クラス |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Process.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.cs` | ソース | 共通実装 |
| Process.Windows.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.Windows.cs` | ソース | Windows実装 |
| Process.Linux.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.Linux.cs` | ソース | Linux実装 |
| ProcessStartInfo.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessStartInfo.cs` | ソース | 起動情報 |
| ProcessThread.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessThread.cs` | ソース | スレッド情報 |
| ProcessModule.cs | `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessModule.cs` | ソース | モジュール情報 |
| SafeProcessHandle.cs | `src/libraries/System.Diagnostics.Process/src/Microsoft/Win32/SafeHandles/SafeProcessHandle.cs` | ソース | セーフハンドル |
