# 機能設計書 28-System.Diagnostics.DiagnosticSource

## 概要

本ドキュメントは、.NETランタイムのSystem.Diagnostics.DiagnosticSource名前空間が提供する診断・トレーシング機能について、その設計仕様と実装の詳細を記述する。アプリケーションの診断イベントとメトリクスを収集する基盤を提供する。

### 本機能の処理概要

System.Diagnostics.DiagnosticSourceは、アプリケーション内の診断イベントを発行・購読するための機構を提供するライブラリである。DiagnosticSource、Activity、Meterの3つの主要コンポーネントにより、分散トレーシングとメトリクス収集を実現する。

**業務上の目的・背景**：マイクロサービスアーキテクチャやクラウドネイティブアプリケーションでは、複数のサービス間でリクエストを追跡し、パフォーマンスを監視することが重要である。DiagnosticSourceは、OpenTelemetryなどの標準に準拠した診断データの収集基盤を提供する。

**機能の利用シーン**：
- 分散トレーシング（リクエストの追跡）
- アプリケーションパフォーマンス監視（APM）
- カスタムメトリクスの収集
- ログ相関（トレースIDによるログの関連付け）
- 依存関係の監視
- SLI/SLOの測定

**主要な処理内容**：
1. 診断イベントの発行・購読（DiagnosticSource/DiagnosticListener）
2. 分散トレーシング（Activity、ActivitySource）
3. メトリクス収集（Meter、Counter、Histogram、Gauge）
4. コンテキスト伝播（W3C Trace Context）
5. イベントソース連携（DiagnosticSourceEventSource）

**関連システム・外部連携**：OpenTelemetry、Application Insights、Jaeger、Zipkin、Prometheus等と統合。

**権限による制御**：特別な権限制御は不要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はUIを持たないライブラリ機能である |

## 機能種別

診断 / トレーシング / メトリクス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | string | Yes | ソース/アクティビティ名 | 空文字列不可 |
| kind | ActivityKind | No | アクティビティ種別 | 有効な列挙値 |
| tags | ActivityTagsCollection | No | タグ情報 | null可 |
| parentContext | ActivityContext | No | 親コンテキスト | null可 |
| unit | string | No | メトリクス単位 | null可 |

### 入力データソース

- プログラムコードからの診断イベント発行
- HTTPヘッダからのトレースコンテキスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Activity | Activity | アクティビティインスタンス |
| TraceId | ActivityTraceId | トレースID |
| SpanId | ActivitySpanId | スパンID |
| Measurement<T> | Measurement<T> | メトリクス測定値 |

### 出力先

- 登録されたリスナー/オブザーバー
- OpenTelemetryエクスポーター

## 処理フロー

### 処理シーケンス

```
1. ソース作成
   └─ new ActivitySource(name, version)
   └─ new Meter(name, version)

2. アクティビティ/メトリクス作成
   └─ source.StartActivity(name, kind)
   └─ meter.CreateCounter<T>(name, unit)

3. データ記録
   └─ activity.SetTag(key, value)
   └─ counter.Add(value, tags)

4. アクティビティ終了
   └─ activity.Stop() または activity.Dispose()

5. リスナーでのデータ処理
   └─ ActivityListener.Sample / ActivityStopped
   └─ MeterListener.RecordObservableInstruments
```

### フローチャート

```mermaid
flowchart TD
    A[ActivitySource/Meter作成] --> B{サンプリング判定}
    B -->|Yes| C[Activity/Instrument作成]
    B -->|No| D[null返却]
    C --> E[データ記録]
    E --> F[Activity.Stop/Counter.Add]
    F --> G[Listener通知]
    G --> H{エクスポート?}
    H -->|Yes| I[外部システムへ送信]
    H -->|No| J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | サンプリング | リスナーがないとActivityはnull | リスナー未登録時 |
| BR-02 | W3C Trace Context | HTTPヘッダでトレースコンテキストを伝播 | 分散トレーシング時 |
| BR-03 | 親子関係 | Activityは親Activityを自動追跡 | ネストされた処理 |
| BR-04 | スレッドセーフ | Activity.Currentはスレッドローカル | 常時 |

### 計算ロジック

サンプリング判定:
- ActivityListener.Sampleデリゲートで判定
- AllData/AllDataAndRecorded/PropagationData/None

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentNullException | 例外 | 必須パラメータがnull | 有効な値を指定 |
| ObjectDisposedException | 例外 | Dispose済みオブジェクトの使用 | ライフサイクル管理 |

### リトライ仕様

診断データの収集失敗は通常無視（アプリケーション動作に影響させない）。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- サンプリングによる低オーバーヘッド
- リスナーがない場合は最小限の処理
- スタックアロケーションを活用したメトリクス記録

## セキュリティ考慮事項

- 機密情報をタグに含めない
- トレースIDの適切な管理
- メトリクスデータの露出範囲を考慮

## 備考

- OpenTelemetry .NET SDKの基盤として使用
- .NET 5以降でActivitySource追加
- .NET 6以降でMeter API追加

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: DiagnosticSourceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiagnosticSource.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DiagnosticSource.cs` | 診断ソース基底クラス |
| 1-2 | DiagnosticListener.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DiagnosticListener.cs` | リスナー実装 |

#### Step 2: Activityを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Activity.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Activity.cs` | 分散トレーシングの核 |
| 2-2 | ActivitySource.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivitySource.cs` | アクティビティファクトリ |

#### Step 3: Metricsを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Meter.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Meter.cs` | メーター基底クラス |
| 3-2 | Counter.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Counter.cs` | カウンター |
| 3-3 | Histogram.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Histogram.cs` | ヒストグラム |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DiagnosticSource.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DiagnosticSource.cs` | ソース | 診断ソース |
| DiagnosticListener.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DiagnosticListener.cs` | ソース | リスナー |
| Activity.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Activity.cs` | ソース | アクティビティ |
| ActivitySource.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivitySource.cs` | ソース | アクティビティソース |
| Meter.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Meter.cs` | ソース | メーター |
| Counter.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Counter.cs` | ソース | カウンター |
| Histogram.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Histogram.cs` | ソース | ヒストグラム |
| Gauge.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Gauge.cs` | ソース | ゲージ |
| DistributedContextPropagator.cs | `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DistributedContextPropagator.cs` | ソース | コンテキスト伝播 |
