# 機能設計書 3-NativeAOT

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるNativeAOT（Native Ahead-of-Time Compilation）の機能設計について記述する。NativeAOTはマネージドコードをネイティブコードへ事前コンパイルする機能であり、スタンドアロン実行ファイルの生成をサポートする。

### 本機能の処理概要

**業務上の目的・背景**：NativeAOTは、.NETアプリケーションをJIT（Just-In-Time）コンパイルに依存せず、ビルド時にネイティブコードへ完全に変換することで、起動時間の大幅な短縮、メモリ使用量の削減、デプロイメントの簡素化を実現する。コンテナ環境やサーバーレス環境、組み込みシステムなど、起動速度と軽量性が重要なシナリオで特に有効である。

**機能の利用シーン**：
- AWS Lambda、Azure Functions等のサーバーレス環境でのコールドスタート改善
- Kubernetesポッドの迅速なスケールアウト
- 組み込みシステムやIoTデバイスへのデプロイ
- セキュリティが重要な環境でのリバースエンジニアリング困難化
- 単一実行ファイルとしての配布

**主要な処理内容**：
1. ILC（IL Compiler）によるILからネイティブコードへの事前コンパイル
2. モジュール登録とグローバルデータの初期化
3. 静的コンストラクター（eager class constructors）の実行
4. Frozen Stringsの最適化
5. Unboxingスタブの生成とマージ
6. スタートアップコードの実行

**関連システム・外部連携**：
- リンカー（MSVC linker、ld、lld）との連携
- プラットフォームネイティブライブラリとのP/Invoke

**権限による制御**：
- ネイティブコード実行権限（OSレベル）
- アセンブリトリミングによる不要コード除去

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | NativeAOTはビルドツールであり、画面を持たない |

## 機能種別

ビルド処理 / コード変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| IL Assembly | バイナリ | Yes | 事前コンパイル対象のマネージドアセンブリ | PE形式検証 |
| RuntimeConfigJson | JSON | No | ランタイム構成 | JSON形式検証 |
| PublishAot | bool | Yes | AOT発行の有効化フラグ | - |
| TrimMode | string | No | トリミングモード | link/copy/copyused |

### 入力データソース

- プロジェクトファイル（.csproj）
- ビルド出力のILアセンブリ
- RD.XML（ランタイムディレクティブ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行ファイル | バイナリ | ネイティブ実行ファイル（.exe / ELF） |
| PDB/DWARF | デバッグ情報 | シンボル情報（オプション） |

### 出力先

- ファイルシステム上の発行ディレクトリ

## 処理フロー

### 処理シーケンス

```
1. ILC（IL Compiler）によるIL解析
   └─ アセンブリのメタデータ解析
2. 依存関係の解決とトリミング
   └─ 使用されるコードの特定
3. ネイティブコード生成
   └─ ILからネイティブコードへの変換
4. オブジェクトファイル出力
   └─ .obj/.o ファイルの生成
5. リンク処理
   └─ ランタイムライブラリとの結合
6. 実行ファイル生成
   └─ スタンドアロン実行ファイルの出力
```

### フローチャート

```mermaid
flowchart TD
    A[ソースコード] --> B[コンパイル（Roslyn）]
    B --> C[ILアセンブリ]
    C --> D[ILC - IL Compiler]
    D --> E[依存関係解析]
    E --> F[トリミング]
    F --> G[ネイティブコード生成]
    G --> H[.obj/.o ファイル]
    H --> I[リンカー]
    I --> J[ネイティブ実行ファイル]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | リフレクション制限 | 動的リフレクションはRD.XMLで明示的に指定が必要 | AOTビルド時 |
| BR-02 | 動的コード生成禁止 | System.Reflection.Emitは使用不可 | AOTビルド時 |
| BR-03 | トリミング警告 | 未使用コードのトリミングによる互換性警告 | トリミング有効時 |

### 計算ロジック

- モジュール境界検出：セクション境界マーカー（__modules_a/__modules_z）による範囲特定
- Unboxingスタブソート：.unbox$A〜.unbox$Z間のアルファベット順マージ

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | NativeAOTはデータベースを直接操作しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IL3000-IL3099 | トリミング警告 | トリムに非互換なコードパターン | RD.XMLでの明示的保持 |
| AOT0001 | 動的コード警告 | Reflection.Emit使用 | 静的な代替実装への置換 |
| Link Error | リンクエラー | 未解決シンボル | P/Invokeターゲット確認 |

### リトライ仕様

- ビルドエラー：リトライなし（ソース修正が必要）

## トランザクション仕様

NativeAOTはビルドツールであり、トランザクション管理は該当しない。

## パフォーマンス要件

- 起動時間：JITビルドの1/10〜1/100（ミリ秒オーダー）
- メモリ使用量：ランタイムメタデータ不要による50%削減
- ファイルサイズ：トリミングにより依存関係のみ含む最小サイズ

## セキュリティ考慮事項

- ネイティブコード化によるIL逆コンパイルの困難化
- トリミングによる攻撃対象面の削減
- スタックプロテクション、ASLR等のOS保護機構との互換性

## 備考

- .NET 7で正式サポート、.NET 8で大幅に改善
- コンソールアプリケーションとライブラリで最もよくサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.cpp | `src/coreclr/nativeaot/Bootstrap/main.cpp` | モジュール境界マーカー、セクション定義 |
| 1-2 | TypeManagerHandle.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/TypeManagerHandle.cs` | 型マネージャーハンドル |

**読解のコツ**:
- **main.cpp 21-29行目**: MSVCでの.modules$A〜.modules$Zセクション定義。リンカーがこれらを.rdataにマージする。
- **main.cpp 32-38行目**: ReadyToRunデータポインタの配置説明
- **main.cpp 40-44行目**: Unboxingスタブのマージ処理

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StartupCodeHelpers.Extensions.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/CompilerHelpers/StartupCode/StartupCodeHelpers.Extensions.cs` | スタートアップ処理 |

**主要処理フロー**:
- **20-21行目**: `GetLoadedModules()` - ロードされたモジュールの取得
- **23-31行目**: `InitializeCommandLineArgsW()` - Windowsコマンドライン引数の初期化
- **33-41行目**: `InitializeCommandLineArgs()` - Unixコマンドライン引数の初期化
- **43-56行目**: `GetMainMethodArguments()` - Main()メソッドへの引数抽出
- **64-78行目**: `Shutdown()` - フォアグラウンドスレッド待機とシャットダウン

#### Step 3: ランタイムサポートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RuntimeAugments.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/Augments/RuntimeAugments.cs` | ランタイム拡張 |
| 3-2 | TypeLoaderCallbacks.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/Augments/TypeLoaderCallbacks.cs` | 型ローダーコールバック |

#### Step 4: プラットフォーム固有処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.cpp (Apple) | `src/coreclr/nativeaot/Bootstrap/main.cpp` (73-80行目) | macOS/iOS固有のセクション定義 |
| 4-2 | dllmain.cpp | `src/coreclr/nativeaot/Bootstrap/dllmain/dllmain.cpp` | Windows DLLエントリーポイント |

**主要処理フロー（Apple）**:
- **73-80行目**: `__asm("section$start$__DATA$__modules")` - macOS固有のセクション境界

### プログラム呼び出し階層図

```
ネイティブエントリーポイント (main / WinMain)
    │
    ├─ __modules_a〜__modules_z のモジュール列挙
    │      └─ 各モジュールのReadyToRunデータ取得
    │
    ├─ StartupCodeHelpers.InitializeCommandLineArgs()
    │      └─ Environment.s_commandLineArgs 設定
    │
    ├─ 静的コンストラクター実行
    │      └─ eager class constructors
    │
    ├─ Main()メソッド実行
    │      └─ GetMainMethodArguments()
    │
    └─ StartupCodeHelpers.Shutdown()
           ├─ Thread.WaitForForegroundThreads()
           └─ Environment.ShutdownCore()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ILアセンブリ ──────▶ ILC (IL Compiler) ──────▶ .obj/.o ファイル
     │                    │
     │                    ▼
     │              依存関係解析
     │                    │
     ▼                    ▼
トリミング指定 ──────▶ 未使用コード除去 ──────▶ 最小コードセット
     │                    │
     │                    ▼
     │              リンカー
     │                    │
     ▼                    ▼
ランタイムライブラリ ────▶ 結合 ──────▶ ネイティブ実行ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.cpp | `src/coreclr/nativeaot/Bootstrap/main.cpp` | ソース | ブートストラップ、セクション定義 |
| dllmain.cpp | `src/coreclr/nativeaot/Bootstrap/dllmain/dllmain.cpp` | ソース | Windows DLLエントリーポイント |
| StartupCodeHelpers.Extensions.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/CompilerHelpers/StartupCode/StartupCodeHelpers.Extensions.cs` | ソース | スタートアップ処理 |
| RuntimeAugments.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/Augments/RuntimeAugments.cs` | ソース | ランタイム拡張API |
| TypeLoaderCallbacks.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/Augments/TypeLoaderCallbacks.cs` | ソース | 型ローダーコールバック |
| InteropHelpers.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/CompilerHelpers/InteropHelpers.cs` | ソース | P/Invokeサポート |
| ThrowHelpers.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/CompilerHelpers/ThrowHelpers.cs` | ソース | 例外スロー補助 |
| ThreadStatics.cs | `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/ThreadStatics.cs` | ソース | スレッド静的変数 |
