# 機能設計書 34-Microsoft.Extensions.Hosting

## 概要

本ドキュメントは、Microsoft.Extensions.Hosting（ホスティング）機能の設計内容を記述する。この機能は.NETアプリケーションの汎用ホスト機能を提供し、アプリケーションのライフサイクル管理、設定、ロギング、依存性注入を統合的に管理する。

### 本機能の処理概要

Microsoft.Extensions.Hostingは、アプリケーションの起動から終了までのライフサイクルを管理する汎用ホストフレームワークである。バックグラウンドサービス、設定、ロギング、DIコンテナを統合し、一貫したアプリケーション基盤を提供する。

**業務上の目的・背景**：現代のアプリケーション開発では、Webサーバー、Worker Service、コンソールアプリケーションなど、様々な形態のアプリケーションが存在する。このライブラリは、これらに共通するアプリケーション基盤（設定、ロギング、DI、ライフサイクル管理）を抽象化し、統一的な開発・運用体験を提供する。Graceful Shutdownのサポートにより、安全なアプリケーション終了も保証する。

**機能の利用シーン**：Worker Service、バックグラウンドタスク処理、マイクロサービス、コンソールアプリケーション、WindowsサービスおよびSystemdサービスの開発で使用される。ASP.NET Coreの内部でも使用されている。

**主要な処理内容**：
1. IHostBuilderを通じたホストの構成
2. HostingEnvironmentの初期化（環境名、ContentRootPath等）
3. 設定、ロギング、DIの自動セットアップ
4. IHostedServiceのライフサイクル管理
5. アプリケーション起動・停止シグナルの処理
6. BackgroundServiceの実行管理

**関連システム・外部連携**：Microsoft.Extensions.Configuration、Microsoft.Extensions.Logging、Microsoft.Extensions.DependencyInjection、Microsoft.Extensions.Options、ASP.NET Coreと密接に連携する。

**権限による制御**：ホスト自体に権限制御はないが、IHostedServiceの実装で権限チェックを行うことが可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | WasmBrowser（ASP.NET Core統合） | 補助機能 | ASP.NET Core汎用ホスト機能との統合 |
| 17 | BlazorHosted（ASP.NET Core統合） | 補助機能 | ASP.NET Core汎用ホスト機能との統合 |
| 27 | Runtime Config Test（StartupHook） | 補助機能 | スタートアップフックのホスティング統合テスト |

## 機能種別

データ連携 / ライフサイクル管理 / サービス管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| args | string[] | No | コマンドライン引数 | - |
| environmentName | string | No | 環境名（Development/Staging/Production等） | - |
| contentRootPath | string | No | コンテンツルートパス | 有効なパス |
| applicationName | string | No | アプリケーション名 | - |

### 入力データソース

- 環境変数（DOTNET_ENVIRONMENT、ASPNETCORE_ENVIRONMENT）
- コマンドライン引数
- 設定ファイル（appsettings.json等）
- プログラマティックな設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Host | IHost | 構築されたホスト |
| HostEnvironment | IHostEnvironment | ホスト環境情報 |
| ApplicationLifetime | IHostApplicationLifetime | アプリケーションライフサイクル |
| Services | IServiceProvider | DIコンテナ |

### 出力先

- アプリケーションの実行コンテキスト
- IHostedServiceの実行

## 処理フロー

### 処理シーケンス

```
1. HostBuilder作成フェーズ
   └─ Host.CreateDefaultBuilder()またはnew HostBuilder()
2. 設定構成フェーズ
   └─ ConfigureHostConfiguration、ConfigureAppConfiguration
3. サービス登録フェーズ
   └─ ConfigureServicesでDI登録
4. ホスト構築フェーズ
   └─ Build()でHostを生成
5. 起動フェーズ
   └─ RunAsync()またはStartAsync()でIHostedServiceを起動
6. 実行フェーズ
   └─ アプリケーション実行中
7. 停止フェーズ
   └─ StopAsync()でIHostedServiceを停止
```

### フローチャート

```mermaid
flowchart TD
    A[HostBuilder作成] --> B[ConfigureHostConfiguration]
    B --> C[InitializeHostingEnvironment]
    C --> D[ConfigureAppConfiguration]
    D --> E[ConfigureServices]
    E --> F[Build]
    F --> G[Host生成]
    G --> H{RunAsync/StartAsync}
    H --> I[IHostedService.StartAsync]
    I --> J[アプリケーション実行中]
    J --> K{停止シグナル?}
    K -->|Yes| L[IHostedService.StopAsync]
    L --> M[Dispose]
    K -->|No| J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | 起動順序 | IHostedServiceは登録順に起動 | StartAsync時 |
| BR-34-02 | 停止順序 | IHostedServiceは登録逆順に停止 | StopAsync時 |
| BR-34-03 | タイムアウト | ShutdownTimeout内に停止完了必須 | StopAsync時 |
| BR-34-04 | 開発環境検証 | Development環境ではValidateOnBuild、ValidateScopesが有効 | IsDevelopment()時 |

### 計算ロジック

環境名決定順序：
1. HostDefaults.EnvironmentKey設定値
2. DOTNET_ENVIRONMENT環境変数
3. デフォルト値「Production」

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | Build()の2回呼び出し | 1回のみ呼び出す |
| - | OperationCanceledException | シャットダウンタイムアウト | ShutdownTimeoutを延長 |
| - | HostAbortedException | Ctrl+C等による強制終了 | 適切なクリーンアップを実装 |

### リトライ仕様

IHostedServiceの起動失敗時、BackgroundServiceExceptionBehaviorに応じてホスト停止または継続

## トランザクション仕様

該当なし

## パフォーマンス要件

- 起動時間: 設定読み込みとDI構築に依存
- シャットダウン: HostOptions.ShutdownTimeout（デフォルト30秒）以内

## セキュリティ考慮事項

- 設定からの機密情報はUser SecretsまたはAzure Key Vaultを使用
- IHostedServiceでの権限チェックを推奨
- 環境変数からの設定読み込みに注意

## 備考

- HostApplicationBuilderは.NET 6で追加された簡易APIで、より直感的な設定が可能
- BackgroundServiceはIHostedServiceの簡易実装で、ExecuteAsyncをオーバーライドして使用
- ConsoleLifetimeはCtrl+Cシグナルを処理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ホスティングシステムの基本的なインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IHostBuilder.cs | `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostBuilder.cs` | ホストビルダーインターフェース |
| 1-2 | IHost.cs | `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHost.cs` | ホストインターフェース。Services、StartAsync、StopAsync |
| 1-3 | IHostedService.cs | `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostedService.cs` | ホステッドサービスインターフェース |
| 1-4 | IHostApplicationLifetime.cs | `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostApplicationLifetime.cs` | ライフサイクルイベント |

**読解のコツ**: IHostBuilder→IHost→IHostedServiceの関係を理解する。BuilderでHostを構築し、Hostが複数のHostedServiceを管理する。

#### Step 2: エントリーポイントを理解する

HostBuilderの構築フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HostBuilder.cs | `src/libraries/Microsoft.Extensions.Hosting/src/HostBuilder.cs` | ホストビルダーの実装。Build、ConfigureServices等 |
| 2-2 | Host.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Host.cs` | 静的ファクトリメソッド。CreateDefaultBuilder |

**主要処理フロー**:
1. **152-171行目**: Build()でホストを構築。一度のみ呼び出し可能
2. **208-218行目**: InitializeHostConfiguration()で設定を初期化
3. **222-251行目**: InitializeHostingEnvironment()で環境を設定
4. **277-289行目**: InitializeAppConfiguration()でアプリケーション設定を構築
5. **334-364行目**: InitializeServiceProvider()でDIコンテナを構築
6. **351-354行目**: Development環境ではValidateOnBuild、ValidateScopesを有効化

#### Step 3: ホスト実装を理解する

内部ホストの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Host.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Internal/Host.cs` | 内部ホスト実装。StartAsync、StopAsyncの実装 |
| 3-2 | HostOptions.cs | `src/libraries/Microsoft.Extensions.Hosting/src/HostOptions.cs` | ホストオプション。ShutdownTimeout等 |

**主要処理フロー**:
- **StartAsync()**: IHostedServiceを順番に起動
- **StopAsync()**: IHostedServiceを逆順に停止

#### Step 4: ライフタイム管理を理解する

アプリケーションライフサイクルの管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ApplicationLifetime.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ApplicationLifetime.cs` | ライフサイクルイベント管理 |
| 4-2 | ConsoleLifetime.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ConsoleLifetime.cs` | コンソールライフタイム（Ctrl+C処理） |

**主要処理フロー**:
- **ApplicationStarted/Stopping/Stopped**: ライフサイクルトークン
- **StopApplication()**: アプリケーション停止をトリガー

### プログラム呼び出し階層図

```
HostBuilder.Build()
    │
    ├─ InitializeHostConfiguration()
    │      └─ ConfigurationBuilder.Build()
    │
    ├─ InitializeHostingEnvironment()
    │      └─ HostingEnvironment設定
    │
    ├─ InitializeHostBuilderContext()
    │
    ├─ InitializeAppConfiguration()
    │      └─ ConfigurationBuilder.Build()
    │
    └─ InitializeServiceProvider()
           │
           ├─ PopulateServiceCollection()
           │      │
           │      ├─ AddSingleton<IHostEnvironment>
           │      ├─ AddSingleton<IHostApplicationLifetime>
           │      ├─ AddSingleton<IHost>
           │      ├─ AddLogging()
           │      └─ AddOptions()
           │
           └─ ServiceProvider構築

Host.RunAsync()
    │
    ├─ StartAsync()
    │      │
    │      └─ foreach IHostedService
    │             └─ service.StartAsync()
    │
    ├─ WaitForShutdownAsync()
    │
    └─ StopAsync()
           │
           └─ foreach IHostedService (逆順)
                  └─ service.StopAsync()
```

### データフロー図

```
[入力]                     [処理]                        [出力]

args/env vars ───▶ HostBuilder ───▶ Configuration
                        │                    │
                        ▼                    ▼
ConfigureServices ─▶ ServiceCollection ─▶ ServiceProvider
                        │                    │
                        ▼                    ▼
                   Build() ──────────▶ IHost
                                          │
                                          ▼
                                   StartAsync()
                                          │
                                          ▼
                              foreach IHostedService.StartAsync()
                                          │
                                          ▼
                              WaitForShutdown
                                          │
                                          ▼
                              foreach IHostedService.StopAsync()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HostBuilder.cs | `src/libraries/Microsoft.Extensions.Hosting/src/HostBuilder.cs` | ソース | ホストビルダー実装 |
| Host.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Host.cs` | ソース | 静的ファクトリ |
| Host.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Internal/Host.cs` | ソース | 内部ホスト実装 |
| HostApplicationBuilder.cs | `src/libraries/Microsoft.Extensions.Hosting/src/HostApplicationBuilder.cs` | ソース | 簡易ビルダー |
| HostOptions.cs | `src/libraries/Microsoft.Extensions.Hosting/src/HostOptions.cs` | ソース | ホストオプション |
| HostingEnvironment.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Internal/HostingEnvironment.cs` | ソース | 環境情報 |
| ApplicationLifetime.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ApplicationLifetime.cs` | ソース | ライフサイクル管理 |
| ConsoleLifetime.cs | `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ConsoleLifetime.cs` | ソース | コンソールライフタイム |
| BackgroundServiceExceptionBehavior.cs | `src/libraries/Microsoft.Extensions.Hosting/src/BackgroundServiceExceptionBehavior.cs` | ソース | 例外動作設定 |
| HostingHostBuilderExtensions.cs | `src/libraries/Microsoft.Extensions.Hosting/src/HostingHostBuilderExtensions.cs` | ソース | 拡張メソッド |
