# 機能設計書 39-Microsoft.Extensions.FileSystemGlobbing

## 概要

本ドキュメントは、Microsoft.Extensions.FileSystemGlobbing（Globパターン）機能の設計内容を記述する。この機能はGlobパターン（ワイルドカードパターン）によるファイルマッチングを提供し、柔軟なファイル検索を実現する。

### 本機能の処理概要

Microsoft.Extensions.FileSystemGlobbingは、Globパターン（*.txt、**/*.cs等）を使用してファイルシステム上のファイルを検索するライブラリである。インクルードパターンとエクスクルードパターンを組み合わせた柔軟なファイルマッチングを提供する。

**業務上の目的・背景**：ビルドツール、静的サイトジェネレーター、ファイル監視などでは、特定のパターンに一致するファイルを効率的に検索する必要がある。このライブラリは、.gitignoreやglob構文でおなじみのパターン記法を使用したファイル検索を提供し、開発者にとって直感的なAPI を実現する。

**機能の利用シーン**：ビルドシステムでのソースファイル検索、PhysicalFileProviderでのファイル変更監視、テスト対象ファイルの指定、ファイルコピー/削除の対象指定など、パターンベースのファイル操作が必要なシナリオで使用される。

**主要な処理内容**：
1. Matcherを通じたパターンの登録
2. インクルードパターン（AddInclude）の追加
3. エクスクルードパターン（AddExclude）の追加
4. ディレクトリに対するパターンマッチング実行
5. マッチ結果の取得

**関連システム・外部連携**：Microsoft.Extensions.FileProviders.Physical（Watch機能）、MSBuild、dotnet CLIと連携する。

**権限による制御**：ファイルシステムアクセス権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに該当なし |

## 機能種別

データ連携 / ファイル検索

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pattern | string | Yes | Globパターン | 有効なGlob構文 |
| directoryInfo | DirectoryInfoBase | Yes | 検索対象ディレクトリ | null不可 |
| comparisonType | StringComparison | No | 比較方法 | OrdinalIgnoreCaseがデフォルト |

### 入力データソース

- Globパターン文字列
- ファイルシステムのディレクトリ構造

### パターン構文

| パターン | 説明 | 例 |
|---------|------|-----|
| * | 0文字以上の任意の文字（ディレクトリ区切り以外） | *.txt |
| ** | 任意の深さのディレクトリ | **/*.cs |
| ? | 任意の1文字 | file?.txt |
| .. | 親ディレクトリ | ../shared/* |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| PatternMatchingResult | PatternMatchingResult | マッチング結果 |
| HasMatches | bool | マッチがあるかどうか |
| Files | IEnumerable<FilePatternMatch> | マッチしたファイル一覧 |

### 出力先

- アプリケーションコードへのマッチ結果
- ファイルパスの一覧

## 処理フロー

### 処理シーケンス

```
1. Matcher作成フェーズ
   └─ Matcherインスタンス作成、比較方法設定
2. パターン登録フェーズ
   └─ AddInclude/AddExcludeでパターンを追加
3. パターンビルドフェーズ
   └─ PatternBuilderでIPatternに変換
4. 実行フェーズ
   └─ Execute()でディレクトリを走査
5. マッチングフェーズ
   └─ MatcherContextでパターンマッチングを実行
6. 結果収集フェーズ
   └─ PatternMatchingResultを返却
```

### フローチャート

```mermaid
flowchart TD
    A[Matcher作成] --> B[AddInclude]
    B --> C[AddExclude]
    C --> D[Execute呼び出し]
    D --> E[MatcherContext作成]
    E --> F{preserveFilterOrder?}
    F -->|Yes| G[パターン順序どおりに処理]
    F -->|No| H[Include先、Exclude後]
    G --> I[ディレクトリ走査]
    H --> I
    I --> J[各ファイルにパターンマッチ]
    J --> K{Include match?}
    K -->|Yes| L{Exclude match?}
    L -->|No| M[結果に追加]
    L -->|Yes| N[除外]
    K -->|No| N
    M --> O[PatternMatchingResult]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-01 | デフォルト大小文字 | 大文字小文字を区別しない（OrdinalIgnoreCase） | デフォルト |
| BR-39-02 | Include/Exclude順序 | デフォルトではInclude優先、Excludeで除外 | preserveFilterOrder=false |
| BR-39-03 | フィルタ順序保持 | preserveFilterOrder=trueで登録順に処理 | preserveFilterOrder=true |
| BR-39-04 | 相対パス | 結果は基準ディレクトリからの相対パス | 常時 |

### 計算ロジック

パターンマッチング順序（デフォルト）：
1. 全てのインクルードパターンでマッチング
2. マッチしたファイルに対してエクスクルードパターンを適用
3. エクスクルードにマッチしないファイルを結果に含める

パターンマッチング順序（preserveFilterOrder=true）：
1. パターンを登録順に処理
2. Include→ファイルを追加、Exclude→ファイルを除外
3. 最終的な結果を返却

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArgumentNullException | directoryInfoがnull | 有効なディレクトリを指定 |

### リトライ仕様

リトライなし（同期的なファイルシステム操作）

## トランザクション仕様

該当なし

## パフォーマンス要件

- マッチング: O(n * m)（ファイル数 * パターン数）
- **パターンは事前コンパイルされる
- ディレクトリ走査はファイル数に依存

## セキュリティ考慮事項

- ..パターンは親ディレクトリへの移動を許可（意図的）
- パストラバーサル攻撃への対策は呼び出し側の責任

## 備考

- PhysicalFileProvider.Watch()で内部的に使用される
- MSBuildのGlobとほぼ互換
- 空の結果でもPatternMatchingResultは非null

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Globマッチングの基本的なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Matcher.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Matcher.cs` | メインクラス。AddInclude、AddExclude、Executeメソッド |
| 1-2 | PatternMatchingResult.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/PatternMatchingResult.cs` | マッチング結果 |
| 1-3 | FilePatternMatch.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/FilePatternMatch.cs` | 個別ファイルのマッチ情報 |

**読解のコツ**: Matcher→PatternMatchingResult→FilePatternMatchの階層を理解する。Matcherがパターンを管理し、Executeで結果を生成する。

#### Step 2: パターンビルダーを理解する

パターン文字列からIPatternへの変換を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PatternBuilder.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternBuilder.cs` | パターン文字列のパース |
| 2-2 | IPattern.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPattern.cs` | パターンインターフェース |

**主要処理フロー**:
- **PatternBuilder.Build()**: 文字列パターンを解析してIPatternを生成
- **/**パターンは任意深度、*パターンはディレクトリ内のワイルドカード

#### Step 3: マッチングコンテキストを理解する

実際のマッチング処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MatcherContext.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/MatcherContext.cs` | マッチング実行コンテキスト |

**主要処理フロー**:
- **Execute()**: ディレクトリを走査し、パターンマッチングを実行
- インクルードパターンでマッチしたファイルを収集
- エクスクルードパターンでフィルタリング

#### Step 4: Matcherの実装を理解する

Matcherクラスの詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Matcher.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Matcher.cs` | コンストラクタ、AddInclude、AddExclude、Execute |

**主要処理フロー**:
1. **97-147行目**: コンストラクタでComparisonTypeとpreserveFilterOrderを設定
2. **161-169行目**: AddInclude()でインクルードパターンを追加
3. **183-191行目**: AddExclude()でエクスクルードパターンを追加
4. **198-205行目**: Execute()でMatcherContextを作成し実行

### プログラム呼び出し階層図

```
Matcher.Execute(directoryInfo)
    │
    ├─ _preserveFilterOrder?
    │      │
    │      ├─ true → new MatcherContext(_includeOrExcludePatterns, ...)
    │      │
    │      └─ false → new MatcherContext(_includePatterns, _excludePatterns, ...)
    │
    └─ MatcherContext.Execute()
           │
           ├─ ディレクトリ走査
           │
           ├─ foreach pattern in includePatterns
           │      │
           │      └─ pattern.Match(file) → マッチなら追加
           │
           ├─ foreach pattern in excludePatterns
           │      │
           │      └─ pattern.Match(file) → マッチなら除外
           │
           └─ new PatternMatchingResult(files)

Matcher.AddInclude(pattern)
    │
    └─ _preserveFilterOrder?
           │
           ├─ true → _includeOrExcludePatterns.Add({Value: Build(pattern), IsInclude: true})
           │
           └─ false → _includePatterns.Add(Build(pattern))

PatternBuilder.Build(pattern)
    │
    ├─ パターン文字列を解析
    │
    └─ IPattern（LiteralPathSegment, WildcardPathSegment等）を生成
```

### データフロー図

```
[入力]                      [処理]                        [出力]

AddInclude(pattern) ───▶ PatternBuilder.Build() ───▶ IPattern追加
AddExclude(pattern) ───▶ PatternBuilder.Build() ───▶ IPattern追加
                                 │
                                 ▼
Execute(directoryInfo) ───▶ MatcherContext作成
                                 │
                                 ▼
                          ディレクトリ走査
                                 │
                                 ▼
                     foreach file in directory
                                 │
                                 ▼
                     Include/Excludeパターンマッチ
                                 │
                                 ▼
                     PatternMatchingResult
                                 │
                                 ▼
                     FilePatternMatch[]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Matcher.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Matcher.cs` | ソース | メインマッチャー |
| PatternMatchingResult.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/PatternMatchingResult.cs` | ソース | マッチング結果 |
| FilePatternMatch.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/FilePatternMatch.cs` | ソース | ファイルマッチ情報 |
| MatcherContext.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/MatcherContext.cs` | ソース | マッチングコンテキスト |
| PatternBuilder.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternBuilder.cs` | ソース | パターンビルダー |
| IPattern.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPattern.cs` | ソース | パターンインターフェース |
| DirectoryInfoBase.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/DirectoryInfoBase.cs` | ソース | ディレクトリ抽象化 |
| DirectoryInfoWrapper.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/DirectoryInfoWrapper.cs` | ソース | DirectoryInfoラッパー |
| MatcherExtensions.cs | `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/MatcherExtensions.cs` | ソース | 拡張メソッド |
