# 機能設計書 40-WasmAppBuilder

## 概要

本ドキュメントは、WasmAppBuilder（WebAssemblyアプリビルド）機能の設計内容を記述する。この機能はWebAssembly（Wasm）アプリケーションのビルドプロセスを支援するMSBuildタスクを提供する。

### 本機能の処理概要

WasmAppBuilderは、.NETアセンブリをWebAssemblyにパッケージングするためのMSBuildタスクを提供する。アセンブリ、ネイティブアセット、サテライトアセンブリ、ランタイム設定を収集し、WebAssemblyアプリケーションの出力ディレクトリを構成する。

**業務上の目的・背景**：Blazor WebAssemblyやその他のWebAssembly .NETアプリケーションのビルドには、アセンブリファイルの収集、ランタイム設定の生成、ICUデータの処理など、複数の処理が必要である。このタスクは、これらの処理をMSBuildパイプラインに統合し、自動化されたビルドプロセスを提供する。

**機能の利用シーン**：Blazor WebAssemblyアプリケーションのビルド、.NET WebAssemblyアプリケーションのパッケージング、WebAssembly用のランタイム設定生成で使用される。

**主要な処理内容**：
1. アセンブリファイルの出力ディレクトリへのコピー
2. ネイティブアセット（dotnet.native.wasm等）の処理
3. サテライトアセンブリ（ローカライズリソース）の処理
4. runtimeconfig.jsonの更新と出力
5. ホスト設定の構成
6. ファイルシステムに含めるファイルの処理

**関連システム・外部連携**：MSBuild、.NET SDK、Blazor、ブラウザランタイム、Node.js/V8ホストと連携する。

**権限による制御**：ファイルシステムへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | WasmBasic | 主機能 | 基本的なWebAssemblyアプリのビルド |
| 14 | WasmBrowserTest | 主機能 | ブラウザ向けWebAssemblyテストアプリのビルド |
| 15 | WasmBrowser | 主機能 | ブラウザ向けWebAssemblyアプリのビルド |

## 機能種別

ビルドタスク / パッケージング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AppDir | string | Yes | 出力ディレクトリ | null不可 |
| Assemblies | string[] | Yes | ビルド対象アセンブリ | null不可 |
| MainAssemblyName | string | Yes | メインアセンブリ名 | null不可 |
| NativeAssets | ITaskItem[] | Yes | ネイティブアセット | null不可 |
| HostConfigs | ITaskItem[] | Yes | ホスト設定 | null不可 |
| RuntimeConfigJsonPath | string | No | runtimeconfig.jsonパス | - |
| SatelliteAssemblies | ITaskItem[] | No | サテライトアセンブリ | - |
| IcuDataFileNames | string[] | No | ICUデータファイル名 | - |
| InvariantGlobalization | bool | No | Invariantモード | - |
| FilesToIncludeInFileSystem | ITaskItem[] | No | ファイルシステムに含めるファイル | - |
| ExtraFilesToDeploy | ITaskItem[] | No | 追加デプロイファイル | - |
| DefaultHostConfig | string | No | デフォルトホスト設定 | - |
| RuntimeArgsForHost | ITaskItem[] | No | ランタイム引数 | - |

### 入力データソース

- MSBuildプロジェクトファイル
- .NETビルド出力
- runtimeconfig.json

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FileWrites | string[] | 書き込まれたファイル一覧 |

### 出力先

- AppDirで指定された出力ディレクトリ
- 更新されたruntimeconfig.json

## 処理フロー

### 処理シーケンス

```
1. 入力検証フェーズ
   └─ ValidateArguments()で必須パラメータを検証
2. 内部実行フェーズ
   └─ ExecuteInternal()を呼び出し
3. サテライトアセンブリ処理フェーズ
   └─ ProcessSatelliteAssemblies()でカルチャ別に処理
4. ランタイム設定更新フェーズ
   └─ UpdateRuntimeConfigJson()で設定を更新
5. ファイルコピーフェーズ
   └─ FileCopyChecked()でファイルをコピー
6. 出力記録フェーズ
   └─ _fileWritesに書き込んだファイルを記録
```

### フローチャート

```mermaid
flowchart TD
    A[Execute呼び出し] --> B{ExecuteInternal}
    B -->|成功| C[return true]
    B -->|LogAsErrorException| D[Log.LogError]
    D --> E[return false]
    B --> F[ValidateArguments]
    F --> G{検証成功?}
    G -->|No| H[エラーログ]
    G -->|Yes| I[ProcessSatelliteAssemblies]
    I --> J[カルチャごとにコールバック]
    J --> K[UpdateRuntimeConfigJson]
    K --> L{RuntimeConfigJsonPathあり?}
    L -->|No| M[スキップ]
    L -->|Yes| N[JSONパース]
    N --> O[wasmHostProperties更新]
    O --> P[perHostConfig追加]
    P --> Q[runtimeArgs追加]
    Q --> R[ファイル書き出し]
    R --> S[_fileWrites.Add]
    S --> T[FileCopyChecked]
    T --> U[ファイルコピー]
    U --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-01 | メインアセンブリ検証 | MainAssemblyNameがAssemblies内に存在すること | UpdateRuntimeConfigJson時 |
| BR-40-02 | 重複チェック | 同名メインアセンブリが複数あるとエラー | UpdateRuntimeConfigJson時 |
| BR-40-03 | カルチャメタデータ | サテライトアセンブリにはCultureNameメタデータが必要 | ProcessSatelliteAssemblies時 |
| BR-40-04 | デフォルトホスト設定 | DefaultHostConfigが未設定の場合、最初のHostConfigを使用 | UpdateRuntimeConfigJson時 |

### 計算ロジック

runtimeconfig.json更新ロジック：
1. 既存のruntimeconfig.jsonをパース
2. runtimeOptions.wasmHostPropertiesノードを取得または作成
3. mainAssembly、defaultConfig、perHostConfig、runtimeArgsを設定
4. 更新されたJSONをAppDirに出力

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | LogAsErrorException | メインアセンブリが見つからない | MainAssemblyNameを確認 |
| - | LogAsErrorException | メインアセンブリが複数 | アセンブリ名を一意にする |
| - | LogAsErrorException | runtimeconfig.jsonのパース失敗 | JSONの形式を確認 |
| - | LogAsErrorException | ファイルコピー失敗 | アクセス権限を確認 |
| WASM0002 | Warning | サテライトアセンブリのCultureNameなし | CultureNameメタデータを追加 |

### リトライ仕様

リトライなし（MSBuildタスクとして実行）

## トランザクション仕様

該当なし（ファイルシステム操作は個別に実行）

## パフォーマンス要件

- ビルド時間に影響を与えるため、ファイル操作は効率的に行う
- 大量のアセンブリがある場合でも適切にスケール

## セキュリティ考慮事項

- 出力ディレクトリへの書き込み権限が必要
- コピー元ファイルの存在確認を行う
- パス操作でのインジェクション攻撃への注意

## 備考

- このタスクはMicrosoft.WebAssembly.Build.Tasksアセンブリに含まれる
- WasmAppBuilderTask等の具象クラスがWasmAppBuilderBaseTaskを継承
- AddToRuntimeConfigはサブクラスでオーバーライド可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MSBuildタスクの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WasmAppBuilderBaseTask.cs | `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs` | 基底タスククラス。入力プロパティ、出力プロパティ |

**読解のコツ**: MSBuildのTask抽象クラスを継承し、[Required]属性で必須入力を、[Output]属性で出力を定義する。Execute()メソッドがタスクのエントリーポイント。

#### Step 2: エントリーポイントを理解する

タスク実行フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WasmAppBuilderBaseTask.cs | `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs` | Execute、ExecuteInternal、ValidateArguments |

**主要処理フロー**:
1. **56-67行目**: Execute()でtry-catchでExecuteInternal()を呼び出し
2. **69行目**: ExecuteInternal()は抽象メソッドとしてサブクラスで実装
3. **71行目**: ValidateArguments()はオーバーライド可能な検証メソッド

#### Step 3: サテライトアセンブリ処理を理解する

ローカライズリソースの処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WasmAppBuilderBaseTask.cs | `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs` | ProcessSatelliteAssemblies |

**主要処理フロー**:
- **73-88行目**: ProcessSatelliteAssemblies()でサテライトアセンブリを処理
- カルチャメタデータを取得し、コールバックに渡す
- CultureNameがない場合は警告（WASM0002）

#### Step 4: ランタイム設定更新を理解する

runtimeconfig.jsonの更新処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WasmAppBuilderBaseTask.cs | `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs` | UpdateRuntimeConfigJson |

**主要処理フロー**:
- **90-163行目**: UpdateRuntimeConfigJson()でruntimeconfig.jsonを更新
- **101-106行目**: メインアセンブリの検証
- **108-118行目**: JSONパースとruntimeOptionsノード取得
- **120-130行目**: wasmHostPropertiesの設定
- **132-152行目**: perHostConfigとruntimeArgsの追加
- **156-162行目**: 更新されたJSONを出力

### プログラム呼び出し階層図

```
WasmAppBuilderTask.Execute() (MSBuildから呼び出し)
    │
    └─ WasmAppBuilderBaseTask.Execute()
           │
           ├─ try
           │      │
           │      └─ ExecuteInternal() (抽象メソッド、サブクラスで実装)
           │             │
           │             ├─ ValidateArguments()
           │             │
           │             ├─ ProcessSatelliteAssemblies(callback)
           │             │      │
           │             │      └─ foreach satellite in SatelliteAssemblies
           │             │             │
           │             │             └─ callback((fullPath, culture))
           │             │
           │             ├─ UpdateRuntimeConfigJson()
           │             │      │
           │             │      ├─ JsonNode.Parse(runtimeconfig.json)
           │             │      │
           │             │      ├─ wasmHostPropertiesノード更新
           │             │      │
           │             │      ├─ AddToRuntimeConfig() (virtual)
           │             │      │
           │             │      └─ JSON書き出し
           │             │
           │             └─ FileCopyChecked(src, dst, label)
           │                    │
           │                    └─ File.Copy() + _fileWrites.Add()
           │
           └─ catch (LogAsErrorException)
                  │
                  └─ Log.LogError()
```

### データフロー図

```
[入力]                         [処理]                         [出力]

Assemblies ─────────────▶ WasmAppBuilderTask ─────────────▶ AppDir/
MainAssemblyName ──────▶       │                            ├── *.dll
NativeAssets ───────────▶      │                            ├── dotnet.native.wasm
SatelliteAssemblies ───▶       │                            ├── {culture}/*.dll
HostConfigs ────────────▶      │                            └── *.runtimeconfig.json
RuntimeConfigJsonPath ─▶       │
                               ▼
                    ProcessSatelliteAssemblies()
                               │
                               ▼
                    UpdateRuntimeConfigJson()
                               │
                               ▼
                    FileCopyChecked()
                               │
                               ▼
                        _fileWrites[]
                               │
                               ▼
                        FileWrites出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WasmAppBuilderBaseTask.cs | `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs` | ソース | 基底タスク |
| WasmAppBuilder.cs | `src/tasks/WasmAppBuilder/WasmAppBuilder.cs` | ソース | 具象タスク |
| IcuSharding.cs | `src/tasks/WasmAppBuilder/IcuSharding.cs` | ソース | ICUシャーディング |
| LogAsErrorException.cs | `src/tasks/WasmAppBuilder/LogAsErrorException.cs` | ソース | エラー例外 |
| JsonExtensions.cs | `src/tasks/WasmAppBuilder/JsonExtensions.cs` | ソース | JSON拡張 |
| PInvokeTableGenerator.cs | `src/tasks/WasmAppBuilder/PInvokeTableGenerator.cs` | ソース | P/Invokeテーブル |
