# 機能設計書 42-Crossgen2Tasks

## 概要

本ドキュメントは、.NETランタイムにおけるCrossgen2Tasksビルドタスクの機能設計を記述したものである。Crossgen2Tasksは、CoreCLRランタイム向けにReadyToRun（R2R）形式の事前コンパイル済みイメージを生成する機能を提供するMSBuildタスク群である。

### 本機能の処理概要

Crossgen2Tasksは、.NETアセンブリをReadyToRun形式に事前コンパイルすることで、アプリケーションの起動時間を短縮し、JITコンパイルのオーバーヘッドを削減する。

**業務上の目的・背景**：サーバーサイドアプリケーションやデスクトップアプリケーションにおいて、起動時間の短縮は重要な要件である。ReadyToRunコンパイルにより、実行時のJITコンパイル時間を削減し、アプリケーションの応答性を向上させる。また、Tiered Compilationと組み合わせることで、初期起動時の性能と長期実行時の最適化のバランスを取ることができる。

**機能の利用シーン**：
- .NETアプリケーションの公開（dotnet publish）時
- 自己完結型アプリケーションのビルド時
- パフォーマンスクリティカルなサーバーアプリケーションのデプロイ時
- コンテナイメージの最適化時

**主要な処理内容**：
1. 入力アセンブリと参照アセンブリの解析
2. Crossgen2コンパイラの呼び出しと引数管理
3. PGO（Profile-Guided Optimization）プロファイルの適用
4. 並列コンパイルによるビルド時間の短縮
5. PDB/PerfMapの生成（デバッグ情報）
6. 複合イメージ（Composite）ビルドのサポート
7. クロスプラットフォームコンパイルのサポート

**関連システム・外部連携**：
- Crossgen2コンパイラ（CoreCLR AOTコンパイラ）
- JITコンパイラ（clrjit）
- MSBuildシステム（ビルドタスクとして実行）

**権限による制御**：特になし。ファイルシステムへの読み書き権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ビルドプロセス（CLI） | 主機能 | dotnet publish -p:PublishReadyToRun=true から呼び出される |

## 機能種別

ビルドタスク / コンパイル処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| InputFilePaths | Dictionary | Yes | 入力ファイルパス辞書 | 少なくとも1つ以上 |
| ReferenceFilePaths | Dictionary | No | 参照アセンブリパス辞書 | - |
| OutputFilePath | string | No | 出力ファイルパス | - |
| TargetArchitecture | TargetArchitecture | No | ターゲットアーキテクチャ | arm, arm64, x86, x64等 |
| TargetOS | TargetOS | No | ターゲットOS | windows, linux, osx等 |
| Optimize | bool | No | 最適化を有効にするか | - |
| OptimizeSpace | bool | No | サイズ最適化を優先 | - |
| OptimizeTime | bool | No | 速度最適化を優先 | - |
| MibcFilePaths | string[] | No | MIBCプロファイルパス | - |
| Composite | bool | No | 複合イメージモード | - |
| Parallelism | int | No | 並列度 | - |
| JitPath | string | No | JITコンパイラのパス | - |
| Pdb | bool | No | PDB生成フラグ | - |
| PerfMap | bool | No | PerfMap生成フラグ | - |

### 入力データソース

- ビルドプロセスから渡されるアセンブリファイル（.dll）
- MIBCプロファイルファイル（.mibc）
- 参照アセンブリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| OutputFile | string | ReadyToRunイメージファイル |
| PdbFile | string | デバッグシンボルファイル（オプション） |
| PerfMapFile | string | Linux向けパフォーマンスマップ（オプション） |

### 出力先

- ReadyToRunイメージ（.dll）: OutputFilePath
- PDBファイル（.pdb）: PdbPath
- PerfMapファイル（.map）: PerfMapPath

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ 入力ファイル、参照、出力パスの設定
   └─ 最適化モードの決定

2. ターゲットプラットフォームの設定
   └─ アーキテクチャ（x64, arm64等）の決定
   └─ OS（Windows, Linux, macOS等）の決定

3. 最適化設定の適用
   └─ PGOプロファイルの読み込み
   └─ 最適化レベルの設定

4. コンパイル実行
   └─ 単一ファイルコンパイル
   └─ または複合イメージコンパイル

5. 出力ファイルの生成
   └─ ReadyToRunイメージの出力
   └─ デバッグ情報の出力（オプション）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[ターゲット設定]
    C --> D{Compositeモード?}
    D -->|Yes| E[複合イメージビルド]
    D -->|No| F[単一ファイルビルド]
    E --> G{PGOプロファイルあり?}
    F --> G
    G -->|Yes| H[プロファイル適用]
    G -->|No| I[デフォルト最適化]
    H --> I
    I --> J[Crossgen2実行]
    J --> K{PDB/PerfMap?}
    K -->|Yes| L[デバッグ情報生成]
    K -->|No| M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-42-01 | 並列度制限 | 32ビット環境では並列度を4以下に制限 | !Environment.Is64BitProcess時 |
| BR-42-02 | アーキテクチャ検証 | armelはarmに変換される | targetarch=armel時 |
| BR-42-03 | PEセクションアライメント | 4096以上かつ2の累乗である必要 | CustomPESectionAlignment指定時 |
| BR-42-04 | 命令セット検証 | ターゲットアーキテクチャでサポートされる命令セットのみ許可 | instructionset指定時 |

### 計算ロジック

並列度の決定:
```csharp
parallelism = Math.Min(24, Environment.ProcessorCount);
if (!Environment.Is64BitProcess)
    parallelism = Math.Min(4, parallelism);
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 入力ファイルが空 | 少なくとも1つのファイルを指定 |
| - | 設定エラー | 無効なアーキテクチャ | 有効なアーキテクチャを指定 |
| - | 設定エラー | 無効なPEセクションアライメント | 4096以上の2の累乗を指定 |
| - | コンパイルエラー | コード生成失敗 | 詳細ログを確認 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 並列コンパイルにより大規模アプリケーションのビルド時間を短縮
- デフォルト並列度は24または論理CPU数の小さい方
- 32ビットプロセスでは仮想アドレス空間の制約から並列度を制限

## セキュリティ考慮事項

- 入力ファイルパスの検証
- 署名付きアセンブリの取り扱い（CompositeKeyFile）

## 備考

- Crossgen2はCrossgen（v1）の後継であり、より高度な最適化をサポート
- ReadyToRunイメージはフレームワーク依存アプリケーションと自己完結型アプリケーションの両方で使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コマンドラインオプションの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Crossgen2RootCommand.cs | `src/coreclr/tools/aot/crossgen2/Crossgen2RootCommand.cs` | 17-150行目のオプション定義 |

**読解のコツ**: System.CommandLineライブラリを使用したオプション定義パターンを理解する。Option<T>とArgument<T>の違いに注目。

#### Step 2: エントリーポイントを理解する

コマンドのセットアップとアクションハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Crossgen2RootCommand.cs | `src/coreclr/tools/aot/crossgen2/Crossgen2RootCommand.cs` | 157-290行目のコンストラクタとSetAction |

**主要処理フロー**:
1. **157-224行目**: オプションの登録
2. **225-289行目**: SetActionでメイン処理を定義
3. **268行目**: Program.Runの呼び出し

#### Step 3: ターゲットアーキテクチャ解析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Crossgen2RootCommand.cs | `src/coreclr/tools/aot/crossgen2/Crossgen2RootCommand.cs` | 350-360行目のMakeTargetArchitecture |

**主要処理フロー**:
- **353-355行目**: armelをarmに変換
- **359行目**: Helpers.GetTargetArchitectureで実際のアーキテクチャ取得

#### Step 4: 並列度制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Crossgen2RootCommand.cs | `src/coreclr/tools/aot/crossgen2/Crossgen2RootCommand.cs` | 362-376行目のMakeParallelism |

### プログラム呼び出し階層図

```
Crossgen2RootCommand
    │
    ├─ コンストラクタ
    │      └─ オプション登録
    │
    └─ SetAction
           │
           ├─ 引数検証
           │
           ├─ CustomPESectionAlignment検証
           │
           ├─ MakeReproPackage（オプション）
           │
           └─ Program.Run()
                  │
                  ├─ 設定読み込み
                  │
                  ├─ コンパイラ初期化
                  │
                  └─ コンパイル実行
```

### データフロー図

```
[入力]                    [処理]                           [出力]

InputFiles(.dll) ───▶ Crossgen2コンパイラ ──────────▶ R2Rイメージ(.dll)
                              │
References(.dll) ───▶         │
                              │
MibcProfiles(.mibc) ─▶        │
                              │
                              ├───────────────────▶ PDB(.pdb)
                              │
                              └───────────────────▶ PerfMap(.map)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Crossgen2RootCommand.cs | `src/coreclr/tools/aot/crossgen2/Crossgen2RootCommand.cs` | ソース | コマンドライン定義 |
| Crossgen2Tasks.csproj | `src/tasks/Crossgen2Tasks/Crossgen2Tasks.csproj` | プロジェクト | MSBuildタスクプロジェクト |
| Microsoft.NET.CrossGen.targets | `src/tasks/Crossgen2Tasks/Microsoft.NET.CrossGen.targets` | MSBuild | ビルドターゲット定義 |
| Crossgen2Runner.cs | `src/coreclr/tools/r2rtest/Crossgen2Runner.cs` | ソース | テスト用ランナー |
| Linux-Hugepage-Crossgen2.md | `docs/design/features/Linux-Hugepage-Crossgen2.md` | ドキュメント | Linuxヒュージページ設計 |
