# 機能設計書 43-AndroidAppBuilder

## 概要

本ドキュメントは、.NETランタイムにおけるAndroidAppBuilderビルドタスクの機能設計を記述したものである。AndroidAppBuilderは、Android向け.NETアプリケーションをAPKパッケージとしてビルドする機能を提供するMSBuildタスクである。

### 本機能の処理概要

AndroidAppBuilderは、.NETアセンブリとランタイムコンポーネントをAndroid APKパッケージにバンドルし、Android端末で実行可能なアプリケーションを生成する。

**業務上の目的・背景**：.NET MAUIやBlazor Hybridなどのクロスプラットフォームフレームワークにおいて、Android向けのネイティブアプリケーションを生成する必要がある。AndroidAppBuilderは、.NETアセンブリ、AOTコンパイル済みバイナリ、ネイティブライブラリをAPKとしてパッケージ化し、Android端末にデプロイ可能な形式を生成する。

**機能の利用シーン**：
- .NET MAUIアプリケーションのAndroid向けビルド時
- Androidワークロードを使用したアプリ開発時
- モバイルテストランナーの実行時
- Android向けパフォーマンステスト時

**主要な処理内容**：
1. Android SDK/NDKのセットアップと検証
2. ネイティブコード（C/C++）のコンパイル
3. マネージドアセンブリとAOTオブジェクトのバンドル
4. APKパッケージの生成と署名
5. ランタイムコンポーネントの組み込み
6. 環境変数と診断ポートの設定
7. ライブラリモードのサポート

**関連システム・外部連携**：
- Android SDK（aapt, apksigner等）
- Android NDK（clang, ld等）
- Mono/CoreCLRランタイム
- MSBuildシステム

**権限による制御**：特になし。ファイルシステムおよびAndroid SDKツールへのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ビルドプロセス（CLI） | 主機能 | dotnet build/publish から間接的に呼び出される |

## 機能種別

ビルドタスク / パッケージング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| RuntimeHeaders | string[] | Yes | ランタイムヘッダーのパス | - |
| AppDir | string | Yes | アプリケーションコンテンツディレクトリ | - |
| RuntimeIdentifier | string | Yes | ランタイム識別子（android-arm64等） | - |
| OutputDir | string | Yes | 出力ディレクトリ | - |
| ProjectName | string | Yes | プロジェクト名 | - |
| MainLibraryFileName | string | No | エントリーポイントDLL | - |
| Assemblies | ITaskItem[] | No | アセンブリリスト | - |
| EnvironmentVariables | ITaskItem[] | No | 環境変数設定 | - |
| ForceAOT | bool | No | エミュレータでもAOT強制 | - |
| ForceFullAOT | bool | No | 全アセンブリAOT | - |
| IsLibraryMode | bool | No | ライブラリモード | - |
| StaticLinkedRuntime | bool | No | ランタイム静的リンク | - |
| RuntimeComponents | string[] | No | 有効なランタイムコンポーネント | - |
| DiagnosticPorts | string | No | 診断ポート設定 | - |
| AndroidSdk | string | No | Android SDKパス | - |
| AndroidNdk | string | No | Android NDKパス | - |
| MinApiLevel | string | No | 最小APIレベル | - |
| TargetApiLevel | string | No | ターゲットAPIレベル | - |
| BuildApiLevel | string | No | ビルドAPIレベル | - |
| StripDebugSymbols | bool | No | デバッグシンボル削除 | - |
| ForceInterpreter | bool | No | インタープリタモード強制 | - |

### 入力データソース

- ビルドプロセスから渡されるアセンブリファイル（.dll）
- AOTコンパイル済みオブジェクトファイル（.o）
- ネイティブ依存ライブラリ（.so）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ApkBundlePath | string | 生成されたAPKファイルのパス |
| ApkPackageId | string | APKのパッケージID |

### 出力先

- APKファイル（.apk）: OutputDir

## 処理フロー

### 処理シーケンス

```
1. 設定の初期化
   └─ Android SDK/NDKパスの設定
   └─ APIレベルの決定

2. ネイティブコードのコンパイル
   └─ ランタイムヘッダーの適用
   └─ AOTオブジェクトの収集

3. アプリケーションのパッケージング
   └─ マネージドアセンブリのバンドル
   └─ ネイティブライブラリのコピー
   └─ リソースの処理

4. APKの生成
   └─ APKファイルの作成
   └─ 署名の適用

5. 出力メタデータの設定
   └─ ApkBundlePathの設定
   └─ ApkPackageIdの設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[設定初期化]
    B --> C{IsLibraryMode?}
    C -->|No| D[AOTオブジェクト収集]
    C -->|Yes| E[ライブラリモード処理]
    D --> F[ネイティブコード準備]
    E --> F
    F --> G[アセンブリバンドル]
    G --> H[APK生成]
    H --> I{署名あり?}
    I -->|Yes| J[APK署名]
    I -->|No| K[出力設定]
    J --> K
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | AOT必須条件 | 静的リンクまたはForceAOT時はAOTファイル必須 | !ForceInterpreter && (StaticLinkedRuntime \|\| ForceAOT) |
| BR-43-02 | ランタイムフレーバー | RuntimeFlavorでMono/CoreCLR選択 | 常時 |
| BR-43-03 | プロジェクト名制約 | プロジェクト名にスペース不可 | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 必須パラメータエラー | RuntimeHeaders等が未指定 | 必須パラメータを指定 |
| - | AOTファイル不足 | 静的リンクビルドでAOTファイルなし | AOTコンパイルを実行 |
| - | SDK/NDKエラー | Android SDK/NDKが見つからない | パスを正しく設定 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- APKビルドは数秒から数分（アセンブリ数に依存）

## セキュリティ考慮事項

- APK署名によるアプリケーション整合性の保証
- KeyStorePathによる署名鍵の管理

## 備考

- Android向け.NETアプリケーションはMonoまたはCoreCLRランタイムで動作可能
- ライブラリモードでは自己完結型ライブラリとしてビルド

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、タスクの入力パラメータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AndroidAppBuilder.cs | `src/tasks/AndroidAppBuilder/AndroidAppBuilder.cs` | 10-116行目のプロパティ定義 |

**読解のコツ**: [Required]属性が付与されたプロパティが必須パラメータ。[Output]属性が出力値。

#### Step 2: エントリーポイントを理解する

MSBuildタスクのエントリーポイントであるExecuteメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AndroidAppBuilder.cs | `src/tasks/AndroidAppBuilder/AndroidAppBuilder.cs` | 117-148行目のExecute()メソッド |

**主要処理フロー**:
1. **119行目**: ApkBuilderインスタンス作成
2. **120-143行目**: プロパティの転送
3. **144行目**: BuildApk()呼び出し

#### Step 3: ApkBuilderの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ApkBuilder.cs（推定） | `src/tasks/AndroidAppBuilder/` | 実際のAPKビルドロジック |

### プログラム呼び出し階層図

```
AndroidAppBuilderTask.Execute()
    │
    ├─ new ApkBuilder(Log)
    │
    ├─ プロパティ転送
    │      ├─ ProjectName
    │      ├─ AppDir
    │      ├─ OutputDir
    │      ├─ AndroidSdk/Ndk
    │      └─ ... (その他設定)
    │
    └─ apkBuilder.BuildApk()
           │
           ├─ ネイティブコードコンパイル
           │
           ├─ アセンブリバンドル
           │
           └─ APK生成・署名
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Assemblies(.dll) ───┬
                    │
AOT Objects(.o) ───┼───▶ ApkBuilder.BuildApk() ──────▶ APK(.apk)
                    │
NativeDeps(.so) ───┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AndroidAppBuilder.cs | `src/tasks/AndroidAppBuilder/AndroidAppBuilder.cs` | ソース | MSBuildタスク定義 |
| AndroidAppBuilder.csproj | `src/tasks/AndroidAppBuilder/AndroidAppBuilder.csproj` | プロジェクト | ビルド設定 |
