# 機能設計書 44-AppleAppBuilder

## 概要

本ドキュメントは、.NETランタイムにおけるAppleAppBuilderビルドタスクの機能設計を記述したものである。AppleAppBuilderは、iOS/macOS/tvOS向け.NETアプリケーションをビルドする機能を提供するMSBuildタスクである。

### 本機能の処理概要

AppleAppBuilderは、.NETアセンブリとランタイムコンポーネントをAppleプラットフォーム向けのアプリケーションバンドル（.app）としてビルドし、Xcodeプロジェクトまたは CMakeプロジェクトを生成する。

**業務上の目的・背景**：.NET MAUIやBlazor Hybridなどのクロスプラットフォームフレームワークにおいて、Apple プラットフォーム（iOS、macOS、tvOS）向けのネイティブアプリケーションを生成する必要がある。AppleAppBuilderは、.NETアセンブリ、AOTコンパイル済みバイナリ、ネイティブライブラリをアプリバンドルとしてパッケージ化し、Appleデバイスにデプロイ可能な形式を生成する。

**機能の利用シーン**：
- .NET MAUIアプリケーションのiOS/macOS向けビルド時
- iOSワークロードを使用したアプリ開発時
- Mac Catalystアプリケーションのビルド時
- tvOSアプリケーションのビルド時
- iOSシミュレータ向けビルド時

**主要な処理内容**：
1. ターゲットOS（iOS、tvOS、macOS等）の判定と設定
2. Xcodeプロジェクトの生成
3. CMakeプロジェクトの生成（オプション）
4. AOTコンパイル済みアセンブラファイルの統合
5. アプリバンドル（.app）のビルド
6. コード署名とプロビジョニング
7. シンボルテーブルのストリップ（オプション）

**関連システム・外部連携**：
- Xcode（xcodebuild）
- CMake
- Mono/CoreCLR/NativeAOTランタイム
- Apple開発者証明書・プロビジョニングプロファイル

**権限による制御**：デバイス向けビルドにはDevTeamProvisioningの設定が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ビルドプロセス（CLI） | 主機能 | dotnet build/publish から間接的に呼び出される |

## 機能種別

ビルドタスク / パッケージング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TargetOS | string | Yes | ターゲットOS（ios, tvos, iossimulator等） | 有効なApple OS名 |
| ProjectName | string | Yes | プロジェクト名（スペース不可） | スペースを含まない |
| AppDir | string | Yes | アプリケーションコンテンツディレクトリ | - |
| Assemblies | ITaskItem[] | Yes | アセンブリリスト | - |
| Arch | string | Yes | ターゲットアーキテクチャ | arm64, arm, x64 |
| MonoRuntimeHeaders | string[] | No | Monoランタイムヘッダー | Monoランタイム使用時必須 |
| MainLibraryFileName | string | No | エントリーポイントDLL | - |
| EnvironmentVariables | ITaskItem[] | No | 環境変数設定 | - |
| OutputDirectory | string | No | 出力ディレクトリ | - |
| Optimized | bool | No | 最適化ビルド | - |
| DevTeamProvisioning | string | No | 開発チームID | デバイスビルド時必須 |
| BuildAppBundle | bool | No | アプリバンドルをビルド | - |
| GenerateXcodeProject | bool | No | Xcodeプロジェクト生成 | - |
| GenerateCMakeProject | bool | No | CMakeプロジェクト生成 | - |
| ForceAOT | bool | No | シミュレータでもAOT強制 | - |
| ForceInterpreter | bool | No | インタープリタモード強制 | - |
| Runtime | string | No | ランタイム種別 | MonoVM, NativeAOT, CoreCLR |
| EnableAppSandbox | bool | No | App Sandbox有効化 | Mac Catalyst用 |
| StripSymbolTable | bool | No | シンボルテーブル削除 | - |
| RuntimeComponents | string[] | No | 有効なランタイムコンポーネント | - |
| DiagnosticPorts | string | No | 診断ポート設定 | - |

### 入力データソース

- ビルドプロセスから渡されるアセンブリファイル（.dll）
- AOTコンパイル済みアセンブラファイル（.s）
- LLVMオブジェクトファイル（.o）
- AOTデータファイル（.aotdata）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AppBundlePath | string | 生成されたアプリバンドルのパス |
| XcodeProjectPath | string | 生成されたXcodeプロジェクトのパス |

### 出力先

- アプリバンドル（.app）: OutputDirectory
- Xcodeプロジェクト（.xcodeproj）: OutputDirectory

## 処理フロー

### 処理シーケンス

```
1. ランタイム選択の検証
   └─ MonoVM/NativeAOT/CoreCLRの検証
   └─ 互換性チェック

2. 入力の検証
   └─ MainLibraryFileNameの存在確認
   └─ ProjectNameのスペースチェック

3. ビルドディレクトリの準備
   └─ 出力ディレクトリの作成
   └─ AOTファイルの収集

4. プロジェクト生成
   └─ Xcodeプロジェクト生成
   └─ またはCMakeプロジェクト生成

5. アプリバンドルのビルド（オプション）
   └─ xcodebuildの実行
   └─ コード署名

6. シンボルストリップ（オプション）
   └─ デバッグシンボルの抽出
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ランタイム検証]
    B --> C{ランタイム有効?}
    C -->|No| Z[エラー終了]
    C -->|Yes| D[入力検証]
    D --> E{Xcodeプロジェクト生成?}
    E -->|Yes| F[GenerateXCode]
    E -->|No| G{CMakeプロジェクト生成?}
    G -->|Yes| H[GenerateCMake]
    G -->|No| Z2[終了]
    F --> I{BuildAppBundle?}
    I -->|Yes| J[BuildAppBundle]
    I -->|No| Z2
    J --> K{StripSymbolTable?}
    K -->|Yes| L[StripApp]
    K -->|No| M[LogAppSize]
    L --> M
    M --> Z2
    H --> Z2
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | ランタイム制約 | NativeAOT/CoreCLRではMonoRuntimeHeaders不可 | Runtime=NativeAOT/CoreCLR時 |
| BR-44-02 | Monoランタイム必須項目 | Monoランタイム使用時はMonoRuntimeHeaders必須 | Runtime=MonoVM時 |
| BR-44-03 | App Sandbox制約 | App Sandbox有効時はDevTeamProvisioning必須 | EnableAppSandbox=true時 |
| BR-44-04 | 診断ポート制約 | DiagnosticPorts使用時はdiagnostics_tracingコンポーネント必須 | DiagnosticPorts設定時 |
| BR-44-05 | プロジェクト名制約 | プロジェクト名にスペース不可 | 常時 |
| BR-44-06 | AOT必須条件 | 静的リンクまたはForceAOT時はAOTファイル必須 | !ForceInterpreter && (shouldStaticLink \|\| ForceAOT) |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ランタイムエラー | 無効なRuntime値 | MonoVM/NativeAOT/CoreCLRを指定 |
| - | 入力エラー | MainLibraryFileNameが存在しない | 正しいパスを指定 |
| - | 入力エラー | ProjectNameにスペース含む | スペースを除去 |
| - | 設定エラー | DiagnosticPorts使用時にコンポーネント不足 | diagnostics_tracingを追加 |
| - | 設定エラー | App Sandbox時にDevTeamProvisioningなし | チームIDを設定 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- Xcodeプロジェクトビルドは数分かかる場合がある

## セキュリティ考慮事項

- コード署名によるアプリケーション整合性の保証
- DevTeamProvisioningによる開発チームの認証
- App Sandboxによるアプリケーション隔離（Mac Catalyst）

## 備考

- Apple向け.NETアプリケーションはMonoVM、NativeAOT、CoreCLRの3つのランタイムから選択可能
- デバイス向けビルドにはApple Developer Programへの登録が必要
- シミュレータ向けビルドは開発者登録なしでも可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、タスクの入力パラメータとランタイム種別を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AppleAppBuilder.cs | `src/tasks/AppleAppBuilder/AppleAppBuilder.cs` | 13-199行目のプロパティ定義 |

**読解のコツ**: [Required]属性、[Output]属性、TargetRuntime enumに注目。

#### Step 2: ランタイム検証を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppleAppBuilder.cs | `src/tasks/AppleAppBuilder/AppleAppBuilder.cs` | 200-235行目のValidateRuntimeSelection() |

**主要処理フロー**:
1. **202-204行目**: Enum.TryParseでランタイム種別解析
2. **207-229行目**: NativeAOT/CoreCLR時の制約チェック
3. **232-233行目**: MonoVM時のヘッダー必須チェック

#### Step 3: Executeメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppleAppBuilder.cs | `src/tasks/AppleAppBuilder/AppleAppBuilder.cs` | 237-384行目のExecute() |

**主要処理フロー**:
- **239-240行目**: shouldStaticLink、isDeviceの判定
- **244-250行目**: MainLibraryFileNameの検証
- **277-306行目**: AOTファイル収集
- **348-354行目**: Xcodeプロジェクト生成
- **355-375行目**: アプリバンドルビルド

### プログラム呼び出し階層図

```
AppleAppBuilderTask.Execute()
    │
    ├─ ValidateRuntimeSelection()
    │
    ├─ AOTファイル収集
    │      ├─ AssemblerFile取得
    │      ├─ LlvmObjectFile取得
    │      └─ AotDataFile取得
    │
    ├─ generator = new Xcode(...)
    │
    ├─ GenerateXcodeProject?
    │      └─ generator.GenerateXCode(...)
    │              │
    │              └─ BuildAppBundle?
    │                     └─ generator.BuildAppBundle(...)
    │                            │
    │                            └─ StripSymbolTable?
    │                                   └─ generator.StripApp(...)
    │
    └─ GenerateCMakeProject?
           └─ generator.GenerateCMake(...)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Assemblies(.dll) ───┬
                    │
AOT Assembler(.s) ─┼───▶ Xcode.GenerateXCode() ──────▶ .xcodeproj
                    │           │
LLVM Objects(.o) ──┼           ▼
                    │     xcodebuild ────────────────▶ .app
AOT Data(.aotdata)─┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppleAppBuilder.cs | `src/tasks/AppleAppBuilder/AppleAppBuilder.cs` | ソース | MSBuildタスク定義 |
| AppleAppBuilder.csproj | `src/tasks/AppleAppBuilder/AppleAppBuilder.csproj` | プロジェクト | ビルド設定 |
