# 機能設計書 47-PInvokeTableGenerator

## 概要

本ドキュメントは、.NETランタイムにおけるPInvokeTableGeneratorの機能設計を記述したものである。PInvokeTableGeneratorは、WebAssembly環境でのP/Invoke（プラットフォーム呼び出し）とコールバック関数をサポートするためのネイティブコードテーブルを生成する。

### 本機能の処理概要

PInvokeTableGeneratorは、.NETアセンブリに含まれるP/Invoke宣言とコールバック属性を解析し、WebAssemblyランタイムがネイティブ関数を呼び出すために必要なCコードを自動生成する。

**業務上の目的・背景**：Blazor WebAssemblyでは、ブラウザのJavaScript APIや他のネイティブ機能にアクセスするためにP/Invokeが使用される。WebAssembly環境では、ネイティブ関数のシンボルを静的に解決する必要があるため、P/Invokeテーブルを事前に生成し、リンク時に組み込む必要がある。また、マネージドコードからネイティブコードへのコールバック（UnmanagedCallersOnly）もサポートする必要がある。

**機能の利用シーン**：
- Blazor WebAssemblyアプリケーションのビルド時
- WebAssembly AOTコンパイル時
- ネイティブ相互運用を使用するWASMアプリ開発時

**主要な処理内容**：
1. アセンブリのスキャンとP/Invoke宣言の収集
2. コールバック属性（UnmanagedCallersOnly等）の収集
3. P/Invokeテーブル（Cコード）の生成
4. ネイティブ→マネージドインターポップコードの生成
5. シグネチャのマッピング（.NET型→C型）
6. WASMインポート/エクスポート属性の処理

**関連システム・外部連携**：
- WebAssemblyビルドパイプライン
- Monoインタープリタ/AOT
- MSBuildシステム

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ビルドプロセス（CLI） | 主機能 | WebAssemblyビルド時に呼び出される |

## 機能種別

ビルドタスク / コード生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| assemblies | Assembly[] | Yes | スキャン対象アセンブリ | - |
| pinvokeModules | string[] | Yes | P/Invokeモジュール名リスト | - |
| outputPath | string | Yes | 出力Cファイルのパス | - |
| isLibraryMode | bool | No | ライブラリモードフラグ | - |

### 入力データソース

- ビルドされた.NETアセンブリ（.dll）
- アセンブリ内のDllImport属性
- UnmanagedCallersOnly属性
- WasmImportLinkage属性

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Cソースファイル | string | P/Invokeテーブルを含むCコード |
| signatures | IEnumerable<string> | 検出されたシグネチャの一覧 |

### 出力先

- Cソースファイル: outputPath

## 処理フロー

### 処理シーケンス

```
1. アセンブリのスキャン
   └─ 各型のP/Invokeメソッド収集
   └─ コールバックメソッド収集

2. P/Invokeテーブルの生成
   └─ モジュール別のインポートテーブル
   └─ 関数宣言の生成

3. ネイティブ→インターポップの生成
   └─ エントリ関数の生成
   └─ 引数/戻り値のマーシャリングコード

4. 出力ファイルの書き込み
   └─ ヘッダーインクルード
   └─ テーブル定義
   └─ インターポップ関数
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ScanAssembly]
    B --> C[P/Invoke収集]
    C --> D[コールバック収集]
    D --> E[Generate呼び出し]
    E --> F[EmitPInvokeTable]
    F --> G[EmitNativeToInterp]
    G --> H[ファイル書き込み]
    H --> I{変更あり?}
    I -->|Yes| J[ファイル更新]
    I -->|No| K[スキップ]
    J --> L[終了]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | 可変引数非サポート | 可変引数P/Invokeは警告を出してスキップ | 引数数が一致しない場合 |
| BR-47-02 | Blittable型のみ | コールバックはBlittable型パラメータのみサポート | コールバック時 |
| BR-47-03 | WasmLinkageマングリング | WasmImportLinkageの場合はシンボル名をマングル | WasmLinkage=true時 |
| BR-47-04 | 重複シンボル禁止 | 同一シンボル名のコールバックは不可 | コールバック定義時 |

### 計算ロジック

C型マッピング:
```csharp
switch (type.Name) {
    case "Void": return "void";
    case "Double": return "double";
    case "Single": return "float";
    case "Int64": return "int64_t";
    case "Int32": return "int32_t";
    case "IntPtr": return "void *";
    // ...
}
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| WASM0001 | 警告 | 可変引数P/Invoke検出 | P/Invokeを修正 |
| WASM0060 | 情報 | 非Blittable型（ValueType以外） | 型を修正 |
| WASM0061 | 情報 | 非Sequential型 | LayoutKind.Sequentialを指定 |
| - | エラー | 重複コールバックシンボル | シンボル名を変更 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- 差分検出により不要な再生成をスキップ
- Blittable判定結果をキャッシュ

## セキュリティ考慮事項

- 生成されたCコードはビルド時にのみ使用
- リテラル文字列のエスケープ処理

## 備考

- WebAssembly環境でのP/Invokeは静的リンクが基本
- __Internal モジュールは特別扱い

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、P/Invokeとコールバックの情報を保持するクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PInvokeTableGenerator.cs | `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` | 19-36行目のフィールド定義 |

**読解のコツ**:
- pinvokes: P/Invoke情報のリスト
- callbacks: コールバック情報のリスト
- signatures: 検出されたシグネチャのハッシュセット

#### Step 2: アセンブリスキャンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PInvokeTableGenerator.cs | `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` | 38-42行目のScanAssembly() |

**主要処理フロー**:
- 各型についてCollectPInvokesを呼び出し

#### Step 3: P/Invokeテーブル生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PInvokeTableGenerator.cs | `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` | 65-185行目のEmitPInvokeTable() |

**主要処理フロー**:
- **89-99行目**: ヘッダーの出力
- **101-135行目**: 関数宣言の生成
- **137-169行目**: モジュール別インポートテーブル

#### Step 4: 型マッピングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PInvokeTableGenerator.cs | `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` | 198-238行目のMapType() |

#### Step 5: ネイティブ→インターポップ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | PInvokeTableGenerator.cs | `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` | 323-402行目のEmitNativeToInterp() |

### プログラム呼び出し階層図

```
PInvokeTableGenerator
    │
    ├─ ScanAssembly()
    │      └─ _pinvokeCollector.CollectPInvokes()
    │
    └─ Generate()
           │
           ├─ EmitPInvokeTable()
           │      │
           │      ├─ GenPInvokeDecl() [for each pinvoke]
           │      │      └─ MapType() [for each parameter]
           │      │
           │      └─ CEntryPoint() [symbol mangling]
           │
           └─ EmitNativeToInterp()
                  │
                  ├─ callback symbol generation
                  │
                  └─ interp entry code generation
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Assembly(.dll) ───▶ ScanAssembly()
                          │
                          ├─ P/Invoke収集
                          │
                          └─ Callback収集
                                 │
                                 ▼
                          Generate()
                                 │
                          ┌──────┴──────┐
                          ▼             ▼
               EmitPInvokeTable  EmitNativeToInterp
                          │             │
                          └──────┬──────┘
                                 ▼
                          pinvoke.c (Cソース)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PInvokeTableGenerator.cs | `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` | ソース | メイン生成ロジック |
| PInvokeCollector.cs | `src/tasks/WasmAppBuilder/mono/PInvokeCollector.cs` | ソース | P/Invoke情報収集 |
| PInvoke.cs | `src/tasks/WasmAppBuilder/mono/PInvoke.cs` | ソース | P/Invokeデータ構造 |
| PInvokeCallback.cs | `src/tasks/WasmAppBuilder/mono/PInvokeCallback.cs` | ソース | コールバックデータ構造 |
| SignatureMapper.cs | `src/tasks/WasmAppBuilder/mono/SignatureMapper.cs` | ソース | シグネチャマッピング |
