# 機能設計書 5-ガベージコレクター

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるガベージコレクター（GC）の機能設計について記述する。GCは自動メモリ管理機能を提供し、世代別GC、バックグラウンドGCをサポートする。

### 本機能の処理概要

**業務上の目的・背景**：ガベージコレクターは、.NETアプリケーションの自動メモリ管理を担当する中核コンポーネントである。開発者が明示的にメモリを解放する必要をなくし、メモリリークやダングリングポインタ等のメモリ関連バグを防止する。世代別ヒープ構造とバックグラウンドGCにより、アプリケーションの応答性を維持しながら効率的なメモリ回収を実現する。

**機能の利用シーン**：
- オブジェクトのヒープ割り当て時
- メモリ使用量がしきい値を超えた時の自動GC実行
- 明示的なGC.Collect()呼び出し時
- アプリケーションのアイドル時間でのバックグラウンドGC

**主要な処理内容**：
1. オブジェクトのヒープ割り当て（SOH/LOH/POH）
2. 世代別ガベージコレクション（Gen0/Gen1/Gen2）
3. バックグラウンドGC（BGC）による並行収集
4. ファイナライザー処理
5. ピン留めオブジェクトの管理
6. カード表による世代間参照の追跡

**関連システム・外部連携**：
- JITコンパイラ（GCセーフポイント情報）
- 実行エンジン（スレッド同期、サスペンション）
- EventPipe（診断イベント出力）

**権限による制御**：
- GCモード設定（Workstation/Server）
- メモリ制限設定（HeapHardLimit）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | Wasm Browser Threading Sample | 補助機能 | スレッド内でのメモリ管理とGCコレクション |
| 7 | Log Profiler Sample | 補助機能 | ヒープショット取得のためのメモリ管理 |

## 機能種別

システム基盤機能 / メモリ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 割り当てサイズ | size_t | Yes | オブジェクト割り当て要求サイズ | 正の整数 |
| GC理由 | gc_reason | No | GCトリガー理由 | 有効な列挙値 |
| 世代番号 | int | No | コレクション対象世代 | 0-2 |

### 入力データソース

- オブジェクト割り当て要求（new演算子）
- GC.Collect()呼び出し
- メモリ圧力検出

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 割り当てアドレス | void* | 割り当てられたメモリアドレス |
| GC結果 | 構造体 | 回収サイズ、処理時間等 |
| ETWイベント | イベント | GC診断情報 |

### 出力先

- マネージドヒープ
- ETW/EventPipe

## 処理フロー

### 処理シーケンス

```
1. 割り当て要求
   └─ サイズに応じてSOH/LOH/POH選択
2. 世代0での割り当て試行
   └─ 空き領域の確認
3. GCトリガー判定
   └─ しきい値超過時にGC開始
4. スレッドサスペンション（STW）
   └─ セーフポイントでの停止
5. マーク処理
   └─ ルートからの到達可能性解析
6. スイープ/コンパクト処理
   └─ 未到達オブジェクトの回収
7. スレッド再開
   └─ アプリケーション実行継続
```

### フローチャート

```mermaid
flowchart TD
    A[割り当て要求] --> B{サイズ > 85KB?}
    B -->|Yes| C[LOH割り当て]
    B -->|No| D[SOH Gen0割り当て]
    D --> E{空き領域あり?}
    E -->|Yes| F[割り当て完了]
    E -->|No| G[Gen0 GC実行]
    G --> H{まだ不足?}
    H -->|Yes| I[Gen1/Gen2 GC]
    H -->|No| F
    C --> J{空き領域あり?}
    J -->|Yes| F
    J -->|No| K[Full GC実行]
    K --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 大きなオブジェクト | 85KB以上はLOHに割り当て | オブジェクト割り当て時 |
| BR-02 | 世代昇格 | GC生存オブジェクトは次世代へ昇格 | GC実行時 |
| BR-03 | BGC条件 | Gen2コレクションはバックグラウンドで実行可 | BGC有効時 |

### 計算ロジック

- 世代しきい値：動的に調整される世代別の容量しきい値
- 断片化率：ヒープ使用率に基づくコンパクション判定

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | GCはデータベースを操作しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfMemoryException | メモリ不足 | ヒープ拡張不可 | メモリ増強、オブジェクト削減 |
| StackOverflowException | スタック溢れ | 再帰過深 | コード修正 |

### リトライ仕様

- 割り当て失敗時：Full GC後に再試行

## トランザクション仕様

GCはトランザクション管理を行わない。

## パフォーマンス要件

- STW時間：数ミリ秒〜数十ミリ秒以内
- スループット：BGCによるアプリケーション実行継続率95%以上
- メモリ効率：断片化率10%以下の維持

## セキュリティ考慮事項

- メモリ内容のゼロクリア（セキュリティクリティカル領域）
- ファイナライザーの確実な実行（リソース解放）

## 備考

- .NET 5以降、Server GCがデフォルト（コンテナ環境以外）
- Regions対応による大規模ヒープ効率化（.NET 7〜）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gc.h | `src/coreclr/gc/gc.h` | GC公開インターフェース、世代定義 |
| 1-2 | gcinterface.h | `src/coreclr/gc/gcinterface.h` | IGCHeapインターフェース |

**読解のコツ**:
- **gc.h 107行目**: `LARGE_OBJECT_SIZE = 85000` - LOH閾値の定義
- **gc.h 109-133行目**: `gc_generation_num` - 世代番号の列挙定義
  - soh_gen0〜soh_gen2: 小オブジェクトヒープの世代
  - loh_generation: 大オブジェクトヒープ
  - poh_generation: ピン留めオブジェクトヒープ
- **gc.h 60-80行目**: `gc_reason` - GCトリガー理由の列挙
- **gc.h 188-199行目**: `bgc_state` - バックグラウンドGC状態

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gcheaputilities.h | `src/coreclr/vm/gcheaputilities.h` | GCヒープユーティリティ |
| 2-2 | gc.cpp | `src/coreclr/gc/gc.cpp` | GCコア実装 |

**主要処理フロー**:
- **gc.h 154-160行目**: グローバルGCテーブル変数
  - `g_gc_card_table`: カード表
  - `g_gc_lowest_address`/`g_gc_highest_address`: ヒープ境界
- **gc.h 166-177行目**: WKS/SVR名前空間でのGCHeap作成関数

#### Step 3: 世代管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gc.h (gc_generation_num) | `src/coreclr/gc/gc.h` | 世代構造 |

**主要処理フロー**:
- **gc.h 111-115行目**: SOH世代（Gen0〜Gen2）
- **gc.h 117-121行目**: UOH（Uncommitted Object Heap）- LOH/POH

### プログラム呼び出し階層図

```
new演算子 / GC.Collect()
    │
    ├─ GCHeapUtilities::GetGCHeap()
    │      └─ IGCHeap::Alloc() / IGCHeap::GarbageCollect()
    │
    ├─ gc_heap::try_allocate_more_space()
    │      └─ 世代別割り当て試行
    │
    ├─ gc_heap::garbage_collect()
    │      │
    │      ├─ suspend_EE() - スレッドサスペンション
    │      │
    │      ├─ gc_heap::mark_phase() - マーク処理
    │      │      └─ ルートからの到達可能性走査
    │      │
    │      ├─ gc_heap::plan_phase() - 計画処理
    │      │      └─ コンパクション要否判定
    │      │
    │      ├─ gc_heap::sweep_phase() または relocate_phase()
    │      │      └─ スイープまたは再配置
    │      │
    │      └─ restart_EE() - スレッド再開
    │
    └─ ファイナライザースレッド
           └─ FinalizerThread::FinalizerThreadStart()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

割り当て要求 ──────▶ 世代選択 ──────▶ ヒープ割り当て
     │                │
     │                ▼
     │            空き領域判定
     │                │
     ▼                ▼
GCトリガー ──────▶ マーク処理 ──────▶ 到達可能性グラフ
     │                │
     │                ▼
     │            スイープ/コンパクト
     │                │
     ▼                ▼
解放メモリ ◀──────── 世代昇格 ──────▶ 昇格オブジェクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gc.h | `src/coreclr/gc/gc.h` | ヘッダ | GCインターフェース定義 |
| gc.cpp | `src/coreclr/gc/gc.cpp` | ソース | GCコア実装 |
| gcinterface.h | `src/coreclr/gc/gcinterface.h` | ヘッダ | IGCHeapインターフェース |
| gcheaputilities.h | `src/coreclr/vm/gcheaputilities.h` | ヘッダ | GCヒープユーティリティ |
| gcconfig.h | `src/coreclr/gc/gcconfig.h` | ヘッダ | GC構成設定 |
| gceventstatus.h | `src/coreclr/gc/gceventstatus.h` | ヘッダ | GCイベント状態 |
| gchandletableimpl.h | `src/coreclr/gc/gchandletableimpl.h` | ヘッダ | GCハンドル表 |
| handletable.cpp | `src/coreclr/gc/handletable.cpp` | ソース | ハンドル表実装 |
