# 機能設計書 56-SharedFramework

## 概要

本ドキュメントは、.NETランタイムにおけるSharedFramework（共有フレームワーク）の機能設計を記述する。SharedFrameworkは、.NETアプリケーションの実行に必要なランタイムライブラリ、ネイティブコンポーネント、およびサポートファイルを含むパッケージである。

### 本機能の処理概要

SharedFrameworkは、.NETランタイムの配布単位として、複数の.NETアプリケーション間で共有されるフレームワークコンポーネントを提供する機能である。

**業務上の目的・背景**：.NETアプリケーションは実行時にランタイムライブラリを必要とする。SharedFrameworkを使用することで、各アプリケーションが個別にランタイムを持つ必要がなくなり、ディスク使用量の削減とセキュリティパッチの一元管理が可能になる。

**機能の利用シーン**：
- Framework-dependent（フレームワーク依存）アプリケーションの実行
- .NET SDKによるアプリケーションビルド
- dotnetコマンドによるアプリケーション実行
- 複数バージョンの.NETアプリケーションの同時実行

**主要な構成内容**：
1. Microsoft.NETCore.App.Runtime - CoreCLRまたはMonoランタイム
2. Microsoft.NETCore.App.Host - ネイティブホスト実行ファイル
3. Microsoft.NETCore.App.Ref - 参照アセンブリ
4. Microsoft.NETCore.App.Crossgen2 - AOTコンパイルツール（オプション）

**関連システム・外部連携**：
- dotnet CLI
- Visual Studio / VS Code
- NuGet パッケージ管理
- Windows/Linux/macOSのパッケージマネージャー

**権限による制御**：グローバルインストール時は管理者権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | SharedFrameworkはインフラのため、直接的なUI関連はない |

## 機能種別

ランタイムインフラストラクチャ / 共有フレームワーク

## 入力仕様

### 入力パラメータ

SharedFrameworkは直接的な入力パラメータを持たない。ビルドシステム（MSBuild）により構成される。

### 構成ファイル

- `runtimeconfig.json` - アプリケーションが要求するフレームワークバージョン
- `deps.json` - 依存関係情報

## 出力仕様

### SharedFrameworkの構成

```
shared/Microsoft.NETCore.App/<version>/
├─ Microsoft.NETCore.App.deps.json
├─ Microsoft.NETCore.App.runtimeconfig.json
├─ coreclr.dll / libcoreclr.so / libcoreclr.dylib
├─ clrjit.dll / libclrjit.so / libclrjit.dylib
├─ System.Private.CoreLib.dll
├─ System.*.dll (BCLアセンブリ)
├─ hostpolicy.dll / libhostpolicy.so
└─ PDB/* (デバッグシンボル、オプション)
```

### パッケージ出力

| パッケージ | 説明 |
|-----------|------|
| Microsoft.NETCore.App.Runtime.\<rid\> | ランタイムパッケージ |
| Microsoft.NETCore.App.Host.\<rid\> | ホストパッケージ |
| Microsoft.NETCore.App.Ref | 参照アセンブリパッケージ |

## 処理フロー

### ビルドフロー

```
1. ソースコードビルド
   └─ CoreCLR/Mono ビルド
   └─ BCL（Base Class Library）ビルド

2. SharedFramework構成
   └─ sharedFramework ディレクトリ構築
   └─ 必要ファイルのコピー

3. パッケージング
   └─ NuGetパッケージ作成
   └─ インストーラー作成（オプション）

4. 配布
   └─ NuGet.org へのパブリッシュ
   └─ インストーラーの配布
```

### フレームワーク解決フロー

```mermaid
flowchart TD
    A[アプリケーション起動] --> B[runtimeconfig.json読取]
    B --> C[要求フレームワーク特定]
    C --> D{ローカル検索}
    D -->|見つかった| E[使用]
    D -->|見つからない| F{グローバル検索}
    F -->|見つかった| E
    F -->|見つからない| G[エラー]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-1 | バージョン互換性 | メジャーバージョンが一致する範囲で上位バージョンにロールフォワード可能 | デフォルト動作 |
| BR-56-2 | 複数バージョン共存 | 異なるバージョンのSharedFrameworkが同一マシンに共存可能 | 常時 |
| BR-56-3 | RID固有パッケージ | ランタイムパッケージはRID（Runtime Identifier）ごとに異なる | 常時 |

### フレームワークロールフォワード

| ロールフォワードポリシー | 説明 |
|------------------------|------|
| LatestPatch | 同一メジャー.マイナーの最新パッチ |
| Minor | 同一メジャーの最新マイナー |
| Major | 最新メジャーバージョン |
| LatestMinor | 同一メジャーの最新マイナー（マイナーが上位でも可） |
| LatestMajor | 利用可能な最新バージョン |
| Disable | ロールフォワード無効 |

## データベース操作仕様

SharedFrameworkはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NETSDK1045 | フレームワーク不在 | 要求バージョンが見つからない | 適切なバージョンをインストール |
| NETSDK1061 | 互換性エラー | プラットフォーム非対応 | 対応プラットフォームを確認 |

## パフォーマンス要件

- 共有フレームワーク使用により、ディスク使用量を削減
- プリコンパイル済みアセンブリによる起動時間短縮（ReadyToRun）

## セキュリティ考慮事項

- 署名されたアセンブリによる改ざん検出
- セキュリティパッチの一元的適用
- グローバルインストール時の管理者権限要求

## 備考

SharedFrameworkは.NET Core 1.0から導入され、.NET 5以降も継続して使用される配布モデルである。Self-contained（自己完結型）デプロイメントでは、SharedFrameworkの内容がアプリケーションにバンドルされる。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビルド構成を理解する

まず、SharedFrameworkのビルド構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Subsets.props | `eng/Subsets.props` | SharedFrameworkProjectToBuild定義 |
| 1-2 | liveBuilds.targets | `eng/liveBuilds.targets` | SharedFrameworkDir定義 |

**読解のコツ**:
- SharedFrameworkProjectToBuildにビルド対象プロジェクトが列挙
- CoreCLRSharedFrameworkDir、LibrariesSharedFrameworkDir等のパス変数を確認

#### Step 2: パッケージ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sfxproj files | `src/installer/pkg/sfx/Microsoft.NETCore.App/*.sfxproj` | パッケージ定義 |
| 2-2 | Framework.props | `src/installer/pkg/sfx/Microsoft.NETCore.App/Microsoft.NETCore.App.Runtime.props` | ランタイムパッケージ構成 |

### プログラム呼び出し階層図

```
MSBuild
    │
    ├─ Subsets.props
    │      └─ SharedFrameworkProjectToBuild
    │
    ├─ Microsoft.NETCore.App.Runtime.*.sfxproj
    │      ├─ CoreCLRビルド成果物
    │      └─ BCLビルド成果物
    │
    └─ Microsoft.NETCore.App.Host.sfxproj
           └─ ネイティブホスト

アプリケーション実行時
    │
    ├─ dotnet.exe / apphost
    │      └─ hostfxr
    │             └─ フレームワーク解決
    │
    └─ shared/Microsoft.NETCore.App/<version>/
           ├─ coreclr
           ├─ clrjit
           └─ BCLアセンブリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Subsets.props | `eng/Subsets.props` | ビルド定義 | ビルド対象定義 |
| liveBuilds.targets | `eng/liveBuilds.targets` | ビルド定義 | パス設定 |
| Microsoft.NETCore.App.Runtime.CoreCLR.sfxproj | `src/installer/pkg/sfx/Microsoft.NETCore.App/` | プロジェクト | CoreCLRランタイムパッケージ |
| Microsoft.NETCore.App.Runtime.Mono.sfxproj | `src/installer/pkg/sfx/Microsoft.NETCore.App/` | プロジェクト | Monoランタイムパッケージ |
| Microsoft.NETCore.App.Host.sfxproj | `src/installer/pkg/sfx/Microsoft.NETCore.App/` | プロジェクト | ホストパッケージ |
| Microsoft.NETCore.App.Ref.sfxproj | `src/installer/pkg/sfx/Microsoft.NETCore.App/` | プロジェクト | 参照アセンブリパッケージ |
| Microsoft.NETCore.App.Crossgen2.sfxproj | `src/installer/pkg/sfx/Microsoft.NETCore.App/` | プロジェクト | AOTツールパッケージ |
