# 機能設計書 57-HostFxr

## 概要

本ドキュメントは、.NETランタイムにおけるHostFxr（ホストFXR）の機能設計を記述する。HostFxrは、.NETホストの中核コンポーネントであり、フレームワーク解決、SDK解決、およびランタイム初期化の調整を担当するネイティブライブラリである。

### 本機能の処理概要

HostFxrは、dotnetコマンドまたはアプリケーションホストから呼び出され、適切な.NETランタイムとフレームワークを解決・ロードし、アプリケーションの実行を開始するエントリーポイントを提供する機能である。

**業務上の目的・背景**：.NETアプリケーションの起動プロセスにおいて、適切なランタイムバージョンの選択、フレームワークの解決、およびhostpolicyへの制御移譲を行う必要がある。HostFxrはこの複雑なプロセスを管理する中間レイヤーとして機能する。

**機能の利用シーン**：
- `dotnet run`コマンドによるアプリケーション実行
- `dotnet build`等のSDKコマンド実行
- 自己完結型アプリケーションの起動
- ネイティブホストからの.NETランタイムロード

**主要な処理内容**：
1. コマンドライン引数の解析
2. runtimeconfig.jsonの読み取りと解析
3. フレームワーク依存関係の解決
4. ロールフォワードポリシーの適用
5. SDK解決（global.json対応）
6. hostpolicy.dllのロードと制御移譲

**関連システム・外部連携**：
- dotnet.exe / apphost（呼び出し元）
- hostpolicy.dll（呼び出し先）
- runtimeconfig.json / global.json（設定ファイル）

**権限による制御**：特別な権限制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | HostFxrはネイティブライブラリのため、直接的なUI関連はない |

## 機能種別

ランタイムインフラストラクチャ / ホストコンポーネント

## 入力仕様

### エクスポート関数

| 関数名 | 説明 |
|--------|------|
| `hostfxr_main` | 標準エントリーポイント |
| `hostfxr_main_startupinfo` | スタートアップ情報付きエントリー |
| `hostfxr_main_bundle_startupinfo` | バンドルアプリ用エントリー |
| `hostfxr_resolve_sdk` | SDK解決（非推奨） |
| `hostfxr_resolve_sdk2` | SDK解決 |
| `hostfxr_get_available_sdks` | 利用可能なSDK一覧取得 |
| `hostfxr_get_native_search_directories` | ネイティブ検索パス取得 |
| `hostfxr_initialize_for_dotnet_command_line` | CLIコマンド初期化 |
| `hostfxr_initialize_for_runtime_config` | ランタイム設定初期化 |
| `hostfxr_run_app` | アプリケーション実行 |
| `hostfxr_get_runtime_delegate` | ランタイムデリゲート取得 |
| `hostfxr_close` | コンテキストクローズ |

### 入力パラメータ（hostfxr_main_startupinfo）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|-----|------|
| argc | int | Yes | 引数の数 |
| argv | char_t** | Yes | 引数配列 |
| host_path | char_t* | Yes | ホスト実行ファイルパス |
| dotnet_root | char_t* | Yes | dotnetルートディレクトリ |
| app_path | char_t* | Yes | アプリケーションパス |

## 出力仕様

### 戻り値

| 値 | 意味 |
|-----|------|
| 0 | 成功 |
| 非0 | エラーコード（StatusCode列挙） |

### 主要なステータスコード

| コード | 名前 | 説明 |
|--------|------|------|
| 0 | Success | 成功 |
| 0x80008081 | InvalidArgFailure | 無効な引数 |
| 0x80008082 | CoreHostLibLoadFailure | ライブラリロード失敗 |
| 0x80008083 | CoreHostLibMissingFailure | ライブラリ不在 |
| 0x80008084 | CoreHostEntryPointFailure | エントリーポイント失敗 |
| 0x80008085 | CoreHostCurHostFindFailure | 現在のホスト検出失敗 |
| 0x80008096 | FrameworkMissingFailure | フレームワーク不在 |

## 処理フロー

### 処理シーケンス

```
1. エントリーポイント呼び出し
   └─ trace_hostfxr_entry_point() でトレース出力

2. スタートアップ情報解析
   └─ host_startup_info_t構築
   └─ パス正規化

3. fx_muxer_t::execute() 呼び出し
   └─ コマンドタイプ判定（run/build/test等）

4. フレームワーク解決
   └─ runtimeconfig.json読み取り
   └─ fx_resolver_t::resolve()
   └─ ロールフォワード適用

5. hostpolicy.dllロード
   └─ 適切なバージョンのhostpolicyを検出
   └─ 動的ロード

6. 制御移譲
   └─ corehost_load() 呼び出し
   └─ corehost_main() 呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[hostfxr_main*呼び出し] --> B[引数解析]
    B --> C[startup_info構築]
    C --> D[fx_muxer_t::execute]
    D --> E{コマンドタイプ?}
    E -->|app| F[runtimeconfig.json読取]
    E -->|sdk| G[SDK解決]
    F --> H[フレームワーク解決]
    G --> I[SDK実行]
    H --> J[hostpolicyロード]
    J --> K[corehost_load]
    K --> L[corehost_main]
    L --> M[アプリ実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-57-1 | フレームワーク解決順序 | ローカル → グローバル → デフォルトの順で検索 | 常時 |
| BR-57-2 | ロールフォワード | 要求バージョンが見つからない場合、ポリシーに従い上位バージョンを使用 | デフォルト有効 |
| BR-57-3 | SDK解決 | global.jsonがある場合はそれに従う | SDKコマンド時 |
| BR-57-4 | マルチレベル検索 | DOTNET_MULTILEVEL_LOOKUP環境変数で制御 | 環境変数設定時 |

### フレームワーク検索パス

1. アプリケーションディレクトリ
2. DOTNET_ROOT環境変数
3. デフォルトインストール場所
   - Windows: `C:\Program Files\dotnet`
   - Linux: `/usr/share/dotnet`
   - macOS: `/usr/local/share/dotnet`

## データベース操作仕様

HostFxrはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FrameworkMissingFailure | フレームワーク不在 | 要求フレームワークが見つからない | フレームワークをインストール |
| InvalidArgFailure | 無効な引数 | 必須引数がnull | 正しい引数を指定 |
| CoreHostLibLoadFailure | ライブラリロード失敗 | hostpolicyのロード失敗 | インストール状態を確認 |

### トレース出力

`COREHOST_TRACE=1`環境変数でデバッグトレースを有効化可能。

## トランザクション仕様

HostFxrはトランザクション処理を行わない。

## パフォーマンス要件

- フレームワーク解決は起動時のみ実行
- ネイティブコードによる高速な処理

## セキュリティ考慮事項

- パス検証による不正なライブラリロード防止
- 署名検証（オプション）

## 備考

HostFxr（hostfxr.dll/libhostfxr.so）は、.NET SDKおよびランタイムインストール時に配置される。バージョンはランタイムバージョンと同期している。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hostfxr.cpp | `src/native/corehost/fxr/hostfxr.cpp` | エクスポート関数定義 |
| 1-2 | hostfxr.h | `src/native/corehost/fxr/hostfxr.h` | 公開API宣言 |

**主要処理フロー**:
- **30-49行目**: `hostfxr_main_bundle_startupinfo` - バンドルアプリ用エントリー
- **52-64行目**: `hostfxr_main_startupinfo` - スタートアップ情報付きエントリー
- **66-74行目**: `hostfxr_main` - 標準エントリーポイント

#### Step 2: フレームワーク解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fx_muxer.cpp | `src/native/corehost/fxr/fx_muxer.cpp` | フレームワークマルチプレクサ |
| 2-2 | fx_resolver.cpp | `src/native/corehost/fxr/fx_resolver.cpp` | フレームワーク解決ロジック |
| 2-3 | runtime_config.cpp | `src/native/corehost/fxr/runtime_config.cpp` | 設定ファイル解析 |

#### Step 3: SDK解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sdk_resolver.cpp | `src/native/corehost/fxr/sdk_resolver.cpp` | SDK解決ロジック |
| 3-2 | sdk_info.cpp | `src/native/corehost/fxr/sdk_info.cpp` | SDK情報管理 |

### プログラム呼び出し階層図

```
dotnet.exe / apphost
    │
    └─ hostfxr.dll
           │
           ├─ hostfxr_main*()
           │      └─ trace_hostfxr_entry_point()
           │
           ├─ host_startup_info_t::parse()
           │
           └─ fx_muxer_t::execute()
                  │
                  ├─ runtime_config_t::parse()
                  │
                  ├─ fx_resolver_t::resolve()
                  │      ├─ fx_ver_t::parse()
                  │      └─ ロールフォワード判定
                  │
                  ├─ hostpolicy.dll ロード
                  │
                  └─ corehost_load() / corehost_main()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hostfxr.cpp | `src/native/corehost/fxr/hostfxr.cpp` | ソース | エクスポート関数 |
| hostfxr.h | `src/native/corehost/fxr/hostfxr.h` | ヘッダ | 公開API |
| fx_muxer.cpp | `src/native/corehost/fxr/fx_muxer.cpp` | ソース | マルチプレクサ |
| fx_muxer.h | `src/native/corehost/fxr/fx_muxer.h` | ヘッダ | マルチプレクサ宣言 |
| fx_resolver.cpp | `src/native/corehost/fxr/fx_resolver.cpp` | ソース | フレームワーク解決 |
| fx_resolver.h | `src/native/corehost/fxr/fx_resolver.h` | ヘッダ | 解決器宣言 |
| runtime_config.cpp | `src/native/corehost/fxr/runtime_config.cpp` | ソース | 設定ファイル解析 |
| runtime_config.h | `src/native/corehost/fxr/runtime_config.h` | ヘッダ | 設定宣言 |
| sdk_resolver.cpp | `src/native/corehost/fxr/sdk_resolver.cpp` | ソース | SDK解決 |
| sdk_info.cpp | `src/native/corehost/fxr/sdk_info.cpp` | ソース | SDK情報 |
| host_context.cpp | `src/native/corehost/fxr/host_context.cpp` | ソース | ホストコンテキスト |
| framework_info.cpp | `src/native/corehost/fxr/framework_info.cpp` | ソース | フレームワーク情報 |
| fx_ver.cpp | `src/native/corehost/fxr/fx_ver.cpp` | ソース | バージョン比較 |
