# 機能設計書 58-HostPolicy

## 概要

本ドキュメントは、.NETランタイムにおけるHostPolicy（ホストポリシー）の機能設計を記述する。HostPolicyは、.NETホストの下位コンポーネントであり、アセンブリ読み込みポリシー、依存関係解決、およびCoreClRの初期化・実行を担当するネイティブライブラリである。

### 本機能の処理概要

HostPolicyは、hostfxrから呼び出され、deps.jsonに基づく依存関係解決、アセンブリ読み込みパスの構築、およびCoreCLRの初期化と管理コード実行を行う機能である。

**業務上の目的・背景**：.NETアプリケーションの実行において、適切なアセンブリの読み込み、依存関係の解決、およびランタイムの初期化が必要である。HostPolicyはこれらの複雑な処理を管理し、正しいアセンブリバージョンが読み込まれることを保証する。

**機能の利用シーン**：
- Framework-dependentアプリケーションの実行
- Self-containedアプリケーションの実行
- ネイティブホスティングシナリオ
- プラグインシステムでのランタイムロード

**主要な処理内容**：
1. deps.jsonの解析と依存関係グラフ構築
2. TPA（Trusted Platform Assemblies）リストの構築
3. ネイティブライブラリ検索パスの構築
4. リソースアセンブリ検索パスの構築
5. CoreCLRの初期化
6. アプリケーションエントリーポイントの実行

**関連システム・外部連携**：
- hostfxr（呼び出し元）
- coreclr.dll/libcoreclr.so（ランタイム）
- deps.json（依存関係定義）

**権限による制御**：特別な権限制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | HostPolicyはネイティブライブラリのため、直接的なUI関連はない |

## 機能種別

ランタイムインフラストラクチャ / ホストコンポーネント

## 入力仕様

### エクスポート関数

| 関数名 | 説明 |
|--------|------|
| `corehost_load` | HostPolicy初期化 |
| `corehost_unload` | HostPolicyアンロード |
| `corehost_main` | アプリケーション実行 |
| `corehost_main_with_output_buffer` | 出力バッファ付き実行 |
| `corehost_get_coreclr_delegate` | CoreCLRデリゲート取得 |
| `corehost_resolve_component_dependencies` | コンポーネント依存関係解決 |
| `corehost_set_error_writer` | エラーライター設定 |

### 初期化パラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|-----|------|
| init | hostpolicy_init_t* | Yes | 初期化情報 |
| argc | int | Yes | 引数の数 |
| argv | char_t** | Yes | 引数配列 |

## 出力仕様

### 戻り値

| 値 | 意味 |
|-----|------|
| 0 | 成功 |
| 非0 | エラーコード（StatusCode列挙） |

### CoreCLRプロパティ

HostPolicyは以下のプロパティをCoreCLRに渡す：

| プロパティ | 説明 |
|-----------|------|
| TRUSTED_PLATFORM_ASSEMBLIES | 信頼されたアセンブリリスト |
| APP_PATHS | アプリケーションパス |
| APP_NI_PATHS | ネイティブイメージパス |
| NATIVE_DLL_SEARCH_DIRECTORIES | ネイティブDLL検索パス |
| PLATFORM_RESOURCE_ROOTS | リソースルートパス |
| APP_CONTEXT_BASE_DIRECTORY | アプリコンテキストベースディレクトリ |
| APP_CONTEXT_DEPS_FILES | deps.jsonファイルパス |
| FX_DEPS_FILE | フレームワークdeps.jsonパス |
| PROBING_DIRECTORIES | プローブディレクトリ |

## 処理フロー

### 処理シーケンス

```
1. corehost_load()
   └─ hostpolicy_init_t受け取り
   └─ グローバル状態初期化

2. 依存関係解決
   └─ deps_resolver_t構築
   └─ deps.json解析
   └─ 依存関係グラフ構築

3. パス構築
   └─ TPAリスト構築
   └─ ネイティブ検索パス構築
   └─ リソースパス構築

4. CoreCLR初期化
   └─ coreclr_t::create()
   └─ プロパティ設定
   └─ AppDomain作成

5. アプリケーション実行
   └─ coreclr_t::execute_assembly()
   └─ エントリーポイント呼び出し

6. クリーンアップ
   └─ coreclr_t::shutdown()
   └─ リソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[corehost_load] --> B[hostpolicy_init_t保存]
    B --> C[corehost_main]
    C --> D[hostpolicy_context_t作成]
    D --> E[deps_resolver_t構築]
    E --> F[deps.json解析]
    F --> G[TPAリスト構築]
    G --> H[CoreCLRプロパティ設定]
    H --> I[coreclr_t::create]
    I --> J{成功?}
    J -->|Yes| K[execute_assembly]
    J -->|No| L[エラー返却]
    K --> M[アプリ実行]
    M --> N[shutdown]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-1 | 単一コンテキスト | hostpolicyコンテキストは1つのみ | 常時 |
| BR-58-2 | 依存関係優先順位 | アプリ依存 → フレームワーク依存の順で解決 | 常時 |
| BR-58-3 | バージョン選択 | 同名アセンブリは最も高いバージョンを選択 | デフォルト |
| BR-58-4 | ネイティブフォールバック | RID固有パスで見つからない場合、汎用パスを検索 | 常時 |

### 依存関係解決順序

1. アプリケーションdeps.json
2. フレームワークdeps.json（複数可能）
3. 追加プローブパス

## データベース操作仕様

HostPolicyはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| HostInvalidState | 無効な状態 | 初期化前のAPI呼び出し | 正しい順序で呼び出し |
| CoreClrInitFailure | CoreCLR初期化失敗 | coreclr.dllのロードまたは初期化失敗 | ランタイムインストール確認 |
| ResolverInitFailure | 解決器初期化失敗 | deps.json解析失敗 | deps.jsonを確認 |

### グローバル状態管理

```cpp
std::mutex g_init_lock;           // 初期化ロック
bool g_init_done;                  // 初期化完了フラグ
hostpolicy_init_t g_init;         // 初期化情報

std::mutex g_context_lock;         // コンテキストロック
std::shared_ptr<hostpolicy_context_t> g_context;  // コンテキスト
std::atomic<bool> g_context_initializing(false);  // 初期化中フラグ
```

## トランザクション仕様

HostPolicyはトランザクション処理を行わない。

## パフォーマンス要件

- deps.json解析は起動時のみ実行
- TPAリストはキャッシュ可能
- 並行アクセス時のロック競合を最小化

## セキュリティ考慮事項

- TPAリストによる信頼されたアセンブリのみ読み込み
- パス検証による不正なアセンブリロード防止

## 備考

HostPolicy（hostpolicy.dll/libhostpolicy.so）は、SharedFramework内に配置される。各フレームワークバージョンに対応するhostpolicyが存在する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hostpolicy.cpp | `src/native/corehost/hostpolicy/hostpolicy.cpp` | エクスポート関数定義 |
| 1-2 | hostpolicy.h | `src/native/corehost/hostpolicy/hostpolicy.h` | 公開API宣言 |

**主要処理フロー**:
- **23-46行目**: グローバル変数定義（g_init_lock, g_context等）
- **48-97行目**: create_coreclr()関数 - CoreCLR作成
- **99行目以降**: create_hostpolicy_context()関数

#### Step 2: 依存関係解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deps_resolver.h | `src/native/corehost/hostpolicy/deps_resolver.h` | 依存関係解決器宣言 |
| 2-2 | deps_resolver.cpp | `src/native/corehost/hostpolicy/deps_resolver.cpp` | 依存関係解決実装 |

#### Step 3: CoreCLRとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | coreclr.cpp | `src/native/corehost/hostpolicy/coreclr.cpp` | CoreCLR操作 |
| 3-2 | coreclr.h | `src/native/corehost/hostpolicy/coreclr.h` | CoreCLRインターフェース |

### プログラム呼び出し階層図

```
hostfxr.dll
    │
    └─ hostpolicy.dll
           │
           ├─ corehost_load()
           │      └─ g_init設定
           │
           ├─ corehost_main()
           │      │
           │      ├─ create_hostpolicy_context()
           │      │      └─ deps_resolver_t
           │      │
           │      ├─ create_coreclr()
           │      │      └─ coreclr_t::create()
           │      │
           │      └─ run_app()
           │             └─ coreclr_t::execute_assembly()
           │
           └─ corehost_unload()
                  └─ coreclr_t::shutdown()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hostpolicy.cpp | `src/native/corehost/hostpolicy/hostpolicy.cpp` | ソース | エクスポート関数 |
| hostpolicy.h | `src/native/corehost/hostpolicy/hostpolicy.h` | ヘッダ | 公開API |
| hostpolicy_context.cpp | `src/native/corehost/hostpolicy/hostpolicy_context.cpp` | ソース | コンテキスト管理 |
| deps_resolver.cpp | `src/native/corehost/hostpolicy/deps_resolver.cpp` | ソース | 依存関係解決 |
| deps_resolver.h | `src/native/corehost/hostpolicy/deps_resolver.h` | ヘッダ | 解決器宣言 |
| coreclr.cpp | `src/native/corehost/hostpolicy/coreclr.cpp` | ソース | CoreCLR操作 |
| coreclr.h | `src/native/corehost/hostpolicy/coreclr.h` | ヘッダ | CoreCLRインターフェース |
| args.cpp | `src/native/corehost/hostpolicy/args.cpp` | ソース | 引数処理 |
| breadcrumbs.cpp | `src/native/corehost/hostpolicy/breadcrumbs.cpp` | ソース | ブレッドクラム |
| shared_store.cpp | `src/native/corehost/hostpolicy/shared_store.cpp` | ソース | 共有ストア |
