# 機能設計書 59-WebAssemblyWorkload

## 概要

本ドキュメントは、.NETランタイムにおけるWebAssembly Workload（WebAssemblyワークロード）の機能設計を記述する。WebAssembly Workloadは、Blazor WebAssemblyアプリケーションおよび.NET WebAssemblyコンソールアプリケーションの開発をサポートするSDKワークロードである。

### 本機能の処理概要

WebAssembly Workloadは、.NETアプリケーションをWebAssemblyにコンパイルし、ブラウザ内で実行可能にするためのビルドツール、ランタイム、およびMSBuildタスクを提供する機能である。

**業務上の目的・背景**：WebAssemblyは、ブラウザ内でネイティブに近い速度でコードを実行できるバイナリ形式である。.NET WebAssembly Workloadにより、C#および.NET開発者はブラウザ向けアプリケーションを開発できる。Blazor WebAssemblyはこの技術を活用したSPAフレームワークである。

**機能の利用シーン**：
- Blazor WebAssemblyアプリケーションの開発
- .NET WebAssemblyコンソールアプリケーションの開発
- ブラウザ内での.NETライブラリ使用
- WebAssemblyでのAOT（Ahead-of-Time）コンパイル

**主要な処理内容**：
1. .NETアセンブリのWebAssemblyへのコンパイル
2. IL Interpreter（インタープリター）モードでの実行
3. AOTコンパイル（オプション）
4. P/Invokeおよびネイティブライブラリのリンク
5. ICU国際化データのシャーディング
6. ブラウザJavaScriptとの相互運用

**関連システム・外部連携**：
- Monoランタイム（WebAssembly用）
- Emscripten（WebAssemblyツールチェイン）
- wasm-tools（WebAssemblyバイナリ操作）
- Blazor（UIフレームワーク）

**権限による制御**：特別な権限制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | WebAssembly Workloadはビルドツールのため、直接的なUI関連はない |

## 機能種別

SDK ワークロード / 開発ツール

## 入力仕様

### ワークロードインストール

```bash
dotnet workload install wasm-tools
dotnet workload install wasm-tools-net8  # 特定バージョン
```

### プロジェクト設定

```xml
<Project Sdk="Microsoft.NET.Sdk.BlazorWebAssembly">
  <PropertyGroup>
    <TargetFramework>net9.0</TargetFramework>
    <RunAOTCompilation>true</RunAOTCompilation>
    <WasmBuildNative>true</WasmBuildNative>
  </PropertyGroup>
</Project>
```

### 主要なMSBuildプロパティ

| プロパティ名 | 型 | デフォルト | 説明 |
|-------------|-----|----------|------|
| RunAOTCompilation | bool | false | AOTコンパイルを有効化 |
| WasmBuildNative | bool | false | ネイティブビルドを有効化 |
| WasmNativeStrip | bool | true | シンボルストリップ |
| InvariantGlobalization | bool | false | 不変グローバリゼーション |
| WasmEnableSIMD | bool | true | SIMD命令の使用 |
| WasmEnableExceptionHandling | bool | true | 例外ハンドリング |

## 出力仕様

### ビルド成果物

```
_framework/
├─ blazor.boot.json          # ブートストラップ設定
├─ dotnet.js                  # ランタイムローダー
├─ dotnet.native.wasm         # ネイティブランタイム
├─ dotnet.native.js           # ネイティブJSグルー
├─ System.*.dll               # BCLアセンブリ
├─ [AppName].dll              # アプリケーションアセンブリ
├─ icudt_*.dat               # ICUデータ（グローバリゼーション用）
└─ *.pdb                     # デバッグシンボル（オプション）
```

### AOTコンパイル成果物

AOTコンパイル時は、追加のWebAssemblyファイルが生成される：
- `.wasm`ファイル（AOTコンパイル済みアセンブリ）
- サイズは増加するが、起動時間とランタイムパフォーマンスが向上

## 処理フロー

### ビルドフロー

```
1. プロジェクト解析
   └─ SDK Resolver
   └─ ワークロード検出

2. アセンブリビルド
   └─ 通常の.NETコンパイル
   └─ ILアセンブリ生成

3. WebAssembly準備
   └─ ランタイムファイルコピー
   └─ ICUデータ選択

4. AOTコンパイル（オプション）
   └─ MonoAOTCompiler
   └─ LLVM/Emscripten

5. ネイティブリンク（オプション）
   └─ emcc（Emscriptenコンパイラ）
   └─ P/Invokeテーブル生成

6. 出力生成
   └─ _frameworkディレクトリ構築
   └─ blazor.boot.json生成
```

### フローチャート

```mermaid
flowchart TD
    A[プロジェクトビルド] --> B[ILアセンブリ生成]
    B --> C{AOT有効?}
    C -->|Yes| D[MonoAOTCompiler]
    C -->|No| E[ILインタープリター用準備]
    D --> F{ネイティブビルド?}
    E --> F
    F -->|Yes| G[Emscriptenリンク]
    F -->|No| H[デフォルトランタイム使用]
    G --> I[_framework生成]
    H --> I
    I --> J[blazor.boot.json生成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-59-1 | ワークロード依存 | AOT/ネイティブビルドにはwasm-toolsワークロードが必要 | AOT/WasmBuildNative有効時 |
| BR-59-2 | ICUシャーディング | グローバリゼーションモードに応じてICUデータをシャード化 | デフォルト |
| BR-59-3 | SIMD互換性 | 古いブラウザではSIMD無効化が必要 | WasmEnableSIMD=false時 |

### 実行モード

| モード | 説明 | 特徴 |
|--------|------|------|
| Interpreter | ILインタープリター実行 | ビルド高速、実行時やや遅い |
| AOT | 事前コンパイル | ビルド遅い、実行時高速 |
| Hybrid | 一部AOT + インタープリター | バランス型 |

## データベース操作仕様

WebAssembly Workloadはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NETSDK1178 | ワークロード未インストール | wasm-toolsが見つからない | ワークロードをインストール |
| AOT001 | AOTコンパイル失敗 | コンパイルエラー | コードを修正 |
| EMCC001 | Emscriptenエラー | リンクエラー | ネイティブコード修正 |

## パフォーマンス要件

- AOTコンパイルにより起動時間を大幅に短縮
- SIMD有効化により数値計算を高速化
- トリミングによりダウンロードサイズを削減

## セキュリティ考慮事項

- WebAssemblyサンドボックスによるセキュリティ分離
- CSP（Content Security Policy）への対応
- 機密データのクライアントサイド処理に注意

## 備考

WebAssembly Workloadは.NET 6以降で正式サポートされている。Blazor WebAssemblyはASP.NET Coreの一部であり、サーバーサイドレンダリングとの組み合わせも可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビルドシステムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WasmApp.targets | `src/mono/wasm/build/WasmApp.targets` | メインビルドターゲット |
| 1-2 | WasmApp.Native.targets | `src/mono/wasm/build/WasmApp.Native.targets` | ネイティブビルドターゲット |
| 1-3 | WasmApp.InTree.targets | `src/mono/wasm/build/WasmApp.InTree.targets` | 内部ビルド用 |

#### Step 2: サンプルとテストを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Program.cs（Browser） | `src/mono/sample/wasm/browser/Program.cs` | ブラウザサンプル |
| 2-2 | WasmBuildAppBase.cs | `src/mono/wasm/Wasm.Build.Tests/WasmBuildAppBase.cs` | テスト基底クラス |

### プログラム呼び出し階層図

```
dotnet build / publish
    │
    ├─ Microsoft.NET.Sdk.BlazorWebAssembly
    │      └─ Blazor固有ターゲット
    │
    └─ WasmApp.targets
           │
           ├─ _WasmBuildNative（ネイティブビルド時）
           │      ├─ MonoAOTCompiler（AOT時）
           │      ├─ EmccCompile
           │      └─ EmccLink
           │
           ├─ _WasmGenerateAppBundle
           │      ├─ アセンブリコピー
           │      ├─ ICUデータ選択
           │      └─ blazor.boot.json生成
           │
           └─ 出力: _framework/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WasmApp.targets | `src/mono/wasm/build/WasmApp.targets` | MSBuild | メインビルドターゲット |
| WasmApp.Native.targets | `src/mono/wasm/build/WasmApp.Native.targets` | MSBuild | ネイティブビルド |
| WasmApp.InTree.targets | `src/mono/wasm/build/WasmApp.InTree.targets` | MSBuild | 内部ビルド |
| WasmApp.props | `src/mono/wasm/build/WasmApp.props` | MSBuild | プロパティ定義 |
| MonoAOTCompiler.cs | `src/tasks/MonoTargetsTasks/MonoAOTCompiler.cs` | C# | AOTコンパイラタスク |
| EmccCompile.cs | `src/tasks/WasmAppBuilder/EmccCompile.cs` | C# | Emscriptenコンパイル |
| WasmBuildAppBase.cs | `src/mono/wasm/Wasm.Build.Tests/WasmBuildAppBase.cs` | C# | テスト基底 |
| BlazorWasmTestBase.cs | `src/mono/wasm/Wasm.Build.Tests/Blazor/BlazorWasmTestBase.cs` | C# | Blazorテスト基底 |
