# 機能設計書 60-iOSWorkload

## 概要

本ドキュメントは、.NETランタイムにおけるiOS Workload（iOSワークロード）の機能設計を記述する。iOS Workloadは、.NET MAUIおよびXamarin.iOSアプリケーションのiOS/iPadOS向け開発をサポートするSDKワークロードである。

### 本機能の処理概要

iOS Workloadは、.NETアプリケーションをiOS/iPadOSデバイス向けにビルド・デプロイするためのビルドツール、ランタイム、およびMSBuildタスクを提供する機能である。

**業務上の目的・背景**：AppleのiOSおよびiPadOSは主要なモバイルプラットフォームであり、.NET開発者がこれらのプラットフォーム向けアプリケーションを開発できることは重要である。iOS Workloadにより、C#および.NETを使用したネイティブiOSアプリケーション開発が可能になる。

**機能の利用シーン**：
- .NET MAUIアプリケーションのiOS向けビルド
- Xamarin.iOSアプリケーションの開発
- iOSシミュレータでのテスト実行
- App Store向けアプリケーションのビルド・署名

**主要な処理内容**：
1. .NETアセンブリのAOT（Ahead-of-Time）コンパイル
2. ネイティブiOSアプリバンドル（.app）の生成
3. IPAパッケージの作成
4. コード署名とプロビジョニングプロファイル適用
5. iOSシミュレータ/デバイスへのデプロイ
6. Objective-C/Swift相互運用

**関連システム・外部連携**：
- Monoランタイム（iOS用）
- Xcode（Appleビルドツール）
- Apple Developer Certificate / Provisioning Profile
- .NET MAUI

**権限による制御**：コード署名にはApple Developer認証が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | iOS Workloadはビルドツールのため、直接的なUI関連はない |

## 機能種別

SDK ワークロード / 開発ツール

## 入力仕様

### ワークロードインストール

```bash
dotnet workload install ios
dotnet workload install maui-ios  # MAUI統合版
```

### プロジェクト設定

```xml
<Project Sdk="Microsoft.NET.Sdk">
  <PropertyGroup>
    <TargetFramework>net9.0-ios</TargetFramework>
    <RuntimeIdentifier>ios-arm64</RuntimeIdentifier>
    <UseInterpreter>false</UseInterpreter>
  </PropertyGroup>
</Project>
```

### 主要なMSBuildプロパティ

| プロパティ名 | 型 | デフォルト | 説明 |
|-------------|-----|----------|------|
| RuntimeIdentifier | string | - | ターゲットRID（ios-arm64, iossimulator-x64等） |
| UseInterpreter | bool | false | ILインタープリター使用 |
| EnableSGenConc | bool | true | 並行GC有効化 |
| MtouchLink | string | SdkOnly | リンカーモード |
| CodesignKey | string | - | コード署名キー |
| CodesignProvision | string | - | プロビジョニングプロファイル |

### サポートされるRID

| RID | 説明 |
|-----|------|
| ios-arm64 | iOSデバイス（ARM64） |
| iossimulator-x64 | iOSシミュレータ（Intel Mac） |
| iossimulator-arm64 | iOSシミュレータ（Apple Silicon Mac） |
| maccatalyst-arm64 | Mac Catalyst（ARM64） |
| maccatalyst-x64 | Mac Catalyst（Intel） |

## 出力仕様

### ビルド成果物

```
bin/Release/net9.0-ios/ios-arm64/
├─ [AppName].app/
│   ├─ Info.plist           # アプリ情報
│   ├─ [AppName]            # メイン実行ファイル
│   ├─ embedded.mobileprovision  # プロビジョニングプロファイル
│   ├─ _CodeSignature/      # コード署名
│   ├─ Assets.car           # アセットカタログ
│   ├─ *.dll                # マネージドアセンブリ
│   └─ MonoBundle/          # Monoランタイムファイル
└─ [AppName].ipa            # 配布用パッケージ（Archive時）
```

### AOTコンパイル成果物

iOSではJITが禁止されているため、AOTコンパイルが必須：
- ネイティブオブジェクトファイル（.o）
- 静的ライブラリ（.a）
- 最終実行ファイル

## 処理フロー

### ビルドフロー

```
1. プロジェクト解析
   └─ SDK Resolver
   └─ iOS SDK検出

2. マネージドビルド
   └─ 通常の.NETコンパイル
   └─ ILアセンブリ生成

3. AOTコンパイル
   └─ MonoAOTCrossCompiler
   └─ LLVM使用

4. ネイティブリンク
   └─ Xcodeツールチェイン
   └─ フレームワークリンク

5. アプリバンドル作成
   └─ Info.plist生成
   └─ リソースコピー
   └─ アセットコンパイル

6. コード署名
   └─ 証明書検証
   └─ プロビジョニングプロファイル適用
   └─ 署名実行

7. IPAパッケージ（配布時）
   └─ Archive作成
   └─ IPAエクスポート
```

### フローチャート

```mermaid
flowchart TD
    A[プロジェクトビルド] --> B[ILアセンブリ生成]
    B --> C[MonoAOTCrossCompiler]
    C --> D[ネイティブオブジェクト生成]
    D --> E[Xcodeリンク]
    E --> F[.app バンドル作成]
    F --> G{コード署名?}
    G -->|Yes| H[証明書で署名]
    G -->|No| I[シミュレータ用]
    H --> J[IPA生成（配布時）]
    I --> K[シミュレータデプロイ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-60-1 | AOT必須 | iOSデバイス向けはAOTコンパイルが必須 | ios-arm64ターゲット時 |
| BR-60-2 | コード署名必須 | 実機デプロイにはコード署名が必須 | デバイス向けビルド時 |
| BR-60-3 | macOS必須 | iOSビルドにはmacOSが必要 | 常時 |
| BR-60-4 | Xcode必須 | ビルドにXcodeのインストールが必要 | 常時 |

### リンカーモード

| モード | 説明 |
|--------|------|
| None | リンクなし（開発用） |
| SdkOnly | SDKアセンブリのみリンク |
| Full | 全アセンブリをリンク |

## データベース操作仕様

iOS Workloadはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| MT0000 | 一般エラー | 各種ビルドエラー | エラーメッセージ参照 |
| MT0020 | iOS SDK不在 | Xcodeが見つからない | Xcodeをインストール |
| MT0051 | AOT失敗 | AOTコンパイルエラー | コードを修正 |
| MT1009 | 署名エラー | 証明書/プロファイル問題 | 署名設定を確認 |

## パフォーマンス要件

- AOTコンパイルにより起動時間を最適化
- 並行GCによるUI応答性の向上
- トリミングによるアプリサイズ削減

## セキュリティ考慮事項

- Apple Developer認証による信頼性確保
- サンドボックスによるアプリ分離
- App Transport Security（ATS）対応

## 備考

iOS Workloadは.NET 6以降で正式サポートされている。Apple Silicon Mac（M1/M2/M3）でのシミュレータビルドにはarm64 RIDを使用する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サンプルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/mono/sample/iOS/Program.cs` | iOSサンプルプログラム |

**読解のコツ**: iOSアプリのエントリーポイント構造を理解する。

#### Step 2: ビルドシステムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | iOS.targets | `src/mono/msbuild/apple/build/*.targets` | iOSビルドターゲット |
| 2-2 | AppleAppBuilder | `src/tasks/AppleAppBuilder/` | アプリバンドル作成タスク |

#### Step 3: AOTコンパイルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MonoAOTCompiler.cs | `src/tasks/MonoTargetsTasks/MonoAOTCompiler.cs` | AOTコンパイラタスク |

### プログラム呼び出し階層図

```
dotnet build / publish
    │
    ├─ Microsoft.NET.Sdk
    │      └─ iOS固有ターゲット
    │
    └─ Apple.targets
           │
           ├─ MonoAOTCompiler（AOT）
           │      └─ LLVM
           │
           ├─ AppleAppBuilder
           │      ├─ Info.plist生成
           │      ├─ アセットコンパイル
           │      └─ バンドル作成
           │
           ├─ コード署名
           │      └─ codesign
           │
           └─ 出力: [AppName].app / .ipa
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `src/mono/sample/iOS/Program.cs` | サンプル | iOSサンプル |
| AppleAppBuilder.cs | `src/tasks/AppleAppBuilder/AppleAppBuilder.cs` | C# | アプリバンドルビルダー |
| MonoAOTCompiler.cs | `src/tasks/MonoTargetsTasks/MonoAOTCompiler.cs` | C# | AOTコンパイラタスク |
| AppleAppBuilderTask.cs | `src/tasks/AppleAppBuilder/AppleAppBuilderTask.cs` | C# | MSBuildタスク |
