---
generated_at: 2026-01-30 12:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：1-CoreCLR.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的な数値**：根拠不足
  2. **セキュリティ機能の詳細実装**：ソースコード確認が必要
  3. **トランザクションサポートの範囲**：外部ドキュメント参照推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/coreclr/vm/ceemain.cpp` - ランタイム初期化コード
- E-02: `src/coreclr/gc/gc.h` - GCインターフェース定義
- E-03: `src/coreclr/jit/compiler.h` - JITコンパイラヘッダ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `src/coreclr/vm/threads.h` - スレッド管理（参照パス確認）
- E-06: `src/coreclr/vm/method.hpp` - メソッド表現（参照パス確認）
- E-07: `src/coreclr/vm/gcheaputilities.h` - GCヒープユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CoreCLRはWindows/Linux/macOS向けの高性能.NETランタイム実装 | E-04 | ○ |
| C-02 | JITコンパイラ、GC、VM、メタデータ処理を含む | E-01, E-02, E-03 | ○ |
| C-03 | EEStartup()がランタイム初期化のエントリーポイント | E-01 (211行目) | ○ |
| C-04 | InitializeGarbageCollector()でGC初期化 | E-01 (214行目) | ○ |
| C-05 | g_fEEStartedがランタイム初期化状態を保持 | E-01 (238行目) | ○ |
| C-06 | gc_reasonでGCトリガー理由を定義 | E-02 (60-80行目) | ○ |
| C-07 | gc_etw_typeでGCタイプを定義 | E-02 (84-88行目) | ○ |
| C-08 | プロセスあたり1回のみランタイム初期化 | E-01 (g_EEStartupLock) | ○ |
| C-09 | ファイナライザー→GC→ネイティブリソースの順で解放 | E-01 (シャットダウンロジック参照) | ○ |
| C-10 | 世代別ヒープによるメモリ管理 | E-02 | ○ |
| C-11 | バックグラウンドGCによるSTW時間最小化 | E-02 (gc_etw_type_bgc) | ○ |
| C-12 | TieredCompilationによる最適化 | E-03 | ○ |
| C-13 | ReadyToRunによる起動高速化 | **根拠なし** | △ |
| C-14 | Type Safetyによるメモリ安全性保証 | E-01 (型システム参照) | ○ |
| C-15 | ETW/LTTngへの診断出力 | E-01 (146行目 eventtrace.h) | ○ |
| C-16 | EventPipeによる診断イベント | E-01 (198行目 eventpipeadapter.h) | ○ |
| C-17 | COM相互運用サポート | E-01 (179-182行目 FEATURE_COMINTEROP) | ○ |
| C-18 | デバッガーサポート | E-01 (216-219行目 InitializeDebugger) | ○ |
| C-19 | プロファイラーサポート | E-01 (188-191行目 PROFILING_SUPPORTED) | ○ |
| C-20 | MethodDescがメソッドの内部表現 | E-06 (参照パス) | ○ |
| C-21 | ClassLoaderによる型ロード | E-01 (123行目 clsload.hpp) | ○ |
| C-22 | P/Invoke連携 | E-01 (128行目 dllimport.h) | ○ |
| C-23 | 具体的なJITコンパイル時間の数値 | **根拠なし** | △ |
| C-24 | 具体的なGC STW時間の数値 | **根拠なし** | △ |
| C-25 | MITライセンス | E-01 (1-2行目 ライセンスヘッダ) | ○ |

## 4) 不足情報（Unknown / Missing）
- ReadyToRun（R2R）の詳細実装に関する直接的なソースコード参照が不足
  - 候補：`src/coreclr/tools/aot/crossgen2` / `docs/design/coreclr/botr/readytorun-overview.md` / ビルドスクリプト
- パフォーマンス要件の具体的数値（ms単位等）の根拠
  - 候補：ベンチマーク結果 / パフォーマンステスト / 設計要件ドキュメント
- スタックオーバーフロー保護の詳細実装
  - 候補：`src/coreclr/vm/stackprobe.h` / セキュリティ設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CoreCLRの基本機能説明（ソースコードで確認可能）
- 1: 中リスク - パフォーマンス要件（数値の根拠確認が望ましい）
- 1: 中リスク - セキュリティ機能の網羅性（追加確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] EEStartup()/EEShutDown()の処理フローがソースコードと一致しているか確認
- [ ] GCの世代別ヒープ構造の説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] 関連ファイル一覧のパスが実在するか確認
- [ ] ReadyToRun関連の説明を追加情報で補完するか検討
