---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：10-System.Text.Json.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **.NET Core 3.0での導入時期**：リリースノート確認推奨
  2. **Strict/Webプリセットの.NET 8追加**：リリースノート確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializerOptions.cs` - JsonSerializerOptions実装
- E-02: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializer.Helpers.cs` - JsonSerializerヘルパー
- E-03: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializer.Write.String.cs` - シリアライズ実装
- E-04: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializer.Read.String.cs` - デシリアライズ実装
- E-05: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonConverter.cs` - JsonConverter基底クラス
- E-06: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonConverterOfT.cs` - JsonConverter<T>実装
- E-07: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializerContext.cs` - Source Generatorコンテキスト
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | System.Text.JsonはJSONシリアライズ/デシリアライズを提供 | E-08 | ○ |
| C-02 | JsonSerializerOptionsクラス定義 | E-01 (22行目) | ○ |
| C-03 | BufferSizeDefault = 16 * 1024 | E-01 (24行目) | ○ |
| C-04 | DefaultMaxDepth = JsonReaderOptions.DefaultMaxDepth | E-01 (28行目) | ○ |
| C-05 | Default静的プロパティ | E-01 (38-43行目) | ○ |
| C-06 | Web静的プロパティ | E-01 (53-58行目) | ○ |
| C-07 | Strict静的プロパティ | E-01 (68-73行目) | ○ |
| C-08 | _typeInfoResolver等のフィールド | E-01 (77-88行目) | ○ |
| C-09 | _defaultBufferSize, _maxDepth等のフィールド | E-01 (90-105行目) | ○ |
| C-10 | JsonSerializerクラス定義 | E-02 (13行目) | ○ |
| C-11 | SerializationUnreferencedCodeMessage定数 | E-02 (15行目) | ○ |
| C-12 | SerializationRequiresDynamicCodeMessage定数 | E-02 (16行目) | ○ |
| C-13 | IsReflectionEnabledByDefaultプロパティ | E-02 (27行目) | ○ |
| C-14 | Serialize<TValue>メソッド | E-03 (30-34行目) | ○ |
| C-15 | Deserialize<TValue>メソッド | E-04 (47-53行目) | ○ |
| C-16 | JsonConverter抽象クラス | E-05 (16行目) | ○ |
| C-17 | Type抽象プロパティ | E-05 (31行目) | ○ |
| C-18 | CanConvert抽象メソッド | E-05 (38行目) | ○ |
| C-19 | JsonConverter<T>クラス定義 | E-06 (15行目) | ○ |
| C-20 | JsonSerializerContext抽象クラス | E-07 (12行目) | ○ |
| C-21 | .NET Core 3.0での導入 | **根拠なし**（リリースノート参照推奨） | △ |
| C-22 | .NET 8でStrict/Webプリセット追加 | **根拠なし**（リリースノート参照推奨） | △ |

## 4) 不足情報（Unknown / Missing）
- .NET Core 3.0での導入時期
  - 候補：.NET Core 3.0リリースノート / Microsoft公式ドキュメント
- Strict/Webプリセットの追加バージョン
  - 候補：.NET 8リリースノート / API差分ドキュメント
- Utf8JsonReader/Utf8JsonWriter詳細実装
  - 候補：`src/libraries/System.Text.Json/src/System/Text/Json/Reader/Utf8JsonReader.cs`
  - 候補：`src/libraries/System.Text.Json/src/System/Text/Json/Writer/Utf8JsonWriter.cs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JsonSerializerOptions基本構造（ソースコードで確認可能）
- 0: 低リスク - JsonConverter階層構造（ソースコードで確認可能）
- 0: 低リスク - Source Generator統合（JsonSerializerContextで確認可能）
- 1: 中リスク - バージョン情報（リリースノート参照推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] JsonSerializerOptions.csのフィールド定義がドキュメントの説明と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] Default/Web/Strictプリセットの動作説明が正確か確認
- [ ] JsonConverter基底クラスの説明が正確か確認
- [ ] Source Generator（JsonSerializerContext）の説明が正確か確認
- [ ] バージョン情報について公式ドキュメントと照合
