---
generated_at: 2026-01-30 12:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：11-System.Text.RegularExpressions.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **デフォルトキャッシュサイズ15**：公式ドキュメントで確認必要
  2. **RegexParseException**：.NET 7以降の追加例外型
  3. **性能比較表の数値**：ベンチマーク結果の裏付け必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.cs`
- E-02: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexParser.cs`
- E-03: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexOptions.cs`（推定）
- E-04: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexRunner.cs`
- E-05: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Match.cs`
- E-06: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexNode.cs`
- E-07: 機能一覧.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Regexクラスが正規表現の主要エントリーポイント | E-01 | ○ |
| C-02 | RegexParserがパターン文字列を構文解析 | E-02 | ○ |
| C-03 | IsMatch()メソッドが静的・インスタンス両方で提供 | E-01 | ○ |
| C-04 | Match()メソッドがMatch オブジェクトを返す | E-01, E-05 | ○ |
| C-05 | Replace()メソッドが文字列またはMatchEvaluatorで置換 | E-01 | ○ |
| C-06 | Split()メソッドがパターンで文字列分割 | E-01 | ○ |
| C-07 | RegexOptions.Noneがデフォルト値 | E-03 | ○ |
| C-08 | RegexOptions.Compiledでパフォーマンス向上 | E-03 | ○ |
| C-09 | RegexOptions.NonBacktrackingで線形時間保証 | E-03 | ○ |
| C-10 | デフォルトキャッシュサイズが15 | **根拠なし** | △ |
| C-11 | Regex.CacheSizeで調整可能 | E-01 | ○ |
| C-12 | ArgumentNullExceptionがnull入力時にスロー | E-01 | ○ |
| C-13 | ArgumentExceptionが無効パターンでスロー | E-02 | ○ |
| C-14 | RegexMatchTimeoutExceptionがタイムアウト時発生 | E-01 | ○ |
| C-15 | RegexParseExceptionがパターンエラーで発生 | **根拠なし** | △ |
| C-16 | RegexNodeが構文木ノードを表現 | E-06 | ○ |
| C-17 | Regex.Escape()でユーザー入力をエスケープ | E-01 | ○ |
| C-18 | ReadOnlySpan<char>対応のオーバーロード存在 | E-01 | ○ |
| C-19 | MatchCollectionが複数マッチ結果を格納 | E-01 | ○ |
| C-20 | Groupクラスがキャプチャグループを表現 | E-05 | ○ |
| C-21 | Captureクラスが単一キャプチャを表現 | E-05 | ○ |
| C-22 | RegexRunnerがマッチングエンジン基底 | E-04 | ○ |
| C-23 | 性能比較（インタプリタ/コンパイル/ソース生成） | **根拠なし** | △ |
| C-24 | タイムアウト設定でReDoS対策 | E-01 | ○ |
| C-25 | Perl5互換の正規表現構文サポート | E-01, E-02 | ○ |
| C-26 | RightToLeftオプションで逆方向マッチング | E-03 | ○ |
| C-27 | ECMAScriptオプションでECMAScript準拠 | E-03 | ○ |
| C-28 | CultureInvariantオプションでカルチャ非依存 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- デフォルトキャッシュサイズ15の根拠
  - 候補：公式ドキュメント / ソースコードのconst定義 / テストコード
- RegexParseExceptionの導入バージョン確認
  - 候補：リリースノート / APIリファレンス / ソースコード履歴
- 性能比較の具体的数値
  - 候補：公式ベンチマーク / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なAPI説明は信頼性が高い
- 1: 中リスク - 性能特性の記述は実測値による検証推奨
- 1: 中リスク - .NET バージョン依存の機能に注意

## 6) レビュアーチェックリスト（最小）
- [ ] RegexOptions列挙値がソースコードと一致しているか確認
- [ ] デフォルトキャッシュサイズ15が正しいか公式ドキュメントで確認
- [ ] RegexParseExceptionが現行バージョンで存在するか確認
- [ ] コードサンプルの動作確認
- [ ] 関連ファイル一覧のパスが実際に存在するか確認
