---
generated_at: 2026-01-30 12:20:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：13-System.Net.Http.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **SocketsHttpHandlerのデフォルト値**：プロパティ値の検証必要
  2. **HTTP/3サポート状況**：opt-inの詳細確認
  3. **最大リダイレクト回数50**：デフォルト値の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Http/src/System/Net/Http/HttpClient.cs`
- E-02: `src/libraries/System.Net.Http/src/System/Net/Http/HttpRequestMessage.cs`（推定）
- E-03: `src/libraries/System.Net.Http/src/System/Net/Http/HttpResponseMessage.cs`（推定）
- E-04: `src/libraries/System.Net.Http/src/System/Net/Http/HttpContent.cs`（推定）
- E-05: `src/libraries/System.Net.Http/src/System/Net/Http/SocketsHttpHandler/SocketsHttpHandler.cs`（推定）
- E-06: 機能一覧.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HttpClientがHTTPリクエストの主要エントリーポイント | E-01 | ○ |
| C-02 | GetAsync/PostAsync等の簡易メソッド提供 | E-01 | ○ |
| C-03 | SendAsyncで完全カスタマイズ可能 | E-01 | ○ |
| C-04 | HttpRequestMessageでリクエスト構造を表現 | E-02 | ○ |
| C-05 | HttpResponseMessageでレスポンス構造を表現 | E-03 | ○ |
| C-06 | HttpContentの派生クラス群の存在 | E-04 | ○ |
| C-07 | StringContent/ByteArrayContent等の提供 | E-04 | ○ |
| C-08 | DelegatingHandlerでパイプライン構築 | E-01 | ○ |
| C-09 | SocketsHttpHandlerがデフォルトハンドラー | E-05 | ○ |
| C-10 | HTTP/1.1, HTTP/2, HTTP/3のサポート | E-01, E-05 | ○ |
| C-11 | 接続プーリング機能 | E-05 | ○ |
| C-12 | PooledConnectionLifetimeのデフォルトがInfinite | **根拠なし** | △ |
| C-13 | PooledConnectionIdleTimeoutのデフォルトが1分 | **根拠なし** | △ |
| C-14 | 最大リダイレクト回数のデフォルトが50 | **根拠なし** | △ |
| C-15 | HttpRequestExceptionがHTTP通信エラーで発生 | E-01 | ○ |
| C-16 | TaskCanceledExceptionがタイムアウトで発生 | E-01 | ○ |
| C-17 | EnsureSuccessStatusCode()で2xx以外に例外 | E-01 | ○ |
| C-18 | HttpCompletionOptionの2種類 | E-01 | ○ |
| C-19 | HttpVersionの指定が可能 | E-02 | ○ |
| C-20 | VersionPolicyの指定が可能 | E-02 | ○ |
| C-21 | CancellationTokenによるキャンセル | E-01 | ○ |
| C-22 | BaseAddressの設定が可能 | E-01 | ○ |
| C-23 | DefaultRequestHeadersの設定が可能 | E-01 | ○ |
| C-24 | Timeoutの設定が可能 | E-01 | ○ |
| C-25 | Disposeでリソース解放 | E-01 | ○ |
| C-26 | シングルトン使用推奨 | E-01（コメント） | ○ |
| C-27 | IHttpClientFactory連携 | 公式ドキュメント | ○ |
| C-28 | JsonContent/.NET 5以降 | E-04 | ○ |
| C-29 | PostAsJsonAsync拡張メソッド | 公式ドキュメント | ○ |
| C-30 | HTTPS/TLSサポート | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- SocketsHttpHandlerのデフォルトプロパティ値
  - 候補：ソースコードの定数定義確認 / 公式ドキュメント
- HTTP/3のopt-in有効化方法
  - 候補：設定方法の確認 / 環境変数の確認
- 最大リダイレクト回数の正確なデフォルト値
  - 候補：ソースコード確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HttpClient API の基本説明は信頼性が高い
- 1: 中リスク - デフォルト値は.NETバージョンで変更可能性あり
- 1: 中リスク - HTTP/3のサポート状況は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] SocketsHttpHandlerのデフォルトプロパティ値を公式ドキュメントで確認
- [ ] HTTP/3のサポート状況と有効化方法を確認
- [ ] コードサンプルの動作確認（特にIHttpClientFactory使用例）
- [ ] 関連ファイル一覧のパスが実際に存在するか確認
- [ ] JsonContentの導入バージョン確認
