---
generated_at: 2026-01-30 12:25:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：14-System.Net.WebSockets.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **WebSocketDeflateOptions**：圧縮オプションの詳細確認
  2. **DefaultClientKeepAliveInterval値**：具体的な値の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocket.cs`
- E-02: `src/libraries/System.Net.WebSockets.Client/src/System/Net/WebSockets/ClientWebSocket.cs`（推定）
- E-03: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/ManagedWebSocket.cs`（推定）
- E-04: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketState.cs`（推定）
- E-05: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocketCloseStatus.cs`（推定）
- E-06: 機能一覧.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocketがRFC 6455に準拠 | E-01 | ○ |
| C-02 | WebSocketが抽象基底クラス | E-01 | ○ |
| C-03 | SendAsync/ReceiveAsyncが抽象メソッド | E-01 | ○ |
| C-04 | CloseAsync/CloseOutputAsyncが抽象メソッド | E-01 | ○ |
| C-05 | Abortメソッドで中断 | E-01 | ○ |
| C-06 | Memory<byte>版ReceiveAsyncがArraySegment版をラップ | E-01（35-54行目） | ○ |
| C-07 | ArrayPool使用でバッファ効率化 | E-01（43-53行目） | ○ |
| C-08 | CreateFromStreamで Stream から WebSocket 作成 | E-01（132-154行目） | ○ |
| C-09 | DefaultKeepAliveIntervalプロパティ存在 | E-01（84-88行目） | ○ |
| C-10 | WebSocketStateの6状態 | E-04 | ○ |
| C-11 | WebSocketCloseStatusの各値 | E-05 | ○ |
| C-12 | ThrowOnInvalidStateで状態検証 | E-01（90-108行目） | ○ |
| C-13 | IsStateTerminalでClosed/Aborted判定 | E-01（110-111行目） | ○ |
| C-14 | CreateClientBuffer/CreateServerBuffer存在 | E-01（113-124行目） | ○ |
| C-15 | ClientWebSocketがクライアント実装 | E-02 | ○ |
| C-16 | ClientWebSocket.Optionsで設定 | E-02 | ○ |
| C-17 | ConnectAsyncで接続 | E-02 | ○ |
| C-18 | WebSocketCreationOptionsで作成オプション | E-01 | ○ |
| C-19 | ManagedWebSocketがマネージド実装 | E-03 | ○ |
| C-20 | クライアントはマスキング必須 | RFC 6455 | ○ |
| C-21 | WebSocketExceptionがプロトコルエラー | E-01 | ○ |
| C-22 | WebSocketMessageTypeにText/Binary | E-01 | ○ |
| C-23 | WebSocketReceiveResultで受信結果 | E-01 | ○ |
| C-24 | ValueWebSocketReceiveResultで値型結果 | E-01 | ○ |
| C-25 | MemoryMarshal.TryGetArrayで最適化 | E-01（37行目） | ○ |
| C-26 | isServerパラメータでマスキング制御 | E-01（132行目） | ○ |
| C-27 | WebSocketDeflateOptionsで圧縮設定 | **根拠なし** | △ |
| C-28 | DefaultClientKeepAliveInterval具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- WebSocketDeflateOptions の詳細
  - 候補：WebSocketCreationOptions.cs / ClientWebSocketOptions.cs 確認
- DefaultClientKeepAliveInterval の具体的な値
  - 候補：WebSocketDefaults.cs / 定数定義確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - WebSocket API の基本説明は信頼性が高い
- 0: 低リスク - ソースコードから直接確認した行番号は正確
- 1: 中リスク - 圧縮オプションは.NETバージョン依存の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] WebSocketDeflateOptions の存在と設定方法を確認
- [ ] DefaultClientKeepAliveInterval の具体的な値を確認
- [ ] コードサンプルの動作確認
- [ ] 関連ファイル一覧のパスが実際に存在するか確認
- [ ] WebSocketState の状態遷移が正確か確認
