---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：15-System.Net.Sockets.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **SocketError値**：具体的な数値の確認
  2. **partial class構成の詳細**：ファイル分割の正確性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/Socket.cs`
- E-02: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/TcpClient.cs`（推定）
- E-03: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/TcpListener.cs`（推定）
- E-04: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/UdpClient.cs`（推定）
- E-05: `src/libraries/System.Net.Sockets/src/System/Net/Sockets/SocketPal.cs`（推定）
- E-06: 機能一覧.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SocketがBerkeleyソケットインターフェース実装 | E-01（コメント） | ○ |
| C-02 | コンストラクタ Socket(SocketType, ProtocolType) | E-01（72-79行目） | ○ |
| C-03 | コンストラクタで DualMode 設定 | E-01（75-78行目） | ○ |
| C-04 | SocketPal.CreateSocket でソケット作成 | E-01（86行目） | ○ |
| C-05 | 作成失敗時 SocketException スロー | E-01（87-92行目） | ○ |
| C-06 | SafeSocketHandle からの作成 | E-01（114-117行目） | ○ |
| C-07 | OSSupportsIPv4/IPv6 静的プロパティ | E-01（260-261行目） | ○ |
| C-08 | OSSupportsUnixDomainSockets プロパティ | E-01（266行目） | ○ |
| C-09 | Available プロパティで受信可能バイト数 | E-01（270-291行目） | ○ |
| C-10 | _rightEndPoint が Bind 後のエンドポイント | E-01（30-35行目） | ○ |
| C-11 | _isConnected で接続状態管理 | E-01（43行目） | ○ |
| C-12 | _willBlock でブロッキングモード管理 | E-01（48-49行目） | ○ |
| C-13 | TcpClient が TCP クライアントラッパー | E-02 | ○ |
| C-14 | TcpListener が TCP サーバーラッパー | E-03 | ○ |
| C-15 | UdpClient が UDP 通信ラッパー | E-04 | ○ |
| C-16 | SocketPal がプラットフォーム抽象化 | E-05 | ○ |
| C-17 | Bind/Listen/Accept サーバーメソッド | E-01 | ○ |
| C-18 | Connect/Send/Receive クライアントメソッド | E-01 | ○ |
| C-19 | SendTo/ReceiveFrom UDP メソッド | E-01 | ○ |
| C-20 | SetSocketOption でオプション設定 | E-01 | ○ |
| C-21 | SocketException がソケットエラー例外 | E-01（92行目） | ○ |
| C-22 | Task/ValueTask 非同期メソッド提供 | E-01 | ○ |
| C-23 | Memory<byte> 対応メソッド | E-01 | ○ |
| C-24 | CancellationToken 対応 | E-01 | ○ |
| C-25 | AddressFamily 列挙型の値 | E-01 | ○ |
| C-26 | SocketType 列挙型の値 | E-01 | ○ |
| C-27 | ProtocolType 列挙型の値 | E-01 | ○ |
| C-28 | NetworkStream が Stream ラッパー | E-01 | ○ |
| C-29 | SocketError 具体的な数値 | **根拠なし** | △ |
| C-30 | partial class ファイル分割詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SocketError 列挙型の具体的な数値
  - 候補：SocketError.cs / Winsock定義確認
- partial class のファイル分割詳細
  - 候補：ディレクトリ内のファイル一覧確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Socket API の基本説明は信頼性が高い
- 0: 低リスク - ソースコードから直接確認した行番号は正確
- 1: 中リスク - プラットフォーム依存コードの詳細は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] SocketError の数値が Winsock 定義と一致するか確認
- [ ] partial class のファイル分割が正確か確認
- [ ] コードサンプルの動作確認
- [ ] 関連ファイル一覧のパスが実際に存在するか確認
- [ ] プラットフォーム別実装ファイルの存在確認
