---
generated_at: 2026-01-30 12:35:00
metrics:
  claims_total: 32
  claims_with_evidence: 29
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：16-System.Security.Cryptography.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：29 / 32、根拠なし：3
- 優先レビュー（高）
  1. **SHA3_256のサポート状況**：.NETバージョン依存
  2. **ChaCha20Poly1305のサポート**：プラットフォーム依存
  3. **CryptoPoolLeaseパターン**：内部実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/Aes.cs`
- E-02: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RSA.cs`（推定）
- E-03: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/SHA256.cs`（推定）
- E-04: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RandomNumberGenerator.cs`（推定）
- E-05: 機能一覧.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Aesが対称暗号化の実装 | E-01 | ○ |
| C-02 | Aes.Create()でファクトリ作成 | E-01（25-29行目） | ○ |
| C-03 | デフォルトBlockSize 128 | E-01（19行目） | ○ |
| C-04 | デフォルトKeySize 256 | E-01（21行目） | ○ |
| C-05 | デフォルトMode CBC | E-01（22行目） | ○ |
| C-06 | サポートキーサイズ 128/192/256 | E-01（515行目） | ○ |
| C-07 | GetKeyWrapPaddedLength計算式 | E-01（59-77行目） | ○ |
| C-08 | EncryptKeyWrapPaddedメソッド群 | E-01（86-149行目） | ○ |
| C-09 | DecryptKeyWrapPaddedメソッド群 | E-01（163-227行目） | ○ |
| C-10 | RFC 5649 AIV 0xA65959A6 | E-01（413行目） | ○ |
| C-11 | Rfc3394Wrap/Unwrap実装 | E-01（450-512行目） | ○ |
| C-12 | CryptoPoolLease使用 | E-01（184行目, 440行目） | ○ |
| C-13 | UnsupportedOSPlatform("browser") | E-01（25行目） | ○ |
| C-14 | SymmetricAlgorithmが基底クラス | E-01 | ○ |
| C-15 | RSAクラスの存在 | E-02 | ○ |
| C-16 | SHA256クラスの存在 | E-03 | ○ |
| C-17 | RandomNumberGeneratorの存在 | E-04 | ○ |
| C-18 | CipherMode列挙値 | E-01 | ○ |
| C-19 | PaddingMode列挙値 | E-01 | ○ |
| C-20 | CryptographicExceptionが暗号エラー例外 | E-01 | ○ |
| C-21 | DecryptKeyWrapPadded失敗時CryptographicException | E-01（385行目） | ○ |
| C-22 | CryptographicOperations.ZeroMemory | E-01（322行目, 429行目） | ○ |
| C-23 | TryDecryptKeyWrapPaddedメソッド | E-01（254-329行目） | ○ |
| C-24 | ArgumentOutOfRangeException.ThrowIfNegativeOrZero | E-01（61行目） | ○ |
| C-25 | オーバーラップバッファでCryptographicException | E-01（145行目, 275行目） | ○ |
| C-26 | EncryptKeyWrapPaddedCoreがprotected virtual | E-01（409行目） | ○ |
| C-27 | DecryptKeyWrapPaddedCoreがprotected virtual | E-01（355行目） | ○ |
| C-28 | EncryptEcb/DecryptEcb呼び出し | E-01（362, 426行目） | ○ |
| C-29 | BinaryPrimitives.ReadUInt64BigEndian使用 | E-01（363, 492, 511行目） | ○ |
| C-30 | SHA3_256のサポート | **根拠なし** | △ |
| C-31 | ChaCha20Poly1305のサポート | **根拠なし** | △ |
| C-32 | CryptoPoolLeaseパターン詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SHA3_256の導入バージョン確認
  - 候補：.NET 8リリースノート / SHA3_256.cs確認
- ChaCha20Poly1305のプラットフォームサポート
  - 候補：公式ドキュメント / プラットフォーム別コード確認
- CryptoPoolLease内部実装の詳細
  - 候補：Internal/Cryptography/CryptoPool.cs確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AES API の基本説明は信頼性が高い
- 0: 低リスク - ソースコードから直接確認した行番号は正確
- 1: 中リスク - 新しいアルゴリズムは.NETバージョン依存
- 1: 中リスク - プラットフォーム依存機能に注意

## 6) レビュアーチェックリスト（最小）
- [ ] SHA3_256の導入バージョンを確認
- [ ] ChaCha20Poly1305のサポート状況を確認
- [ ] コードサンプルの動作確認
- [ ] 関連ファイル一覧のパスが実際に存在するか確認
- [ ] CipherMode/PaddingMode列挙値の完全性確認
