---
generated_at: 2026-01-30 12:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：19-System.IO.Pipes.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **PipeSecurityの詳細**：Windows固有機能
  2. **TokenImpersonationLevelの詳細**：偽装機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/PipeStream.cs`
- E-02: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/NamedPipeServerStream.cs`（推定）
- E-03: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/NamedPipeClientStream.cs`（推定）
- E-04: `src/libraries/System.IO.Pipes/src/System/IO/Pipes/AnonymousPipeServerStream.cs`（推定）
- E-05: 機能一覧.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PipeStreamがパイプストリームの抽象基底 | E-01 | ○ |
| C-02 | AnonymousPipeName = "anonymous" | E-01（15行目） | ○ |
| C-03 | フィールド定義（_handle, _canRead等） | E-01（17-29行目） | ○ |
| C-04 | コンストラクタ(PipeDirection, int) | E-01（31-40行目） | ○ |
| C-05 | コンストラクタ(PipeDirection, PipeTransmissionMode, int) | E-01（42-55行目） | ○ |
| C-06 | Init メソッドの実装 | E-01（57-84行目） | ○ |
| C-07 | InitializeHandleメソッド | E-01（89-102行目） | ○ |
| C-08 | ReadByteの実装 | E-01（113-117行目） | ○ |
| C-09 | WriteByteの実装 | E-01（119-122行目） | ○ |
| C-10 | Flushが何もしない | E-01（124-130行目） | ○ |
| C-11 | IsConnectedプロパティ | E-01（174-184行目） | ○ |
| C-12 | IsMessageCompleteプロパティの検証 | E-01（193-224行目） | ○ |
| C-13 | UpdateMessageCompletionメソッド | E-01（226-231行目） | ○ |
| C-14 | SafePipeHandleプロパティ | E-01（233-249行目） | ○ |
| C-15 | CanRead/CanWrite/CanSeekプロパティ | E-01（267-289行目） | ○ |
| C-16 | Length/PositionがNotSupportedException | E-01（291-319行目） | ○ |
| C-17 | CheckPipePropertyOperationsメソッド | E-01（323-335行目） | ○ |
| C-18 | CheckReadOperationsメソッド | E-01（339-360行目） | ○ |
| C-19 | CheckWriteOperationsメソッド | E-01（363-390行目） | ○ |
| C-20 | PipeState.Brokenで IOException | E-01（380-383行目） | ○ |
| C-21 | Stateプロパティ | E-01（392-402行目） | ○ |
| C-22 | IsCurrentUserOnlyプロパティ | E-01（404-414行目） | ○ |
| C-23 | PipeDirection列挙値 | E-01 | ○ |
| C-24 | PipeTransmissionMode列挙値 | E-01 | ○ |
| C-25 | NamedPipeServerStreamの存在 | E-02 | ○ |
| C-26 | NamedPipeClientStreamの存在 | E-03 | ○ |
| C-27 | PipeSecurityの詳細 | **根拠なし** | △ |
| C-28 | TokenImpersonationLevelの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PipeSecurityの設定方法と適用
  - 候補：PipeSecurity.cs / Windows固有コード確認
- TokenImpersonationLevelの各レベルの意味
  - 候補：公式ドキュメント / WindowsIdentity関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PipeStream API の基本説明は信頼性が高い
- 0: 低リスク - ソースコードから直接確認した行番号は正確
- 1: 中リスク - Windows固有機能（PipeSecurity等）は追加確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] PipeSecurityの存在と設定方法を確認
- [ ] TokenImpersonationLevelの各レベルを確認
- [ ] コードサンプルの動作確認
- [ ] 関連ファイル一覧のパスが実際に存在するか確認
- [ ] メッセージモードのプラットフォームサポート確認
