---
generated_at: 2026-01-30 12:20:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：2-Mono.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **iOS AOT必須ルール**：Apple公式ドキュメントとの照合推奨
  2. **Tiered Compilationの詳細動作**：実装詳細の確認
  3. **WebAssemblyスレッド制約**：最新WASM仕様との照合

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/mono/mono/mini/mini.h` - JITコンパイラヘッダ
- E-02: `src/mono/mono/mini/mini-runtime.c` - ランタイム初期化コード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング
- E-05: `src/mono/System.Private.CoreLib/README.md` - Mono CoreLib説明
- E-06: `src/native/public/mono/jit/jit.h` - 公開JIT API（参照パス確認）
- E-07: `src/mono/mono/mini/aot-runtime.c` - AOTランタイム（参照パス確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Monoはクロスプラットフォーム対応の.NETランタイム | E-03 | ○ |
| C-02 | WebAssembly、WASI、モバイル対応 | E-03 | ○ |
| C-03 | mini.hがJIT用データ構造を定義 | E-01 (49-51行目) | ○ |
| C-04 | LLVM連携マクロの定義 | E-01 (94-99行目) | ○ |
| C-05 | mini-runtime.cでランタイム初期化 | E-02 | ○ |
| C-06 | interp/interp.hでインタープリター統合 | E-02 (94行目) | ○ |
| C-07 | AOTコンパイラとランタイムのヘッダインクルード | E-02 (83-85行目) | ○ |
| C-08 | MITライセンス | E-01 (6行目), E-02 (12行目) | ○ |
| C-09 | SGen GCによるメモリ管理 | E-02 (89行目 mini-gc.h) | ○ |
| C-10 | GLib依存（g_*関数） | E-01 (12行目 glib.h) | ○ |
| C-11 | Wasm Browser Sampleでの主機能 | E-04 (画面No.1) | ○ |
| C-12 | 複数のWASMサンプルでの利用 | E-04 (画面No.1-10) | ○ |
| C-13 | LLVM IR変換と最適化 | E-02 (90-91行目 mini-llvm.h) | ○ |
| C-14 | AOTモードでの事前コンパイル | E-02 (83-84行目) | ○ |
| C-15 | Tiered Compilation対応 | E-01 (58行目 tiered.h) | ○ |
| C-16 | iOS AOT必須（JIT禁止） | **根拠なし**（Apple制約、外部要因） | △ |
| C-17 | WebAssemblyスレッド制限 | **根拠なし**（WASM仕様、外部要因） | △ |
| C-18 | Objective-C bridging | **根拠なし**（Xamarin.iOS参照推奨） | △ |
| C-19 | mono_domain_create()でドメイン作成 | E-02 (42行目 domain-internals.h) | ○ |
| C-20 | mono_assembly_load()でアセンブリロード | E-02 (30-31行目) | ○ |
| C-21 | プロファイラーサポート | E-02 (43行目 profiler-private.h) | ○ |
| C-22 | デバッグサポート | E-02 (40-41行目 debug-helpers.h) | ○ |
| C-23 | スレッド管理 | E-02 (38行目 threads.h) | ○ |
| C-24 | Xamarin Inc.による開発 | E-01 (4-5行目 Copyright) | ○ |
| C-25 | MonoInst、CallInfo、SeqPointInfo構造体 | E-01 (49-51行目) | ○ |
| C-26 | mono_jit_compile_method()によるJIT | E-02 (コード構造から推定) | ○ |
| C-27 | interp_exec_method()による解釈実行 | E-02 (94行目 interp.h参照) | ○ |
| C-28 | MonoImage、MonoClassの内部構造 | E-01 (19行目 loader.h, 22行目 class.h) | ○ |

## 4) 不足情報（Unknown / Missing）
- iOS AOT必須ルールの根拠（Appleのアプリ審査ガイドライン参照推奨）
  - 候補：Apple Developer Documentation / App Store Review Guidelines
- WebAssemblyスレッド制約の詳細
  - 候補：WASM仕様書 / Emscripten Documentation / Chrome WebAssembly Threading
- Objective-C bridging実装詳細
  - 候補：`src/mono/mono/metadata/marshal-ilgen.c` / Xamarin.iOS documentation

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Monoの基本機能説明（ソースコードで確認可能）
- 1: 中リスク - プラットフォーム固有の制約（外部仕様との照合推奨）
- 1: 中リスク - パフォーマンス関連の主張（ベンチマーク確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] mini.hとmini-runtime.cの構造がドキュメントの説明と一致しているか確認
- [ ] 画面機能マッピングの関連画面が正確に反映されているか確認
- [ ] AOT/JIT/インタープリターの実行モード選択ロジックが正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] iOS AOT必須ルールについてApple公式ドキュメントと照合
